/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean2.compute.strategy;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.math.BigInteger;
import java.security.PublicKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.config.CustomizationResponse;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.compute.strategy.CreateNodeWithGroupEncodedIntoName;
import org.jclouds.compute.strategy.CustomizeNodeAndAddToGoodMapOrPutExceptionIntoBadMap;
import org.jclouds.compute.strategy.ListNodesStrategy;
import org.jclouds.compute.strategy.impl.CreateNodesWithGroupEncodedIntoNameThenAddToSet;
import org.jclouds.digitalocean2.DigitalOcean2Api;
import org.jclouds.digitalocean2.compute.options.DigitalOcean2TemplateOptions;
import org.jclouds.digitalocean2.domain.Key;
import org.jclouds.digitalocean2.ssh.DSAKeys;
import org.jclouds.digitalocean2.ssh.ECDSAKeys;
import org.jclouds.logging.Logger;
import org.jclouds.ssh.SshKeyPairGenerator;
import org.jclouds.ssh.SshKeys;

@Singleton
public class CreateKeyPairsThenCreateNodes
extends CreateNodesWithGroupEncodedIntoNameThenAddToSet {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final DigitalOcean2Api api;
    private final SshKeyPairGenerator keyGenerator;
    private final Function<String, PublicKey> sshKeyToPublicKey;

    @Inject
    protected CreateKeyPairsThenCreateNodes(CreateNodeWithGroupEncodedIntoName addNodeWithGroupStrategy, ListNodesStrategy listNodesStrategy, GroupNamingConvention.Factory namingConvention, @Named(value="jclouds.user-threads") ListeningExecutorService userExecutor, CustomizeNodeAndAddToGoodMapOrPutExceptionIntoBadMap.Factory customizeNodeAndAddToGoodMapOrPutExceptionIntoBadMapFactory, DigitalOcean2Api api, SshKeyPairGenerator keyGenerator, Function<String, PublicKey> sshKeyToPublicKey) {
        super(addNodeWithGroupStrategy, listNodesStrategy, namingConvention, userExecutor, customizeNodeAndAddToGoodMapOrPutExceptionIntoBadMapFactory);
        this.api = (DigitalOcean2Api)Preconditions.checkNotNull((Object)api, (Object)"api cannot be null");
        this.keyGenerator = (SshKeyPairGenerator)Preconditions.checkNotNull((Object)keyGenerator, (Object)"keyGenerator cannot be null");
        Preconditions.checkNotNull((Object)userExecutor, (Object)"userExecutor cannot be null");
        this.sshKeyToPublicKey = (Function)Preconditions.checkNotNull(sshKeyToPublicKey, (Object)"sshKeyToPublicKey cannot be null");
    }

    public Map<?, ListenableFuture<Void>> execute(String group, int count, Template template, Set<NodeMetadata> goodNodes, Map<NodeMetadata, Exception> badNodes, Multimap<NodeMetadata, CustomizationResponse> customizationResponses) {
        DigitalOcean2TemplateOptions options = (DigitalOcean2TemplateOptions)template.getOptions().as(DigitalOcean2TemplateOptions.class);
        HashSet generatedSshKeyIds = Sets.newHashSet();
        if (options.getSshKeyIds().isEmpty() && options.getAutoCreateKeyPair() && Strings.isNullOrEmpty((String)options.getPublicKey())) {
            this.generateKeyPairAndAddKeyToSet(options, generatedSshKeyIds, group);
        }
        if (options.getRunScript() != null && Strings.isNullOrEmpty((String)options.getLoginPrivateKey())) {
            this.logger.warn(">> A runScript has been configured but no SSH key has been provided. Authentication will delegate to the ssh-agent", new Object[0]);
        }
        if (!Strings.isNullOrEmpty((String)options.getPublicKey())) {
            this.createKeyPairForPublicKeyInOptionsAndAddToSet(options, generatedSshKeyIds);
        }
        options.sshKeyIds((Iterable<Integer>)Sets.union((Set)generatedSshKeyIds, options.getSshKeyIds()));
        Map responses = super.execute(group, count, template, goodNodes, badNodes, customizationResponses);
        this.registerAutoGeneratedKeyPairCleanupCallbacks(responses, generatedSshKeyIds);
        return responses;
    }

    private void createKeyPairForPublicKeyInOptionsAndAddToSet(DigitalOcean2TemplateOptions options, Set<Integer> generatedSshKeyIds) {
        this.logger.debug(">> checking if the key pair already exists...", new Object[0]);
        PublicKey userKey = (PublicKey)this.sshKeyToPublicKey.apply((Object)options.getPublicKey());
        String userFingerprint = CreateKeyPairsThenCreateNodes.computeFingerprint(userKey);
        Key key = this.api.keyApi().get(userFingerprint);
        if (key == null) {
            this.logger.debug(">> key pair not found. creating a new one...", new Object[0]);
            Key newKey = this.api.keyApi().create(userFingerprint, options.getPublicKey());
            generatedSshKeyIds.add(newKey.id());
            this.logger.debug(">> key pair created! %s", new Object[]{newKey});
        } else {
            this.logger.debug(">> key pair found! %s", new Object[]{key});
            generatedSshKeyIds.add(key.id());
        }
    }

    private void generateKeyPairAndAddKeyToSet(DigitalOcean2TemplateOptions options, Set<Integer> generatedSshKeyIds, String prefix) {
        this.logger.debug(">> creating default keypair for node...", new Object[0]);
        Map defaultKeys = (Map)this.keyGenerator.get();
        Key defaultKey = this.api.keyApi().create(prefix + "-" + System.getProperty("user.name"), (String)defaultKeys.get("public"));
        generatedSshKeyIds.add(defaultKey.id());
        this.logger.debug(">> keypair created! %s", new Object[]{defaultKey});
        if (Strings.isNullOrEmpty((String)options.getLoginPrivateKey())) {
            options.overrideLoginPrivateKey((String)defaultKeys.get("private"));
        }
    }

    private void registerAutoGeneratedKeyPairCleanupCallbacks(Map<?, ListenableFuture<Void>> responses, final Set<Integer> generatedSshKeyIds) {
        ListenableFuture aggregatedResponses = Futures.successfulAsList(responses.values());
        Futures.addCallback((ListenableFuture)aggregatedResponses, (FutureCallback)new FutureCallback<List<Void>>(){

            public void onSuccess(List<Void> result) {
                this.cleanupAutoGeneratedKeyPairs(generatedSshKeyIds);
            }

            public void onFailure(Throwable t) {
                this.cleanupAutoGeneratedKeyPairs(generatedSshKeyIds);
            }

            private void cleanupAutoGeneratedKeyPairs(Set<Integer> generatedSshKeyIds2) {
                CreateKeyPairsThenCreateNodes.this.logger.debug(">> cleaning up auto-generated key pairs...", new Object[0]);
                for (Integer sshKeyId : generatedSshKeyIds2) {
                    try {
                        CreateKeyPairsThenCreateNodes.this.api.keyApi().delete(sshKeyId);
                    }
                    catch (Exception ex) {
                        CreateKeyPairsThenCreateNodes.this.logger.warn(">> could not delete key pair %s: %s", new Object[]{sshKeyId, ex.getMessage()});
                    }
                }
            }
        }, (Executor)this.userExecutor);
    }

    private static String computeFingerprint(PublicKey key) {
        if (key instanceof RSAPublicKey) {
            RSAPublicKey rsaKey = (RSAPublicKey)key;
            return SshKeys.fingerprint((BigInteger)rsaKey.getPublicExponent(), (BigInteger)rsaKey.getModulus());
        }
        if (key instanceof DSAPublicKey) {
            DSAPublicKey dsaKey = (DSAPublicKey)key;
            return DSAKeys.fingerprint(dsaKey.getParams().getP(), dsaKey.getParams().getQ(), dsaKey.getParams().getG(), dsaKey.getY());
        }
        if (key instanceof ECPublicKey) {
            ECPublicKey ecdsaKey = (ECPublicKey)key;
            return ECDSAKeys.fingerprint(ecdsaKey);
        }
        throw new IllegalArgumentException("Only RSA and DSA keys are supported");
    }
}

