/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.elasticstack.domain;

import com.google.common.base.Preconditions;
import java.util.Map;
import org.jclouds.elasticstack.domain.ClaimType;
import org.jclouds.elasticstack.domain.Drive;
import org.jclouds.elasticstack.domain.ImageConversionType;
import org.jclouds.elasticstack.domain.MediaType;
import org.jclouds.javax.annotation.Nullable;

public class StandardDrive
extends Drive {
    protected final ImageConversionType format;
    protected final MediaType media;
    protected final long rawSize;

    public StandardDrive(String uuid, String name, long size, ClaimType claimType, Iterable<String> readers, Iterable<String> tags, Map<String, String> userMetadata, @Nullable ImageConversionType format, MediaType media, long rawSize) {
        super(uuid, name, size, claimType, readers, tags, userMetadata);
        this.format = format;
        this.media = (MediaType)((Object)Preconditions.checkNotNull((Object)((Object)media), (Object)"media"));
        this.rawSize = rawSize;
    }

    public MediaType getMedia() {
        return this.media;
    }

    public ImageConversionType getFormat() {
        return this.format;
    }

    public long getRawSize() {
        return this.rawSize;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.format == null ? 0 : this.format.hashCode());
        result = 31 * result + (this.media == null ? 0 : this.media.hashCode());
        result = 31 * result + (int)(this.rawSize ^ this.rawSize >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StandardDrive other = (StandardDrive)obj;
        if (this.format != other.format) {
            return false;
        }
        if (this.media == null ? other.media != null : !this.media.equals((Object)other.media)) {
            return false;
        }
        return this.rawSize == other.rawSize;
    }

    @Override
    public String toString() {
        return "StandardDrive [format=" + (Object)((Object)this.format) + ", media=" + (Object)((Object)this.media) + ", rawSize=" + this.rawSize + ", size=" + this.size + ", claimType=" + (Object)((Object)this.claimType) + ", readers=" + this.readers + ", uuid=" + this.uuid + ", name=" + this.name + ", tags=" + this.tags + ", userMetadata=" + this.userMetadata + "]";
    }

    public static class Builder
    extends Drive.Builder {
        protected ImageConversionType format;
        protected MediaType media;
        protected long rawSize;

        public Builder format(ImageConversionType format) {
            this.format = format;
            return this;
        }

        public Builder media(MediaType media) {
            this.media = media;
            return this;
        }

        public Builder rawSize(long rawSize) {
            this.rawSize = rawSize;
            return this;
        }

        @Override
        public Builder claimType(ClaimType claimType) {
            return (Builder)Builder.class.cast(super.claimType(claimType));
        }

        @Override
        public Builder readers(Iterable<String> readers) {
            return (Builder)Builder.class.cast(super.readers(readers));
        }

        @Override
        public Builder size(long size) {
            return (Builder)Builder.class.cast(super.size(size));
        }

        @Override
        public Builder uuid(String uuid) {
            return (Builder)Builder.class.cast(super.uuid(uuid));
        }

        @Override
        public Builder name(String name) {
            return (Builder)Builder.class.cast(super.name(name));
        }

        @Override
        public Builder tags(Iterable<String> tags) {
            return (Builder)Builder.class.cast(super.tags((Iterable)tags));
        }

        @Override
        public Builder userMetadata(Map<String, String> userMetadata) {
            return (Builder)Builder.class.cast(super.userMetadata((Map)userMetadata));
        }

        public static Builder fromDriveInfo(StandardDrive driveInfo) {
            return ((Builder)((Builder)((Builder)new Builder().uuid(driveInfo.getUuid()).name(driveInfo.getName()).size(driveInfo.getSize()).claimType(driveInfo.getClaimType()).readers(driveInfo.getReaders())).tags(driveInfo.getTags())).userMetadata((Map)driveInfo.getUserMetadata())).media(driveInfo.getMedia());
        }

        @Override
        public StandardDrive build() {
            return new StandardDrive(this.uuid, this.name, this.size, this.claimType, this.readers, this.tags, this.userMetadata, this.format, this.media, this.rawSize);
        }
    }
}

