/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection;

import com.mongodb.MongoCredential;
import com.mongodb.connection.Cluster;
import com.mongodb.connection.ClusterConnectionMode;
import com.mongodb.connection.ClusterFactory;
import com.mongodb.connection.ClusterId;
import com.mongodb.connection.ClusterSettings;
import com.mongodb.connection.ConnectionPoolSettings;
import com.mongodb.connection.DefaultClusterableServerFactory;
import com.mongodb.connection.MultiServerCluster;
import com.mongodb.connection.NoOpClusterListener;
import com.mongodb.connection.NoOpConnectionListener;
import com.mongodb.connection.NoOpConnectionPoolListener;
import com.mongodb.connection.ServerSettings;
import com.mongodb.connection.SingleServerCluster;
import com.mongodb.connection.StreamFactory;
import com.mongodb.event.ClusterListener;
import com.mongodb.event.ConnectionListener;
import com.mongodb.event.ConnectionPoolListener;
import java.util.List;

public final class DefaultClusterFactory
implements ClusterFactory {
    @Override
    public Cluster create(ClusterSettings settings, ServerSettings serverSettings, ConnectionPoolSettings connectionPoolSettings, StreamFactory streamFactory, StreamFactory heartbeatStreamFactory, List<MongoCredential> credentialList, ClusterListener clusterListener, ConnectionPoolListener connectionPoolListener, ConnectionListener connectionListener) {
        ClusterId clusterId = new ClusterId(settings.getDescription());
        DefaultClusterableServerFactory serverFactory = new DefaultClusterableServerFactory(clusterId, settings, serverSettings, connectionPoolSettings, streamFactory, heartbeatStreamFactory, credentialList, connectionListener != null ? connectionListener : new NoOpConnectionListener(), connectionPoolListener != null ? connectionPoolListener : new NoOpConnectionPoolListener());
        if (settings.getMode() == ClusterConnectionMode.SINGLE) {
            return new SingleServerCluster(clusterId, settings, serverFactory, clusterListener != null ? clusterListener : new NoOpClusterListener());
        }
        if (settings.getMode() == ClusterConnectionMode.MULTIPLE) {
            return new MultiServerCluster(clusterId, settings, serverFactory, clusterListener != null ? clusterListener : new NoOpClusterListener());
        }
        throw new UnsupportedOperationException("Unsupported cluster mode: " + (Object)((Object)settings.getMode()));
    }
}

