/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.osgi.bundle.util.equinox;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import org.apache.xbean.osgi.bundle.util.BundleResourceHelper;
import org.apache.xbean.osgi.bundle.util.DelegatingBundle;
import org.apache.xbean.osgi.bundle.util.DelegatingBundleReference;
import org.apache.xbean.osgi.bundle.util.equinox.EquinoxBundleResourceHelper;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EquinoxBundleClassLoader
extends URLClassLoader
implements DelegatingBundleReference {
    private final Bundle bundle;
    private final BundleResourceHelper resourceHelper;

    public EquinoxBundleClassLoader(Bundle bundle) {
        this(bundle, BundleResourceHelper.getSearchWiredBundles(true), BundleResourceHelper.getConvertResourceUrls(true));
    }

    public EquinoxBundleClassLoader(Bundle bundle, boolean searchWiredBundles, boolean convertResourceUrls) {
        super(new URL[0]);
        this.bundle = bundle;
        this.resourceHelper = new EquinoxBundleResourceHelper(bundle, searchWiredBundles, convertResourceUrls);
    }

    public String toString() {
        return "[EquinoxBundleClassLoader] " + this.bundle;
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class clazz = this.bundle.loadClass(name);
        if (resolve) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    @Override
    public URL getResource(String name) {
        return this.resourceHelper.getResource(name);
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        return this.resourceHelper.getResources(name);
    }

    public void setSearchWiredBundles(boolean search) {
        this.resourceHelper.setSearchWiredBundles(search);
    }

    public boolean getSearchWiredBundles() {
        return this.resourceHelper.getSearchWiredBundles();
    }

    public void setConvertResourceUrls(boolean convert) {
        this.resourceHelper.setConvertResourceUrls(convert);
    }

    public boolean getConvertResourceUrls() {
        return this.resourceHelper.getConvertResourceUrls();
    }

    @Override
    public Bundle getBundle(boolean unwrap) {
        if (unwrap && this.bundle instanceof DelegatingBundle) {
            return ((DelegatingBundle)this.bundle).getMainBundle();
        }
        return this.bundle;
    }

    public Bundle getBundle() {
        return this.getBundle(true);
    }

    public int hashCode() {
        return this.bundle.hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || !other.getClass().equals(this.getClass())) {
            return false;
        }
        EquinoxBundleClassLoader otherBundleClassLoader = (EquinoxBundleClassLoader)other;
        return this.bundle == otherBundleClassLoader.bundle;
    }
}

