/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.profitbricks.http.filters;

import com.google.common.base.Preconditions;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.http.HttpUtils;
import org.jclouds.io.ContentMetadata;
import org.jclouds.io.MutableContentMetadata;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.io.payloads.StringPayload;

public class ProfitBricksSoapMessageEnvelope
implements HttpRequestFilter {
    private static final String SOAP_PREFIX = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:ws=\"http://ws.api.profitbricks.com/\"><soapenv:Header/><soapenv:Body>";
    private static final String SOAP_SUFFIX = "</soapenv:Body></soapenv:Envelope>";

    public HttpRequest filter(HttpRequest request) throws HttpException {
        Preconditions.checkNotNull((Object)request.getPayload(), (Object)"HTTP Request must contain payload message.");
        return this.createSoapRequest(request);
    }

    private HttpRequest createSoapRequest(HttpRequest request) {
        Payload oldPayload = request.getPayload();
        MutableContentMetadata oldMetadata = oldPayload.getContentMetadata();
        String body = SOAP_PREFIX.concat(oldPayload.getRawContent().toString()).concat(SOAP_SUFFIX);
        StringPayload newPayload = Payloads.newStringPayload((String)body);
        HttpUtils.copy((ContentMetadata)oldMetadata, (MutableContentMetadata)newPayload.getContentMetadata());
        newPayload.getContentMetadata().setContentLength(Long.valueOf(body.getBytes().length));
        return ((HttpRequest.Builder)request.toBuilder().payload((Payload)newPayload)).build();
    }
}

