/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.jmx;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.eclipse.jetty.jmx.ObjectMBean;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.AggregateLifeCycle;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.ShutdownThread;

public class MBeanContainer
extends AbstractLifeCycle
implements Container.Listener,
Dumpable {
    private static final Logger LOG = Log.getLogger(MBeanContainer.class.getName());
    private static final HashMap<String, Integer> __unique = new HashMap();
    private final MBeanServer _server;
    private final WeakHashMap<Object, ObjectName> _beans = new WeakHashMap();
    private final WeakHashMap<ObjectName, List<Container.Relationship>> _relations = new WeakHashMap();
    private String _domain = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void resetUnique() {
        HashMap<String, Integer> hashMap = __unique;
        synchronized (hashMap) {
            __unique.clear();
        }
    }

    public synchronized ObjectName findMBean(Object object) {
        ObjectName bean = this._beans.get(object);
        return bean == null ? null : bean;
    }

    public synchronized Object findBean(ObjectName oname) {
        for (Map.Entry<Object, ObjectName> entry : this._beans.entrySet()) {
            ObjectName bean = entry.getValue();
            if (!bean.equals(oname)) continue;
            return entry.getKey();
        }
        return null;
    }

    public MBeanContainer(MBeanServer server) {
        this._server = server;
    }

    public MBeanServer getMBeanServer() {
        return this._server;
    }

    public void setDomain(String domain) {
        this._domain = domain;
    }

    public String getDomain() {
        return this._domain;
    }

    @Override
    public synchronized void add(Container.Relationship relationship) {
        ObjectName child;
        LOG.debug("add {}", relationship);
        ObjectName parent = this._beans.get(relationship.getParent());
        if (parent == null) {
            this.addBean(relationship.getParent());
            parent = this._beans.get(relationship.getParent());
        }
        if ((child = this._beans.get(relationship.getChild())) == null) {
            this.addBean(relationship.getChild());
            child = this._beans.get(relationship.getChild());
        }
        if (parent != null && child != null) {
            List<Container.Relationship> rels = this._relations.get(parent);
            if (rels == null) {
                rels = new ArrayList<Container.Relationship>();
                this._relations.put(parent, rels);
            }
            rels.add(relationship);
        }
    }

    @Override
    public synchronized void remove(Container.Relationship relationship) {
        List<Container.Relationship> rels;
        LOG.debug("remove {}", relationship);
        ObjectName parent = this._beans.get(relationship.getParent());
        ObjectName child = this._beans.get(relationship.getChild());
        if (parent != null && child != null && (rels = this._relations.get(parent)) != null) {
            Iterator<Container.Relationship> i = rels.iterator();
            while (i.hasNext()) {
                Container.Relationship r = i.next();
                if (!relationship.equals(r) && r.getChild() != null) continue;
                i.remove();
            }
        }
    }

    @Override
    public synchronized void removeBean(Object obj) {
        LOG.debug("removeBean {}", obj);
        ObjectName bean = this._beans.remove(obj);
        if (bean != null) {
            List<Container.Relationship> beanRelations = this._relations.remove(bean);
            if (beanRelations != null) {
                LOG.debug("Unregister {}", beanRelations);
                ArrayList<Container.Relationship> removeList = new ArrayList<Container.Relationship>(beanRelations);
                for (Object e : removeList) {
                    Container.Relationship relation = (Container.Relationship)e;
                    relation.getContainer().update(relation.getParent(), relation.getChild(), null, relation.getRelationship(), true);
                }
            }
            try {
                this._server.unregisterMBean(bean);
                LOG.debug("Unregistered {}", bean);
            }
            catch (InstanceNotFoundException e) {
                LOG.ignore(e);
            }
            catch (Exception e) {
                LOG.warn(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void addBean(Object obj) {
        LOG.debug("addBean {}", obj);
        try {
            if (obj == null || this._beans.containsKey(obj)) {
                return;
            }
            Object mbean = ObjectMBean.mbeanFor(obj);
            if (mbean == null) {
                return;
            }
            ObjectName oname = null;
            if (mbean instanceof ObjectMBean) {
                ((ObjectMBean)mbean).setMBeanContainer(this);
                oname = ((ObjectMBean)mbean).getObjectName();
            }
            if (oname == null) {
                Integer count;
                String type = obj.getClass().getName().toLowerCase(Locale.ENGLISH);
                int dot = type.lastIndexOf(46);
                if (dot >= 0) {
                    type = type.substring(dot + 1);
                }
                String context = null;
                if (mbean instanceof ObjectMBean) {
                    context = this.makeName(((ObjectMBean)mbean).getObjectContextBasis());
                }
                String name = null;
                if (mbean instanceof ObjectMBean) {
                    name = this.makeName(((ObjectMBean)mbean).getObjectNameBasis());
                }
                StringBuffer buf = new StringBuffer();
                buf.append("type=").append(type);
                if (context != null && context.length() > 1) {
                    buf.append(buf.length() > 0 ? "," : "");
                    buf.append("context=").append(context);
                }
                if (name != null && name.length() > 1) {
                    buf.append(buf.length() > 0 ? "," : "");
                    buf.append("name=").append(name);
                }
                String basis = buf.toString();
                HashMap<String, Integer> hashMap = __unique;
                synchronized (hashMap) {
                    count = __unique.get(basis);
                    count = count == null ? 0 : 1 + count;
                    __unique.put(basis, count);
                }
                String domain = this._domain;
                if (domain == null) {
                    domain = obj.getClass().getPackage().getName();
                }
                oname = ObjectName.getInstance(domain + ":" + basis + ",id=" + count);
            }
            ObjectInstance oinstance = this._server.registerMBean(mbean, oname);
            LOG.debug("Registered {}", oinstance.getObjectName());
            this._beans.put(obj, oinstance.getObjectName());
        }
        catch (Exception e) {
            LOG.warn("bean: " + obj, e);
        }
    }

    public String makeName(String basis) {
        if (basis == null) {
            return basis;
        }
        return basis.replace(':', '_').replace('*', '_').replace('?', '_').replace('=', '_').replace(',', '_').replace(' ', '_');
    }

    @Override
    public void doStart() {
        ShutdownThread.register(this);
    }

    @Override
    public void doStop() {
        HashSet<Object> removeSet = new HashSet<Object>(this._beans.keySet());
        for (Object e : removeSet) {
            this.removeBean(e);
        }
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        AggregateLifeCycle.dumpObject(out, this);
        AggregateLifeCycle.dump(out, indent, this._beans.entrySet());
    }

    @Override
    public String dump() {
        return AggregateLifeCycle.dump(this);
    }
}

