/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.typereg;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.catalog.CatalogItem;
import org.apache.brooklyn.api.mgmt.rebind.RebindSupport;
import org.apache.brooklyn.api.typereg.ManagedBundle;
import org.apache.brooklyn.api.typereg.OsgiBundleWithUrl;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.mgmt.rebind.BasicManagedBundleRebindSupport;
import org.apache.brooklyn.core.objs.AbstractBrooklynObject;
import org.apache.brooklyn.core.objs.BrooklynObjectInternal;
import org.apache.brooklyn.util.http.auth.Credentials;
import org.apache.brooklyn.util.osgi.VersionedName;
import org.apache.brooklyn.util.text.BrooklynVersionSyntax;

public class BasicManagedBundle
extends AbstractBrooklynObject
implements ManagedBundle,
BrooklynObjectInternal {
    private String symbolicName;
    private String version;
    private String checksum;
    private String url;
    private Credentials credentials;
    private transient boolean persistenceNeeded = false;

    public BasicManagedBundle() {
    }

    public BasicManagedBundle(String name, String version, String url, @Nullable String checksum) {
        this(name, version, url, null, checksum);
    }

    public BasicManagedBundle(String name, String version, String url, Credentials credentials, @Nullable String checksum) {
        if (name == null && version == null) {
            Preconditions.checkNotNull((Object)url, (Object)"Either a URL or both name and version are required");
        } else {
            Preconditions.checkNotNull((Object)name, (Object)"Either a URL or both name and version are required");
            Preconditions.checkNotNull((Object)version, (Object)"Either a URL or both name and version are required");
        }
        this.symbolicName = name;
        this.version = version;
        this.url = url;
        this.checksum = checksum;
        this.credentials = credentials;
    }

    public boolean isNameResolved() {
        return this.symbolicName != null && this.version != null;
    }

    public String getSymbolicName() {
        return this.symbolicName;
    }

    public void setSymbolicName(String symbolicName) {
        this.symbolicName = symbolicName;
    }

    public String getSuppliedVersionString() {
        return this.version;
    }

    public String getOsgiVersionString() {
        return this.version == null ? null : BrooklynVersionSyntax.toValidOsgiVersion((String)this.version);
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public VersionedName getVersionedName() {
        if (this.symbolicName == null) {
            return null;
        }
        return new VersionedName(this.symbolicName, this.version);
    }

    public String getUrl() {
        return this.url;
    }

    public Credentials getUrlCredential() {
        return this.credentials;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getOsgiUniqueUrl() {
        return "brooklyn:" + (this.checksum != null ? this.checksum : this.getId());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("symbolicName", (Object)this.symbolicName).add("version", (Object)this.version).add("url", (Object)this.url).toString();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.symbolicName, this.getOsgiVersionString(), this.url});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OsgiBundleWithUrl other = (OsgiBundleWithUrl)obj;
        if (!Objects.equal((Object)this.symbolicName, (Object)other.getSymbolicName())) {
            return false;
        }
        if (!Objects.equal((Object)this.getOsgiVersionString(), (Object)other.getOsgiVersionString())) {
            return false;
        }
        if (!Objects.equal((Object)this.url, (Object)other.getUrl())) {
            return false;
        }
        if (other instanceof ManagedBundle) {
            if (!Objects.equal((Object)this.checksum, (Object)((ManagedBundle)other).getChecksum())) {
                return false;
            }
            if (!Objects.equal((Object)this.getId(), (Object)((ManagedBundle)other).getId())) {
                return false;
            }
        }
        return true;
    }

    public String getDisplayName() {
        return null;
    }

    public <T> T getConfig(ConfigKey<T> key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RebindSupport<?> getRebindSupport() {
        return new BasicManagedBundleRebindSupport(this);
    }

    @Override
    public BrooklynObjectInternal.ConfigurationSupportInternal config() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BrooklynObjectInternal.SubscriptionSupportInternal subscriptions() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDisplayName(String newName) {
        throw new UnsupportedOperationException();
    }

    public String getChecksum() {
        return this.checksum;
    }

    public void setChecksum(String md5Checksum) {
        this.checksum = md5Checksum;
    }

    @Override
    protected BrooklynObjectInternal configure(Map<?, ?> flags) {
        throw new UnsupportedOperationException();
    }

    public static ManagedBundle of(CatalogItem.CatalogBundle bundle) {
        String checksum = bundle instanceof ManagedBundle ? ((ManagedBundle)bundle).getChecksum() : null;
        return new BasicManagedBundle(bundle.getSymbolicName(), bundle.getSuppliedVersionString(), bundle.getUrl(), bundle.getUrlCredential(), checksum);
    }

    public void setPersistenceNeeded(boolean val) {
        this.persistenceNeeded |= val;
    }

    public boolean getPersistenceNeeded() {
        return this.persistenceNeeded;
    }
}

