/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.util;

import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.bookkeeper.feature.Feature;
import org.apache.bookkeeper.stats.Counter;
import org.apache.bookkeeper.stats.Gauge;
import org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.distributedlog.common.util.PermitLimiter;

public class SimplePermitLimiter
implements PermitLimiter {
    final Counter acquireFailureCounter;
    final OpStatsLogger permitsMetric;
    final AtomicInteger permits = new AtomicInteger(0);
    final int permitsMax;
    final boolean darkmode;
    final Feature disableWriteLimitFeature;
    private StatsLogger statsLogger = null;
    private Gauge<Number> permitsGauge = null;
    private String permitsGaugeLabel = "";

    public SimplePermitLimiter(boolean darkmode, int permitsMax, StatsLogger statsLogger, boolean singleton, Feature disableWriteLimitFeature) {
        this.permitsMax = permitsMax;
        this.darkmode = darkmode;
        this.disableWriteLimitFeature = disableWriteLimitFeature;
        if (singleton) {
            this.statsLogger = statsLogger;
            this.permitsGauge = new Gauge<Number>(){

                public Number getDefaultValue() {
                    return 0;
                }

                public Number getSample() {
                    return SimplePermitLimiter.this.permits.get();
                }
            };
            this.permitsGaugeLabel = "permits";
            statsLogger.registerGauge(this.permitsGaugeLabel, this.permitsGauge);
        }
        this.acquireFailureCounter = statsLogger.getCounter("acquireFailure");
        this.permitsMetric = statsLogger.getOpStatsLogger("permits");
    }

    public boolean isDarkmode() {
        return this.darkmode || this.disableWriteLimitFeature.isAvailable();
    }

    public boolean acquire() {
        this.permitsMetric.registerSuccessfulValue((long)this.permits.get());
        if (this.permits.incrementAndGet() <= this.permitsMax || this.isDarkmode()) {
            return true;
        }
        this.acquireFailureCounter.inc();
        this.permits.decrementAndGet();
        return false;
    }

    public void release(int permitsToRelease) {
        this.permits.addAndGet(-permitsToRelease);
    }

    public void close() {
        this.unregisterGauge();
    }

    @VisibleForTesting
    public int getPermits() {
        return this.permits.get();
    }

    public void unregisterGauge() {
        if (this.statsLogger != null && this.permitsGauge != null) {
            this.statsLogger.unregisterGauge(this.permitsGaugeLabel, this.permitsGauge);
        }
    }
}

