/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.bookkeeper.bookie.BufferedChannelBase;

public class BufferedReadChannel
extends BufferedChannelBase {
    protected final int readCapacity;
    protected ByteBuffer readBuffer;
    protected long readBufferStartPosition = Long.MIN_VALUE;
    long invocationCount = 0L;
    long cacheHitCount = 0L;

    public BufferedReadChannel(FileChannel fileChannel, int readCapacity) throws IOException {
        super(fileChannel);
        this.readCapacity = readCapacity;
        this.readBuffer = ByteBuffer.allocateDirect(readCapacity);
        this.readBuffer.limit(0);
    }

    public synchronized int read(ByteBuffer dest, long pos) throws IOException {
        ++this.invocationCount;
        long currentPosition = pos;
        long eof = this.validateAndGetFileChannel().size();
        if (pos >= eof) {
            return -1;
        }
        while (dest.remaining() > 0) {
            if (this.readBufferStartPosition <= currentPosition && currentPosition < this.readBufferStartPosition + (long)this.readBuffer.limit()) {
                long posInBuffer = currentPosition - this.readBufferStartPosition;
                long bytesToCopy = Math.min((long)dest.remaining(), (long)this.readBuffer.limit() - posInBuffer);
                ByteBuffer rbDup = this.readBuffer.duplicate();
                rbDup.position((int)posInBuffer);
                rbDup.limit((int)(posInBuffer + bytesToCopy));
                dest.put(rbDup);
                currentPosition += bytesToCopy;
                ++this.cacheHitCount;
                continue;
            }
            if (currentPosition >= eof) break;
            this.readBuffer.clear();
            this.readBufferStartPosition = currentPosition;
            int readBytes = 0;
            readBytes = this.validateAndGetFileChannel().read(this.readBuffer, currentPosition);
            if (readBytes <= 0) {
                throw new IOException("Reading from filechannel returned a non-positive value. Short read.");
            }
            this.readBuffer.limit(readBytes);
        }
        return (int)(currentPosition - pos);
    }

    public synchronized void clear() {
        this.readBuffer.clear();
        this.readBuffer.limit(0);
    }
}

