/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.args.parsers;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import com.twitter.common.args.parsers.NonParameterizedTypeParser;

public class RangeParser
extends NonParameterizedTypeParser<Range<Integer>> {
    @Override
    public Range<Integer> doParse(String raw) throws IllegalArgumentException {
        ImmutableList numbers = ImmutableList.copyOf((Iterable)Splitter.on((char)'-').omitEmptyStrings().split((CharSequence)raw));
        try {
            int from = Integer.parseInt((String)numbers.get(0));
            int to = Integer.parseInt((String)numbers.get(1));
            if (numbers.size() != 2) {
                throw new IllegalArgumentException("Failed to parse the range:" + raw);
            }
            if (to < from) {
                return Range.closed((Comparable)Integer.valueOf(to), (Comparable)Integer.valueOf(from));
            }
            return Range.closed((Comparable)Integer.valueOf(from), (Comparable)Integer.valueOf(to));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Failed to parse the range:" + raw, e);
        }
    }
}

