/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.util;

import com.google.common.base.Preconditions;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;

public class QueueDrainer<T extends Runnable>
implements Runnable {
    private final Executor taskExecutor;
    private final BlockingQueue<T> blockingQueue;

    public QueueDrainer(Executor taskExecutor, BlockingQueue<T> blockingQueue) {
        this.taskExecutor = (Executor)Preconditions.checkNotNull((Object)taskExecutor);
        this.blockingQueue = (BlockingQueue)Preconditions.checkNotNull(blockingQueue);
    }

    @Override
    public void run() {
        Runnable command = (Runnable)this.blockingQueue.poll();
        if (command != null) {
            this.taskExecutor.execute(command);
        }
    }
}

