/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.stats;

import com.twitter.common.stats.StatisticsInterface;

public class Statistics
implements StatisticsInterface {
    private long populationSize;
    private long sum;
    private double accumulatedVariance;
    private double runningMean;
    private long minValue;
    private long maxValue;

    public Statistics() {
        this.clear();
    }

    @Override
    public void accumulate(long l) {
        ++this.populationSize;
        this.sum += l;
        double d = (double)l - this.runningMean;
        this.runningMean += d / (double)this.populationSize;
        this.accumulatedVariance += d * ((double)l - this.runningMean);
        this.minValue = l < this.minValue ? l : this.minValue;
        this.maxValue = l > this.maxValue ? l : this.maxValue;
    }

    @Override
    public void clear() {
        this.populationSize = 0L;
        this.sum = 0L;
        this.accumulatedVariance = 0.0;
        this.runningMean = 0.0;
        this.minValue = Long.MAX_VALUE;
        this.maxValue = Long.MIN_VALUE;
    }

    @Override
    public double variance() {
        return this.accumulatedVariance / (double)this.populationSize;
    }

    @Override
    public double standardDeviation() {
        return Math.sqrt(this.variance());
    }

    @Override
    public double mean() {
        return this.runningMean;
    }

    @Override
    public long min() {
        return this.minValue;
    }

    @Override
    public long max() {
        return this.maxValue;
    }

    @Override
    public long range() {
        return this.maxValue - this.minValue;
    }

    @Override
    public long sum() {
        return this.sum;
    }

    @Override
    public long populationSize() {
        return this.populationSize;
    }

    public String toString() {
        return String.format("Mean: %f, Min: %d, Max: %d, Range: %d, Stddev: %f, Variance: %f, Population: %d, Sum: %d", this.mean(), this.min(), this.max(), this.range(), this.standardDeviation(), this.variance(), this.populationSize(), this.sum());
    }
}

