/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.net;

import io.netty.util.HashedWheelTimer;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.net.NetworkTopology;
import org.apache.bookkeeper.net.NetworkTopologyImpl;
import org.apache.bookkeeper.net.Node;
import org.apache.bookkeeper.util.MathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StabilizeNetworkTopology
implements NetworkTopology {
    private static final Logger logger = LoggerFactory.getLogger(StabilizeNetworkTopology.class);
    protected final NetworkTopologyImpl impl = new NetworkTopologyImpl();
    protected final HashedWheelTimer timer;
    protected final ConcurrentMap<Node, NodeStatus> nodeStatuses;
    protected final long stabilizePeriodMillis;

    public StabilizeNetworkTopology(HashedWheelTimer timer, int stabilizePeriodSeconds) {
        this.timer = timer;
        this.nodeStatuses = new ConcurrentHashMap<Node, NodeStatus>();
        this.stabilizePeriodMillis = TimeUnit.SECONDS.toMillis(stabilizePeriodSeconds);
    }

    void updateNode(Node node, boolean tentativeToRemove) {
        NodeStatus ns = (NodeStatus)this.nodeStatuses.get(node);
        if (null == ns) {
            NodeStatus newStatus = new NodeStatus();
            NodeStatus oldStatus = this.nodeStatuses.putIfAbsent(node, newStatus);
            ns = null == oldStatus ? newStatus : oldStatus;
        }
        ns.updateStatus(tentativeToRemove);
    }

    @Override
    public void add(Node node) {
        this.updateNode(node, false);
        this.impl.add(node);
    }

    @Override
    public void remove(Node node) {
        this.updateNode(node, true);
        this.timer.newTimeout((TimerTask)new RemoveNodeTask(node), this.stabilizePeriodMillis, TimeUnit.MILLISECONDS);
    }

    @Override
    public boolean contains(Node node) {
        return this.impl.contains(node);
    }

    @Override
    public Node getNode(String loc) {
        return this.impl.getNode(loc);
    }

    @Override
    public int getNumOfRacks() {
        return this.impl.getNumOfRacks();
    }

    @Override
    public Set<Node> getLeaves(String loc) {
        return this.impl.getLeaves(loc);
    }

    private class RemoveNodeTask
    implements TimerTask {
        private final Node node;

        RemoveNodeTask(Node node) {
            this.node = node;
        }

        public void run(Timeout timeout) throws Exception {
            long millisSinceLastSeen;
            if (timeout.isCancelled()) {
                return;
            }
            NodeStatus status = (NodeStatus)StabilizeNetworkTopology.this.nodeStatuses.get(this.node);
            if (null == status) {
                StabilizeNetworkTopology.this.impl.remove(this.node);
            } else if (status.isTentativeToRemove() && (millisSinceLastSeen = MathUtils.now() - status.getLastPresentTime()) >= StabilizeNetworkTopology.this.stabilizePeriodMillis) {
                logger.info("Node {} (seen @ {}) becomes stale for {} ms, remove it from the topology.", new Object[]{this.node, status.getLastPresentTime(), millisSinceLastSeen});
                StabilizeNetworkTopology.this.impl.remove(this.node);
                StabilizeNetworkTopology.this.nodeStatuses.remove(this.node, status);
            }
        }
    }

    static class NodeStatus {
        long lastPresentTime = MathUtils.now();
        boolean tentativeToRemove;

        NodeStatus() {
        }

        synchronized boolean isTentativeToRemove() {
            return this.tentativeToRemove;
        }

        synchronized NodeStatus updateStatus(boolean tentativeToRemove) {
            this.tentativeToRemove = tentativeToRemove;
            if (!this.tentativeToRemove) {
                this.lastPresentTime = MathUtils.now();
            }
            return this;
        }

        synchronized long getLastPresentTime() {
            return this.lastPresentTime;
        }
    }
}

