/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.jshell;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.lang.model.element.Name;
import org.openjdk.source.tree.ClassTree;
import org.openjdk.source.tree.IdentifierTree;
import org.openjdk.source.tree.ImportTree;
import org.openjdk.source.tree.MemberSelectTree;
import org.openjdk.source.tree.MethodTree;
import org.openjdk.source.tree.PackageTree;
import org.openjdk.source.tree.Tree;
import org.openjdk.source.tree.VariableTree;
import org.openjdk.source.util.TreeScanner;

class TreeDependencyScanner
extends TreeScanner<Void, Set<String>> {
    private final Set<String> decl = new HashSet<String>();
    private final Set<String> body = new HashSet<String>();

    TreeDependencyScanner() {
    }

    public void scan(Tree node) {
        this.scan(node, this.decl);
    }

    public Collection<String> declareReferences() {
        return this.decl;
    }

    public Collection<String> bodyReferences() {
        return this.body;
    }

    private void add(Set<String> p, Name name) {
        p.add(name.toString());
    }

    @Override
    public Void visitClass(ClassTree node, Set<String> p) {
        this.scan(node.getModifiers(), p);
        this.scan(node.getTypeParameters(), p);
        this.scan(node.getExtendsClause(), p);
        this.scan(node.getImplementsClause(), p);
        this.scan(node.getMembers(), this.body);
        return null;
    }

    @Override
    public Void visitMethod(MethodTree node, Set<String> p) {
        this.scan(node.getModifiers(), p);
        this.scan(node.getReturnType(), p);
        this.scan(node.getTypeParameters(), p);
        this.scan(node.getParameters(), p);
        this.scan(node.getReceiverParameter(), p);
        this.scan(node.getThrows(), p);
        this.scan(node.getBody(), this.body);
        this.scan(node.getDefaultValue(), this.body);
        return null;
    }

    @Override
    public Void visitVariable(VariableTree node, Set<String> p) {
        this.scan(node.getModifiers(), p);
        this.scan(node.getType(), p);
        this.scan(node.getNameExpression(), p);
        this.scan(node.getInitializer(), this.body);
        return null;
    }

    @Override
    public Void visitPackage(PackageTree node, Set<String> p) {
        return null;
    }

    @Override
    public Void visitImport(ImportTree node, Set<String> p) {
        return null;
    }

    @Override
    public Void visitMemberSelect(MemberSelectTree node, Set<String> p) {
        this.add(p, node.getIdentifier());
        return (Void)super.visitMemberSelect(node, p);
    }

    @Override
    public Void visitIdentifier(IdentifierTree node, Set<String> p) {
        this.add(p, node.getName());
        return (Void)super.visitIdentifier(node, p);
    }
}

