/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javadoc.internal.doclets.toolkit.builders;

import java.util.HashSet;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.AnnotationTypeWriter;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.ClassWriter;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.Configuration;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.PropertyWriter;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.WriterFactory;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.builders.AbstractBuilder;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.builders.AnnotationTypeBuilder;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.builders.AnnotationTypeFieldBuilder;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.builders.AnnotationTypeOptionalMemberBuilder;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.builders.AnnotationTypeRequiredMemberBuilder;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.builders.ClassBuilder;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.builders.ConstantsSummaryBuilder;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.builders.ConstructorBuilder;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.builders.EnumConstantBuilder;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.builders.FieldBuilder;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.builders.LayoutParser;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.builders.MemberSummaryBuilder;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.builders.MethodBuilder;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.builders.PackageSummaryBuilder;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.builders.PropertyBuilder;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.builders.SerializedFormBuilder;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.ClassTree;

public class BuilderFactory {
    private final Configuration configuration;
    private final WriterFactory writerFactory;
    private final AbstractBuilder.Context context;

    public BuilderFactory(Configuration configuration) {
        this.configuration = configuration;
        this.writerFactory = configuration.getWriterFactory();
        HashSet<PackageElement> containingPackagesSeen = new HashSet<PackageElement>();
        this.context = new AbstractBuilder.Context(configuration, containingPackagesSeen, LayoutParser.getInstance(configuration));
    }

    public AbstractBuilder getConstantsSummaryBuilder() throws Exception {
        return ConstantsSummaryBuilder.getInstance(this.context, this.writerFactory.getConstantsSummaryWriter());
    }

    public AbstractBuilder getPackageSummaryBuilder(PackageElement pkg, PackageElement prevPkg, PackageElement nextPkg) throws Exception {
        return PackageSummaryBuilder.getInstance(this.context, pkg, this.writerFactory.getPackageSummaryWriter(pkg, prevPkg, nextPkg));
    }

    public AbstractBuilder getClassBuilder(TypeElement typeElement, TypeElement prevClass, TypeElement nextClass, ClassTree classTree) throws Exception {
        return ClassBuilder.getInstance(this.context, typeElement, this.writerFactory.getClassWriter(typeElement, prevClass, nextClass, classTree));
    }

    public AbstractBuilder getAnnotationTypeBuilder(TypeElement annotationType, TypeMirror prevType, TypeMirror nextType) throws Exception {
        return AnnotationTypeBuilder.getInstance(this.context, annotationType, this.writerFactory.getAnnotationTypeWriter(annotationType, prevType, nextType));
    }

    public AbstractBuilder getMethodBuilder(ClassWriter classWriter) throws Exception {
        return MethodBuilder.getInstance(this.context, classWriter.getTypeElement(), this.writerFactory.getMethodWriter(classWriter));
    }

    public AbstractBuilder getAnnotationTypeFieldsBuilder(AnnotationTypeWriter annotationTypeWriter) throws Exception {
        return AnnotationTypeFieldBuilder.getInstance(this.context, annotationTypeWriter.getAnnotationTypeElement(), this.writerFactory.getAnnotationTypeFieldWriter(annotationTypeWriter));
    }

    public AbstractBuilder getAnnotationTypeOptionalMemberBuilder(AnnotationTypeWriter annotationTypeWriter) throws Exception {
        return AnnotationTypeOptionalMemberBuilder.getInstance(this.context, annotationTypeWriter.getAnnotationTypeElement(), this.writerFactory.getAnnotationTypeOptionalMemberWriter(annotationTypeWriter));
    }

    public AbstractBuilder getAnnotationTypeRequiredMemberBuilder(AnnotationTypeWriter annotationTypeWriter) throws Exception {
        return AnnotationTypeRequiredMemberBuilder.getInstance(this.context, annotationTypeWriter.getAnnotationTypeElement(), this.writerFactory.getAnnotationTypeRequiredMemberWriter(annotationTypeWriter));
    }

    public AbstractBuilder getEnumConstantsBuilder(ClassWriter classWriter) throws Exception {
        return EnumConstantBuilder.getInstance(this.context, classWriter.getTypeElement(), this.writerFactory.getEnumConstantWriter(classWriter));
    }

    public AbstractBuilder getFieldBuilder(ClassWriter classWriter) throws Exception {
        return FieldBuilder.getInstance(this.context, classWriter.getTypeElement(), this.writerFactory.getFieldWriter(classWriter));
    }

    public AbstractBuilder getPropertyBuilder(ClassWriter classWriter) throws Exception {
        PropertyWriter propertyWriter = this.writerFactory.getPropertyWriter(classWriter);
        return PropertyBuilder.getInstance(this.context, classWriter.getTypeElement(), propertyWriter);
    }

    public AbstractBuilder getConstructorBuilder(ClassWriter classWriter) throws Exception {
        return ConstructorBuilder.getInstance(this.context, classWriter.getTypeElement(), this.writerFactory.getConstructorWriter(classWriter));
    }

    public AbstractBuilder getMemberSummaryBuilder(ClassWriter classWriter) throws Exception {
        return MemberSummaryBuilder.getInstance(classWriter, this.context);
    }

    public AbstractBuilder getMemberSummaryBuilder(AnnotationTypeWriter annotationTypeWriter) throws Exception {
        return MemberSummaryBuilder.getInstance(annotationTypeWriter, this.context);
    }

    public AbstractBuilder getSerializedFormBuilder() throws Exception {
        return SerializedFormBuilder.getInstance(this.context);
    }
}

