/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javac.parser;

import java.text.BreakIterator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openjdk.source.doctree.AttributeTree;
import org.openjdk.source.doctree.DocTree;
import org.openjdk.source.doctree.IdentifierTree;
import org.openjdk.source.doctree.ReferenceTree;
import org.openjdk.tools.javac.parser.JavacParser;
import org.openjdk.tools.javac.parser.ParserFactory;
import org.openjdk.tools.javac.parser.Tokens;
import org.openjdk.tools.javac.tree.DCTree;
import org.openjdk.tools.javac.tree.DocTreeMaker;
import org.openjdk.tools.javac.tree.JCTree;
import org.openjdk.tools.javac.util.DiagnosticSource;
import org.openjdk.tools.javac.util.ListBuffer;
import org.openjdk.tools.javac.util.Log;
import org.openjdk.tools.javac.util.Name;
import org.openjdk.tools.javac.util.Names;

public class DocCommentParser {
    final ParserFactory fac;
    final DiagnosticSource diagSource;
    final Tokens.Comment comment;
    final DocTreeMaker m;
    final Names names;
    BreakIterator sentenceBreaker;
    protected char[] buf;
    protected int bp;
    protected int buflen;
    protected char ch;
    int textStart = -1;
    int lastNonWhite = -1;
    boolean newline = true;
    Map<Name, TagParser> tagParsers;

    public DocCommentParser(ParserFactory fac, DiagnosticSource diagSource, Tokens.Comment comment) {
        this.fac = fac;
        this.diagSource = diagSource;
        this.comment = comment;
        this.names = fac.names;
        this.m = fac.docTreeMaker;
        this.initTagParsers();
    }

    public DocCommentParser(ParserFactory fac) {
        this(fac, null, null);
    }

    public DCTree.DCDocComment parse() {
        String c = this.comment.getText();
        this.buf = new char[c.length() + 1];
        c.getChars(0, c.length(), this.buf, 0);
        this.buf[this.buf.length - 1] = 26;
        this.buflen = this.buf.length - 1;
        this.bp = -1;
        this.nextChar();
        org.openjdk.tools.javac.util.List<DCTree> body = this.blockContent();
        org.openjdk.tools.javac.util.List<DCTree> tags = this.blockTags();
        int pos = !body.isEmpty() ? ((DCTree)body.head).pos : (!tags.isEmpty() ? ((DCTree)tags.head).pos : -1);
        DCTree.DCDocComment dc = this.m.at(pos).newDocCommentTree(this.comment, body, tags);
        return dc;
    }

    void nextChar() {
        this.ch = this.buf[this.bp < this.buflen ? (this.bp = this.bp + 1) : this.buflen];
        switch (this.ch) {
            case '\n': 
            case '\f': 
            case '\r': {
                this.newline = true;
            }
        }
    }

    protected org.openjdk.tools.javac.util.List<DCTree> blockContent() {
        ListBuffer<DCTree> trees = new ListBuffer<DCTree>();
        this.textStart = -1;
        block9: while (this.bp < this.buflen) {
            switch (this.ch) {
                case '\n': 
                case '\f': 
                case '\r': {
                    this.newline = true;
                }
                case '\t': 
                case ' ': {
                    this.nextChar();
                    continue block9;
                }
                case '&': {
                    this.entity(trees);
                    continue block9;
                }
                case '<': {
                    this.newline = false;
                    this.addPendingText(trees, this.bp - 1);
                    trees.add(this.html());
                    if (this.textStart != -1) continue block9;
                    this.textStart = this.bp;
                    this.lastNonWhite = -1;
                    continue block9;
                }
                case '>': {
                    this.newline = false;
                    this.addPendingText(trees, this.bp - 1);
                    trees.add(this.m.at(this.bp).newErroneousTree(this.newString(this.bp, this.bp + 1), this.diagSource, "dc.bad.gt", new Object[0]));
                    this.nextChar();
                    if (this.textStart != -1) continue block9;
                    this.textStart = this.bp;
                    this.lastNonWhite = -1;
                    continue block9;
                }
                case '{': {
                    this.inlineTag(trees);
                    continue block9;
                }
                case '@': {
                    if (this.newline) {
                        this.addPendingText(trees, this.lastNonWhite);
                        break block9;
                    }
                }
                default: {
                    this.newline = false;
                    if (this.textStart == -1) {
                        this.textStart = this.bp;
                    }
                    this.lastNonWhite = this.bp;
                    this.nextChar();
                    continue block9;
                }
            }
        }
        if (this.lastNonWhite != -1) {
            this.addPendingText(trees, this.lastNonWhite);
        }
        return trees.toList();
    }

    protected org.openjdk.tools.javac.util.List<DCTree> blockTags() {
        ListBuffer<DCTree> tags = new ListBuffer<DCTree>();
        while (this.ch == '@') {
            tags.add(this.blockTag());
        }
        return tags.toList();
    }

    protected DCTree blockTag() {
        int p = this.bp;
        try {
            this.nextChar();
            if (this.isIdentifierStart(this.ch)) {
                Name name = this.readTagName();
                TagParser tp = this.tagParsers.get(name);
                if (tp == null) {
                    org.openjdk.tools.javac.util.List<DCTree> content = this.blockContent();
                    return this.m.at(p).newUnknownBlockTagTree((javax.lang.model.element.Name)name, content);
                }
                switch (tp.getKind()) {
                    case BLOCK: {
                        return tp.parse(p);
                    }
                    case INLINE: {
                        return this.erroneous("dc.bad.inline.tag", p);
                    }
                }
            }
            this.blockContent();
            return this.erroneous("dc.no.tag.name", p);
        }
        catch (ParseException e) {
            this.blockContent();
            return this.erroneous(e.getMessage(), p);
        }
    }

    protected void inlineTag(ListBuffer<DCTree> list) {
        this.newline = false;
        this.nextChar();
        if (this.ch == '@') {
            this.addPendingText(list, this.bp - 2);
            list.add(this.inlineTag());
            this.textStart = this.bp;
            this.lastNonWhite = -1;
        } else {
            if (this.textStart == -1) {
                this.textStart = this.bp - 1;
            }
            this.lastNonWhite = this.bp;
        }
    }

    protected DCTree inlineTag() {
        int p = this.bp - 1;
        try {
            this.nextChar();
            if (this.isIdentifierStart(this.ch)) {
                Name name = this.readTagName();
                TagParser tp = this.tagParsers.get(name);
                if (tp == null) {
                    this.skipWhitespace();
                    DCTree text = this.inlineText(WhitespaceRetentionPolicy.REMOVE_ALL);
                    if (text != null) {
                        this.nextChar();
                        return ((DCTree.DCEndPosTree)((Object)this.m.at(p).newUnknownInlineTagTree((javax.lang.model.element.Name)name, org.openjdk.tools.javac.util.List.of(text)))).setEndPos(this.bp);
                    }
                } else {
                    if (!tp.retainWhiteSpace) {
                        this.skipWhitespace();
                    }
                    if (tp.getKind() == TagParser.Kind.INLINE) {
                        DCTree.DCEndPosTree tree = (DCTree.DCEndPosTree)tp.parse(p);
                        if (tree != null) {
                            return tree.setEndPos(this.bp);
                        }
                    } else {
                        this.inlineText(WhitespaceRetentionPolicy.REMOVE_ALL);
                        this.nextChar();
                    }
                }
            }
            return this.erroneous("dc.no.tag.name", p);
        }
        catch (ParseException e) {
            return this.erroneous(e.getMessage(), p);
        }
    }

    private DCTree inlineText(WhitespaceRetentionPolicy whitespacePolicy) throws ParseException {
        switch (whitespacePolicy) {
            case REMOVE_ALL: {
                this.skipWhitespace();
                break;
            }
            case REMOVE_FIRST_SPACE: {
                if (this.ch != ' ') break;
                this.nextChar();
                break;
            }
        }
        int pos = this.bp;
        int depth = 1;
        block11: while (this.bp < this.buflen) {
            switch (this.ch) {
                case '\n': 
                case '\f': 
                case '\r': {
                    this.newline = true;
                    break;
                }
                case '\t': 
                case ' ': {
                    break;
                }
                case '{': {
                    this.newline = false;
                    this.lastNonWhite = this.bp;
                    ++depth;
                    break;
                }
                case '}': {
                    if (--depth == 0) {
                        return this.m.at(pos).newTextTree(this.newString(pos, this.bp));
                    }
                    this.newline = false;
                    this.lastNonWhite = this.bp;
                    break;
                }
                case '@': {
                    if (this.newline) break block11;
                    this.newline = false;
                    this.lastNonWhite = this.bp;
                    break;
                }
                default: {
                    this.newline = false;
                    this.lastNonWhite = this.bp;
                }
            }
            this.nextChar();
        }
        throw new ParseException("dc.unterminated.inline.tag");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DCTree.DCReference reference(boolean allowMember) throws ParseException {
        org.openjdk.tools.javac.util.List<JCTree> paramTypes;
        Name member;
        JCTree qualExpr;
        int pos = this.bp;
        int depth = 0;
        block11: while (this.bp < this.buflen) {
            switch (this.ch) {
                case '\n': 
                case '\f': 
                case '\r': {
                    this.newline = true;
                }
                case '\t': 
                case ' ': {
                    if (depth != 0) break;
                    break block11;
                }
                case '(': 
                case '<': {
                    this.newline = false;
                    ++depth;
                    break;
                }
                case ')': 
                case '>': {
                    this.newline = false;
                    --depth;
                    break;
                }
                case '}': {
                    if (this.bp == pos) {
                        return null;
                    }
                    this.newline = false;
                    break block11;
                }
                case '@': {
                    if (this.newline) break block11;
                }
                default: {
                    this.newline = false;
                }
            }
            this.nextChar();
        }
        if (depth != 0) {
            throw new ParseException("dc.unterminated.signature");
        }
        String sig = this.newString(pos, this.bp);
        Log.DeferredDiagnosticHandler deferredDiagnosticHandler = new Log.DeferredDiagnosticHandler(this.fac.log);
        try {
            int hash = sig.indexOf("#");
            int lparen = sig.indexOf("(", hash + 1);
            if (hash == -1) {
                if (lparen == -1) {
                    qualExpr = this.parseType(sig);
                    member = null;
                } else {
                    qualExpr = null;
                    member = this.parseMember(sig.substring(0, lparen));
                }
            } else {
                qualExpr = hash == 0 ? null : this.parseType(sig.substring(0, hash));
                member = lparen == -1 ? this.parseMember(sig.substring(hash + 1)) : this.parseMember(sig.substring(hash + 1, lparen));
            }
            if (lparen < 0) {
                paramTypes = null;
            } else {
                int rparen = sig.indexOf(")", lparen);
                if (rparen != sig.length() - 1) {
                    throw new ParseException("dc.ref.bad.parens");
                }
                paramTypes = this.parseParams(sig.substring(lparen + 1, rparen));
            }
            if (!deferredDiagnosticHandler.getDiagnostics().isEmpty()) {
                throw new ParseException("dc.ref.syntax.error");
            }
        }
        finally {
            this.fac.log.popDiagnosticHandler(deferredDiagnosticHandler);
        }
        return (DCTree.DCReference)this.m.at(pos).newReferenceTree(sig, qualExpr, member, paramTypes).setEndPos(this.bp);
    }

    JCTree parseType(String s) throws ParseException {
        JavacParser p = this.fac.newParser(s, false, false, false);
        JCTree.JCExpression tree = p.parseType();
        if (p.token().kind != Tokens.TokenKind.EOF) {
            throw new ParseException("dc.ref.unexpected.input");
        }
        return tree;
    }

    Name parseMember(String s) throws ParseException {
        JavacParser p = this.fac.newParser(s, false, false, false);
        Name name = p.ident();
        if (p.token().kind != Tokens.TokenKind.EOF) {
            throw new ParseException("dc.ref.unexpected.input");
        }
        return name;
    }

    org.openjdk.tools.javac.util.List<JCTree> parseParams(String s) throws ParseException {
        if (s.trim().isEmpty()) {
            return org.openjdk.tools.javac.util.List.nil();
        }
        JavacParser p = this.fac.newParser(s.replace("...", "[]"), false, false, false);
        ListBuffer<JCTree.JCExpression> paramTypes = new ListBuffer<JCTree.JCExpression>();
        paramTypes.add(p.parseType());
        if (p.token().kind == Tokens.TokenKind.IDENTIFIER) {
            p.nextToken();
        }
        while (p.token().kind == Tokens.TokenKind.COMMA) {
            p.nextToken();
            paramTypes.add(p.parseType());
            if (p.token().kind != Tokens.TokenKind.IDENTIFIER) continue;
            p.nextToken();
        }
        if (p.token().kind != Tokens.TokenKind.EOF) {
            throw new ParseException("dc.ref.unexpected.input");
        }
        return paramTypes.toList();
    }

    protected DCTree.DCIdentifier identifier() throws ParseException {
        this.skipWhitespace();
        int pos = this.bp;
        if (this.isJavaIdentifierStart(this.ch)) {
            Name name = this.readJavaIdentifier();
            return this.m.at(pos).newIdentifierTree(name);
        }
        throw new ParseException("dc.identifier.expected");
    }

    /*
     * Enabled aggressive block sorting
     */
    protected DCTree.DCText quotedString() {
        int pos = this.bp;
        this.nextChar();
        while (this.bp < this.buflen) {
            switch (this.ch) {
                case '\n': 
                case '\f': 
                case '\r': {
                    this.newline = true;
                    break;
                }
                case '\t': 
                case ' ': {
                    break;
                }
                case '\"': {
                    this.nextChar();
                    return this.m.at(pos).newTextTree(this.newString(pos, this.bp));
                }
                case '@': {
                    if (!this.newline) break;
                    return null;
                }
            }
            this.nextChar();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected DCTree.DCText inlineWord() {
        int pos = this.bp;
        int depth = 0;
        while (this.bp < this.buflen) {
            switch (this.ch) {
                case '\n': {
                    this.newline = true;
                }
                case '\t': 
                case '\f': 
                case '\r': 
                case ' ': {
                    return this.m.at(pos).newTextTree(this.newString(pos, this.bp));
                }
                case '@': {
                    if (this.newline) {
                        return null;
                    }
                }
                case '{': {
                    ++depth;
                    break;
                }
                case '}': {
                    if (depth == 0) return this.m.at(pos).newTextTree(this.newString(pos, this.bp));
                    if (--depth != 0) break;
                    return this.m.at(pos).newTextTree(this.newString(pos, this.bp));
                }
            }
            this.newline = false;
            this.nextChar();
        }
        return null;
    }

    private org.openjdk.tools.javac.util.List<DCTree> inlineContent() {
        ListBuffer<DCTree> trees = new ListBuffer<DCTree>();
        this.skipWhitespace();
        int pos = this.bp;
        int depth = 1;
        this.textStart = -1;
        block9: while (this.bp < this.buflen) {
            switch (this.ch) {
                case '\n': 
                case '\f': 
                case '\r': {
                    this.newline = true;
                }
                case '\t': 
                case ' ': {
                    this.nextChar();
                    continue block9;
                }
                case '&': {
                    this.entity(trees);
                    continue block9;
                }
                case '<': {
                    this.newline = false;
                    this.addPendingText(trees, this.bp - 1);
                    trees.add(this.html());
                    continue block9;
                }
                case '{': {
                    if (this.textStart == -1) {
                        this.textStart = this.bp;
                    }
                    this.newline = false;
                    ++depth;
                    this.nextChar();
                    continue block9;
                }
                case '}': {
                    this.newline = false;
                    if (--depth == 0) {
                        this.addPendingText(trees, this.bp - 1);
                        this.nextChar();
                        return trees.toList();
                    }
                    this.nextChar();
                    continue block9;
                }
                case '@': {
                    if (this.newline) break block9;
                }
                default: {
                    if (this.textStart == -1) {
                        this.textStart = this.bp;
                    }
                    this.nextChar();
                    continue block9;
                }
            }
        }
        return org.openjdk.tools.javac.util.List.of(this.erroneous("dc.unterminated.inline.tag", pos));
    }

    protected void entity(ListBuffer<DCTree> list) {
        this.newline = false;
        this.addPendingText(list, this.bp - 1);
        list.add(this.entity());
        if (this.textStart == -1) {
            this.textStart = this.bp;
            this.lastNonWhite = -1;
        }
    }

    protected DCTree entity() {
        int p = this.bp;
        this.nextChar();
        Name name = null;
        if (this.ch == '#') {
            int namep = this.bp;
            this.nextChar();
            if (this.isDecimalDigit(this.ch)) {
                this.nextChar();
                while (this.isDecimalDigit(this.ch)) {
                    this.nextChar();
                }
                name = this.names.fromChars(this.buf, namep, this.bp - namep);
            } else if (this.ch == 'x' || this.ch == 'X') {
                this.nextChar();
                if (this.isHexDigit(this.ch)) {
                    this.nextChar();
                    while (this.isHexDigit(this.ch)) {
                        this.nextChar();
                    }
                    name = this.names.fromChars(this.buf, namep, this.bp - namep);
                }
            }
        } else if (this.isIdentifierStart(this.ch)) {
            name = this.readIdentifier();
        }
        if (name == null) {
            return this.erroneous("dc.bad.entity", p);
        }
        if (this.ch != ';') {
            return this.erroneous("dc.missing.semicolon", p);
        }
        this.nextChar();
        return this.m.at(p).newEntityTree(name);
    }

    protected DCTree html() {
        int p = this.bp;
        this.nextChar();
        if (this.isIdentifierStart(this.ch)) {
            Name name = this.readIdentifier();
            org.openjdk.tools.javac.util.List<DCTree> attrs = this.htmlAttrs();
            if (attrs != null) {
                boolean selfClosing = false;
                if (this.ch == '/') {
                    this.nextChar();
                    selfClosing = true;
                }
                if (this.ch == '>') {
                    this.nextChar();
                    Object dctree = ((DCTree.DCEndPosTree)((Object)this.m.at(p).newStartElementTree((javax.lang.model.element.Name)name, attrs, selfClosing))).setEndPos(this.bp);
                    return dctree;
                }
            }
        } else if (this.ch == '/') {
            this.nextChar();
            if (this.isIdentifierStart(this.ch)) {
                Name name = this.readIdentifier();
                this.skipWhitespace();
                if (this.ch == '>') {
                    this.nextChar();
                    return this.m.at(p).newEndElementTree(name);
                }
            }
        } else if (this.ch == '!') {
            this.nextChar();
            if (this.ch == '-') {
                this.nextChar();
                if (this.ch == '-') {
                    this.nextChar();
                    while (this.bp < this.buflen) {
                        int dash = 0;
                        while (this.ch == '-') {
                            ++dash;
                            this.nextChar();
                        }
                        if (dash >= 2 && this.ch == '>') {
                            this.nextChar();
                            return this.m.at(p).newCommentTree(this.newString(p, this.bp));
                        }
                        this.nextChar();
                    }
                }
            }
        }
        this.bp = p + 1;
        this.ch = this.buf[this.bp];
        return this.erroneous("dc.malformed.html", p);
    }

    protected org.openjdk.tools.javac.util.List<DCTree> htmlAttrs() {
        ListBuffer<DocTree> attrs = new ListBuffer<DocTree>();
        this.skipWhitespace();
        block0: while (this.isIdentifierStart(this.ch)) {
            int namePos = this.bp;
            Name name = this.readAttributeName();
            this.skipWhitespace();
            org.openjdk.tools.javac.util.List<DCTree> value = null;
            AttributeTree.ValueKind vkind = AttributeTree.ValueKind.EMPTY;
            if (this.ch == '=') {
                ListBuffer<DCTree> v = new ListBuffer<DCTree>();
                this.nextChar();
                this.skipWhitespace();
                if (this.ch == '\'' || this.ch == '\"') {
                    vkind = this.ch == '\'' ? AttributeTree.ValueKind.SINGLE : AttributeTree.ValueKind.DOUBLE;
                    char quote = this.ch;
                    this.nextChar();
                    this.textStart = this.bp;
                    while (this.bp < this.buflen && this.ch != quote) {
                        if (this.newline && this.ch == '@') {
                            attrs.add(this.erroneous("dc.unterminated.string", namePos));
                            break block0;
                        }
                        this.attrValueChar(v);
                    }
                    this.addPendingText(v, this.bp - 1);
                    this.nextChar();
                } else {
                    vkind = AttributeTree.ValueKind.UNQUOTED;
                    this.textStart = this.bp;
                    while (this.bp < this.buflen && !this.isUnquotedAttrValueTerminator(this.ch)) {
                        this.attrValueChar(v);
                    }
                    this.addPendingText(v, this.bp - 1);
                }
                this.skipWhitespace();
                value = v.toList();
            }
            AttributeTree attr = this.m.at(namePos).newAttributeTree((javax.lang.model.element.Name)name, vkind, value);
            attrs.add(attr);
        }
        return attrs.toList();
    }

    protected void attrValueChar(ListBuffer<DCTree> list) {
        switch (this.ch) {
            case '&': {
                this.entity(list);
                break;
            }
            case '{': {
                this.inlineTag(list);
                break;
            }
            default: {
                this.nextChar();
            }
        }
    }

    protected void addPendingText(ListBuffer<DCTree> list, int textEnd) {
        if (this.textStart != -1) {
            if (this.textStart <= textEnd) {
                list.add(this.m.at(this.textStart).newTextTree(this.newString(this.textStart, textEnd + 1)));
            }
            this.textStart = -1;
        }
    }

    protected DCTree.DCErroneous erroneous(String code, int pos) {
        int i;
        block4: for (i = this.bp - 1; i > pos; --i) {
            switch (this.buf[i]) {
                case '\n': 
                case '\f': 
                case '\r': {
                    this.newline = true;
                    continue block4;
                }
                case '\t': 
                case ' ': {
                    continue block4;
                }
            }
        }
        this.textStart = -1;
        return this.m.at(pos).newErroneousTree(this.newString(pos, i + 1), this.diagSource, code, new Object[0]);
    }

    protected boolean isIdentifierStart(char ch) {
        return Character.isUnicodeIdentifierStart(ch);
    }

    protected Name readIdentifier() {
        int start = this.bp;
        this.nextChar();
        while (this.bp < this.buflen && Character.isUnicodeIdentifierPart(this.ch)) {
            this.nextChar();
        }
        return this.names.fromChars(this.buf, start, this.bp - start);
    }

    protected Name readAttributeName() {
        int start = this.bp;
        this.nextChar();
        while (this.bp < this.buflen && (Character.isUnicodeIdentifierPart(this.ch) || this.ch == '-')) {
            this.nextChar();
        }
        return this.names.fromChars(this.buf, start, this.bp - start);
    }

    protected Name readTagName() {
        int start = this.bp;
        this.nextChar();
        while (this.bp < this.buflen && (Character.isUnicodeIdentifierPart(this.ch) || this.ch == '.' || this.ch == '-' || this.ch == ':')) {
            this.nextChar();
        }
        return this.names.fromChars(this.buf, start, this.bp - start);
    }

    protected boolean isJavaIdentifierStart(char ch) {
        return Character.isJavaIdentifierStart(ch);
    }

    protected Name readJavaIdentifier() {
        int start = this.bp;
        this.nextChar();
        while (this.bp < this.buflen && Character.isJavaIdentifierPart(this.ch)) {
            this.nextChar();
        }
        return this.names.fromChars(this.buf, start, this.bp - start);
    }

    protected boolean isDecimalDigit(char ch) {
        return '0' <= ch && ch <= '9';
    }

    protected boolean isHexDigit(char ch) {
        return '0' <= ch && ch <= '9' || 'a' <= ch && ch <= 'f' || 'A' <= ch && ch <= 'F';
    }

    protected boolean isUnquotedAttrValueTerminator(char ch) {
        switch (ch) {
            case '\t': 
            case '\n': 
            case '\f': 
            case '\r': 
            case ' ': 
            case '\"': 
            case '\'': 
            case '<': 
            case '=': 
            case '>': 
            case '`': {
                return true;
            }
        }
        return false;
    }

    protected boolean isWhitespace(char ch) {
        return Character.isWhitespace(ch);
    }

    protected void skipWhitespace() {
        while (this.isWhitespace(this.ch)) {
            this.nextChar();
        }
    }

    String newString(int start, int end) {
        return new String(this.buf, start, end - start);
    }

    private void initTagParsers() {
        TagParser[] parsers = new TagParser[]{new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.AUTHOR){

            @Override
            public DCTree parse(int pos) {
                org.openjdk.tools.javac.util.List<DCTree> name = DocCommentParser.this.blockContent();
                return DocCommentParser.this.m.at(pos).newAuthorTree(name);
            }
        }, new TagParser(TagParser.Kind.INLINE, DocTree.Kind.CODE, true){

            @Override
            public DCTree parse(int pos) throws ParseException {
                DCTree text = DocCommentParser.this.inlineText(WhitespaceRetentionPolicy.REMOVE_FIRST_SPACE);
                DocCommentParser.this.nextChar();
                return DocCommentParser.this.m.at(pos).newCodeTree((DCTree.DCText)text);
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.DEPRECATED){

            @Override
            public DCTree parse(int pos) {
                org.openjdk.tools.javac.util.List<DCTree> reason = DocCommentParser.this.blockContent();
                return DocCommentParser.this.m.at(pos).newDeprecatedTree(reason);
            }
        }, new TagParser(TagParser.Kind.INLINE, DocTree.Kind.DOC_ROOT){

            @Override
            public DCTree parse(int pos) throws ParseException {
                if (DocCommentParser.this.ch == '}') {
                    DocCommentParser.this.nextChar();
                    return DocCommentParser.this.m.at(pos).newDocRootTree();
                }
                DocCommentParser.this.inlineText(WhitespaceRetentionPolicy.REMOVE_ALL);
                DocCommentParser.this.nextChar();
                throw new ParseException("dc.unexpected.content");
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.EXCEPTION){

            @Override
            public DCTree parse(int pos) throws ParseException {
                DocCommentParser.this.skipWhitespace();
                DCTree.DCReference ref = DocCommentParser.this.reference(false);
                org.openjdk.tools.javac.util.List<DCTree> description = DocCommentParser.this.blockContent();
                return DocCommentParser.this.m.at(pos).newExceptionTree((ReferenceTree)ref, description);
            }
        }, new TagParser(TagParser.Kind.INLINE, DocTree.Kind.INDEX){

            @Override
            public DCTree parse(int pos) throws ParseException {
                DCTree.DCText term;
                DocCommentParser.this.skipWhitespace();
                if (DocCommentParser.this.ch == '}') {
                    throw new ParseException("dc.no.content");
                }
                DCTree.DCText dCText = term = DocCommentParser.this.ch == '\"' ? DocCommentParser.this.quotedString() : DocCommentParser.this.inlineWord();
                if (term == null) {
                    throw new ParseException("dc.no.content");
                }
                DocCommentParser.this.skipWhitespace();
                org.openjdk.tools.javac.util.List description = org.openjdk.tools.javac.util.List.nil();
                if (DocCommentParser.this.ch != '}') {
                    description = DocCommentParser.this.inlineContent();
                } else {
                    DocCommentParser.this.nextChar();
                }
                return DocCommentParser.this.m.at(pos).newIndexTree((DocTree)term, (List)description);
            }
        }, new TagParser(TagParser.Kind.INLINE, DocTree.Kind.INHERIT_DOC){

            @Override
            public DCTree parse(int pos) throws ParseException {
                if (DocCommentParser.this.ch == '}') {
                    DocCommentParser.this.nextChar();
                    return DocCommentParser.this.m.at(pos).newInheritDocTree();
                }
                DocCommentParser.this.inlineText(WhitespaceRetentionPolicy.REMOVE_ALL);
                DocCommentParser.this.nextChar();
                throw new ParseException("dc.unexpected.content");
            }
        }, new TagParser(TagParser.Kind.INLINE, DocTree.Kind.LINK){

            @Override
            public DCTree parse(int pos) throws ParseException {
                DCTree.DCReference ref = DocCommentParser.this.reference(true);
                org.openjdk.tools.javac.util.List label = DocCommentParser.this.inlineContent();
                return DocCommentParser.this.m.at(pos).newLinkTree((ReferenceTree)ref, (List)label);
            }
        }, new TagParser(TagParser.Kind.INLINE, DocTree.Kind.LINK_PLAIN){

            @Override
            public DCTree parse(int pos) throws ParseException {
                DCTree.DCReference ref = DocCommentParser.this.reference(true);
                org.openjdk.tools.javac.util.List label = DocCommentParser.this.inlineContent();
                return DocCommentParser.this.m.at(pos).newLinkPlainTree((ReferenceTree)ref, (List)label);
            }
        }, new TagParser(TagParser.Kind.INLINE, DocTree.Kind.LITERAL, true){

            @Override
            public DCTree parse(int pos) throws ParseException {
                DCTree text = DocCommentParser.this.inlineText(WhitespaceRetentionPolicy.REMOVE_FIRST_SPACE);
                DocCommentParser.this.nextChar();
                return DocCommentParser.this.m.at(pos).newLiteralTree((DCTree.DCText)text);
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.PARAM){

            @Override
            public DCTree parse(int pos) throws ParseException {
                DocCommentParser.this.skipWhitespace();
                boolean typaram = false;
                if (DocCommentParser.this.ch == '<') {
                    typaram = true;
                    DocCommentParser.this.nextChar();
                }
                DCTree.DCIdentifier id = DocCommentParser.this.identifier();
                if (typaram) {
                    if (DocCommentParser.this.ch != '>') {
                        throw new ParseException("dc.gt.expected");
                    }
                    DocCommentParser.this.nextChar();
                }
                DocCommentParser.this.skipWhitespace();
                org.openjdk.tools.javac.util.List<DCTree> desc = DocCommentParser.this.blockContent();
                return DocCommentParser.this.m.at(pos).newParamTree(typaram, (IdentifierTree)id, desc);
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.RETURN){

            @Override
            public DCTree parse(int pos) {
                org.openjdk.tools.javac.util.List<DCTree> description = DocCommentParser.this.blockContent();
                return DocCommentParser.this.m.at(pos).newReturnTree(description);
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.SEE){

            @Override
            public DCTree parse(int pos) throws ParseException {
                DocCommentParser.this.skipWhitespace();
                switch (DocCommentParser.this.ch) {
                    case '\"': {
                        DCTree.DCText string = DocCommentParser.this.quotedString();
                        if (string == null) break;
                        DocCommentParser.this.skipWhitespace();
                        if (DocCommentParser.this.ch != '@' && (DocCommentParser.this.ch != '\u001a' || DocCommentParser.this.bp != DocCommentParser.this.buf.length - 1)) break;
                        return DocCommentParser.this.m.at(pos).newSeeTree(org.openjdk.tools.javac.util.List.of(string));
                    }
                    case '<': {
                        org.openjdk.tools.javac.util.List<DCTree> html = DocCommentParser.this.blockContent();
                        if (html == null) break;
                        return DocCommentParser.this.m.at(pos).newSeeTree(html);
                    }
                    case '@': {
                        if (!DocCommentParser.this.newline) break;
                        throw new ParseException("dc.no.content");
                    }
                    case '\u001a': {
                        if (DocCommentParser.this.bp != DocCommentParser.this.buf.length - 1) break;
                        throw new ParseException("dc.no.content");
                    }
                    default: {
                        if (!DocCommentParser.this.isJavaIdentifierStart(DocCommentParser.this.ch) && DocCommentParser.this.ch != '#') break;
                        DCTree.DCReference ref = DocCommentParser.this.reference(true);
                        org.openjdk.tools.javac.util.List<DCTree> description = DocCommentParser.this.blockContent();
                        return DocCommentParser.this.m.at(pos).newSeeTree(description.prepend(ref));
                    }
                }
                throw new ParseException("dc.unexpected.content");
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.SERIAL_DATA){

            @Override
            public DCTree parse(int pos) {
                org.openjdk.tools.javac.util.List<DCTree> description = DocCommentParser.this.blockContent();
                return DocCommentParser.this.m.at(pos).newSerialDataTree(description);
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.SERIAL_FIELD){

            @Override
            public DCTree parse(int pos) throws ParseException {
                DocCommentParser.this.skipWhitespace();
                DCTree.DCIdentifier name = DocCommentParser.this.identifier();
                DocCommentParser.this.skipWhitespace();
                DCTree.DCReference type = DocCommentParser.this.reference(false);
                org.openjdk.tools.javac.util.List<DCTree> description = null;
                if (DocCommentParser.this.isWhitespace(DocCommentParser.this.ch)) {
                    DocCommentParser.this.skipWhitespace();
                    description = DocCommentParser.this.blockContent();
                }
                return DocCommentParser.this.m.at(pos).newSerialFieldTree((IdentifierTree)name, (ReferenceTree)type, description);
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.SERIAL){

            @Override
            public DCTree parse(int pos) {
                org.openjdk.tools.javac.util.List<DCTree> description = DocCommentParser.this.blockContent();
                return DocCommentParser.this.m.at(pos).newSerialTree(description);
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.SINCE){

            @Override
            public DCTree parse(int pos) {
                org.openjdk.tools.javac.util.List<DCTree> description = DocCommentParser.this.blockContent();
                return DocCommentParser.this.m.at(pos).newSinceTree(description);
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.THROWS){

            @Override
            public DCTree parse(int pos) throws ParseException {
                DocCommentParser.this.skipWhitespace();
                DCTree.DCReference ref = DocCommentParser.this.reference(false);
                org.openjdk.tools.javac.util.List<DCTree> description = DocCommentParser.this.blockContent();
                return DocCommentParser.this.m.at(pos).newThrowsTree((ReferenceTree)ref, description);
            }
        }, new TagParser(TagParser.Kind.INLINE, DocTree.Kind.VALUE){

            @Override
            public DCTree parse(int pos) throws ParseException {
                DCTree.DCReference ref = DocCommentParser.this.reference(true);
                DocCommentParser.this.skipWhitespace();
                if (DocCommentParser.this.ch == '}') {
                    DocCommentParser.this.nextChar();
                    return DocCommentParser.this.m.at(pos).newValueTree(ref);
                }
                DocCommentParser.this.nextChar();
                throw new ParseException("dc.unexpected.content");
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.VERSION){

            @Override
            public DCTree parse(int pos) {
                org.openjdk.tools.javac.util.List<DCTree> description = DocCommentParser.this.blockContent();
                return DocCommentParser.this.m.at(pos).newVersionTree(description);
            }
        }};
        this.tagParsers = new HashMap<Name, TagParser>();
        for (TagParser p : parsers) {
            this.tagParsers.put(this.names.fromString(p.getTreeKind().tagName), p);
        }
    }

    static abstract class TagParser {
        final Kind kind;
        final DocTree.Kind treeKind;
        final boolean retainWhiteSpace;

        TagParser(Kind k, DocTree.Kind tk) {
            this.kind = k;
            this.treeKind = tk;
            this.retainWhiteSpace = false;
        }

        TagParser(Kind k, DocTree.Kind tk, boolean retainWhiteSpace) {
            this.kind = k;
            this.treeKind = tk;
            this.retainWhiteSpace = retainWhiteSpace;
        }

        Kind getKind() {
            return this.kind;
        }

        DocTree.Kind getTreeKind() {
            return this.treeKind;
        }

        abstract DCTree parse(int var1) throws ParseException;

        static enum Kind {
            INLINE,
            BLOCK;

        }
    }

    private static enum WhitespaceRetentionPolicy {
        RETAIN_ALL,
        REMOVE_FIRST_SPACE,
        REMOVE_ALL;

    }

    static class ParseException
    extends Exception {
        private static final long serialVersionUID = 0L;

        ParseException(String key) {
            super(key);
        }
    }
}

