/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.base;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.twitter.common.base.Command;
import com.twitter.common.base.ExceptionalCommand;
import com.twitter.common.base.ExceptionalSupplier;

public final class Commands {
    public static final Command NOOP = new Command(){

        @Override
        public void execute() {
        }
    };

    private Commands() {
    }

    public static <E extends Exception> ExceptionalSupplier<Void, E> asSupplier(final ExceptionalCommand<E> command) {
        Preconditions.checkNotNull(command);
        return new ExceptionalSupplier<Void, E>(){

            @Override
            public Void get() throws Exception {
                command.execute();
                return null;
            }
        };
    }

    public static Command compound(Iterable<Command> commands) {
        final ImmutableList executableCommands = ImmutableList.copyOf(commands);
        return new Command(){

            @Override
            public void execute() {
                for (Command command : executableCommands) {
                    command.execute();
                }
            }
        };
    }
}

