/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.blueprints;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.thinkaurelius.titan.core.PropertyKey;
import com.thinkaurelius.titan.core.TitanEdge;
import com.thinkaurelius.titan.core.TitanGraph;
import com.thinkaurelius.titan.core.TitanProperty;
import com.thinkaurelius.titan.core.TitanTransaction;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.core.VertexLabel;
import com.thinkaurelius.titan.graphdb.database.serialize.AttributeUtil;
import com.thinkaurelius.titan.graphdb.internal.InternalRelationType;
import com.thinkaurelius.titan.graphdb.internal.TitanSchemaCategory;
import com.thinkaurelius.titan.graphdb.relations.RelationIdentifier;
import com.thinkaurelius.titan.graphdb.types.system.BaseKey;
import com.thinkaurelius.titan.util.datastructures.IterablesUtil;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Features;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.Parameter;
import com.tinkerpop.blueprints.TransactionalGraph;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.util.ExceptionFactory;
import com.tinkerpop.blueprints.util.StringFactory;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TitanBlueprintsTransaction
implements TitanTransaction {
    private static final Logger log = LoggerFactory.getLogger(TitanBlueprintsTransaction.class);

    protected abstract TitanGraph getGraph();

    public void stopTransaction(TransactionalGraph.Conclusion conclusion) {
        switch (conclusion) {
            case SUCCESS: {
                this.commit();
                break;
            }
            case FAILURE: {
                this.rollback();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized conclusion: " + conclusion);
            }
        }
    }

    public Features getFeatures() {
        return this.getGraph().getFeatures();
    }

    public TitanVertex addVertex(Object id) {
        if (id instanceof Number && AttributeUtil.isWholeNumber((Number)id)) {
            log.trace("tx {}: addVertex(Object) detected numeric argument {}", (Object)this, id);
            return this.addVertex(((Number)id).longValue(), null);
        }
        if (id instanceof VertexLabel) {
            log.trace("tx {}: addVertex(Object) detected VertexLabel argument {}", (Object)this, id);
            return this.addVertexWithLabel((VertexLabel)id);
        }
        if (null != id) {
            log.trace("tx {}: addVertex(Object) ignored argument {}", (Object)this, id);
        }
        return this.addVertex(null, null);
    }

    public TitanVertex getVertex(Object id) {
        long longId;
        if (null == id) {
            throw ExceptionFactory.vertexIdCanNotBeNull();
        }
        if (id instanceof Vertex) {
            return this.getVertex(((Vertex)id).getId());
        }
        if (id instanceof Long) {
            longId = (Long)id;
        } else if (id instanceof Number) {
            longId = ((Number)id).longValue();
        } else {
            try {
                longId = Long.valueOf(id.toString());
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return this.getVertex(longId);
    }

    public Iterable<Vertex> getVertices(String key, Object attribute) {
        if (!this.containsRelationType(key)) {
            return IterablesUtil.emptyIterable();
        }
        return this.getVertices(this.getPropertyKey(key), attribute);
    }

    public void removeVertex(Vertex vertex) {
        vertex.remove();
    }

    public TitanEdge addEdge(Object id, Vertex outVertex, Vertex inVertex, String label) {
        Preconditions.checkArgument((boolean)(outVertex instanceof TitanVertex), (String)"Expected a TitanVertex but got: %s", (Object[])new Object[]{outVertex});
        Preconditions.checkArgument((boolean)(inVertex instanceof TitanVertex), (String)"Expected a TitanVertex but got: %s", (Object[])new Object[]{inVertex});
        return this.addEdge((TitanVertex)outVertex, (TitanVertex)inVertex, label);
    }

    @Override
    public TitanEdge addEdge(TitanVertex outVertex, TitanVertex inVertex, String label) {
        if (null == label) {
            throw new IllegalArgumentException("Edge label must be non-null");
        }
        return this.addEdge(outVertex, inVertex, this.getOrCreateEdgeLabel(label));
    }

    public TitanEdge getEdge(Object id) {
        if (id == null) {
            throw ExceptionFactory.edgeIdCanNotBeNull();
        }
        RelationIdentifier rid = null;
        try {
            if (id instanceof TitanEdge) {
                rid = (RelationIdentifier)((TitanEdge)id).getId();
            } else if (id instanceof RelationIdentifier) {
                rid = (RelationIdentifier)id;
            } else if (id instanceof String) {
                rid = RelationIdentifier.parse((String)id);
            } else if (id instanceof long[]) {
                rid = RelationIdentifier.get((long[])id);
            } else if (id instanceof int[]) {
                rid = RelationIdentifier.get((int[])id);
            }
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        if (rid != null) {
            return rid.findEdge(this);
        }
        return null;
    }

    public void removeEdge(Edge edge) {
        edge.remove();
    }

    public Iterable<Edge> getEdges(String key, Object value) {
        if (!this.containsRelationType(key)) {
            return IterablesUtil.emptyIterable();
        }
        return this.getEdges(this.getPropertyKey(key), value);
    }

    @Override
    public TitanProperty addProperty(TitanVertex vertex, String key, Object attribute) {
        return this.addProperty(vertex, this.getOrCreatePropertyKey(key), attribute);
    }

    public void shutdown() {
        this.commit();
    }

    public String toString() {
        return StringFactory.graphString((Graph)this, null);
    }

    public <T extends Element> void dropKeyIndex(String key, Class<T> elementClass) {
        throw new UnsupportedOperationException("Key indexes cannot currently be dropped. Create a new key instead.");
    }

    public <T extends Element> void createKeyIndex(String key, Class<T> elementClass, Parameter ... indexParameters) {
        throw new UnsupportedOperationException("Use Titan's Management API to create indices");
    }

    public <T extends Element> Set<String> getIndexedKeys(Class<T> elementClass) {
        Preconditions.checkArgument((elementClass == Vertex.class || elementClass == Edge.class ? 1 : 0) != 0, (Object)"Must provide either Vertex.class or Edge.class as an argument");
        HashSet<String> indexedkeys = new HashSet<String>();
        for (TitanVertex k : this.getVertices(BaseKey.SchemaCategory, (Object)TitanSchemaCategory.PROPERTYKEY)) {
            assert (k instanceof InternalRelationType);
            if (Iterables.isEmpty(((InternalRelationType)k).getKeyIndexes())) continue;
            indexedkeys.add(((PropertyKey)k).getName());
        }
        return indexedkeys;
    }
}

