/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.util.Arrays;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;
import org.apache.hyracks.data.std.util.ByteArrayAccessibleOutputStream;

public final class StringEvaluatorUtils {
    public static final char[] RESERVED_REGEX_CHARS = new char[]{'\\', '(', ')', '[', ']', '{', '}', '.', '^', '$', '*', '|', '+', '?', '<', '>', '-', '=', '!'};

    private StringEvaluatorUtils() {
    }

    public static int toFlag(String pattern) {
        int flag = 0;
        block6: for (int i = 0; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            switch (c) {
                case 's': {
                    flag |= 0x20;
                    continue block6;
                }
                case 'm': {
                    flag |= 8;
                    continue block6;
                }
                case 'i': {
                    flag |= 2;
                    continue block6;
                }
                case 'x': {
                    flag |= 4;
                }
            }
        }
        return flag;
    }

    public static UTF8StringPointable copyResetUTF8Pointable(UTF8StringPointable srcString, ByteArrayAccessibleOutputStream destCopyStorage, UTF8StringPointable destString) {
        destCopyStorage.reset();
        destCopyStorage.write(srcString.getByteArray(), srcString.getStartOffset(), srcString.getMetaDataLength() + srcString.getUTF8Length());
        destString.set(destCopyStorage.getByteArray(), 0, destCopyStorage.size());
        return destString;
    }

    static {
        Arrays.sort(RESERVED_REGEX_CHARS);
    }
}

