/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.lazybinary.objectinspector;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.hive.serde2.lazybinary.objectinspector.LazyBinaryListObjectInspector;
import org.apache.hadoop.hive.serde2.lazybinary.objectinspector.LazyBinaryMapObjectInspector;
import org.apache.hadoop.hive.serde2.lazybinary.objectinspector.LazyBinaryStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;

public final class LazyBinaryObjectInspectorFactory {
    static ConcurrentHashMap<ArrayList<Object>, LazyBinaryStructObjectInspector> cachedLazyBinaryStructObjectInspector = new ConcurrentHashMap();
    static ConcurrentHashMap<ArrayList<Object>, LazyBinaryListObjectInspector> cachedLazyBinaryListObjectInspector = new ConcurrentHashMap();
    static ConcurrentHashMap<ArrayList<Object>, LazyBinaryMapObjectInspector> cachedLazyBinaryMapObjectInspector = new ConcurrentHashMap();

    public static LazyBinaryStructObjectInspector getLazyBinaryStructObjectInspector(List<String> structFieldNames, List<ObjectInspector> structFieldObjectInspectors) {
        return LazyBinaryObjectInspectorFactory.getLazyBinaryStructObjectInspector(structFieldNames, structFieldObjectInspectors, null);
    }

    public static LazyBinaryStructObjectInspector getLazyBinaryStructObjectInspector(List<String> structFieldNames, List<ObjectInspector> structFieldObjectInspectors, List<String> structFieldComments) {
        LazyBinaryStructObjectInspector result;
        ArrayList<List<Object>> signature = new ArrayList<List<Object>>(3);
        signature.add(structFieldNames);
        signature.add(structFieldObjectInspectors);
        if (structFieldComments != null) {
            signature.add(structFieldComments);
        }
        if ((result = cachedLazyBinaryStructObjectInspector.get(signature)) == null) {
            result = new LazyBinaryStructObjectInspector(structFieldNames, structFieldObjectInspectors, structFieldComments);
            cachedLazyBinaryStructObjectInspector.put(signature, result);
        }
        return result;
    }

    public static LazyBinaryListObjectInspector getLazyBinaryListObjectInspector(ObjectInspector listElementObjectInspector) {
        ArrayList<ObjectInspector> signature = new ArrayList<ObjectInspector>();
        signature.add(listElementObjectInspector);
        LazyBinaryListObjectInspector result = cachedLazyBinaryListObjectInspector.get(signature);
        if (result == null) {
            result = new LazyBinaryListObjectInspector(listElementObjectInspector);
            cachedLazyBinaryListObjectInspector.put(signature, result);
        }
        return result;
    }

    public static LazyBinaryMapObjectInspector getLazyBinaryMapObjectInspector(ObjectInspector mapKeyObjectInspector, ObjectInspector mapValueObjectInspector) {
        ArrayList<ObjectInspector> signature = new ArrayList<ObjectInspector>();
        signature.add(mapKeyObjectInspector);
        signature.add(mapValueObjectInspector);
        LazyBinaryMapObjectInspector result = cachedLazyBinaryMapObjectInspector.get(signature);
        if (result == null) {
            result = new LazyBinaryMapObjectInspector(mapKeyObjectInspector, mapValueObjectInspector);
            cachedLazyBinaryMapObjectInspector.put(signature, result);
        }
        return result;
    }

    private LazyBinaryObjectInspectorFactory() {
    }
}

