/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.nc.resources.memory;

import java.nio.ByteBuffer;
import org.apache.hyracks.api.comm.FrameHelper;
import org.apache.hyracks.api.context.IHyracksFrameMgrContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class FrameManager
implements IHyracksFrameMgrContext {
    private final int minFrameSize;

    public FrameManager(int minFrameSize) {
        this.minFrameSize = minFrameSize;
    }

    public int getInitialFrameSize() {
        return this.minFrameSize;
    }

    public ByteBuffer allocateFrame() throws HyracksDataException {
        return this.allocateFrame(this.minFrameSize);
    }

    public ByteBuffer allocateFrame(int bytes) throws HyracksDataException {
        if (bytes % this.minFrameSize != 0) {
            throw new HyracksDataException("The size should be an integral multiple of the default frame size");
        }
        if (bytes > Integer.MAX_VALUE) {
            throw new HyracksDataException("Unable to allocate frame larger than:2147483647 bytes");
        }
        ByteBuffer buffer = ByteBuffer.allocate(bytes);
        FrameHelper.serializeFrameSize((ByteBuffer)buffer, (int)(bytes / this.minFrameSize));
        return (ByteBuffer)buffer.clear();
    }

    public ByteBuffer reallocateFrame(ByteBuffer tobeDeallocate, int newSizeInBytes, boolean copyOldData) throws HyracksDataException {
        if (!copyOldData) {
            this.deallocateFrames(tobeDeallocate.capacity());
            return this.allocateFrame(newSizeInBytes);
        }
        if (newSizeInBytes > Integer.MAX_VALUE) {
            throw new HyracksDataException("Unable to allocate frame of size bigger than: 2147483647 bytes");
        }
        ByteBuffer buffer = this.allocateFrame(newSizeInBytes);
        int limit = Math.min(newSizeInBytes, tobeDeallocate.capacity());
        int pos = Math.min(limit, tobeDeallocate.position());
        tobeDeallocate.position(0);
        tobeDeallocate.limit(limit);
        buffer.put(tobeDeallocate);
        buffer.position(pos);
        FrameHelper.serializeFrameSize((ByteBuffer)buffer, (int)(newSizeInBytes / this.minFrameSize));
        return buffer;
    }

    public void deallocateFrames(int bytes) {
    }
}

