/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.transaction.jms;

import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.XAConnection;
import org.apache.aries.transaction.jms.internal.ConnectionPool;
import org.apache.aries.transaction.jms.internal.GenericResourceManager;
import org.apache.aries.transaction.jms.internal.RecoverableConnectionPool;
import org.apache.aries.transaction.jms.internal.XaPooledConnectionFactory;

public class RecoverablePooledConnectionFactory
extends XaPooledConnectionFactory {
    private String name;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    protected ConnectionPool createConnectionPool(Connection connection) throws JMSException {
        if (!(connection instanceof XAConnection)) {
            throw new JMSException("Require an instance of javax.jms.XAConnection for creating the ConnectionPool");
        }
        return new RecoverableConnectionPool((XAConnection)connection, this.getPoolFactory(), this.getTransactionManager(), this.getName());
    }

    public void start() {
        if (this.getConnectionFactory() == null) {
            throw new IllegalArgumentException("connectionFactory or xaConnectionFactory must be set");
        }
        if (this.getTransactionManager() == null) {
            throw new IllegalArgumentException("transactionManager must be set");
        }
        super.start();
        new GenericResourceManager(this.name, this.getTransactionManager(), this.getConnectionFactory()).recoverResource();
    }
}

