/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.transaction.jdbc.internal;

import java.sql.SQLException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.TransactionSupport;
import javax.security.auth.Subject;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import org.apache.aries.transaction.jdbc.internal.AbstractMCFFactory;
import org.tranql.connector.CredentialExtractor;
import org.tranql.connector.jdbc.AbstractXADataSourceMCF;
import org.tranql.connector.jdbc.ManagedXAConnection;

public class XADataSourceMCFFactory
extends AbstractMCFFactory {
    @Override
    public void init() throws Exception {
        if (this.getDataSource() == null) {
            throw new IllegalArgumentException("dataSource must be set");
        }
        if (this.connectionFactory == null) {
            this.connectionFactory = new XADataSourceMCF();
        }
    }

    public class XADataSourceMCF
    extends AbstractXADataSourceMCF<XADataSource>
    implements TransactionSupport {
        public XADataSourceMCF() {
            super((XADataSource)XADataSourceMCFFactory.this.getDataSource(), XADataSourceMCFFactory.this.getExceptionSorter());
        }

        @Override
        public String getUserName() {
            return XADataSourceMCFFactory.this.getUserName();
        }

        @Override
        public String getPassword() {
            return XADataSourceMCFFactory.this.getPassword();
        }

        @Override
        public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
            CredentialExtractor credentialExtractor = new CredentialExtractor(subject, connectionRequestInfo, this);
            XAConnection sqlConnection = this.getPhysicalConnection(credentialExtractor);
            try {
                return new ManagedXAConnection(this, sqlConnection, credentialExtractor, this.exceptionSorter){

                    @Override
                    public void cleanup() throws ResourceException {
                        this.dissociateConnections();
                    }
                };
            }
            catch (SQLException e) {
                throw new ResourceAdapterInternalException("Could not set up ManagedXAConnection", (Throwable)e);
            }
        }

        @Override
        protected XAConnection getPhysicalConnection(CredentialExtractor credentialExtractor) throws ResourceException {
            try {
                String userName = credentialExtractor.getUserName();
                String password = credentialExtractor.getPassword();
                if (userName != null) {
                    return this.xaDataSource.getXAConnection(userName, password);
                }
                return this.xaDataSource.getXAConnection();
            }
            catch (SQLException e) {
                throw new ResourceAdapterInternalException("Unable to obtain physical connection to " + this.xaDataSource, (Throwable)e);
            }
        }

        public TransactionSupport.TransactionSupportLevel getTransactionSupport() {
            return TransactionSupport.TransactionSupportLevel.XATransaction;
        }
    }
}

