/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.temp;

import java.io.File;
import java.util.Collection;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.AbstractFileProvider;
import org.apache.commons.vfs2.provider.UriParser;
import org.apache.commons.vfs2.provider.local.DefaultLocalFileProvider;
import org.apache.commons.vfs2.provider.local.LocalFileSystem;

public class TemporaryFileProvider
extends AbstractFileProvider
implements Comparable<Object> {
    private File rootFile;

    public TemporaryFileProvider(File rootFile) {
        this();
        this.rootFile = rootFile;
    }

    public TemporaryFileProvider() {
    }

    @Override
    public int compareTo(Object o) {
        int h2;
        int h1 = this.hashCode();
        if (h1 < (h2 = o.hashCode())) {
            return -1;
        }
        if (h1 > h2) {
            return 1;
        }
        return 0;
    }

    @Override
    public synchronized FileObject findFile(FileObject baseFile, String uri, FileSystemOptions properties) throws FileSystemException {
        StringBuilder buffer = new StringBuilder(uri);
        String scheme = UriParser.extractScheme(uri, buffer);
        UriParser.fixSeparators(buffer);
        UriParser.normalisePath(buffer);
        String path = buffer.toString();
        FileSystem filesystem = this.findFileSystem(this, properties);
        if (filesystem == null) {
            if (this.rootFile == null) {
                this.rootFile = this.getContext().getTemporaryFileStore().allocateFile("tempfs");
            }
            FileName rootName = this.getContext().parseURI(scheme + ":" + "/");
            filesystem = new LocalFileSystem(rootName, this.rootFile.getAbsolutePath(), properties);
            this.addFileSystem(this, filesystem);
        }
        return filesystem.resolveFile(path);
    }

    @Override
    public Collection<Capability> getCapabilities() {
        return DefaultLocalFileProvider.capabilities;
    }
}

