/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ant.compress.resources;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.AbstractFileSet;
import org.apache.tools.ant.types.ArchiveFileSet;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Reference;

public abstract class CommonsCompressFileSet
extends ArchiveFileSet {
    private boolean userIdSet;
    private boolean groupIdSet;
    private int uid;
    private int gid;
    private boolean skipUnreadable = false;
    private String encoding = null;

    public CommonsCompressFileSet() {
    }

    protected CommonsCompressFileSet(FileSet fileset) {
        super(fileset);
    }

    protected CommonsCompressFileSet(CommonsCompressFileSet fileset) {
        super((ArchiveFileSet)fileset);
        this.encoding = fileset.encoding;
    }

    public void setEncoding(String enc) {
        this.checkCommonsCompressFileSetAttributesAllowed();
        this.encoding = enc;
    }

    public String getEncoding() {
        if (this.isReference()) {
            AbstractFileSet ref = this.getRef(this.getProject());
            if (ref instanceof CommonsCompressFileSet) {
                return ((CommonsCompressFileSet)ref).getEncoding();
            }
            return null;
        }
        return this.encoding;
    }

    public void setUid(int uid) {
        this.checkCommonsCompressFileSetAttributesAllowed();
        this.userIdSet = true;
        this.uid = uid;
    }

    public int getUid() {
        if (this.isReference()) {
            return ((CommonsCompressFileSet)((Object)this.getCheckedRef())).getUid();
        }
        return this.uid;
    }

    public boolean hasUserIdBeenSet() {
        return this.userIdSet;
    }

    public void setGid(int gid) {
        this.checkCommonsCompressFileSetAttributesAllowed();
        this.groupIdSet = true;
        this.gid = gid;
    }

    public int getGid() {
        if (this.isReference()) {
            return ((CommonsCompressFileSet)((Object)this.getCheckedRef())).getGid();
        }
        return this.gid;
    }

    public boolean hasGroupIdBeenSet() {
        return this.groupIdSet;
    }

    public void setSkipUnreadableEntries(boolean b) {
        this.skipUnreadable = b;
    }

    public boolean getSkipUnreadableEntries() {
        return this.skipUnreadable;
    }

    public void setRefid(Reference r) throws BuildException {
        if (this.userIdSet || this.groupIdSet) {
            throw this.tooManyAttributes();
        }
        super.setRefid(r);
    }

    protected AbstractFileSet getRef(Project p) {
        this.dieOnCircularReference(p);
        Object o = this.getRefid().getReferencedObject(p);
        if (o.getClass().equals(((Object)((Object)this)).getClass())) {
            return (AbstractFileSet)o;
        }
        if (o instanceof FileSet) {
            CommonsCompressFileSet zfs = this.newFileSet((FileSet)o);
            this.configureFileSet(zfs);
            return zfs;
        }
        String msg = this.getRefid().getRefId() + " doesn't denote a fileset";
        throw new BuildException(msg);
    }

    protected void configureFileSet(ArchiveFileSet zfs) {
        super.configureFileSet(zfs);
        if (zfs instanceof CommonsCompressFileSet) {
            CommonsCompressFileSet ccfs = (CommonsCompressFileSet)zfs;
            ccfs.setUid(this.uid);
            ccfs.setGid(this.gid);
        }
    }

    public CommonsCompressFileSet clone() {
        if (this.isReference()) {
            return ((CommonsCompressFileSet)this.getRef(this.getProject())).clone();
        }
        return (CommonsCompressFileSet)((Object)super.clone());
    }

    protected abstract CommonsCompressFileSet newFileSet(FileSet var1);

    protected final void checkCommonsCompressFileSetAttributesAllowed() {
        if (this.getProject() == null || this.isReference() && this.getRefid().getReferencedObject(this.getProject()) instanceof CommonsCompressFileSet) {
            this.checkAttributesAllowed();
        }
    }
}

