/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.ast.nodes;

import com.ibm.xtq.ast.nodes.Expr;
import com.ibm.xtq.ast.nodes.TopLevelDecl;
import com.ibm.xtq.ast.nodes.TypeExpr;
import com.ibm.xtq.ast.parsers.xslt.XSLTParser;
import com.ibm.xtq.ast.res.ASTBaseMsg;
import com.ibm.xtq.ast.res.ASTMsg;
import java.io.PrintStream;
import javax.xml.namespace.QName;

public class VariableBase
extends TopLevelDecl {
    protected QName _name;
    protected boolean _isLocal;
    protected Expr _expr;
    private boolean _hasDuplicate = false;
    protected TypeExpr _type;

    public VariableBase(int n) {
        super(n);
    }

    public void setDuplicate(boolean bl) {
        this._hasDuplicate = bl;
    }

    public boolean isDuplicate() {
        return this._hasDuplicate;
    }

    public Expr getExpression() {
        return this._expr;
    }

    public void setExpression(Expr expr) {
        this._expr = expr;
    }

    @Override
    public String toString() {
        return "variable(" + this._name + ")";
    }

    @Override
    public void dump(String string, PrintStream printStream) {
        printStream.print(string + "Variable");
        printStream.print(" name=" + this._name);
        if (null == this._expr) {
            printStream.println(" select:NONE");
        } else {
            printStream.println(" select:");
            this._expr.dump(" " + string, printStream);
        }
        this.dumpChildren(string + " ", printStream);
    }

    public QName getQName() {
        return this._name;
    }

    public TypeExpr getType() {
        return this._type;
    }

    public void setQName(QName qName) {
        this._name = qName;
    }

    @Override
    public void setName(String string, String string2, String string3) {
        this._name = new QName(string, string3, string2);
    }

    public boolean isLocal() {
        return this._isLocal;
    }

    @Override
    public void parseContents(XSLTParser xSLTParser) {
        Object object;
        String string = this.getAttribute("name");
        if (string == null) {
            string = "";
        }
        if (string.length() > 0) {
            if (!xSLTParser.isValidQName(string)) {
                object = new ASTMsg("INVALID_QNAME_ERR", (Object)string, (Expr)this);
                xSLTParser.reportError(3, (ASTBaseMsg)object);
            }
            this.setQName(xSLTParser.getQNameIgnoreDefaultNs(string));
        } else if (this._name == null) {
            object = new ASTMsg("REQUIRED_ATTR_ERR", (Object)"name", (Expr)this);
            xSLTParser.reportError(3, (ASTBaseMsg)object);
        } else {
            this._name = xSLTParser.getQNameIgnoreDefaultNs(this._name.getLocalPart());
        }
        object = this.getAttribute("as");
        if (((String)object).length() > 0) {
            this._type = xSLTParser.parseSequenceTypeExpression(this, (String)object);
        }
        this.parseChildren(xSLTParser);
    }

    @Override
    public void getXQueryString(StringBuffer stringBuffer, boolean bl, String string) {
        if (this.isLocal()) {
            stringBuffer.append("let $").append(this._name).append(" := ");
        } else {
            stringBuffer.append("declare variable ").append(this._name);
        }
        if (this._type != null) {
            stringBuffer.append(" as ").append(this._type);
        }
        if (this._expr != null) {
            if (!this.isLocal()) {
                stringBuffer.append("{");
            }
            this._expr.getXQueryString(stringBuffer, bl, string);
            if (!this.isLocal()) {
                stringBuffer.append("} ");
            }
        } else if (this.jjtGetNumChildren() > 0) {
            if (!this.isLocal()) {
                stringBuffer.append("{");
            }
            this.getXQueryStringForChildren(stringBuffer, bl, string);
            if (!this.isLocal()) {
                stringBuffer.append("} ");
            }
        } else {
            stringBuffer.append("external");
        }
        if (!this.isLocal()) {
            stringBuffer.append(";\r");
        }
        stringBuffer.append("\r");
    }

    public void setType(TypeExpr typeExpr) {
        this._type = typeExpr;
    }

    public void setLocal(boolean bl) {
        this._isLocal = bl;
    }
}

