/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jgroups.util.Util;

public class UnicastTestTcpRpc {
    private ServerSocket srv_sock;
    private volatile Socket sock;
    private DataInputStream sock_in;
    private DataOutputStream sock_out;
    private long sleep_time = 0L;
    private boolean exit_on_end = false;
    private boolean busy_sleep = false;
    private boolean sync = false;
    private boolean oob = false;
    private int num_threads = 1;
    private int num_msgs = 50000;
    private int msg_size = 1000;
    private InetAddress addr = null;
    private int local_port = 8000;
    private int dest_port = 9000;
    private boolean started = false;
    private long start = 0L;
    private long stop = 0L;
    private AtomicInteger current_value = new AtomicInteger(0);
    private int num_values = 0;
    private int print;
    private AtomicLong total_bytes = new AtomicLong(0L);
    private Thread acceptor;
    private final byte[] buf = new byte[65535];
    long total_req_time = 0L;
    long total_rsp_time = 0L;
    long entire_req_time = 0L;
    long num_entire_reqs = 0L;
    int num_reqs = 0;
    int num_rsps = 0;
    static final byte START = 0;
    static final byte RECEIVE_ASYNC = 1;
    static final byte RECEIVE_SYNC = 2;
    static final byte ACK = 10;

    public void init(long sleep_time, boolean exit_on_end, boolean busy_sleep, boolean sync, boolean oob, String addr, int local_port, int dest_port) throws Exception {
        this.sleep_time = sleep_time;
        this.exit_on_end = exit_on_end;
        this.busy_sleep = busy_sleep;
        this.sync = sync;
        this.oob = oob;
        this.addr = InetAddress.getByName(addr);
        this.local_port = local_port;
        this.dest_port = dest_port;
        this.srv_sock = new ServerSocket(local_port);
        System.out.println("Listening on " + this.srv_sock.getLocalSocketAddress());
        this.acceptor = new Thread(){

            /*
             * Exception decompiling
             */
            @Override
            public void run() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[DOLOOP]], but top level block is 0[TRYBLOCK]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        };
        this.acceptor.start();
    }

    void createSocket() throws IOException {
        if (this.sock == null) {
            this.sock = new Socket(this.addr, this.dest_port);
            UnicastTestTcpRpc.set(this.sock);
            this.sock_in = new DataInputStream(this.sock.getInputStream());
            this.sock_out = new DataOutputStream(this.sock.getOutputStream());
        }
    }

    boolean handleRequest(DataInputStream in, DataOutputStream out) throws IOException {
        byte type;
        block4: while ((type = (byte)in.read()) != -1) {
            switch (type) {
                case 0: {
                    int num = in.readInt();
                    this.startTest(num);
                    continue block4;
                }
                case 1: 
                case 2: {
                    long val = in.readLong();
                    int len = in.readInt();
                    byte[] data = new byte[len];
                    in.readFully(data, 0, data.length);
                    this.receiveData(val, data);
                    if (type != 2) continue block4;
                    out.writeLong(System.currentTimeMillis());
                    out.flush();
                    continue block4;
                }
            }
            System.err.println("type " + type + " not known");
        }
        return false;
    }

    static void set(Socket socket) throws SocketException {
        socket.setTcpNoDelay(true);
        socket.setReceiveBufferSize(20000000);
        socket.setSendBufferSize(10000000);
    }

    void stop() {
    }

    public void startTest(int num_values) {
        if (this.started) {
            System.err.println("UnicastTest.run(): received START data, but am already processing data");
        } else {
            this.started = true;
            this.current_value.set(0);
            this.total_bytes.set(0L);
            this.num_values = num_values;
            this.print = num_values / 10;
            this.total_req_time = 0L;
            this.num_reqs = 0;
            this.total_rsp_time = 0L;
            this.num_rsps = 0;
            this.entire_req_time = 0L;
            this.num_entire_reqs = 0L;
            this.start = System.currentTimeMillis();
        }
    }

    public void receiveData(long value, byte[] buffer) {
        long diff = System.currentTimeMillis() - value;
        this.total_req_time += diff;
        ++this.num_reqs;
        long new_val = this.current_value.incrementAndGet();
        this.total_bytes.addAndGet(buffer.length);
        if (this.print > 0 && new_val % (long)this.print == 0L) {
            System.out.println("received " + this.current_value);
        }
        if (new_val >= (long)this.num_values) {
            this.stop = System.currentTimeMillis();
            long total_time = this.stop - this.start;
            long msgs_per_sec = (long)((double)this.num_values / ((double)total_time / 1000.0));
            double throughput = (double)this.total_bytes.get() / ((double)total_time / 1000.0);
            System.out.println("\n-- received " + this.num_values + " messages in " + total_time + " ms (" + msgs_per_sec + " messages/sec, " + Util.printBytes(throughput) + " / sec)");
            double time_per_req = (double)this.total_req_time / (double)this.num_reqs;
            System.out.println("received " + this.num_reqs + " requests in " + this.total_req_time + " ms, " + time_per_req + " ms / req (only requests)\n");
            this.started = false;
            if (this.exit_on_end) {
                System.exit(0);
            }
        }
    }

    public void eventLoop() throws Throwable {
        block16: while (true) {
            System.out.print("[1] Send msgs [2] Print view [3] Print conns [4] Trash conn [5] Trash all conns\n[6] Set sender threads (" + this.num_threads + ") [7] Set num msgs (" + this.num_msgs + ") " + "[8] Set msg size (" + Util.printBytes(this.msg_size) + ")" + "\n[o] Toggle OOB (" + this.oob + ") [s] Toggle sync (" + this.sync + ")" + "\n[q] Quit\n");
            System.out.flush();
            int c = System.in.read();
            switch (c) {
                case -1: {
                    continue block16;
                }
                case 49: {
                    try {
                        this.invokeRpcs();
                    }
                    catch (Throwable t) {
                        System.err.println(t);
                    }
                    continue block16;
                }
                case 50: {
                    continue block16;
                }
                case 51: {
                    continue block16;
                }
                case 52: {
                    continue block16;
                }
                case 53: {
                    continue block16;
                }
                case 54: {
                    this.setSenderThreads();
                    continue block16;
                }
                case 55: {
                    this.setNumMessages();
                    continue block16;
                }
                case 56: {
                    this.setMessageSize();
                    continue block16;
                }
                case 111: {
                    this.oob = !this.oob;
                    System.out.println("oob=" + this.oob);
                    continue block16;
                }
                case 115: {
                    this.sync = !this.sync;
                    System.out.println("sync=" + this.sync);
                    continue block16;
                }
                case 113: {
                    Util.close((Closeable)this.sock);
                    Util.close((Closeable)this.srv_sock);
                    return;
                }
            }
        }
    }

    void invokeRpcs() throws Throwable {
        if (this.sock == null) {
            this.createSocket();
        }
        if (this.num_threads > 1 && this.num_msgs % this.num_threads != 0) {
            System.err.println("num_msgs (" + this.num_msgs + " ) has to be divisible by num_threads (" + this.num_threads + ")");
            return;
        }
        System.out.println("invoking " + this.num_msgs + " RPCs of " + Util.printBytes(this.msg_size) + " on " + ", sync=" + this.sync + ", oob=" + this.oob);
        this.num_rsps = 0;
        this.entire_req_time = this.total_rsp_time = (long)0;
        this.num_entire_reqs = this.total_rsp_time;
        this.sock_out.write(0);
        this.sock_out.writeInt(this.num_msgs);
        byte[] data = new byte[this.msg_size];
        int type = this.sync ? 2 : 1;
        for (int i = 0; i < this.num_msgs; ++i) {
            long tmp_start = System.currentTimeMillis();
            this.sock_out.write(type);
            this.sock_out.writeLong(tmp_start);
            this.sock_out.writeInt(this.msg_size);
            this.sock_out.write(data, 0, data.length);
            if (!this.sync) continue;
            long timestamp = this.sock_in.readLong();
            long curr_time = System.currentTimeMillis();
            long diff = curr_time - tmp_start;
            ++this.num_entire_reqs;
            this.entire_req_time += diff;
            diff = curr_time - timestamp;
            this.total_rsp_time += diff;
            ++this.num_rsps;
        }
        this.sock_out.flush();
        System.out.println("done sending " + this.num_msgs + " to " + this.sock.getRemoteSocketAddress());
        double time_per_req = (double)this.entire_req_time / (double)this.num_msgs;
        System.out.println("\ninvoked " + this.num_entire_reqs + " requests in " + this.entire_req_time + " ms: " + time_per_req + " ms / req (entire request)");
        if (this.sync) {
            double time_per_rsp = (double)this.total_rsp_time / (double)this.num_rsps;
            System.out.println("received " + this.num_rsps + " responses in " + this.total_rsp_time + " ms: " + time_per_rsp + " ms / rsp (only response)\n");
        }
    }

    void setSenderThreads() throws Exception {
        int threads = Util.readIntFromStdin("Number of sender threads: ");
        int old = this.num_threads;
        this.num_threads = threads;
        System.out.println("sender threads set to " + this.num_threads + " (from " + old + ")");
    }

    void setNumMessages() throws Exception {
        this.num_msgs = Util.readIntFromStdin("Number of RPCs: ");
        System.out.println("Set num_msgs=" + this.num_msgs);
        this.print = this.num_msgs / 10;
    }

    void setMessageSize() throws Exception {
        this.msg_size = Util.readIntFromStdin("Message size: ");
        System.out.println("set msg_size=" + this.msg_size);
    }

    public static void main(String[] args) {
        block11: {
            long sleep_time = 0L;
            boolean exit_on_end = false;
            boolean busy_sleep = false;
            boolean sync = false;
            boolean oob = false;
            String addr = null;
            int dest_port = 9000;
            int local_port = 8000;
            for (int i = 0; i < args.length; ++i) {
                if ("-sleep".equals(args[i])) {
                    sleep_time = Long.parseLong(args[++i]);
                    continue;
                }
                if ("-exit_on_end".equals(args[i])) {
                    exit_on_end = true;
                    continue;
                }
                if ("-busy_sleep".equals(args[i])) {
                    busy_sleep = true;
                    continue;
                }
                if ("-sync".equals(args[i])) {
                    sync = true;
                    continue;
                }
                if ("-oob".equals(args[i])) {
                    oob = true;
                    continue;
                }
                if ("-addr".equals(args[i])) {
                    addr = args[++i];
                    continue;
                }
                if ("-dest_port".equals(args[i])) {
                    dest_port = Integer.parseInt(args[++i]);
                    continue;
                }
                if ("-local_port".equals(args[i])) {
                    local_port = Integer.parseInt(args[++i]);
                    continue;
                }
                UnicastTestTcpRpc.help();
                return;
            }
            UnicastTestTcpRpc test = null;
            try {
                test = new UnicastTestTcpRpc();
                test.init(sleep_time, exit_on_end, busy_sleep, sync, oob, addr, local_port, dest_port);
                test.eventLoop();
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                if (test == null) break block11;
                test.stop();
            }
        }
    }

    static void help() {
        System.out.println("UnicastTestRpc [-help] [-sleep <time in ms between msg sends] [-exit_on_end] [-busy-sleep] [-addr address] [-dest_port port] [-local_port port]");
    }

    static /* synthetic */ ServerSocket access$000(UnicastTestTcpRpc x0) {
        return x0.srv_sock;
    }
}

