/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.component;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import javax.security.auth.Subject;
import org.apache.activemq.artemis.logs.AuditLogger;
import org.eclipse.jetty.ee9.nested.Request;
import org.eclipse.jetty.ee9.nested.Response;

public class AuthenticationFilter
implements Filter {
    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        filterChain.doFilter(servletRequest, servletResponse);
        if (AuditLogger.isAnyLoggingEnabled()) {
            int status = ((Response)servletResponse).getStatus();
            if (status >= 200 && status < 299) {
                HttpSession session = ((Request)servletRequest).getSession(false);
                if (session != null) {
                    AuditLogger.userSuccesfullyAuthenticatedInAudit((Subject)((Subject)session.getAttribute("subject")));
                }
            } else if (status >= 400 && status < 599) {
                AuditLogger.userFailedAuthenticationInAudit((String)("" + status));
            }
        }
    }

    public void destroy() {
    }
}

