/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.federation;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederation;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationMetrics;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationPolicyManager;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationSenderController;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPException;
import org.apache.activemq.artemis.protocol.amqp.federation.FederationType;
import org.apache.activemq.artemis.protocol.amqp.proton.ProtonServerSenderContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AMQPFederationRemotePolicyManager
extends AMQPFederationPolicyManager {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final List<AMQPFederationSenderController> controllers = new ArrayList<AMQPFederationSenderController>();

    public AMQPFederationRemotePolicyManager(AMQPFederation federation, AMQPFederationMetrics metrics, String policyName, FederationType policyType) {
        super(federation, metrics, policyName, policyType);
    }

    public final synchronized AMQPFederationSenderController newSenderController() throws ActiveMQAMQPException {
        AMQPFederationSenderController controller = this.createSenderController(this::handleSenderControllerClosed);
        this.controllers.add(controller);
        return controller;
    }

    protected abstract AMQPFederationSenderController createSenderController(Consumer<AMQPFederationSenderController> var1) throws ActiveMQAMQPException;

    @Override
    protected void handleManagerInitialized() {
        try {
            this.federation.registerRemotePolicyManagement(this);
        }
        catch (Exception e) {
            logger.trace("Error while attempting to add remote policy control to management", (Throwable)e);
        }
    }

    @Override
    protected void handleManagerStarted() {
    }

    @Override
    protected void handleManagerStopped() {
        this.closeAllTrackedControllers();
    }

    @Override
    protected void handleManagerShutdown() {
        try {
            this.federation.unregisterRemotePolicyManagement(this);
        }
        catch (Exception e) {
            logger.trace("Error while attempting to add remote policy control to management", (Throwable)e);
        }
        this.closeAllTrackedControllers();
    }

    @Override
    protected void handleConnectionInterrupted() {
        this.closeAllTrackedControllers();
    }

    @Override
    protected void handleConnectionRestored() {
    }

    private synchronized void handleSenderControllerClosed(AMQPFederationSenderController controller) {
        this.controllers.remove(controller);
    }

    private void closeAllTrackedControllers() {
        ArrayList<AMQPFederationSenderController> controllers = new ArrayList<AMQPFederationSenderController>(this.controllers);
        for (AMQPFederationSenderController controller : controllers) {
            ProtonServerSenderContext context = controller.getSenderContext();
            if (context == null || !context.isInitialized()) continue;
            try {
                context.close(false);
            }
            catch (ActiveMQAMQPException e) {
                logger.trace("Ignored exception while closing federation sender controller on connection drop:", (Throwable)((Object)e));
            }
        }
        this.controllers.clear();
    }
}

