/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee9.nested;

import jakarta.servlet.MultipartConfigElement;
import jakarta.servlet.http.Part;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import org.eclipse.jetty.ee9.nested.MultiPartFormInputStream;
import org.eclipse.jetty.ee9.nested.MultiPartInputStreamLegacyParser;
import org.eclipse.jetty.http.ComplianceViolation;
import org.eclipse.jetty.http.MultiPartCompliance;

class MultiPart {
    MultiPart() {
    }

    public static Parser newFormDataParser(MultiPartCompliance multiPartCompliance, InputStream inputStream, String contentType, MultipartConfigElement config, File contextTmpDir, int maxParts) {
        if (multiPartCompliance == MultiPartCompliance.RFC7578) {
            return new MultiPartFormInputStream(inputStream, contentType, config, contextTmpDir, maxParts);
        }
        return new MultiPartInputStreamLegacyParser(multiPartCompliance, inputStream, contentType, config, contextTmpDir, maxParts);
    }

    public static interface Parser {
        public void deleteParts();

        public Part getPart(String var1) throws IOException;

        public Collection<Part> getParts() throws IOException;

        public List<ComplianceViolation.Event> getNonComplianceWarnings();
    }
}

