/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.broker;

import io.netty.buffer.ByteBuf;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.persistence.CoreMessageObjectPools;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPLargeMessage;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPMessage;
import org.apache.activemq.artemis.spi.core.protocol.MessagePersister;
import org.apache.activemq.artemis.utils.collections.TypedProperties;

public class AMQPLargeMessagePersister
extends MessagePersister {
    public static final byte ID = 4;
    public static AMQPLargeMessagePersister theInstance;

    public static AMQPLargeMessagePersister getInstance() {
        if (theInstance == null) {
            theInstance = new AMQPLargeMessagePersister();
        }
        return theInstance;
    }

    public byte getID() {
        return 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getEncodeSize(Message record) {
        AMQPLargeMessage msgEncode = (AMQPLargeMessage)record;
        ByteBuf buf = msgEncode.getSavedEncodeBuffer();
        try {
            int encodeSize = 21 + SimpleString.sizeofNullableString((SimpleString)record.getAddressSimpleString()) + 1 + buf.writerIndex() + 8 + 1;
            TypedProperties properties = ((AMQPMessage)record).getExtraProperties();
            int n = encodeSize + (properties != null ? properties.getEncodeSize() : 0);
            return n;
        }
        finally {
            msgEncode.releaseEncodedBuffer();
        }
    }

    public void encode(ActiveMQBuffer buffer, Message record) {
        super.encode(buffer, record);
        AMQPLargeMessage msgEncode = (AMQPLargeMessage)record;
        buffer.writeLong(record.getMessageID());
        buffer.writeBoolean(record.isDurable());
        buffer.writeLong(msgEncode.getMessageFormat());
        buffer.writeNullableSimpleString(record.getAddressSimpleString());
        TypedProperties properties = ((AMQPMessage)record).getExtraProperties();
        if (properties == null) {
            buffer.writeInt(0);
        } else {
            buffer.writeInt(properties.getEncodeSize());
            properties.encode(buffer.byteBuf());
        }
        ByteBuf savedEncodeBuffer = msgEncode.getSavedEncodeBuffer();
        buffer.writeBytes(savedEncodeBuffer, 0, savedEncodeBuffer.writerIndex());
        buffer.writeLong(record.getExpiration());
        buffer.writeBoolean(msgEncode.isReencoded());
        msgEncode.releaseEncodedBufferAfterWrite();
    }

    public Message decode(ActiveMQBuffer buffer, Message record, CoreMessageObjectPools pools) {
        TypedProperties properties;
        long id = buffer.readLong();
        boolean durable = buffer.readBoolean();
        long format = buffer.readLong();
        SimpleString address = buffer.readNullableSimpleString();
        int size = buffer.readInt();
        if (size != 0) {
            properties = new TypedProperties(Message.INTERNAL_PROPERTY_NAMES_PREDICATE);
            properties.decode(buffer.byteBuf());
        } else {
            properties = null;
        }
        AMQPLargeMessage largeMessage = new AMQPLargeMessage(id, format, properties, null, null);
        largeMessage.setFileDurable(durable);
        if (address != null) {
            largeMessage.setAddress(address);
        }
        largeMessage.readSavedEncoding(buffer.byteBuf());
        if (buffer.readableBytes() >= 8) {
            largeMessage.reloadExpiration(buffer.readLong());
        }
        if (buffer.readable()) {
            boolean reEncoded = buffer.readBoolean();
            largeMessage.setReencoded(reEncoded);
        }
        return largeMessage;
    }
}

