/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Autogenerated by Thrift Compiler (0.9.3)
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 *  @generated
 */
package org.apache.accumulo.proxy.thrift;

import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;

import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TException;
import org.apache.thrift.async.AsyncMethodCallback;
import org.apache.thrift.server.AbstractNonblockingServer.*;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.EnumMap;
import java.util.Set;
import java.util.HashSet;
import java.util.EnumSet;
import java.util.Collections;
import java.util.BitSet;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressWarnings({"cast", "rawtypes", "serial", "unchecked", "unused"})
public class AccumuloProxy {

  public interface Iface {

    public ByteBuffer login(String principal, Map<String,String> loginProperties) throws AccumuloSecurityException, org.apache.thrift.TException;

    public int addConstraint(ByteBuffer login, String tableName, String constraintClassName) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException;

    public void addSplits(ByteBuffer login, String tableName, Set<ByteBuffer> splits) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException;

    public void attachIterator(ByteBuffer login, String tableName, IteratorSetting setting, Set<IteratorScope> scopes) throws AccumuloSecurityException, AccumuloException, TableNotFoundException, org.apache.thrift.TException;

    public void checkIteratorConflicts(ByteBuffer login, String tableName, IteratorSetting setting, Set<IteratorScope> scopes) throws AccumuloSecurityException, AccumuloException, TableNotFoundException, org.apache.thrift.TException;

    public void clearLocatorCache(ByteBuffer login, String tableName) throws TableNotFoundException, org.apache.thrift.TException;

    public void cloneTable(ByteBuffer login, String tableName, String newTableName, boolean flush, Map<String,String> propertiesToSet, Set<String> propertiesToExclude) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, TableExistsException, org.apache.thrift.TException;

    public void compactTable(ByteBuffer login, String tableName, ByteBuffer startRow, ByteBuffer endRow, List<IteratorSetting> iterators, boolean flush, boolean wait, CompactionStrategyConfig compactionStrategy) throws AccumuloSecurityException, TableNotFoundException, AccumuloException, org.apache.thrift.TException;

    public void cancelCompaction(ByteBuffer login, String tableName) throws AccumuloSecurityException, TableNotFoundException, AccumuloException, org.apache.thrift.TException;

    public void createTable(ByteBuffer login, String tableName, boolean versioningIter, TimeType type) throws AccumuloException, AccumuloSecurityException, TableExistsException, org.apache.thrift.TException;

    public void deleteTable(ByteBuffer login, String tableName) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException;

    public void deleteRows(ByteBuffer login, String tableName, ByteBuffer startRow, ByteBuffer endRow) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException;

    public void exportTable(ByteBuffer login, String tableName, String exportDir) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException;

    public void flushTable(ByteBuffer login, String tableName, ByteBuffer startRow, ByteBuffer endRow, boolean wait) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException;

    public List<DiskUsage> getDiskUsage(ByteBuffer login, Set<String> tables) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException;

    public Map<String,Set<String>> getLocalityGroups(ByteBuffer login, String tableName) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException;

    public IteratorSetting getIteratorSetting(ByteBuffer login, String tableName, String iteratorName, IteratorScope scope) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException;

    public ByteBuffer getMaxRow(ByteBuffer login, String tableName, Set<ByteBuffer> auths, ByteBuffer startRow, boolean startInclusive, ByteBuffer endRow, boolean endInclusive) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException;

    public Map<String,String> getTableProperties(ByteBuffer login, String tableName) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException;

    public void importDirectory(ByteBuffer login, String tableName, String importDir, String failureDir, boolean setTime) throws TableNotFoundException, AccumuloException, AccumuloSecurityException, org.apache.thrift.TException;

    public void importTable(ByteBuffer login, String tableName, String importDir) throws TableExistsException, AccumuloException, AccumuloSecurityException, org.apache.thrift.TException;

    public List<ByteBuffer> listSplits(ByteBuffer login, String tableName, int maxSplits) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException;

    public Set<String> listTables(ByteBuffer login) throws org.apache.thrift.TException;

    public Map<String,Set<IteratorScope>> listIterators(ByteBuffer login, String tableName) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException;

    public Map<String,Integer> listConstraints(ByteBuffer login, String tableName) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException;

    public void mergeTablets(ByteBuffer login, String tableName, ByteBuffer startRow, ByteBuffer endRow) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException;

    public void offlineTable(ByteBuffer login, String tableName, boolean wait) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException;

    public void onlineTable(ByteBuffer login, String tableName, boolean wait) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException;

    public void removeConstraint(ByteBuffer login, String tableName, int constraint) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException;

    public void removeIterator(ByteBuffer login, String tableName, String iterName, Set<IteratorScope> scopes) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException;

    public void removeTableProperty(ByteBuffer login, String tableName, String property) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException;

    public void renameTable(ByteBuffer login, String oldTableName, String newTableName) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, TableExistsException, org.apache.thrift.TException;

    public void setLocalityGroups(ByteBuffer login, String tableName, Map<String,Set<String>> groups) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException;

    public void setTableProperty(ByteBuffer login, String tableName, String property, String value) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException;

    public Set<Range> splitRangeByTablets(ByteBuffer login, String tableName, Range range, int maxSplits) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException;

    public boolean tableExists(ByteBuffer login, String tableName) throws org.apache.thrift.TException;

    public Map<String,String> tableIdMap(ByteBuffer login) throws org.apache.thrift.TException;

    public boolean testTableClassLoad(ByteBuffer login, String tableName, String className, String asTypeName) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException;

    public void pingTabletServer(ByteBuffer login, String tserver) throws AccumuloException, AccumuloSecurityException, org.apache.thrift.TException;

    public List<ActiveScan> getActiveScans(ByteBuffer login, String tserver) throws AccumuloException, AccumuloSecurityException, org.apache.thrift.TException;

    public List<ActiveCompaction> getActiveCompactions(ByteBuffer login, String tserver) throws AccumuloException, AccumuloSecurityException, org.apache.thrift.TException;

    public Map<String,String> getSiteConfiguration(ByteBuffer login) throws AccumuloException, AccumuloSecurityException, org.apache.thrift.TException;

    public Map<String,String> getSystemConfiguration(ByteBuffer login) throws AccumuloException, AccumuloSecurityException, org.apache.thrift.TException;

    public List<String> getTabletServers(ByteBuffer login) throws org.apache.thrift.TException;

    public void removeProperty(ByteBuffer login, String property) throws AccumuloException, AccumuloSecurityException, org.apache.thrift.TException;

    public void setProperty(ByteBuffer login, String property, String value) throws AccumuloException, AccumuloSecurityException, org.apache.thrift.TException;

    public boolean testClassLoad(ByteBuffer login, String className, String asTypeName) throws AccumuloException, AccumuloSecurityException, org.apache.thrift.TException;

    public boolean authenticateUser(ByteBuffer login, String user, Map<String,String> properties) throws AccumuloException, AccumuloSecurityException, org.apache.thrift.TException;

    public void changeUserAuthorizations(ByteBuffer login, String user, Set<ByteBuffer> authorizations) throws AccumuloException, AccumuloSecurityException, org.apache.thrift.TException;

    public void changeLocalUserPassword(ByteBuffer login, String user, ByteBuffer password) throws AccumuloException, AccumuloSecurityException, org.apache.thrift.TException;

    public void createLocalUser(ByteBuffer login, String user, ByteBuffer password) throws AccumuloException, AccumuloSecurityException, org.apache.thrift.TException;

    public void dropLocalUser(ByteBuffer login, String user) throws AccumuloException, AccumuloSecurityException, org.apache.thrift.TException;

    public List<ByteBuffer> getUserAuthorizations(ByteBuffer login, String user) throws AccumuloException, AccumuloSecurityException, org.apache.thrift.TException;

    public void grantSystemPermission(ByteBuffer login, String user, SystemPermission perm) throws AccumuloException, AccumuloSecurityException, org.apache.thrift.TException;

    public void grantTablePermission(ByteBuffer login, String user, String table, TablePermission perm) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException;

    public boolean hasSystemPermission(ByteBuffer login, String user, SystemPermission perm) throws AccumuloException, AccumuloSecurityException, org.apache.thrift.TException;

    public boolean hasTablePermission(ByteBuffer login, String user, String table, TablePermission perm) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException;

    public Set<String> listLocalUsers(ByteBuffer login) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException;

    public void revokeSystemPermission(ByteBuffer login, String user, SystemPermission perm) throws AccumuloException, AccumuloSecurityException, org.apache.thrift.TException;

    public void revokeTablePermission(ByteBuffer login, String user, String table, TablePermission perm) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException;

    public void grantNamespacePermission(ByteBuffer login, String user, String namespaceName, NamespacePermission perm) throws AccumuloException, AccumuloSecurityException, org.apache.thrift.TException;

    public boolean hasNamespacePermission(ByteBuffer login, String user, String namespaceName, NamespacePermission perm) throws AccumuloException, AccumuloSecurityException, org.apache.thrift.TException;

    public void revokeNamespacePermission(ByteBuffer login, String user, String namespaceName, NamespacePermission perm) throws AccumuloException, AccumuloSecurityException, org.apache.thrift.TException;

    public String createBatchScanner(ByteBuffer login, String tableName, BatchScanOptions options) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException;

    public String createScanner(ByteBuffer login, String tableName, ScanOptions options) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException;

    public boolean hasNext(String scanner) throws UnknownScanner, org.apache.thrift.TException;

    public KeyValueAndPeek nextEntry(String scanner) throws NoMoreEntriesException, UnknownScanner, AccumuloSecurityException, org.apache.thrift.TException;

    public ScanResult nextK(String scanner, int k) throws NoMoreEntriesException, UnknownScanner, AccumuloSecurityException, org.apache.thrift.TException;

    public void closeScanner(String scanner) throws UnknownScanner, org.apache.thrift.TException;

    public void updateAndFlush(ByteBuffer login, String tableName, Map<ByteBuffer,List<ColumnUpdate>> cells) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, MutationsRejectedException, org.apache.thrift.TException;

    public String createWriter(ByteBuffer login, String tableName, WriterOptions opts) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException;

    public void update(String writer, Map<ByteBuffer,List<ColumnUpdate>> cells) throws org.apache.thrift.TException;

    public void flush(String writer) throws UnknownWriter, MutationsRejectedException, org.apache.thrift.TException;

    public void closeWriter(String writer) throws UnknownWriter, MutationsRejectedException, org.apache.thrift.TException;

    public ConditionalStatus updateRowConditionally(ByteBuffer login, String tableName, ByteBuffer row, ConditionalUpdates updates) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException;

    public String createConditionalWriter(ByteBuffer login, String tableName, ConditionalWriterOptions options) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException;

    public Map<ByteBuffer,ConditionalStatus> updateRowsConditionally(String conditionalWriter, Map<ByteBuffer,ConditionalUpdates> updates) throws UnknownWriter, AccumuloException, AccumuloSecurityException, org.apache.thrift.TException;

    public void closeConditionalWriter(String conditionalWriter) throws org.apache.thrift.TException;

    public Range getRowRange(ByteBuffer row) throws org.apache.thrift.TException;

    public Key getFollowing(Key key, PartialKey part) throws org.apache.thrift.TException;

    public String systemNamespace() throws org.apache.thrift.TException;

    public String defaultNamespace() throws org.apache.thrift.TException;

    public List<String> listNamespaces(ByteBuffer login) throws AccumuloException, AccumuloSecurityException, org.apache.thrift.TException;

    public boolean namespaceExists(ByteBuffer login, String namespaceName) throws AccumuloException, AccumuloSecurityException, org.apache.thrift.TException;

    public void createNamespace(ByteBuffer login, String namespaceName) throws AccumuloException, AccumuloSecurityException, NamespaceExistsException, org.apache.thrift.TException;

    public void deleteNamespace(ByteBuffer login, String namespaceName) throws AccumuloException, AccumuloSecurityException, NamespaceNotFoundException, NamespaceNotEmptyException, org.apache.thrift.TException;

    public void renameNamespace(ByteBuffer login, String oldNamespaceName, String newNamespaceName) throws AccumuloException, AccumuloSecurityException, NamespaceNotFoundException, NamespaceExistsException, org.apache.thrift.TException;

    public void setNamespaceProperty(ByteBuffer login, String namespaceName, String property, String value) throws AccumuloException, AccumuloSecurityException, NamespaceNotFoundException, org.apache.thrift.TException;

    public void removeNamespaceProperty(ByteBuffer login, String namespaceName, String property) throws AccumuloException, AccumuloSecurityException, NamespaceNotFoundException, org.apache.thrift.TException;

    public Map<String,String> getNamespaceProperties(ByteBuffer login, String namespaceName) throws AccumuloException, AccumuloSecurityException, NamespaceNotFoundException, org.apache.thrift.TException;

    public Map<String,String> namespaceIdMap(ByteBuffer login) throws AccumuloException, AccumuloSecurityException, org.apache.thrift.TException;

    public void attachNamespaceIterator(ByteBuffer login, String namespaceName, IteratorSetting setting, Set<IteratorScope> scopes) throws AccumuloException, AccumuloSecurityException, NamespaceNotFoundException, org.apache.thrift.TException;

    public void removeNamespaceIterator(ByteBuffer login, String namespaceName, String name, Set<IteratorScope> scopes) throws AccumuloException, AccumuloSecurityException, NamespaceNotFoundException, org.apache.thrift.TException;

    public IteratorSetting getNamespaceIteratorSetting(ByteBuffer login, String namespaceName, String name, IteratorScope scope) throws AccumuloException, AccumuloSecurityException, NamespaceNotFoundException, org.apache.thrift.TException;

    public Map<String,Set<IteratorScope>> listNamespaceIterators(ByteBuffer login, String namespaceName) throws AccumuloException, AccumuloSecurityException, NamespaceNotFoundException, org.apache.thrift.TException;

    public void checkNamespaceIteratorConflicts(ByteBuffer login, String namespaceName, IteratorSetting setting, Set<IteratorScope> scopes) throws AccumuloException, AccumuloSecurityException, NamespaceNotFoundException, org.apache.thrift.TException;

    public int addNamespaceConstraint(ByteBuffer login, String namespaceName, String constraintClassName) throws AccumuloException, AccumuloSecurityException, NamespaceNotFoundException, org.apache.thrift.TException;

    public void removeNamespaceConstraint(ByteBuffer login, String namespaceName, int id) throws AccumuloException, AccumuloSecurityException, NamespaceNotFoundException, org.apache.thrift.TException;

    public Map<String,Integer> listNamespaceConstraints(ByteBuffer login, String namespaceName) throws AccumuloException, AccumuloSecurityException, NamespaceNotFoundException, org.apache.thrift.TException;

    public boolean testNamespaceClassLoad(ByteBuffer login, String namespaceName, String className, String asTypeName) throws AccumuloException, AccumuloSecurityException, NamespaceNotFoundException, org.apache.thrift.TException;

  }

  public interface AsyncIface {

    public void login(String principal, Map<String,String> loginProperties, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void addConstraint(ByteBuffer login, String tableName, String constraintClassName, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void addSplits(ByteBuffer login, String tableName, Set<ByteBuffer> splits, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void attachIterator(ByteBuffer login, String tableName, IteratorSetting setting, Set<IteratorScope> scopes, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void checkIteratorConflicts(ByteBuffer login, String tableName, IteratorSetting setting, Set<IteratorScope> scopes, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void clearLocatorCache(ByteBuffer login, String tableName, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void cloneTable(ByteBuffer login, String tableName, String newTableName, boolean flush, Map<String,String> propertiesToSet, Set<String> propertiesToExclude, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void compactTable(ByteBuffer login, String tableName, ByteBuffer startRow, ByteBuffer endRow, List<IteratorSetting> iterators, boolean flush, boolean wait, CompactionStrategyConfig compactionStrategy, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void cancelCompaction(ByteBuffer login, String tableName, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void createTable(ByteBuffer login, String tableName, boolean versioningIter, TimeType type, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void deleteTable(ByteBuffer login, String tableName, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void deleteRows(ByteBuffer login, String tableName, ByteBuffer startRow, ByteBuffer endRow, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void exportTable(ByteBuffer login, String tableName, String exportDir, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void flushTable(ByteBuffer login, String tableName, ByteBuffer startRow, ByteBuffer endRow, boolean wait, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getDiskUsage(ByteBuffer login, Set<String> tables, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getLocalityGroups(ByteBuffer login, String tableName, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getIteratorSetting(ByteBuffer login, String tableName, String iteratorName, IteratorScope scope, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getMaxRow(ByteBuffer login, String tableName, Set<ByteBuffer> auths, ByteBuffer startRow, boolean startInclusive, ByteBuffer endRow, boolean endInclusive, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getTableProperties(ByteBuffer login, String tableName, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void importDirectory(ByteBuffer login, String tableName, String importDir, String failureDir, boolean setTime, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void importTable(ByteBuffer login, String tableName, String importDir, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void listSplits(ByteBuffer login, String tableName, int maxSplits, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void listTables(ByteBuffer login, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void listIterators(ByteBuffer login, String tableName, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void listConstraints(ByteBuffer login, String tableName, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void mergeTablets(ByteBuffer login, String tableName, ByteBuffer startRow, ByteBuffer endRow, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void offlineTable(ByteBuffer login, String tableName, boolean wait, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void onlineTable(ByteBuffer login, String tableName, boolean wait, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void removeConstraint(ByteBuffer login, String tableName, int constraint, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void removeIterator(ByteBuffer login, String tableName, String iterName, Set<IteratorScope> scopes, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void removeTableProperty(ByteBuffer login, String tableName, String property, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void renameTable(ByteBuffer login, String oldTableName, String newTableName, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void setLocalityGroups(ByteBuffer login, String tableName, Map<String,Set<String>> groups, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void setTableProperty(ByteBuffer login, String tableName, String property, String value, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void splitRangeByTablets(ByteBuffer login, String tableName, Range range, int maxSplits, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void tableExists(ByteBuffer login, String tableName, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void tableIdMap(ByteBuffer login, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void testTableClassLoad(ByteBuffer login, String tableName, String className, String asTypeName, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void pingTabletServer(ByteBuffer login, String tserver, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getActiveScans(ByteBuffer login, String tserver, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getActiveCompactions(ByteBuffer login, String tserver, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getSiteConfiguration(ByteBuffer login, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getSystemConfiguration(ByteBuffer login, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getTabletServers(ByteBuffer login, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void removeProperty(ByteBuffer login, String property, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void setProperty(ByteBuffer login, String property, String value, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void testClassLoad(ByteBuffer login, String className, String asTypeName, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void authenticateUser(ByteBuffer login, String user, Map<String,String> properties, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void changeUserAuthorizations(ByteBuffer login, String user, Set<ByteBuffer> authorizations, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void changeLocalUserPassword(ByteBuffer login, String user, ByteBuffer password, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void createLocalUser(ByteBuffer login, String user, ByteBuffer password, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void dropLocalUser(ByteBuffer login, String user, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getUserAuthorizations(ByteBuffer login, String user, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void grantSystemPermission(ByteBuffer login, String user, SystemPermission perm, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void grantTablePermission(ByteBuffer login, String user, String table, TablePermission perm, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void hasSystemPermission(ByteBuffer login, String user, SystemPermission perm, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void hasTablePermission(ByteBuffer login, String user, String table, TablePermission perm, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void listLocalUsers(ByteBuffer login, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void revokeSystemPermission(ByteBuffer login, String user, SystemPermission perm, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void revokeTablePermission(ByteBuffer login, String user, String table, TablePermission perm, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void grantNamespacePermission(ByteBuffer login, String user, String namespaceName, NamespacePermission perm, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void hasNamespacePermission(ByteBuffer login, String user, String namespaceName, NamespacePermission perm, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void revokeNamespacePermission(ByteBuffer login, String user, String namespaceName, NamespacePermission perm, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void createBatchScanner(ByteBuffer login, String tableName, BatchScanOptions options, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void createScanner(ByteBuffer login, String tableName, ScanOptions options, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void hasNext(String scanner, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void nextEntry(String scanner, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void nextK(String scanner, int k, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void closeScanner(String scanner, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void updateAndFlush(ByteBuffer login, String tableName, Map<ByteBuffer,List<ColumnUpdate>> cells, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void createWriter(ByteBuffer login, String tableName, WriterOptions opts, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void update(String writer, Map<ByteBuffer,List<ColumnUpdate>> cells, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void flush(String writer, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void closeWriter(String writer, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void updateRowConditionally(ByteBuffer login, String tableName, ByteBuffer row, ConditionalUpdates updates, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void createConditionalWriter(ByteBuffer login, String tableName, ConditionalWriterOptions options, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void updateRowsConditionally(String conditionalWriter, Map<ByteBuffer,ConditionalUpdates> updates, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void closeConditionalWriter(String conditionalWriter, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getRowRange(ByteBuffer row, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getFollowing(Key key, PartialKey part, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void systemNamespace(org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void defaultNamespace(org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void listNamespaces(ByteBuffer login, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void namespaceExists(ByteBuffer login, String namespaceName, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void createNamespace(ByteBuffer login, String namespaceName, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void deleteNamespace(ByteBuffer login, String namespaceName, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void renameNamespace(ByteBuffer login, String oldNamespaceName, String newNamespaceName, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void setNamespaceProperty(ByteBuffer login, String namespaceName, String property, String value, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void removeNamespaceProperty(ByteBuffer login, String namespaceName, String property, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getNamespaceProperties(ByteBuffer login, String namespaceName, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void namespaceIdMap(ByteBuffer login, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void attachNamespaceIterator(ByteBuffer login, String namespaceName, IteratorSetting setting, Set<IteratorScope> scopes, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void removeNamespaceIterator(ByteBuffer login, String namespaceName, String name, Set<IteratorScope> scopes, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getNamespaceIteratorSetting(ByteBuffer login, String namespaceName, String name, IteratorScope scope, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void listNamespaceIterators(ByteBuffer login, String namespaceName, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void checkNamespaceIteratorConflicts(ByteBuffer login, String namespaceName, IteratorSetting setting, Set<IteratorScope> scopes, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void addNamespaceConstraint(ByteBuffer login, String namespaceName, String constraintClassName, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void removeNamespaceConstraint(ByteBuffer login, String namespaceName, int id, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void listNamespaceConstraints(ByteBuffer login, String namespaceName, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void testNamespaceClassLoad(ByteBuffer login, String namespaceName, String className, String asTypeName, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

  }

  public static class Client extends org.apache.thrift.TServiceClient implements Iface {
    public static class Factory implements org.apache.thrift.TServiceClientFactory<Client> {
      public Factory() {}
      public Client getClient(org.apache.thrift.protocol.TProtocol prot) {
        return new Client(prot);
      }
      public Client getClient(org.apache.thrift.protocol.TProtocol iprot, org.apache.thrift.protocol.TProtocol oprot) {
        return new Client(iprot, oprot);
      }
    }

    public Client(org.apache.thrift.protocol.TProtocol prot)
    {
      super(prot, prot);
    }

    public Client(org.apache.thrift.protocol.TProtocol iprot, org.apache.thrift.protocol.TProtocol oprot) {
      super(iprot, oprot);
    }

    public ByteBuffer login(String principal, Map<String,String> loginProperties) throws AccumuloSecurityException, org.apache.thrift.TException
    {
      send_login(principal, loginProperties);
      return recv_login();
    }

    public void send_login(String principal, Map<String,String> loginProperties) throws org.apache.thrift.TException
    {
      login_args args = new login_args();
      args.setPrincipal(principal);
      args.setLoginProperties(loginProperties);
      sendBase("login", args);
    }

    public ByteBuffer recv_login() throws AccumuloSecurityException, org.apache.thrift.TException
    {
      login_result result = new login_result();
      receiveBase(result, "login");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ouch2 != null) {
        throw result.ouch2;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "login failed: unknown result");
    }

    public int addConstraint(ByteBuffer login, String tableName, String constraintClassName) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException
    {
      send_addConstraint(login, tableName, constraintClassName);
      return recv_addConstraint();
    }

    public void send_addConstraint(ByteBuffer login, String tableName, String constraintClassName) throws org.apache.thrift.TException
    {
      addConstraint_args args = new addConstraint_args();
      args.setLogin(login);
      args.setTableName(tableName);
      args.setConstraintClassName(constraintClassName);
      sendBase("addConstraint", args);
    }

    public int recv_addConstraint() throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException
    {
      addConstraint_result result = new addConstraint_result();
      receiveBase(result, "addConstraint");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ouch1 != null) {
        throw result.ouch1;
      }
      if (result.ouch2 != null) {
        throw result.ouch2;
      }
      if (result.ouch3 != null) {
        throw result.ouch3;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "addConstraint failed: unknown result");
    }

    public void addSplits(ByteBuffer login, String tableName, Set<ByteBuffer> splits) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException
    {
      send_addSplits(login, tableName, splits);
      recv_addSplits();
    }

    public void send_addSplits(ByteBuffer login, String tableName, Set<ByteBuffer> splits) throws org.apache.thrift.TException
    {
      addSplits_args args = new addSplits_args();
      args.setLogin(login);
      args.setTableName(tableName);
      args.setSplits(splits);
      sendBase("addSplits", args);
    }

    public void recv_addSplits() throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException
    {
      addSplits_result result = new addSplits_result();
      receiveBase(result, "addSplits");
      if (result.ouch1 != null) {
        throw result.ouch1;
      }
      if (result.ouch2 != null) {
        throw result.ouch2;
      }
      if (result.ouch3 != null) {
        throw result.ouch3;
      }
      return;
    }

    public void attachIterator(ByteBuffer login, String tableName, IteratorSetting setting, Set<IteratorScope> scopes) throws AccumuloSecurityException, AccumuloException, TableNotFoundException, org.apache.thrift.TException
    {
      send_attachIterator(login, tableName, setting, scopes);
      recv_attachIterator();
    }

    public void send_attachIterator(ByteBuffer login, String tableName, IteratorSetting setting, Set<IteratorScope> scopes) throws org.apache.thrift.TException
    {
      attachIterator_args args = new attachIterator_args();
      args.setLogin(login);
      args.setTableName(tableName);
      args.setSetting(setting);
      args.setScopes(scopes);
      sendBase("attachIterator", args);
    }

    public void recv_attachIterator() throws AccumuloSecurityException, AccumuloException, TableNotFoundException, org.apache.thrift.TException
    {
      attachIterator_result result = new attachIterator_result();
      receiveBase(result, "attachIterator");
      if (result.ouch1 != null) {
        throw result.ouch1;
      }
      if (result.ouch2 != null) {
        throw result.ouch2;
      }
      if (result.ouch3 != null) {
        throw result.ouch3;
      }
      return;
    }

    public void checkIteratorConflicts(ByteBuffer login, String tableName, IteratorSetting setting, Set<IteratorScope> scopes) throws AccumuloSecurityException, AccumuloException, TableNotFoundException, org.apache.thrift.TException
    {
      send_checkIteratorConflicts(login, tableName, setting, scopes);
      recv_checkIteratorConflicts();
    }

    public void send_checkIteratorConflicts(ByteBuffer login, String tableName, IteratorSetting setting, Set<IteratorScope> scopes) throws org.apache.thrift.TException
    {
      checkIteratorConflicts_args args = new checkIteratorConflicts_args();
      args.setLogin(login);
      args.setTableName(tableName);
      args.setSetting(setting);
      args.setScopes(scopes);
      sendBase("checkIteratorConflicts", args);
    }

    public void recv_checkIteratorConflicts() throws AccumuloSecurityException, AccumuloException, TableNotFoundException, org.apache.thrift.TException
    {
      checkIteratorConflicts_result result = new checkIteratorConflicts_result();
      receiveBase(result, "checkIteratorConflicts");
      if (result.ouch1 != null) {
        throw result.ouch1;
      }
      if (result.ouch2 != null) {
        throw result.ouch2;
      }
      if (result.ouch3 != null) {
        throw result.ouch3;
      }
      return;
    }

    public void clearLocatorCache(ByteBuffer login, String tableName) throws TableNotFoundException, org.apache.thrift.TException
    {
      send_clearLocatorCache(login, tableName);
      recv_clearLocatorCache();
    }

    public void send_clearLocatorCache(ByteBuffer login, String tableName) throws org.apache.thrift.TException
    {
      clearLocatorCache_args args = new clearLocatorCache_args();
      args.setLogin(login);
      args.setTableName(tableName);
      sendBase("clearLocatorCache", args);
    }

    public void recv_clearLocatorCache() throws TableNotFoundException, org.apache.thrift.TException
    {
      clearLocatorCache_result result = new clearLocatorCache_result();
      receiveBase(result, "clearLocatorCache");
      if (result.ouch1 != null) {
        throw result.ouch1;
      }
      return;
    }

    public void cloneTable(ByteBuffer login, String tableName, String newTableName, boolean flush, Map<String,String> propertiesToSet, Set<String> propertiesToExclude) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, TableExistsException, org.apache.thrift.TException
    {
      send_cloneTable(login, tableName, newTableName, flush, propertiesToSet, propertiesToExclude);
      recv_cloneTable();
    }

    public void send_cloneTable(ByteBuffer login, String tableName, String newTableName, boolean flush, Map<String,String> propertiesToSet, Set<String> propertiesToExclude) throws org.apache.thrift.TException
    {
      cloneTable_args args = new cloneTable_args();
      args.setLogin(login);
      args.setTableName(tableName);
      args.setNewTableName(newTableName);
      args.setFlush(flush);
      args.setPropertiesToSet(propertiesToSet);
      args.setPropertiesToExclude(propertiesToExclude);
      sendBase("cloneTable", args);
    }

    public void recv_cloneTable() throws AccumuloException, AccumuloSecurityException, TableNotFoundException, TableExistsException, org.apache.thrift.TException
    {
      cloneTable_result result = new cloneTable_result();
      receiveBase(result, "cloneTable");
      if (result.ouch1 != null) {
        throw result.ouch1;
      }
      if (result.ouch2 != null) {
        throw result.ouch2;
      }
      if (result.ouch3 != null) {
        throw result.ouch3;
      }
      if (result.ouch4 != null) {
        throw result.ouch4;
      }
      return;
    }

    public void compactTable(ByteBuffer login, String tableName, ByteBuffer startRow, ByteBuffer endRow, List<IteratorSetting> iterators, boolean flush, boolean wait, CompactionStrategyConfig compactionStrategy) throws AccumuloSecurityException, TableNotFoundException, AccumuloException, org.apache.thrift.TException
    {
      send_compactTable(login, tableName, startRow, endRow, iterators, flush, wait, compactionStrategy);
      recv_compactTable();
    }

    public void send_compactTable(ByteBuffer login, String tableName, ByteBuffer startRow, ByteBuffer endRow, List<IteratorSetting> iterators, boolean flush, boolean wait, CompactionStrategyConfig compactionStrategy) throws org.apache.thrift.TException
    {
      compactTable_args args = new compactTable_args();
      args.setLogin(login);
      args.setTableName(tableName);
      args.setStartRow(startRow);
      args.setEndRow(endRow);
      args.setIterators(iterators);
      args.setFlush(flush);
      args.setWait(wait);
      args.setCompactionStrategy(compactionStrategy);
      sendBase("compactTable", args);
    }

    public void recv_compactTable() throws AccumuloSecurityException, TableNotFoundException, AccumuloException, org.apache.thrift.TException
    {
      compactTable_result result = new compactTable_result();
      receiveBase(result, "compactTable");
      if (result.ouch1 != null) {
        throw result.ouch1;
      }
      if (result.ouch2 != null) {
        throw result.ouch2;
      }
      if (result.ouch3 != null) {
        throw result.ouch3;
      }
      return;
    }

    public void cancelCompaction(ByteBuffer login, String tableName) throws AccumuloSecurityException, TableNotFoundException, AccumuloException, org.apache.thrift.TException
    {
      send_cancelCompaction(login, tableName);
      recv_cancelCompaction();
    }

    public void send_cancelCompaction(ByteBuffer login, String tableName) throws org.apache.thrift.TException
    {
      cancelCompaction_args args = new cancelCompaction_args();
      args.setLogin(login);
      args.setTableName(tableName);
      sendBase("cancelCompaction", args);
    }

    public void recv_cancelCompaction() throws AccumuloSecurityException, TableNotFoundException, AccumuloException, org.apache.thrift.TException
    {
      cancelCompaction_result result = new cancelCompaction_result();
      receiveBase(result, "cancelCompaction");
      if (result.ouch1 != null) {
        throw result.ouch1;
      }
      if (result.ouch2 != null) {
        throw result.ouch2;
      }
      if (result.ouch3 != null) {
        throw result.ouch3;
      }
      return;
    }

    public void createTable(ByteBuffer login, String tableName, boolean versioningIter, TimeType type) throws AccumuloException, AccumuloSecurityException, TableExistsException, org.apache.thrift.TException
    {
      send_createTable(login, tableName, versioningIter, type);
      recv_createTable();
    }

    public void send_createTable(ByteBuffer login, String tableName, boolean versioningIter, TimeType type) throws org.apache.thrift.TException
    {
      createTable_args args = new createTable_args();
      args.setLogin(login);
      args.setTableName(tableName);
      args.setVersioningIter(versioningIter);
      args.setType(type);
      sendBase("createTable", args);
    }

    public void recv_createTable() throws AccumuloException, AccumuloSecurityException, TableExistsException, org.apache.thrift.TException
    {
      createTable_result result = new createTable_result();
      receiveBase(result, "createTable");
      if (result.ouch1 != null) {
        throw result.ouch1;
      }
      if (result.ouch2 != null) {
        throw result.ouch2;
      }
      if (result.ouch3 != null) {
        throw result.ouch3;
      }
      return;
    }

    public void deleteTable(ByteBuffer login, String tableName) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException
    {
      send_deleteTable(login, tableName);
      recv_deleteTable();
    }

    public void send_deleteTable(ByteBuffer login, String tableName) throws org.apache.thrift.TException
    {
      deleteTable_args args = new deleteTable_args();
      args.setLogin(login);
      args.setTableName(tableName);
      sendBase("deleteTable", args);
    }

    public void recv_deleteTable() throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException
    {
      deleteTable_result result = new deleteTable_result();
      receiveBase(result, "deleteTable");
      if (result.ouch1 != null) {
        throw result.ouch1;
      }
      if (result.ouch2 != null) {
        throw result.ouch2;
      }
      if (result.ouch3 != null) {
        throw result.ouch3;
      }
      return;
    }

    public void deleteRows(ByteBuffer login, String tableName, ByteBuffer startRow, ByteBuffer endRow) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException
    {
      send_deleteRows(login, tableName, startRow, endRow);
      recv_deleteRows();
    }

    public void send_deleteRows(ByteBuffer login, String tableName, ByteBuffer startRow, ByteBuffer endRow) throws org.apache.thrift.TException
    {
      deleteRows_args args = new deleteRows_args();
      args.setLogin(login);
      args.setTableName(tableName);
      args.setStartRow(startRow);
      args.setEndRow(endRow);
      sendBase("deleteRows", args);
    }

    public void recv_deleteRows() throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException
    {
      deleteRows_result result = new deleteRows_result();
      receiveBase(result, "deleteRows");
      if (result.ouch1 != null) {
        throw result.ouch1;
      }
      if (result.ouch2 != null) {
        throw result.ouch2;
      }
      if (result.ouch3 != null) {
        throw result.ouch3;
      }
      return;
    }

    public void exportTable(ByteBuffer login, String tableName, String exportDir) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException
    {
      send_exportTable(login, tableName, exportDir);
      recv_exportTable();
    }

    public void send_exportTable(ByteBuffer login, String tableName, String exportDir) throws org.apache.thrift.TException
    {
      exportTable_args args = new exportTable_args();
      args.setLogin(login);
      args.setTableName(tableName);
      args.setExportDir(exportDir);
      sendBase("exportTable", args);
    }

    public void recv_exportTable() throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException
    {
      exportTable_result result = new exportTable_result();
      receiveBase(result, "exportTable");
      if (result.ouch1 != null) {
        throw result.ouch1;
      }
      if (result.ouch2 != null) {
        throw result.ouch2;
      }
      if (result.ouch3 != null) {
        throw result.ouch3;
      }
      return;
    }

    public void flushTable(ByteBuffer login, String tableName, ByteBuffer startRow, ByteBuffer endRow, boolean wait) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException
    {
      send_flushTable(login, tableName, startRow, endRow, wait);
      recv_flushTable();
    }

    public void send_flushTable(ByteBuffer login, String tableName, ByteBuffer startRow, ByteBuffer endRow, boolean wait) throws org.apache.thrift.TException
    {
      flushTable_args args = new flushTable_args();
      args.setLogin(login);
      args.setTableName(tableName);
      args.setStartRow(startRow);
      args.setEndRow(endRow);
      args.setWait(wait);
      sendBase("flushTable", args);
    }

    public void recv_flushTable() throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException
    {
      flushTable_result result = new flushTable_result();
      receiveBase(result, "flushTable");
      if (result.ouch1 != null) {
        throw result.ouch1;
      }
      if (result.ouch2 != null) {
        throw result.ouch2;
      }
      if (result.ouch3 != null) {
        throw result.ouch3;
      }
      return;
    }

    public List<DiskUsage> getDiskUsage(ByteBuffer login, Set<String> tables) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException
    {
      send_getDiskUsage(login, tables);
      return recv_getDiskUsage();
    }

    public void send_getDiskUsage(ByteBuffer login, Set<String> tables) throws org.apache.thrift.TException
    {
      getDiskUsage_args args = new getDiskUsage_args();
      args.setLogin(login);
      args.setTables(tables);
      sendBase("getDiskUsage", args);
    }

    public List<DiskUsage> recv_getDiskUsage() throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException
    {
      getDiskUsage_result result = new getDiskUsage_result();
      receiveBase(result, "getDiskUsage");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ouch1 != null) {
        throw result.ouch1;
      }
      if (result.ouch2 != null) {
        throw result.ouch2;
      }
      if (result.ouch3 != null) {
        throw result.ouch3;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getDiskUsage failed: unknown result");
    }

    public Map<String,Set<String>> getLocalityGroups(ByteBuffer login, String tableName) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException
    {
      send_getLocalityGroups(login, tableName);
      return recv_getLocalityGroups();
    }

    public void send_getLocalityGroups(ByteBuffer login, String tableName) throws org.apache.thrift.TException
    {
      getLocalityGroups_args args = new getLocalityGroups_args();
      args.setLogin(login);
      args.setTableName(tableName);
      sendBase("getLocalityGroups", args);
    }

    public Map<String,Set<String>> recv_getLocalityGroups() throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException
    {
      getLocalityGroups_result result = new getLocalityGroups_result();
      receiveBase(result, "getLocalityGroups");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ouch1 != null) {
        throw result.ouch1;
      }
      if (result.ouch2 != null) {
        throw result.ouch2;
      }
      if (result.ouch3 != null) {
        throw result.ouch3;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getLocalityGroups failed: unknown result");
    }

    public IteratorSetting getIteratorSetting(ByteBuffer login, String tableName, String iteratorName, IteratorScope scope) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException
    {
      send_getIteratorSetting(login, tableName, iteratorName, scope);
      return recv_getIteratorSetting();
    }

    public void send_getIteratorSetting(ByteBuffer login, String tableName, String iteratorName, IteratorScope scope) throws org.apache.thrift.TException
    {
      getIteratorSetting_args args = new getIteratorSetting_args();
      args.setLogin(login);
      args.setTableName(tableName);
      args.setIteratorName(iteratorName);
      args.setScope(scope);
      sendBase("getIteratorSetting", args);
    }

    public IteratorSetting recv_getIteratorSetting() throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException
    {
      getIteratorSetting_result result = new getIteratorSetting_result();
      receiveBase(result, "getIteratorSetting");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ouch1 != null) {
        throw result.ouch1;
      }
      if (result.ouch2 != null) {
        throw result.ouch2;
      }
      if (result.ouch3 != null) {
        throw result.ouch3;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getIteratorSetting failed: unknown result");
    }

    public ByteBuffer getMaxRow(ByteBuffer login, String tableName, Set<ByteBuffer> auths, ByteBuffer startRow, boolean startInclusive, ByteBuffer endRow, boolean endInclusive) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException
    {
      send_getMaxRow(login, tableName, auths, startRow, startInclusive, endRow, endInclusive);
      return recv_getMaxRow();
    }

    public void send_getMaxRow(ByteBuffer login, String tableName, Set<ByteBuffer> auths, ByteBuffer startRow, boolean startInclusive, ByteBuffer endRow, boolean endInclusive) throws org.apache.thrift.TException
    {
      getMaxRow_args args = new getMaxRow_args();
      args.setLogin(login);
      args.setTableName(tableName);
      args.setAuths(auths);
      args.setStartRow(startRow);
      args.setStartInclusive(startInclusive);
      args.setEndRow(endRow);
      args.setEndInclusive(endInclusive);
      sendBase("getMaxRow", args);
    }

    public ByteBuffer recv_getMaxRow() throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException
    {
      getMaxRow_result result = new getMaxRow_result();
      receiveBase(result, "getMaxRow");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ouch1 != null) {
        throw result.ouch1;
      }
      if (result.ouch2 != null) {
        throw result.ouch2;
      }
      if (result.ouch3 != null) {
        throw result.ouch3;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getMaxRow failed: unknown result");
    }

    public Map<String,String> getTableProperties(ByteBuffer login, String tableName) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException
    {
      send_getTableProperties(login, tableName);
      return recv_getTableProperties();
    }

    public void send_getTableProperties(ByteBuffer login, String tableName) throws org.apache.thrift.TException
    {
      getTableProperties_args args = new getTableProperties_args();
      args.setLogin(login);
      args.setTableName(tableName);
      sendBase("getTableProperties", args);
    }

    public Map<String,String> recv_getTableProperties() throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException
    {
      getTableProperties_result result = new getTableProperties_result();
      receiveBase(result, "getTableProperties");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ouch1 != null) {
        throw result.ouch1;
      }
      if (result.ouch2 != null) {
        throw result.ouch2;
      }
      if (result.ouch3 != null) {
        throw result.ouch3;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getTableProperties failed: unknown result");
    }

    public void importDirectory(ByteBuffer login, String tableName, String importDir, String failureDir, boolean setTime) throws TableNotFoundException, AccumuloException, AccumuloSecurityException, org.apache.thrift.TException
    {
      send_importDirectory(login, tableName, importDir, failureDir, setTime);
      recv_importDirectory();
    }

    public void send_importDirectory(ByteBuffer login, String tableName, String importDir, String failureDir, boolean setTime) throws org.apache.thrift.TException
    {
      importDirectory_args args = new importDirectory_args();
      args.setLogin(login);
      args.setTableName(tableName);
      args.setImportDir(importDir);
      args.setFailureDir(failureDir);
      args.setSetTime(setTime);
      sendBase("importDirectory", args);
    }

    public void recv_importDirectory() throws TableNotFoundException, AccumuloException, AccumuloSecurityException, org.apache.thrift.TException
    {
      importDirectory_result result = new importDirectory_result();
      receiveBase(result, "importDirectory");
      if (result.ouch1 != null) {
        throw result.ouch1;
      }
      if (result.ouch3 != null) {
        throw result.ouch3;
      }
      if (result.ouch4 != null) {
        throw result.ouch4;
      }
      return;
    }

    public void importTable(ByteBuffer login, String tableName, String importDir) throws TableExistsException, AccumuloException, AccumuloSecurityException, org.apache.thrift.TException
    {
      send_importTable(login, tableName, importDir);
      recv_importTable();
    }

    public void send_importTable(ByteBuffer login, String tableName, String importDir) throws org.apache.thrift.TException
    {
      importTable_args args = new importTable_args();
      args.setLogin(login);
      args.setTableName(tableName);
      args.setImportDir(importDir);
      sendBase("importTable", args);
    }

    public void recv_importTable() throws TableExistsException, AccumuloException, AccumuloSecurityException, org.apache.thrift.TException
    {
      importTable_result result = new importTable_result();
      receiveBase(result, "importTable");
      if (result.ouch1 != null) {
        throw result.ouch1;
      }
      if (result.ouch2 != null) {
        throw result.ouch2;
      }
      if (result.ouch3 != null) {
        throw result.ouch3;
      }
      return;
    }

    public List<ByteBuffer> listSplits(ByteBuffer login, String tableName, int maxSplits) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException
    {
      send_listSplits(login, tableName, maxSplits);
      return recv_listSplits();
    }

    public void send_listSplits(ByteBuffer login, String tableName, int maxSplits) throws org.apache.thrift.TException
    {
      listSplits_args args = new listSplits_args();
      args.setLogin(login);
      args.setTableName(tableName);
      args.setMaxSplits(maxSplits);
      sendBase("listSplits", args);
    }

    public List<ByteBuffer> recv_listSplits() throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException
    {
      listSplits_result result = new listSplits_result();
      receiveBase(result, "listSplits");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ouch1 != null) {
        throw result.ouch1;
      }
      if (result.ouch2 != null) {
        throw result.ouch2;
      }
      if (result.ouch3 != null) {
        throw result.ouch3;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "listSplits failed: unknown result");
    }

    public Set<String> listTables(ByteBuffer login) throws org.apache.thrift.TException
    {
      send_listTables(login);
      return recv_listTables();
    }

    public void send_listTables(ByteBuffer login) throws org.apache.thrift.TException
    {
      listTables_args args = new listTables_args();
      args.setLogin(login);
      sendBase("listTables", args);
    }

    public Set<String> recv_listTables() throws org.apache.thrift.TException
    {
      listTables_result result = new listTables_result();
      receiveBase(result, "listTables");
      if (result.isSetSuccess()) {
        return result.success;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "listTables failed: unknown result");
    }

    public Map<String,Set<IteratorScope>> listIterators(ByteBuffer login, String tableName) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException
    {
      send_listIterators(login, tableName);
      return recv_listIterators();
    }

    public void send_listIterators(ByteBuffer login, String tableName) throws org.apache.thrift.TException
    {
      listIterators_args args = new listIterators_args();
      args.setLogin(login);
      args.setTableName(tableName);
      sendBase("listIterators", args);
    }

    public Map<String,Set<IteratorScope>> recv_listIterators() throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException
    {
      listIterators_result result = new listIterators_result();
      receiveBase(result, "listIterators");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ouch1 != null) {
        throw result.ouch1;
      }
      if (result.ouch2 != null) {
        throw result.ouch2;
      }
      if (result.ouch3 != null) {
        throw result.ouch3;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "listIterators failed: unknown result");
    }

    public Map<String,Integer> listConstraints(ByteBuffer login, String tableName) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException
    {
      send_listConstraints(login, tableName);
      return recv_listConstraints();
    }

    public void send_listConstraints(ByteBuffer login, String tableName) throws org.apache.thrift.TException
    {
      listConstraints_args args = new listConstraints_args();
      args.setLogin(login);
      args.setTableName(tableName);
      sendBase("listConstraints", args);
    }

    public Map<String,Integer> recv_listConstraints() throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException
    {
      listConstraints_result result = new listConstraints_result();
      receiveBase(result, "listConstraints");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ouch1 != null) {
        throw result.ouch1;
      }
      if (result.ouch2 != null) {
        throw result.ouch2;
      }
      if (result.ouch3 != null) {
        throw result.ouch3;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "listConstraints failed: unknown result");
    }

    public void mergeTablets(ByteBuffer login, String tableName, ByteBuffer startRow, ByteBuffer endRow) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException
    {
      send_mergeTablets(login, tableName, startRow, endRow);
      recv_mergeTablets();
    }

    public void send_mergeTablets(ByteBuffer login, String tableName, ByteBuffer startRow, ByteBuffer endRow) throws org.apache.thrift.TException
    {
      mergeTablets_args args = new mergeTablets_args();
      args.setLogin(login);
      args.setTableName(tableName);
      args.setStartRow(startRow);
      args.setEndRow(endRow);
      sendBase("mergeTablets", args);
    }

    public void recv_mergeTablets() throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException
    {
      mergeTablets_result result = new mergeTablets_result();
      receiveBase(result, "mergeTablets");
      if (result.ouch1 != null) {
        throw result.ouch1;
      }
      if (result.ouch2 != null) {
        throw result.ouch2;
      }
      if (result.ouch3 != null) {
        throw result.ouch3;
      }
      return;
    }

    public void offlineTable(ByteBuffer login, String tableName, boolean wait) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException
    {
      send_offlineTable(login, tableName, wait);
      recv_offlineTable();
    }

    public void send_offlineTable(ByteBuffer login, String tableName, boolean wait) throws org.apache.thrift.TException
    {
      offlineTable_args args = new offlineTable_args();
      args.setLogin(login);
      args.setTableName(tableName);
      args.setWait(wait);
      sendBase("offlineTable", args);
    }

    public void recv_offlineTable() throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException
    {
      offlineTable_result result = new offlineTable_result();
      receiveBase(result, "offlineTable");
      if (result.ouch1 != null) {
        throw result.ouch1;
      }
      if (result.ouch2 != null) {
        throw result.ouch2;
      }
      if (result.ouch3 != null) {
        throw result.ouch3;
      }
      return;
    }

    public void onlineTable(ByteBuffer login, String tableName, boolean wait) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException
    {
      send_onlineTable(login, tableName, wait);
      recv_onlineTable();
    }

    public void send_onlineTable(ByteBuffer login, String tableName, boolean wait) throws org.apache.thrift.TException
    {
      onlineTable_args args = new onlineTable_args();
      args.setLogin(login);
      args.setTableName(tableName);
      args.setWait(wait);
      sendBase("onlineTable", args);
    }

    public void recv_onlineTable() throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException
    {
      onlineTable_result result = new onlineTable_result();
      receiveBase(result, "onlineTable");
      if (result.ouch1 != null) {
        throw result.ouch1;
      }
      if (result.ouch2 != null) {
        throw result.ouch2;
      }
      if (result.ouch3 != null) {
        throw result.ouch3;
      }
      return;
    }

    public void removeConstraint(ByteBuffer login, String tableName, int constraint) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException
    {
      send_removeConstraint(login, tableName, constraint);
      recv_removeConstraint();
    }

    public void send_removeConstraint(ByteBuffer login, String tableName, int constraint) throws org.apache.thrift.TException
    {
      removeConstraint_args args = new removeConstraint_args();
      args.setLogin(login);
      args.setTableName(tableName);
      args.setConstraint(constraint);
      sendBase("removeConstraint", args);
    }

    public void recv_removeConstraint() throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException
    {
      removeConstraint_result result = new removeConstraint_result();
      receiveBase(result, "removeConstraint");
      if (result.ouch1 != null) {
        throw result.ouch1;
      }
      if (result.ouch2 != null) {
        throw result.ouch2;
      }
      if (result.ouch3 != null) {
        throw result.ouch3;
      }
      return;
    }

    public void removeIterator(ByteBuffer login, String tableName, String iterName, Set<IteratorScope> scopes) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException
    {
      send_removeIterator(login, tableName, iterName, scopes);
      recv_removeIterator();
    }

    public void send_removeIterator(ByteBuffer login, String tableName, String iterName, Set<IteratorScope> scopes) throws org.apache.thrift.TException
    {
      removeIterator_args args = new removeIterator_args();
      args.setLogin(login);
      args.setTableName(tableName);
      args.setIterName(iterName);
      args.setScopes(scopes);
      sendBase("removeIterator", args);
    }

    public void recv_removeIterator() throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException
    {
      removeIterator_result result = new removeIterator_result();
      receiveBase(result, "removeIterator");
      if (result.ouch1 != null) {
        throw result.ouch1;
      }
      if (result.ouch2 != null) {
        throw result.ouch2;
      }
      if (result.ouch3 != null) {
        throw result.ouch3;
      }
      return;
    }

    public void removeTableProperty(ByteBuffer login, String tableName, String property) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException
    {
      send_removeTableProperty(login, tableName, property);
      recv_removeTableProperty();
    }

    public void send_removeTableProperty(ByteBuffer login, String tableName, String property) throws org.apache.thrift.TException
    {
      removeTableProperty_args args = new removeTableProperty_args();
      args.setLogin(login);
      args.setTableName(tableName);
      args.setProperty(property);
      sendBase("removeTableProperty", args);
    }

    public void recv_removeTableProperty() throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException
    {
      removeTableProperty_result result = new removeTableProperty_result();
      receiveBase(result, "removeTableProperty");
      if (result.ouch1 != null) {
        throw result.ouch1;
      }
      if (result.ouch2 != null) {
        throw result.ouch2;
      }
      if (result.ouch3 != null) {
        throw result.ouch3;
      }
      return;
    }

    public void renameTable(ByteBuffer login, String oldTableName, String newTableName) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, TableExistsException, org.apache.thrift.TException
    {
      send_renameTable(login, oldTableName, newTableName);
      recv_renameTable();
    }

    public void send_renameTable(ByteBuffer login, String oldTableName, String newTableName) throws org.apache.thrift.TException
    {
      renameTable_args args = new renameTable_args();
      args.setLogin(login);
      args.setOldTableName(oldTableName);
      args.setNewTableName(newTableName);
      sendBase("renameTable", args);
    }

    public void recv_renameTable() throws AccumuloException, AccumuloSecurityException, TableNotFoundException, TableExistsException, org.apache.thrift.TException
    {
      renameTable_result result = new renameTable_result();
      receiveBase(result, "renameTable");
      if (result.ouch1 != null) {
        throw result.ouch1;
      }
      if (result.ouch2 != null) {
        throw result.ouch2;
      }
      if (result.ouch3 != null) {
        throw result.ouch3;
      }
      if (result.ouch4 != null) {
        throw result.ouch4;
      }
      return;
    }

    public void setLocalityGroups(ByteBuffer login, String tableName, Map<String,Set<String>> groups) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException
    {
      send_setLocalityGroups(login, tableName, groups);
      recv_setLocalityGroups();
    }

    public void send_setLocalityGroups(ByteBuffer login, String tableName, Map<String,Set<String>> groups) throws org.apache.thrift.TException
    {
      setLocalityGroups_args args = new setLocalityGroups_args();
      args.setLogin(login);
      args.setTableName(tableName);
      args.setGroups(groups);
      sendBase("setLocalityGroups", args);
    }

    public void recv_setLocalityGroups() throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException
    {
      setLocalityGroups_result result = new setLocalityGroups_result();
      receiveBase(result, "setLocalityGroups");
      if (result.ouch1 != null) {
        throw result.ouch1;
      }
      if (result.ouch2 != null) {
        throw result.ouch2;
      }
      if (result.ouch3 != null) {
        throw result.ouch3;
      }
      return;
    }

    public void setTableProperty(ByteBuffer login, String tableName, String property, String value) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException
    {
      send_setTableProperty(login, tableName, property, value);
      recv_setTableProperty();
    }

    public void send_setTableProperty(ByteBuffer login, String tableName, String property, String value) throws org.apache.thrift.TException
    {
      setTableProperty_args args = new setTableProperty_args();
      args.setLogin(login);
      args.setTableName(tableName);
      args.setProperty(property);
      args.setValue(value);
      sendBase("setTableProperty", args);
    }

    public void recv_setTableProperty() throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException
    {
      setTableProperty_result result = new setTableProperty_result();
      receiveBase(result, "setTableProperty");
      if (result.ouch1 != null) {
        throw result.ouch1;
      }
      if (result.ouch2 != null) {
        throw result.ouch2;
      }
      if (result.ouch3 != null) {
        throw result.ouch3;
      }
      return;
    }

    public Set<Range> splitRangeByTablets(ByteBuffer login, String tableName, Range range, int maxSplits) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException
    {
      send_splitRangeByTablets(login, tableName, range, maxSplits);
      return recv_splitRangeByTablets();
    }

    public void send_splitRangeByTablets(ByteBuffer login, String tableName, Range range, int maxSplits) throws org.apache.thrift.TException
    {
      splitRangeByTablets_args args = new splitRangeByTablets_args();
      args.setLogin(login);
      args.setTableName(tableName);
      args.setRange(range);
      args.setMaxSplits(maxSplits);
      sendBase("splitRangeByTablets", args);
    }

    public Set<Range> recv_splitRangeByTablets() throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException
    {
      splitRangeByTablets_result result = new splitRangeByTablets_result();
      receiveBase(result, "splitRangeByTablets");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ouch1 != null) {
        throw result.ouch1;
      }
      if (result.ouch2 != null) {
        throw result.ouch2;
      }
      if (result.ouch3 != null) {
        throw result.ouch3;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "splitRangeByTablets failed: unknown result");
    }

    public boolean tableExists(ByteBuffer login, String tableName) throws org.apache.thrift.TException
    {
      send_tableExists(login, tableName);
      return recv_tableExists();
    }

    public void send_tableExists(ByteBuffer login, String tableName) throws org.apache.thrift.TException
    {
      tableExists_args args = new tableExists_args();
      args.setLogin(login);
      args.setTableName(tableName);
      sendBase("tableExists", args);
    }

    public boolean recv_tableExists() throws org.apache.thrift.TException
    {
      tableExists_result result = new tableExists_result();
      receiveBase(result, "tableExists");
      if (result.isSetSuccess()) {
        return result.success;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "tableExists failed: unknown result");
    }

    public Map<String,String> tableIdMap(ByteBuffer login) throws org.apache.thrift.TException
    {
      send_tableIdMap(login);
      return recv_tableIdMap();
    }

    public void send_tableIdMap(ByteBuffer login) throws org.apache.thrift.TException
    {
      tableIdMap_args args = new tableIdMap_args();
      args.setLogin(login);
      sendBase("tableIdMap", args);
    }

    public Map<String,String> recv_tableIdMap() throws org.apache.thrift.TException
    {
      tableIdMap_result result = new tableIdMap_result();
      receiveBase(result, "tableIdMap");
      if (result.isSetSuccess()) {
        return result.success;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "tableIdMap failed: unknown result");
    }

    public boolean testTableClassLoad(ByteBuffer login, String tableName, String className, String asTypeName) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException
    {
      send_testTableClassLoad(login, tableName, className, asTypeName);
      return recv_testTableClassLoad();
    }

    public void send_testTableClassLoad(ByteBuffer login, String tableName, String className, String asTypeName) throws org.apache.thrift.TException
    {
      testTableClassLoad_args args = new testTableClassLoad_args();
      args.setLogin(login);
      args.setTableName(tableName);
      args.setClassName(className);
      args.setAsTypeName(asTypeName);
      sendBase("testTableClassLoad", args);
    }

    public boolean recv_testTableClassLoad() throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException
    {
      testTableClassLoad_result result = new testTableClassLoad_result();
      receiveBase(result, "testTableClassLoad");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ouch1 != null) {
        throw result.ouch1;
      }
      if (result.ouch2 != null) {
        throw result.ouch2;
      }
      if (result.ouch3 != null) {
        throw result.ouch3;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "testTableClassLoad failed: unknown result");
    }

    public void pingTabletServer(ByteBuffer login, String tserver) throws AccumuloException, AccumuloSecurityException, org.apache.thrift.TException
    {
      send_pingTabletServer(login, tserver);
      recv_pingTabletServer();
    }

    public void send_pingTabletServer(ByteBuffer login, String tserver) throws org.apache.thrift.TException
    {
      pingTabletServer_args args = new pingTabletServer_args();
      args.setLogin(login);
      args.setTserver(tserver);
      sendBase("pingTabletServer", args);
    }

    public void recv_pingTabletServer() throws AccumuloException, AccumuloSecurityException, org.apache.thrift.TException
    {
      pingTabletServer_result result = new pingTabletServer_result();
      receiveBase(result, "pingTabletServer");
      if (result.ouch1 != null) {
        throw result.ouch1;
      }
      if (result.ouch2 != null) {
        throw result.ouch2;
      }
      return;
    }

    public List<ActiveScan> getActiveScans(ByteBuffer login, String tserver) throws AccumuloException, AccumuloSecurityException, org.apache.thrift.TException
    {
      send_getActiveScans(login, tserver);
      return recv_getActiveScans();
    }

    public void send_getActiveScans(ByteBuffer login, String tserver) throws org.apache.thrift.TException
    {
      getActiveScans_args args = new getActiveScans_args();
      args.setLogin(login);
      args.setTserver(tserver);
      sendBase("getActiveScans", args);
    }

    public List<ActiveScan> recv_getActiveScans() throws AccumuloException, AccumuloSecurityException, org.apache.thrift.TException
    {
      getActiveScans_result result = new getActiveScans_result();
      receiveBase(result, "getActiveScans");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ouch1 != null) {
        throw result.ouch1;
      }
      if (result.ouch2 != null) {
        throw result.ouch2;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getActiveScans failed: unknown result");
    }

    public List<ActiveCompaction> getActiveCompactions(ByteBuffer login, String tserver) throws AccumuloException, AccumuloSecurityException, org.apache.thrift.TException
    {
      send_getActiveCompactions(login, tserver);
      return recv_getActiveCompactions();
    }

    public void send_getActiveCompactions(ByteBuffer login, String tserver) throws org.apache.thrift.TException
    {
      getActiveCompactions_args args = new getActiveCompactions_args();
      args.setLogin(login);
      args.setTserver(tserver);
      sendBase("getActiveCompactions", args);
    }

    public List<ActiveCompaction> recv_getActiveCompactions() throws AccumuloException, AccumuloSecurityException, org.apache.thrift.TException
    {
      getActiveCompactions_result result = new getActiveCompactions_result();
      receiveBase(result, "getActiveCompactions");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ouch1 != null) {
        throw result.ouch1;
      }
      if (result.ouch2 != null) {
        throw result.ouch2;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getActiveCompactions failed: unknown result");
    }

    public Map<String,String> getSiteConfiguration(ByteBuffer login) throws AccumuloException, AccumuloSecurityException, org.apache.thrift.TException
    {
      send_getSiteConfiguration(login);
      return recv_getSiteConfiguration();
    }

    public void send_getSiteConfiguration(ByteBuffer login) throws org.apache.thrift.TException
    {
      getSiteConfiguration_args args = new getSiteConfiguration_args();
      args.setLogin(login);
      sendBase("getSiteConfiguration", args);
    }

    public Map<String,String> recv_getSiteConfiguration() throws AccumuloException, AccumuloSecurityException, org.apache.thrift.TException
    {
      getSiteConfiguration_result result = new getSiteConfiguration_result();
      receiveBase(result, "getSiteConfiguration");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ouch1 != null) {
        throw result.ouch1;
      }
      if (result.ouch2 != null) {
        throw result.ouch2;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getSiteConfiguration failed: unknown result");
    }

    public Map<String,String> getSystemConfiguration(ByteBuffer login) throws AccumuloException, AccumuloSecurityException, org.apache.thrift.TException
    {
      send_getSystemConfiguration(login);
      return recv_getSystemConfiguration();
    }

    public void send_getSystemConfiguration(ByteBuffer login) throws org.apache.thrift.TException
    {
      getSystemConfiguration_args args = new getSystemConfiguration_args();
      args.setLogin(login);
      sendBase("getSystemConfiguration", args);
    }

    public Map<String,String> recv_getSystemConfiguration() throws AccumuloException, AccumuloSecurityException, org.apache.thrift.TException
    {
      getSystemConfiguration_result result = new getSystemConfiguration_result();
      receiveBase(result, "getSystemConfiguration");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ouch1 != null) {
        throw result.ouch1;
      }
      if (result.ouch2 != null) {
        throw result.ouch2;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getSystemConfiguration failed: unknown result");
    }

    public List<String> getTabletServers(ByteBuffer login) throws org.apache.thrift.TException
    {
      send_getTabletServers(login);
      return recv_getTabletServers();
    }

    public void send_getTabletServers(ByteBuffer login) throws org.apache.thrift.TException
    {
      getTabletServers_args args = new getTabletServers_args();
      args.setLogin(login);
      sendBase("getTabletServers", args);
    }

    public List<String> recv_getTabletServers() throws org.apache.thrift.TException
    {
      getTabletServers_result result = new getTabletServers_result();
      receiveBase(result, "getTabletServers");
      if (result.isSetSuccess()) {
        return result.success;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getTabletServers failed: unknown result");
    }

    public void removeProperty(ByteBuffer login, String property) throws AccumuloException, AccumuloSecurityException, org.apache.thrift.TException
    {
      send_removeProperty(login, property);
      recv_removeProperty();
    }

    public void send_removeProperty(ByteBuffer login, String property) throws org.apache.thrift.TException
    {
      removeProperty_args args = new removeProperty_args();
      args.setLogin(login);
      args.setProperty(property);
      sendBase("removeProperty", args);
    }

    public void recv_removeProperty() throws AccumuloException, AccumuloSecurityException, org.apache.thrift.TException
    {
      removeProperty_result result = new removeProperty_result();
      receiveBase(result, "removeProperty");
      if (result.ouch1 != null) {
        throw result.ouch1;
      }
      if (result.ouch2 != null) {
        throw result.ouch2;
      }
      return;
    }

    public void setProperty(ByteBuffer login, String property, String value) throws AccumuloException, AccumuloSecurityException, org.apache.thrift.TException
    {
      send_setProperty(login, property, value);
      recv_setProperty();
    }

    public void send_setProperty(ByteBuffer login, String property, String value) throws org.apache.thrift.TException
    {
      setProperty_args args = new setProperty_args();
      args.setLogin(login);
      args.setProperty(property);
      args.setValue(value);
      sendBase("setProperty", args);
    }

    public void recv_setProperty() throws AccumuloException, AccumuloSecurityException, org.apache.thrift.TException
    {
      setProperty_result result = new setProperty_result();
      receiveBase(result, "setProperty");
      if (result.ouch1 != null) {
        throw result.ouch1;
      }
      if (result.ouch2 != null) {
        throw result.ouch2;
      }
      return;
    }

    public boolean testClassLoad(ByteBuffer login, String className, String asTypeName) throws AccumuloException, AccumuloSecurityException, org.apache.thrift.TException
    {
      send_testClassLoad(login, className, asTypeName);
      return recv_testClassLoad();
    }

    public void send_testClassLoad(ByteBuffer login, String className, String asTypeName) throws org.apache.thrift.TException
    {
      testClassLoad_args args = new testClassLoad_args();
      args.setLogin(login);
      args.setClassName(className);
      args.setAsTypeName(asTypeName);
      sendBase("testClassLoad", args);
    }

    public boolean recv_testClassLoad() throws AccumuloException, AccumuloSecurityException, org.apache.thrift.TException
    {
      testClassLoad_result result = new testClassLoad_result();
      receiveBase(result, "testClassLoad");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ouch1 != null) {
        throw result.ouch1;
      }
      if (result.ouch2 != null) {
        throw result.ouch2;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "testClassLoad failed: unknown result");
    }

    public boolean authenticateUser(ByteBuffer login, String user, Map<String,String> properties) throws AccumuloException, AccumuloSecurityException, org.apache.thrift.TException
    {
      send_authenticateUser(login, user, properties);
      return recv_authenticateUser();
    }

    public void send_authenticateUser(ByteBuffer login, String user, Map<String,String> properties) throws org.apache.thrift.TException
    {
      authenticateUser_args args = new authenticateUser_args();
      args.setLogin(login);
      args.setUser(user);
      args.setProperties(properties);
      sendBase("authenticateUser", args);
    }

    public boolean recv_authenticateUser() throws AccumuloException, AccumuloSecurityException, org.apache.thrift.TException
    {
      authenticateUser_result result = new authenticateUser_result();
      receiveBase(result, "authenticateUser");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ouch1 != null) {
        throw result.ouch1;
      }
      if (result.ouch2 != null) {
        throw result.ouch2;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "authenticateUser failed: unknown result");
    }

    public void changeUserAuthorizations(ByteBuffer login, String user, Set<ByteBuffer> authorizations) throws AccumuloException, AccumuloSecurityException, org.apache.thrift.TException
    {
      send_changeUserAuthorizations(login, user, authorizations);
      recv_changeUserAuthorizations();
    }

    public void send_changeUserAuthorizations(ByteBuffer login, String user, Set<ByteBuffer> authorizations) throws org.apache.thrift.TException
    {
      changeUserAuthorizations_args args = new changeUserAuthorizations_args();
      args.setLogin(login);
      args.setUser(user);
      args.setAuthorizations(authorizations);
      sendBase("changeUserAuthorizations", args);
    }

    public void recv_changeUserAuthorizations() throws AccumuloException, AccumuloSecurityException, org.apache.thrift.TException
    {
      changeUserAuthorizations_result result = new changeUserAuthorizations_result();
      receiveBase(result, "changeUserAuthorizations");
      if (result.ouch1 != null) {
        throw result.ouch1;
      }
      if (result.ouch2 != null) {
        throw result.ouch2;
      }
      return;
    }

    public void changeLocalUserPassword(ByteBuffer login, String user, ByteBuffer password) throws AccumuloException, AccumuloSecurityException, org.apache.thrift.TException
    {
      send_changeLocalUserPassword(login, user, password);
      recv_changeLocalUserPassword();
    }

    public void send_changeLocalUserPassword(ByteBuffer login, String user, ByteBuffer password) throws org.apache.thrift.TException
    {
      changeLocalUserPassword_args args = new changeLocalUserPassword_args();
      args.setLogin(login);
      args.setUser(user);
      args.setPassword(password);
      sendBase("changeLocalUserPassword", args);
    }

    public void recv_changeLocalUserPassword() throws AccumuloException, AccumuloSecurityException, org.apache.thrift.TException
    {
      changeLocalUserPassword_result result = new changeLocalUserPassword_result();
      receiveBase(result, "changeLocalUserPassword");
      if (result.ouch1 != null) {
        throw result.ouch1;
      }
      if (result.ouch2 != null) {
        throw result.ouch2;
      }
      return;
    }

    public void createLocalUser(ByteBuffer login, String user, ByteBuffer password) throws AccumuloException, AccumuloSecurityException, org.apache.thrift.TException
    {
      send_createLocalUser(login, user, password);
      recv_createLocalUser();
    }

    public void send_createLocalUser(ByteBuffer login, String user, ByteBuffer password) throws org.apache.thrift.TException
    {
      createLocalUser_args args = new createLocalUser_args();
      args.setLogin(login);
      args.setUser(user);
      args.setPassword(password);
      sendBase("createLocalUser", args);
    }

    public void recv_createLocalUser() throws AccumuloException, AccumuloSecurityException, org.apache.thrift.TException
    {
      createLocalUser_result result = new createLocalUser_result();
      receiveBase(result, "createLocalUser");
      if (result.ouch1 != null) {
        throw result.ouch1;
      }
      if (result.ouch2 != null) {
        throw result.ouch2;
      }
      return;
    }

    public void dropLocalUser(ByteBuffer login, String user) throws AccumuloException, AccumuloSecurityException, org.apache.thrift.TException
    {
      send_dropLocalUser(login, user);
      recv_dropLocalUser();
    }

    public void send_dropLocalUser(ByteBuffer login, String user) throws org.apache.thrift.TException
    {
      dropLocalUser_args args = new dropLocalUser_args();
      args.setLogin(login);
      args.setUser(user);
      sendBase("dropLocalUser", args);
    }

    public void recv_dropLocalUser() throws AccumuloException, AccumuloSecurityException, org.apache.thrift.TException
    {
      dropLocalUser_result result = new dropLocalUser_result();
      receiveBase(result, "dropLocalUser");
      if (result.ouch1 != null) {
        throw result.ouch1;
      }
      if (result.ouch2 != null) {
        throw result.ouch2;
      }
      return;
    }

    public List<ByteBuffer> getUserAuthorizations(ByteBuffer login, String user) throws AccumuloException, AccumuloSecurityException, org.apache.thrift.TException
    {
      send_getUserAuthorizations(login, user);
      return recv_getUserAuthorizations();
    }

    public void send_getUserAuthorizations(ByteBuffer login, String user) throws org.apache.thrift.TException
    {
      getUserAuthorizations_args args = new getUserAuthorizations_args();
      args.setLogin(login);
      args.setUser(user);
      sendBase("getUserAuthorizations", args);
    }

    public List<ByteBuffer> recv_getUserAuthorizations() throws AccumuloException, AccumuloSecurityException, org.apache.thrift.TException
    {
      getUserAuthorizations_result result = new getUserAuthorizations_result();
      receiveBase(result, "getUserAuthorizations");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ouch1 != null) {
        throw result.ouch1;
      }
      if (result.ouch2 != null) {
        throw result.ouch2;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getUserAuthorizations failed: unknown result");
    }

    public void grantSystemPermission(ByteBuffer login, String user, SystemPermission perm) throws AccumuloException, AccumuloSecurityException, org.apache.thrift.TException
    {
      send_grantSystemPermission(login, user, perm);
      recv_grantSystemPermission();
    }

    public void send_grantSystemPermission(ByteBuffer login, String user, SystemPermission perm) throws org.apache.thrift.TException
    {
      grantSystemPermission_args args = new grantSystemPermission_args();
      args.setLogin(login);
      args.setUser(user);
      args.setPerm(perm);
      sendBase("grantSystemPermission", args);
    }

    public void recv_grantSystemPermission() throws AccumuloException, AccumuloSecurityException, org.apache.thrift.TException
    {
      grantSystemPermission_result result = new grantSystemPermission_result();
      receiveBase(result, "grantSystemPermission");
      if (result.ouch1 != null) {
        throw result.ouch1;
      }
      if (result.ouch2 != null) {
        throw result.ouch2;
      }
      return;
    }

    public void grantTablePermission(ByteBuffer login, String user, String table, TablePermission perm) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException
    {
      send_grantTablePermission(login, user, table, perm);
      recv_grantTablePermission();
    }

    public void send_grantTablePermission(ByteBuffer login, String user, String table, TablePermission perm) throws org.apache.thrift.TException
    {
      grantTablePermission_args args = new grantTablePermission_args();
      args.setLogin(login);
      args.setUser(user);
      args.setTable(table);
      args.setPerm(perm);
      sendBase("grantTablePermission", args);
    }

    public void recv_grantTablePermission() throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException
    {
      grantTablePermission_result result = new grantTablePermission_result();
      receiveBase(result, "grantTablePermission");
      if (result.ouch1 != null) {
        throw result.ouch1;
      }
      if (result.ouch2 != null) {
        throw result.ouch2;
      }
      if (result.ouch3 != null) {
        throw result.ouch3;
      }
      return;
    }

    public boolean hasSystemPermission(ByteBuffer login, String user, SystemPermission perm) throws AccumuloException, AccumuloSecurityException, org.apache.thrift.TException
    {
      send_hasSystemPermission(login, user, perm);
      return recv_hasSystemPermission();
    }

    public void send_hasSystemPermission(ByteBuffer login, String user, SystemPermission perm) throws org.apache.thrift.TException
    {
      hasSystemPermission_args args = new hasSystemPermission_args();
      args.setLogin(login);
      args.setUser(user);
      args.setPerm(perm);
      sendBase("hasSystemPermission", args);
    }

    public boolean recv_hasSystemPermission() throws AccumuloException, AccumuloSecurityException, org.apache.thrift.TException
    {
      hasSystemPermission_result result = new hasSystemPermission_result();
      receiveBase(result, "hasSystemPermission");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ouch1 != null) {
        throw result.ouch1;
      }
      if (result.ouch2 != null) {
        throw result.ouch2;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "hasSystemPermission failed: unknown result");
    }

    public boolean hasTablePermission(ByteBuffer login, String user, String table, TablePermission perm) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException
    {
      send_hasTablePermission(login, user, table, perm);
      return recv_hasTablePermission();
    }

    public void send_hasTablePermission(ByteBuffer login, String user, String table, TablePermission perm) throws org.apache.thrift.TException
    {
      hasTablePermission_args args = new hasTablePermission_args();
      args.setLogin(login);
      args.setUser(user);
      args.setTable(table);
      args.setPerm(perm);
      sendBase("hasTablePermission", args);
    }

    public boolean recv_hasTablePermission() throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException
    {
      hasTablePermission_result result = new hasTablePermission_result();
      receiveBase(result, "hasTablePermission");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ouch1 != null) {
        throw result.ouch1;
      }
      if (result.ouch2 != null) {
        throw result.ouch2;
      }
      if (result.ouch3 != null) {
        throw result.ouch3;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "hasTablePermission failed: unknown result");
    }

    public Set<String> listLocalUsers(ByteBuffer login) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException
    {
      send_listLocalUsers(login);
      return recv_listLocalUsers();
    }

    public void send_listLocalUsers(ByteBuffer login) throws org.apache.thrift.TException
    {
      listLocalUsers_args args = new listLocalUsers_args();
      args.setLogin(login);
      sendBase("listLocalUsers", args);
    }

    public Set<String> recv_listLocalUsers() throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException
    {
      listLocalUsers_result result = new listLocalUsers_result();
      receiveBase(result, "listLocalUsers");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ouch1 != null) {
        throw result.ouch1;
      }
      if (result.ouch2 != null) {
        throw result.ouch2;
      }
      if (result.ouch3 != null) {
        throw result.ouch3;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "listLocalUsers failed: unknown result");
    }

    public void revokeSystemPermission(ByteBuffer login, String user, SystemPermission perm) throws AccumuloException, AccumuloSecurityException, org.apache.thrift.TException
    {
      send_revokeSystemPermission(login, user, perm);
      recv_revokeSystemPermission();
    }

    public void send_revokeSystemPermission(ByteBuffer login, String user, SystemPermission perm) throws org.apache.thrift.TException
    {
      revokeSystemPermission_args args = new revokeSystemPermission_args();
      args.setLogin(login);
      args.setUser(user);
      args.setPerm(perm);
      sendBase("revokeSystemPermission", args);
    }

    public void recv_revokeSystemPermission() throws AccumuloException, AccumuloSecurityException, org.apache.thrift.TException
    {
      revokeSystemPermission_result result = new revokeSystemPermission_result();
      receiveBase(result, "revokeSystemPermission");
      if (result.ouch1 != null) {
        throw result.ouch1;
      }
      if (result.ouch2 != null) {
        throw result.ouch2;
      }
      return;
    }

    public void revokeTablePermission(ByteBuffer login, String user, String table, TablePermission perm) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException
    {
      send_revokeTablePermission(login, user, table, perm);
      recv_revokeTablePermission();
    }

    public void send_revokeTablePermission(ByteBuffer login, String user, String table, TablePermission perm) throws org.apache.thrift.TException
    {
      revokeTablePermission_args args = new revokeTablePermission_args();
      args.setLogin(login);
      args.setUser(user);
      args.setTable(table);
      args.setPerm(perm);
      sendBase("revokeTablePermission", args);
    }

    public void recv_revokeTablePermission() throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException
    {
      revokeTablePermission_result result = new revokeTablePermission_result();
      receiveBase(result, "revokeTablePermission");
      if (result.ouch1 != null) {
        throw result.ouch1;
      }
      if (result.ouch2 != null) {
        throw result.ouch2;
      }
      if (result.ouch3 != null) {
        throw result.ouch3;
      }
      return;
    }

    public void grantNamespacePermission(ByteBuffer login, String user, String namespaceName, NamespacePermission perm) throws AccumuloException, AccumuloSecurityException, org.apache.thrift.TException
    {
      send_grantNamespacePermission(login, user, namespaceName, perm);
      recv_grantNamespacePermission();
    }

    public void send_grantNamespacePermission(ByteBuffer login, String user, String namespaceName, NamespacePermission perm) throws org.apache.thrift.TException
    {
      grantNamespacePermission_args args = new grantNamespacePermission_args();
      args.setLogin(login);
      args.setUser(user);
      args.setNamespaceName(namespaceName);
      args.setPerm(perm);
      sendBase("grantNamespacePermission", args);
    }

    public void recv_grantNamespacePermission() throws AccumuloException, AccumuloSecurityException, org.apache.thrift.TException
    {
      grantNamespacePermission_result result = new grantNamespacePermission_result();
      receiveBase(result, "grantNamespacePermission");
      if (result.ouch1 != null) {
        throw result.ouch1;
      }
      if (result.ouch2 != null) {
        throw result.ouch2;
      }
      return;
    }

    public boolean hasNamespacePermission(ByteBuffer login, String user, String namespaceName, NamespacePermission perm) throws AccumuloException, AccumuloSecurityException, org.apache.thrift.TException
    {
      send_hasNamespacePermission(login, user, namespaceName, perm);
      return recv_hasNamespacePermission();
    }

    public void send_hasNamespacePermission(ByteBuffer login, String user, String namespaceName, NamespacePermission perm) throws org.apache.thrift.TException
    {
      hasNamespacePermission_args args = new hasNamespacePermission_args();
      args.setLogin(login);
      args.setUser(user);
      args.setNamespaceName(namespaceName);
      args.setPerm(perm);
      sendBase("hasNamespacePermission", args);
    }

    public boolean recv_hasNamespacePermission() throws AccumuloException, AccumuloSecurityException, org.apache.thrift.TException
    {
      hasNamespacePermission_result result = new hasNamespacePermission_result();
      receiveBase(result, "hasNamespacePermission");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ouch1 != null) {
        throw result.ouch1;
      }
      if (result.ouch2 != null) {
        throw result.ouch2;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "hasNamespacePermission failed: unknown result");
    }

    public void revokeNamespacePermission(ByteBuffer login, String user, String namespaceName, NamespacePermission perm) throws AccumuloException, AccumuloSecurityException, org.apache.thrift.TException
    {
      send_revokeNamespacePermission(login, user, namespaceName, perm);
      recv_revokeNamespacePermission();
    }

    public void send_revokeNamespacePermission(ByteBuffer login, String user, String namespaceName, NamespacePermission perm) throws org.apache.thrift.TException
    {
      revokeNamespacePermission_args args = new revokeNamespacePermission_args();
      args.setLogin(login);
      args.setUser(user);
      args.setNamespaceName(namespaceName);
      args.setPerm(perm);
      sendBase("revokeNamespacePermission", args);
    }

    public void recv_revokeNamespacePermission() throws AccumuloException, AccumuloSecurityException, org.apache.thrift.TException
    {
      revokeNamespacePermission_result result = new revokeNamespacePermission_result();
      receiveBase(result, "revokeNamespacePermission");
      if (result.ouch1 != null) {
        throw result.ouch1;
      }
      if (result.ouch2 != null) {
        throw result.ouch2;
      }
      return;
    }

    public String createBatchScanner(ByteBuffer login, String tableName, BatchScanOptions options) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException
    {
      send_createBatchScanner(login, tableName, options);
      return recv_createBatchScanner();
    }

    public void send_createBatchScanner(ByteBuffer login, String tableName, BatchScanOptions options) throws org.apache.thrift.TException
    {
      createBatchScanner_args args = new createBatchScanner_args();
      args.setLogin(login);
      args.setTableName(tableName);
      args.setOptions(options);
      sendBase("createBatchScanner", args);
    }

    public String recv_createBatchScanner() throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException
    {
      createBatchScanner_result result = new createBatchScanner_result();
      receiveBase(result, "createBatchScanner");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ouch1 != null) {
        throw result.ouch1;
      }
      if (result.ouch2 != null) {
        throw result.ouch2;
      }
      if (result.ouch3 != null) {
        throw result.ouch3;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "createBatchScanner failed: unknown result");
    }

    public String createScanner(ByteBuffer login, String tableName, ScanOptions options) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException
    {
      send_createScanner(login, tableName, options);
      return recv_createScanner();
    }

    public void send_createScanner(ByteBuffer login, String tableName, ScanOptions options) throws org.apache.thrift.TException
    {
      createScanner_args args = new createScanner_args();
      args.setLogin(login);
      args.setTableName(tableName);
      args.setOptions(options);
      sendBase("createScanner", args);
    }

    public String recv_createScanner() throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException
    {
      createScanner_result result = new createScanner_result();
      receiveBase(result, "createScanner");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ouch1 != null) {
        throw result.ouch1;
      }
      if (result.ouch2 != null) {
        throw result.ouch2;
      }
      if (result.ouch3 != null) {
        throw result.ouch3;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "createScanner failed: unknown result");
    }

    public boolean hasNext(String scanner) throws UnknownScanner, org.apache.thrift.TException
    {
      send_hasNext(scanner);
      return recv_hasNext();
    }

    public void send_hasNext(String scanner) throws org.apache.thrift.TException
    {
      hasNext_args args = new hasNext_args();
      args.setScanner(scanner);
      sendBase("hasNext", args);
    }

    public boolean recv_hasNext() throws UnknownScanner, org.apache.thrift.TException
    {
      hasNext_result result = new hasNext_result();
      receiveBase(result, "hasNext");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ouch1 != null) {
        throw result.ouch1;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "hasNext failed: unknown result");
    }

    public KeyValueAndPeek nextEntry(String scanner) throws NoMoreEntriesException, UnknownScanner, AccumuloSecurityException, org.apache.thrift.TException
    {
      send_nextEntry(scanner);
      return recv_nextEntry();
    }

    public void send_nextEntry(String scanner) throws org.apache.thrift.TException
    {
      nextEntry_args args = new nextEntry_args();
      args.setScanner(scanner);
      sendBase("nextEntry", args);
    }

    public KeyValueAndPeek recv_nextEntry() throws NoMoreEntriesException, UnknownScanner, AccumuloSecurityException, org.apache.thrift.TException
    {
      nextEntry_result result = new nextEntry_result();
      receiveBase(result, "nextEntry");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ouch1 != null) {
        throw result.ouch1;
      }
      if (result.ouch2 != null) {
        throw result.ouch2;
      }
      if (result.ouch3 != null) {
        throw result.ouch3;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "nextEntry failed: unknown result");
    }

    public ScanResult nextK(String scanner, int k) throws NoMoreEntriesException, UnknownScanner, AccumuloSecurityException, org.apache.thrift.TException
    {
      send_nextK(scanner, k);
      return recv_nextK();
    }

    public void send_nextK(String scanner, int k) throws org.apache.thrift.TException
    {
      nextK_args args = new nextK_args();
      args.setScanner(scanner);
      args.setK(k);
      sendBase("nextK", args);
    }

    public ScanResult recv_nextK() throws NoMoreEntriesException, UnknownScanner, AccumuloSecurityException, org.apache.thrift.TException
    {
      nextK_result result = new nextK_result();
      receiveBase(result, "nextK");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ouch1 != null) {
        throw result.ouch1;
      }
      if (result.ouch2 != null) {
        throw result.ouch2;
      }
      if (result.ouch3 != null) {
        throw result.ouch3;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "nextK failed: unknown result");
    }

    public void closeScanner(String scanner) throws UnknownScanner, org.apache.thrift.TException
    {
      send_closeScanner(scanner);
      recv_closeScanner();
    }

    public void send_closeScanner(String scanner) throws org.apache.thrift.TException
    {
      closeScanner_args args = new closeScanner_args();
      args.setScanner(scanner);
      sendBase("closeScanner", args);
    }

    public void recv_closeScanner() throws UnknownScanner, org.apache.thrift.TException
    {
      closeScanner_result result = new closeScanner_result();
      receiveBase(result, "closeScanner");
      if (result.ouch1 != null) {
        throw result.ouch1;
      }
      return;
    }

    public void updateAndFlush(ByteBuffer login, String tableName, Map<ByteBuffer,List<ColumnUpdate>> cells) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, MutationsRejectedException, org.apache.thrift.TException
    {
      send_updateAndFlush(login, tableName, cells);
      recv_updateAndFlush();
    }

    public void send_updateAndFlush(ByteBuffer login, String tableName, Map<ByteBuffer,List<ColumnUpdate>> cells) throws org.apache.thrift.TException
    {
      updateAndFlush_args args = new updateAndFlush_args();
      args.setLogin(login);
      args.setTableName(tableName);
      args.setCells(cells);
      sendBase("updateAndFlush", args);
    }

    public void recv_updateAndFlush() throws AccumuloException, AccumuloSecurityException, TableNotFoundException, MutationsRejectedException, org.apache.thrift.TException
    {
      updateAndFlush_result result = new updateAndFlush_result();
      receiveBase(result, "updateAndFlush");
      if (result.outch1 != null) {
        throw result.outch1;
      }
      if (result.ouch2 != null) {
        throw result.ouch2;
      }
      if (result.ouch3 != null) {
        throw result.ouch3;
      }
      if (result.ouch4 != null) {
        throw result.ouch4;
      }
      return;
    }

    public String createWriter(ByteBuffer login, String tableName, WriterOptions opts) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException
    {
      send_createWriter(login, tableName, opts);
      return recv_createWriter();
    }

    public void send_createWriter(ByteBuffer login, String tableName, WriterOptions opts) throws org.apache.thrift.TException
    {
      createWriter_args args = new createWriter_args();
      args.setLogin(login);
      args.setTableName(tableName);
      args.setOpts(opts);
      sendBase("createWriter", args);
    }

    public String recv_createWriter() throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException
    {
      createWriter_result result = new createWriter_result();
      receiveBase(result, "createWriter");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.outch1 != null) {
        throw result.outch1;
      }
      if (result.ouch2 != null) {
        throw result.ouch2;
      }
      if (result.ouch3 != null) {
        throw result.ouch3;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "createWriter failed: unknown result");
    }

    public void update(String writer, Map<ByteBuffer,List<ColumnUpdate>> cells) throws org.apache.thrift.TException
    {
      send_update(writer, cells);
    }

    public void send_update(String writer, Map<ByteBuffer,List<ColumnUpdate>> cells) throws org.apache.thrift.TException
    {
      update_args args = new update_args();
      args.setWriter(writer);
      args.setCells(cells);
      sendBaseOneway("update", args);
    }

    public void flush(String writer) throws UnknownWriter, MutationsRejectedException, org.apache.thrift.TException
    {
      send_flush(writer);
      recv_flush();
    }

    public void send_flush(String writer) throws org.apache.thrift.TException
    {
      flush_args args = new flush_args();
      args.setWriter(writer);
      sendBase("flush", args);
    }

    public void recv_flush() throws UnknownWriter, MutationsRejectedException, org.apache.thrift.TException
    {
      flush_result result = new flush_result();
      receiveBase(result, "flush");
      if (result.ouch1 != null) {
        throw result.ouch1;
      }
      if (result.ouch2 != null) {
        throw result.ouch2;
      }
      return;
    }

    public void closeWriter(String writer) throws UnknownWriter, MutationsRejectedException, org.apache.thrift.TException
    {
      send_closeWriter(writer);
      recv_closeWriter();
    }

    public void send_closeWriter(String writer) throws org.apache.thrift.TException
    {
      closeWriter_args args = new closeWriter_args();
      args.setWriter(writer);
      sendBase("closeWriter", args);
    }

    public void recv_closeWriter() throws UnknownWriter, MutationsRejectedException, org.apache.thrift.TException
    {
      closeWriter_result result = new closeWriter_result();
      receiveBase(result, "closeWriter");
      if (result.ouch1 != null) {
        throw result.ouch1;
      }
      if (result.ouch2 != null) {
        throw result.ouch2;
      }
      return;
    }

    public ConditionalStatus updateRowConditionally(ByteBuffer login, String tableName, ByteBuffer row, ConditionalUpdates updates) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException
    {
      send_updateRowConditionally(login, tableName, row, updates);
      return recv_updateRowConditionally();
    }

    public void send_updateRowConditionally(ByteBuffer login, String tableName, ByteBuffer row, ConditionalUpdates updates) throws org.apache.thrift.TException
    {
      updateRowConditionally_args args = new updateRowConditionally_args();
      args.setLogin(login);
      args.setTableName(tableName);
      args.setRow(row);
      args.setUpdates(updates);
      sendBase("updateRowConditionally", args);
    }

    public ConditionalStatus recv_updateRowConditionally() throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException
    {
      updateRowConditionally_result result = new updateRowConditionally_result();
      receiveBase(result, "updateRowConditionally");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ouch1 != null) {
        throw result.ouch1;
      }
      if (result.ouch2 != null) {
        throw result.ouch2;
      }
      if (result.ouch3 != null) {
        throw result.ouch3;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "updateRowConditionally failed: unknown result");
    }

    public String createConditionalWriter(ByteBuffer login, String tableName, ConditionalWriterOptions options) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException
    {
      send_createConditionalWriter(login, tableName, options);
      return recv_createConditionalWriter();
    }

    public void send_createConditionalWriter(ByteBuffer login, String tableName, ConditionalWriterOptions options) throws org.apache.thrift.TException
    {
      createConditionalWriter_args args = new createConditionalWriter_args();
      args.setLogin(login);
      args.setTableName(tableName);
      args.setOptions(options);
      sendBase("createConditionalWriter", args);
    }

    public String recv_createConditionalWriter() throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException
    {
      createConditionalWriter_result result = new createConditionalWriter_result();
      receiveBase(result, "createConditionalWriter");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ouch1 != null) {
        throw result.ouch1;
      }
      if (result.ouch2 != null) {
        throw result.ouch2;
      }
      if (result.ouch3 != null) {
        throw result.ouch3;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "createConditionalWriter failed: unknown result");
    }

    public Map<ByteBuffer,ConditionalStatus> updateRowsConditionally(String conditionalWriter, Map<ByteBuffer,ConditionalUpdates> updates) throws UnknownWriter, AccumuloException, AccumuloSecurityException, org.apache.thrift.TException
    {
      send_updateRowsConditionally(conditionalWriter, updates);
      return recv_updateRowsConditionally();
    }

    public void send_updateRowsConditionally(String conditionalWriter, Map<ByteBuffer,ConditionalUpdates> updates) throws org.apache.thrift.TException
    {
      updateRowsConditionally_args args = new updateRowsConditionally_args();
      args.setConditionalWriter(conditionalWriter);
      args.setUpdates(updates);
      sendBase("updateRowsConditionally", args);
    }

    public Map<ByteBuffer,ConditionalStatus> recv_updateRowsConditionally() throws UnknownWriter, AccumuloException, AccumuloSecurityException, org.apache.thrift.TException
    {
      updateRowsConditionally_result result = new updateRowsConditionally_result();
      receiveBase(result, "updateRowsConditionally");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ouch1 != null) {
        throw result.ouch1;
      }
      if (result.ouch2 != null) {
        throw result.ouch2;
      }
      if (result.ouch3 != null) {
        throw result.ouch3;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "updateRowsConditionally failed: unknown result");
    }

    public void closeConditionalWriter(String conditionalWriter) throws org.apache.thrift.TException
    {
      send_closeConditionalWriter(conditionalWriter);
      recv_closeConditionalWriter();
    }

    public void send_closeConditionalWriter(String conditionalWriter) throws org.apache.thrift.TException
    {
      closeConditionalWriter_args args = new closeConditionalWriter_args();
      args.setConditionalWriter(conditionalWriter);
      sendBase("closeConditionalWriter", args);
    }

    public void recv_closeConditionalWriter() throws org.apache.thrift.TException
    {
      closeConditionalWriter_result result = new closeConditionalWriter_result();
      receiveBase(result, "closeConditionalWriter");
      return;
    }

    public Range getRowRange(ByteBuffer row) throws org.apache.thrift.TException
    {
      send_getRowRange(row);
      return recv_getRowRange();
    }

    public void send_getRowRange(ByteBuffer row) throws org.apache.thrift.TException
    {
      getRowRange_args args = new getRowRange_args();
      args.setRow(row);
      sendBase("getRowRange", args);
    }

    public Range recv_getRowRange() throws org.apache.thrift.TException
    {
      getRowRange_result result = new getRowRange_result();
      receiveBase(result, "getRowRange");
      if (result.isSetSuccess()) {
        return result.success;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getRowRange failed: unknown result");
    }

    public Key getFollowing(Key key, PartialKey part) throws org.apache.thrift.TException
    {
      send_getFollowing(key, part);
      return recv_getFollowing();
    }

    public void send_getFollowing(Key key, PartialKey part) throws org.apache.thrift.TException
    {
      getFollowing_args args = new getFollowing_args();
      args.setKey(key);
      args.setPart(part);
      sendBase("getFollowing", args);
    }

    public Key recv_getFollowing() throws org.apache.thrift.TException
    {
      getFollowing_result result = new getFollowing_result();
      receiveBase(result, "getFollowing");
      if (result.isSetSuccess()) {
        return result.success;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getFollowing failed: unknown result");
    }

    public String systemNamespace() throws org.apache.thrift.TException
    {
      send_systemNamespace();
      return recv_systemNamespace();
    }

    public void send_systemNamespace() throws org.apache.thrift.TException
    {
      systemNamespace_args args = new systemNamespace_args();
      sendBase("systemNamespace", args);
    }

    public String recv_systemNamespace() throws org.apache.thrift.TException
    {
      systemNamespace_result result = new systemNamespace_result();
      receiveBase(result, "systemNamespace");
      if (result.isSetSuccess()) {
        return result.success;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "systemNamespace failed: unknown result");
    }

    public String defaultNamespace() throws org.apache.thrift.TException
    {
      send_defaultNamespace();
      return recv_defaultNamespace();
    }

    public void send_defaultNamespace() throws org.apache.thrift.TException
    {
      defaultNamespace_args args = new defaultNamespace_args();
      sendBase("defaultNamespace", args);
    }

    public String recv_defaultNamespace() throws org.apache.thrift.TException
    {
      defaultNamespace_result result = new defaultNamespace_result();
      receiveBase(result, "defaultNamespace");
      if (result.isSetSuccess()) {
        return result.success;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "defaultNamespace failed: unknown result");
    }

    public List<String> listNamespaces(ByteBuffer login) throws AccumuloException, AccumuloSecurityException, org.apache.thrift.TException
    {
      send_listNamespaces(login);
      return recv_listNamespaces();
    }

    public void send_listNamespaces(ByteBuffer login) throws org.apache.thrift.TException
    {
      listNamespaces_args args = new listNamespaces_args();
      args.setLogin(login);
      sendBase("listNamespaces", args);
    }

    public List<String> recv_listNamespaces() throws AccumuloException, AccumuloSecurityException, org.apache.thrift.TException
    {
      listNamespaces_result result = new listNamespaces_result();
      receiveBase(result, "listNamespaces");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ouch1 != null) {
        throw result.ouch1;
      }
      if (result.ouch2 != null) {
        throw result.ouch2;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "listNamespaces failed: unknown result");
    }

    public boolean namespaceExists(ByteBuffer login, String namespaceName) throws AccumuloException, AccumuloSecurityException, org.apache.thrift.TException
    {
      send_namespaceExists(login, namespaceName);
      return recv_namespaceExists();
    }

    public void send_namespaceExists(ByteBuffer login, String namespaceName) throws org.apache.thrift.TException
    {
      namespaceExists_args args = new namespaceExists_args();
      args.setLogin(login);
      args.setNamespaceName(namespaceName);
      sendBase("namespaceExists", args);
    }

    public boolean recv_namespaceExists() throws AccumuloException, AccumuloSecurityException, org.apache.thrift.TException
    {
      namespaceExists_result result = new namespaceExists_result();
      receiveBase(result, "namespaceExists");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ouch1 != null) {
        throw result.ouch1;
      }
      if (result.ouch2 != null) {
        throw result.ouch2;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "namespaceExists failed: unknown result");
    }

    public void createNamespace(ByteBuffer login, String namespaceName) throws AccumuloException, AccumuloSecurityException, NamespaceExistsException, org.apache.thrift.TException
    {
      send_createNamespace(login, namespaceName);
      recv_createNamespace();
    }

    public void send_createNamespace(ByteBuffer login, String namespaceName) throws org.apache.thrift.TException
    {
      createNamespace_args args = new createNamespace_args();
      args.setLogin(login);
      args.setNamespaceName(namespaceName);
      sendBase("createNamespace", args);
    }

    public void recv_createNamespace() throws AccumuloException, AccumuloSecurityException, NamespaceExistsException, org.apache.thrift.TException
    {
      createNamespace_result result = new createNamespace_result();
      receiveBase(result, "createNamespace");
      if (result.ouch1 != null) {
        throw result.ouch1;
      }
      if (result.ouch2 != null) {
        throw result.ouch2;
      }
      if (result.ouch3 != null) {
        throw result.ouch3;
      }
      return;
    }

    public void deleteNamespace(ByteBuffer login, String namespaceName) throws AccumuloException, AccumuloSecurityException, NamespaceNotFoundException, NamespaceNotEmptyException, org.apache.thrift.TException
    {
      send_deleteNamespace(login, namespaceName);
      recv_deleteNamespace();
    }

    public void send_deleteNamespace(ByteBuffer login, String namespaceName) throws org.apache.thrift.TException
    {
      deleteNamespace_args args = new deleteNamespace_args();
      args.setLogin(login);
      args.setNamespaceName(namespaceName);
      sendBase("deleteNamespace", args);
    }

    public void recv_deleteNamespace() throws AccumuloException, AccumuloSecurityException, NamespaceNotFoundException, NamespaceNotEmptyException, org.apache.thrift.TException
    {
      deleteNamespace_result result = new deleteNamespace_result();
      receiveBase(result, "deleteNamespace");
      if (result.ouch1 != null) {
        throw result.ouch1;
      }
      if (result.ouch2 != null) {
        throw result.ouch2;
      }
      if (result.ouch3 != null) {
        throw result.ouch3;
      }
      if (result.ouch4 != null) {
        throw result.ouch4;
      }
      return;
    }

    public void renameNamespace(ByteBuffer login, String oldNamespaceName, String newNamespaceName) throws AccumuloException, AccumuloSecurityException, NamespaceNotFoundException, NamespaceExistsException, org.apache.thrift.TException
    {
      send_renameNamespace(login, oldNamespaceName, newNamespaceName);
      recv_renameNamespace();
    }

    public void send_renameNamespace(ByteBuffer login, String oldNamespaceName, String newNamespaceName) throws org.apache.thrift.TException
    {
      renameNamespace_args args = new renameNamespace_args();
      args.setLogin(login);
      args.setOldNamespaceName(oldNamespaceName);
      args.setNewNamespaceName(newNamespaceName);
      sendBase("renameNamespace", args);
    }

    public void recv_renameNamespace() throws AccumuloException, AccumuloSecurityException, NamespaceNotFoundException, NamespaceExistsException, org.apache.thrift.TException
    {
      renameNamespace_result result = new renameNamespace_result();
      receiveBase(result, "renameNamespace");
      if (result.ouch1 != null) {
        throw result.ouch1;
      }
      if (result.ouch2 != null) {
        throw result.ouch2;
      }
      if (result.ouch3 != null) {
        throw result.ouch3;
      }
      if (result.ouch4 != null) {
        throw result.ouch4;
      }
      return;
    }

    public void setNamespaceProperty(ByteBuffer login, String namespaceName, String property, String value) throws AccumuloException, AccumuloSecurityException, NamespaceNotFoundException, org.apache.thrift.TException
    {
      send_setNamespaceProperty(login, namespaceName, property, value);
      recv_setNamespaceProperty();
    }

    public void send_setNamespaceProperty(ByteBuffer login, String namespaceName, String property, String value) throws org.apache.thrift.TException
    {
      setNamespaceProperty_args args = new setNamespaceProperty_args();
      args.setLogin(login);
      args.setNamespaceName(namespaceName);
      args.setProperty(property);
      args.setValue(value);
      sendBase("setNamespaceProperty", args);
    }

    public void recv_setNamespaceProperty() throws AccumuloException, AccumuloSecurityException, NamespaceNotFoundException, org.apache.thrift.TException
    {
      setNamespaceProperty_result result = new setNamespaceProperty_result();
      receiveBase(result, "setNamespaceProperty");
      if (result.ouch1 != null) {
        throw result.ouch1;
      }
      if (result.ouch2 != null) {
        throw result.ouch2;
      }
      if (result.ouch3 != null) {
        throw result.ouch3;
      }
      return;
    }

    public void removeNamespaceProperty(ByteBuffer login, String namespaceName, String property) throws AccumuloException, AccumuloSecurityException, NamespaceNotFoundException, org.apache.thrift.TException
    {
      send_removeNamespaceProperty(login, namespaceName, property);
      recv_removeNamespaceProperty();
    }

    public void send_removeNamespaceProperty(ByteBuffer login, String namespaceName, String property) throws org.apache.thrift.TException
    {
      removeNamespaceProperty_args args = new removeNamespaceProperty_args();
      args.setLogin(login);
      args.setNamespaceName(namespaceName);
      args.setProperty(property);
      sendBase("removeNamespaceProperty", args);
    }

    public void recv_removeNamespaceProperty() throws AccumuloException, AccumuloSecurityException, NamespaceNotFoundException, org.apache.thrift.TException
    {
      removeNamespaceProperty_result result = new removeNamespaceProperty_result();
      receiveBase(result, "removeNamespaceProperty");
      if (result.ouch1 != null) {
        throw result.ouch1;
      }
      if (result.ouch2 != null) {
        throw result.ouch2;
      }
      if (result.ouch3 != null) {
        throw result.ouch3;
      }
      return;
    }

    public Map<String,String> getNamespaceProperties(ByteBuffer login, String namespaceName) throws AccumuloException, AccumuloSecurityException, NamespaceNotFoundException, org.apache.thrift.TException
    {
      send_getNamespaceProperties(login, namespaceName);
      return recv_getNamespaceProperties();
    }

    public void send_getNamespaceProperties(ByteBuffer login, String namespaceName) throws org.apache.thrift.TException
    {
      getNamespaceProperties_args args = new getNamespaceProperties_args();
      args.setLogin(login);
      args.setNamespaceName(namespaceName);
      sendBase("getNamespaceProperties", args);
    }

    public Map<String,String> recv_getNamespaceProperties() throws AccumuloException, AccumuloSecurityException, NamespaceNotFoundException, org.apache.thrift.TException
    {
      getNamespaceProperties_result result = new getNamespaceProperties_result();
      receiveBase(result, "getNamespaceProperties");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ouch1 != null) {
        throw result.ouch1;
      }
      if (result.ouch2 != null) {
        throw result.ouch2;
      }
      if (result.ouch3 != null) {
        throw result.ouch3;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getNamespaceProperties failed: unknown result");
    }

    public Map<String,String> namespaceIdMap(ByteBuffer login) throws AccumuloException, AccumuloSecurityException, org.apache.thrift.TException
    {
      send_namespaceIdMap(login);
      return recv_namespaceIdMap();
    }

    public void send_namespaceIdMap(ByteBuffer login) throws org.apache.thrift.TException
    {
      namespaceIdMap_args args = new namespaceIdMap_args();
      args.setLogin(login);
      sendBase("namespaceIdMap", args);
    }

    public Map<String,String> recv_namespaceIdMap() throws AccumuloException, AccumuloSecurityException, org.apache.thrift.TException
    {
      namespaceIdMap_result result = new namespaceIdMap_result();
      receiveBase(result, "namespaceIdMap");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ouch1 != null) {
        throw result.ouch1;
      }
      if (result.ouch2 != null) {
        throw result.ouch2;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "namespaceIdMap failed: unknown result");
    }

    public void attachNamespaceIterator(ByteBuffer login, String namespaceName, IteratorSetting setting, Set<IteratorScope> scopes) throws AccumuloException, AccumuloSecurityException, NamespaceNotFoundException, org.apache.thrift.TException
    {
      send_attachNamespaceIterator(login, namespaceName, setting, scopes);
      recv_attachNamespaceIterator();
    }

    public void send_attachNamespaceIterator(ByteBuffer login, String namespaceName, IteratorSetting setting, Set<IteratorScope> scopes) throws org.apache.thrift.TException
    {
      attachNamespaceIterator_args args = new attachNamespaceIterator_args();
      args.setLogin(login);
      args.setNamespaceName(namespaceName);
      args.setSetting(setting);
      args.setScopes(scopes);
      sendBase("attachNamespaceIterator", args);
    }

    public void recv_attachNamespaceIterator() throws AccumuloException, AccumuloSecurityException, NamespaceNotFoundException, org.apache.thrift.TException
    {
      attachNamespaceIterator_result result = new attachNamespaceIterator_result();
      receiveBase(result, "attachNamespaceIterator");
      if (result.ouch1 != null) {
        throw result.ouch1;
      }
      if (result.ouch2 != null) {
        throw result.ouch2;
      }
      if (result.ouch3 != null) {
        throw result.ouch3;
      }
      return;
    }

    public void removeNamespaceIterator(ByteBuffer login, String namespaceName, String name, Set<IteratorScope> scopes) throws AccumuloException, AccumuloSecurityException, NamespaceNotFoundException, org.apache.thrift.TException
    {
      send_removeNamespaceIterator(login, namespaceName, name, scopes);
      recv_removeNamespaceIterator();
    }

    public void send_removeNamespaceIterator(ByteBuffer login, String namespaceName, String name, Set<IteratorScope> scopes) throws org.apache.thrift.TException
    {
      removeNamespaceIterator_args args = new removeNamespaceIterator_args();
      args.setLogin(login);
      args.setNamespaceName(namespaceName);
      args.setName(name);
      args.setScopes(scopes);
      sendBase("removeNamespaceIterator", args);
    }

    public void recv_removeNamespaceIterator() throws AccumuloException, AccumuloSecurityException, NamespaceNotFoundException, org.apache.thrift.TException
    {
      removeNamespaceIterator_result result = new removeNamespaceIterator_result();
      receiveBase(result, "removeNamespaceIterator");
      if (result.ouch1 != null) {
        throw result.ouch1;
      }
      if (result.ouch2 != null) {
        throw result.ouch2;
      }
      if (result.ouch3 != null) {
        throw result.ouch3;
      }
      return;
    }

    public IteratorSetting getNamespaceIteratorSetting(ByteBuffer login, String namespaceName, String name, IteratorScope scope) throws AccumuloException, AccumuloSecurityException, NamespaceNotFoundException, org.apache.thrift.TException
    {
      send_getNamespaceIteratorSetting(login, namespaceName, name, scope);
      return recv_getNamespaceIteratorSetting();
    }

    public void send_getNamespaceIteratorSetting(ByteBuffer login, String namespaceName, String name, IteratorScope scope) throws org.apache.thrift.TException
    {
      getNamespaceIteratorSetting_args args = new getNamespaceIteratorSetting_args();
      args.setLogin(login);
      args.setNamespaceName(namespaceName);
      args.setName(name);
      args.setScope(scope);
      sendBase("getNamespaceIteratorSetting", args);
    }

    public IteratorSetting recv_getNamespaceIteratorSetting() throws AccumuloException, AccumuloSecurityException, NamespaceNotFoundException, org.apache.thrift.TException
    {
      getNamespaceIteratorSetting_result result = new getNamespaceIteratorSetting_result();
      receiveBase(result, "getNamespaceIteratorSetting");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ouch1 != null) {
        throw result.ouch1;
      }
      if (result.ouch2 != null) {
        throw result.ouch2;
      }
      if (result.ouch3 != null) {
        throw result.ouch3;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getNamespaceIteratorSetting failed: unknown result");
    }

    public Map<String,Set<IteratorScope>> listNamespaceIterators(ByteBuffer login, String namespaceName) throws AccumuloException, AccumuloSecurityException, NamespaceNotFoundException, org.apache.thrift.TException
    {
      send_listNamespaceIterators(login, namespaceName);
      return recv_listNamespaceIterators();
    }

    public void send_listNamespaceIterators(ByteBuffer login, String namespaceName) throws org.apache.thrift.TException
    {
      listNamespaceIterators_args args = new listNamespaceIterators_args();
      args.setLogin(login);
      args.setNamespaceName(namespaceName);
      sendBase("listNamespaceIterators", args);
    }

    public Map<String,Set<IteratorScope>> recv_listNamespaceIterators() throws AccumuloException, AccumuloSecurityException, NamespaceNotFoundException, org.apache.thrift.TException
    {
      listNamespaceIterators_result result = new listNamespaceIterators_result();
      receiveBase(result, "listNamespaceIterators");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ouch1 != null) {
        throw result.ouch1;
      }
      if (result.ouch2 != null) {
        throw result.ouch2;
      }
      if (result.ouch3 != null) {
        throw result.ouch3;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "listNamespaceIterators failed: unknown result");
    }

    public void checkNamespaceIteratorConflicts(ByteBuffer login, String namespaceName, IteratorSetting setting, Set<IteratorScope> scopes) throws AccumuloException, AccumuloSecurityException, NamespaceNotFoundException, org.apache.thrift.TException
    {
      send_checkNamespaceIteratorConflicts(login, namespaceName, setting, scopes);
      recv_checkNamespaceIteratorConflicts();
    }

    public void send_checkNamespaceIteratorConflicts(ByteBuffer login, String namespaceName, IteratorSetting setting, Set<IteratorScope> scopes) throws org.apache.thrift.TException
    {
      checkNamespaceIteratorConflicts_args args = new checkNamespaceIteratorConflicts_args();
      args.setLogin(login);
      args.setNamespaceName(namespaceName);
      args.setSetting(setting);
      args.setScopes(scopes);
      sendBase("checkNamespaceIteratorConflicts", args);
    }

    public void recv_checkNamespaceIteratorConflicts() throws AccumuloException, AccumuloSecurityException, NamespaceNotFoundException, org.apache.thrift.TException
    {
      checkNamespaceIteratorConflicts_result result = new checkNamespaceIteratorConflicts_result();
      receiveBase(result, "checkNamespaceIteratorConflicts");
      if (result.ouch1 != null) {
        throw result.ouch1;
      }
      if (result.ouch2 != null) {
        throw result.ouch2;
      }
      if (result.ouch3 != null) {
        throw result.ouch3;
      }
      return;
    }

    public int addNamespaceConstraint(ByteBuffer login, String namespaceName, String constraintClassName) throws AccumuloException, AccumuloSecurityException, NamespaceNotFoundException, org.apache.thrift.TException
    {
      send_addNamespaceConstraint(login, namespaceName, constraintClassName);
      return recv_addNamespaceConstraint();
    }

    public void send_addNamespaceConstraint(ByteBuffer login, String namespaceName, String constraintClassName) throws org.apache.thrift.TException
    {
      addNamespaceConstraint_args args = new addNamespaceConstraint_args();
      args.setLogin(login);
      args.setNamespaceName(namespaceName);
      args.setConstraintClassName(constraintClassName);
      sendBase("addNamespaceConstraint", args);
    }

    public int recv_addNamespaceConstraint() throws AccumuloException, AccumuloSecurityException, NamespaceNotFoundException, org.apache.thrift.TException
    {
      addNamespaceConstraint_result result = new addNamespaceConstraint_result();
      receiveBase(result, "addNamespaceConstraint");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ouch1 != null) {
        throw result.ouch1;
      }
      if (result.ouch2 != null) {
        throw result.ouch2;
      }
      if (result.ouch3 != null) {
        throw result.ouch3;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "addNamespaceConstraint failed: unknown result");
    }

    public void removeNamespaceConstraint(ByteBuffer login, String namespaceName, int id) throws AccumuloException, AccumuloSecurityException, NamespaceNotFoundException, org.apache.thrift.TException
    {
      send_removeNamespaceConstraint(login, namespaceName, id);
      recv_removeNamespaceConstraint();
    }

    public void send_removeNamespaceConstraint(ByteBuffer login, String namespaceName, int id) throws org.apache.thrift.TException
    {
      removeNamespaceConstraint_args args = new removeNamespaceConstraint_args();
      args.setLogin(login);
      args.setNamespaceName(namespaceName);
      args.setId(id);
      sendBase("removeNamespaceConstraint", args);
    }

    public void recv_removeNamespaceConstraint() throws AccumuloException, AccumuloSecurityException, NamespaceNotFoundException, org.apache.thrift.TException
    {
      removeNamespaceConstraint_result result = new removeNamespaceConstraint_result();
      receiveBase(result, "removeNamespaceConstraint");
      if (result.ouch1 != null) {
        throw result.ouch1;
      }
      if (result.ouch2 != null) {
        throw result.ouch2;
      }
      if (result.ouch3 != null) {
        throw result.ouch3;
      }
      return;
    }

    public Map<String,Integer> listNamespaceConstraints(ByteBuffer login, String namespaceName) throws AccumuloException, AccumuloSecurityException, NamespaceNotFoundException, org.apache.thrift.TException
    {
      send_listNamespaceConstraints(login, namespaceName);
      return recv_listNamespaceConstraints();
    }

    public void send_listNamespaceConstraints(ByteBuffer login, String namespaceName) throws org.apache.thrift.TException
    {
      listNamespaceConstraints_args args = new listNamespaceConstraints_args();
      args.setLogin(login);
      args.setNamespaceName(namespaceName);
      sendBase("listNamespaceConstraints", args);
    }

    public Map<String,Integer> recv_listNamespaceConstraints() throws AccumuloException, AccumuloSecurityException, NamespaceNotFoundException, org.apache.thrift.TException
    {
      listNamespaceConstraints_result result = new listNamespaceConstraints_result();
      receiveBase(result, "listNamespaceConstraints");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ouch1 != null) {
        throw result.ouch1;
      }
      if (result.ouch2 != null) {
        throw result.ouch2;
      }
      if (result.ouch3 != null) {
        throw result.ouch3;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "listNamespaceConstraints failed: unknown result");
    }

    public boolean testNamespaceClassLoad(ByteBuffer login, String namespaceName, String className, String asTypeName) throws AccumuloException, AccumuloSecurityException, NamespaceNotFoundException, org.apache.thrift.TException
    {
      send_testNamespaceClassLoad(login, namespaceName, className, asTypeName);
      return recv_testNamespaceClassLoad();
    }

    public void send_testNamespaceClassLoad(ByteBuffer login, String namespaceName, String className, String asTypeName) throws org.apache.thrift.TException
    {
      testNamespaceClassLoad_args args = new testNamespaceClassLoad_args();
      args.setLogin(login);
      args.setNamespaceName(namespaceName);
      args.setClassName(className);
      args.setAsTypeName(asTypeName);
      sendBase("testNamespaceClassLoad", args);
    }

    public boolean recv_testNamespaceClassLoad() throws AccumuloException, AccumuloSecurityException, NamespaceNotFoundException, org.apache.thrift.TException
    {
      testNamespaceClassLoad_result result = new testNamespaceClassLoad_result();
      receiveBase(result, "testNamespaceClassLoad");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ouch1 != null) {
        throw result.ouch1;
      }
      if (result.ouch2 != null) {
        throw result.ouch2;
      }
      if (result.ouch3 != null) {
        throw result.ouch3;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "testNamespaceClassLoad failed: unknown result");
    }

  }
  public static class AsyncClient extends org.apache.thrift.async.TAsyncClient implements AsyncIface {
    public static class Factory implements org.apache.thrift.async.TAsyncClientFactory<AsyncClient> {
      private org.apache.thrift.async.TAsyncClientManager clientManager;
      private org.apache.thrift.protocol.TProtocolFactory protocolFactory;
      public Factory(org.apache.thrift.async.TAsyncClientManager clientManager, org.apache.thrift.protocol.TProtocolFactory protocolFactory) {
        this.clientManager = clientManager;
        this.protocolFactory = protocolFactory;
      }
      public AsyncClient getAsyncClient(org.apache.thrift.transport.TNonblockingTransport transport) {
        return new AsyncClient(protocolFactory, clientManager, transport);
      }
    }

    public AsyncClient(org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.async.TAsyncClientManager clientManager, org.apache.thrift.transport.TNonblockingTransport transport) {
      super(protocolFactory, clientManager, transport);
    }

    public void login(String principal, Map<String,String> loginProperties, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      login_call method_call = new login_call(principal, loginProperties, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class login_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String principal;
      private Map<String,String> loginProperties;
      public login_call(String principal, Map<String,String> loginProperties, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.principal = principal;
        this.loginProperties = loginProperties;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("login", org.apache.thrift.protocol.TMessageType.CALL, 0));
        login_args args = new login_args();
        args.setPrincipal(principal);
        args.setLoginProperties(loginProperties);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public ByteBuffer getResult() throws AccumuloSecurityException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_login();
      }
    }

    public void addConstraint(ByteBuffer login, String tableName, String constraintClassName, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      addConstraint_call method_call = new addConstraint_call(login, tableName, constraintClassName, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class addConstraint_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer login;
      private String tableName;
      private String constraintClassName;
      public addConstraint_call(ByteBuffer login, String tableName, String constraintClassName, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.login = login;
        this.tableName = tableName;
        this.constraintClassName = constraintClassName;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("addConstraint", org.apache.thrift.protocol.TMessageType.CALL, 0));
        addConstraint_args args = new addConstraint_args();
        args.setLogin(login);
        args.setTableName(tableName);
        args.setConstraintClassName(constraintClassName);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public int getResult() throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_addConstraint();
      }
    }

    public void addSplits(ByteBuffer login, String tableName, Set<ByteBuffer> splits, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      addSplits_call method_call = new addSplits_call(login, tableName, splits, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class addSplits_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer login;
      private String tableName;
      private Set<ByteBuffer> splits;
      public addSplits_call(ByteBuffer login, String tableName, Set<ByteBuffer> splits, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.login = login;
        this.tableName = tableName;
        this.splits = splits;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("addSplits", org.apache.thrift.protocol.TMessageType.CALL, 0));
        addSplits_args args = new addSplits_args();
        args.setLogin(login);
        args.setTableName(tableName);
        args.setSplits(splits);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_addSplits();
      }
    }

    public void attachIterator(ByteBuffer login, String tableName, IteratorSetting setting, Set<IteratorScope> scopes, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      attachIterator_call method_call = new attachIterator_call(login, tableName, setting, scopes, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class attachIterator_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer login;
      private String tableName;
      private IteratorSetting setting;
      private Set<IteratorScope> scopes;
      public attachIterator_call(ByteBuffer login, String tableName, IteratorSetting setting, Set<IteratorScope> scopes, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.login = login;
        this.tableName = tableName;
        this.setting = setting;
        this.scopes = scopes;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("attachIterator", org.apache.thrift.protocol.TMessageType.CALL, 0));
        attachIterator_args args = new attachIterator_args();
        args.setLogin(login);
        args.setTableName(tableName);
        args.setSetting(setting);
        args.setScopes(scopes);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws AccumuloSecurityException, AccumuloException, TableNotFoundException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_attachIterator();
      }
    }

    public void checkIteratorConflicts(ByteBuffer login, String tableName, IteratorSetting setting, Set<IteratorScope> scopes, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      checkIteratorConflicts_call method_call = new checkIteratorConflicts_call(login, tableName, setting, scopes, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class checkIteratorConflicts_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer login;
      private String tableName;
      private IteratorSetting setting;
      private Set<IteratorScope> scopes;
      public checkIteratorConflicts_call(ByteBuffer login, String tableName, IteratorSetting setting, Set<IteratorScope> scopes, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.login = login;
        this.tableName = tableName;
        this.setting = setting;
        this.scopes = scopes;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("checkIteratorConflicts", org.apache.thrift.protocol.TMessageType.CALL, 0));
        checkIteratorConflicts_args args = new checkIteratorConflicts_args();
        args.setLogin(login);
        args.setTableName(tableName);
        args.setSetting(setting);
        args.setScopes(scopes);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws AccumuloSecurityException, AccumuloException, TableNotFoundException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_checkIteratorConflicts();
      }
    }

    public void clearLocatorCache(ByteBuffer login, String tableName, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      clearLocatorCache_call method_call = new clearLocatorCache_call(login, tableName, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class clearLocatorCache_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer login;
      private String tableName;
      public clearLocatorCache_call(ByteBuffer login, String tableName, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.login = login;
        this.tableName = tableName;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("clearLocatorCache", org.apache.thrift.protocol.TMessageType.CALL, 0));
        clearLocatorCache_args args = new clearLocatorCache_args();
        args.setLogin(login);
        args.setTableName(tableName);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws TableNotFoundException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_clearLocatorCache();
      }
    }

    public void cloneTable(ByteBuffer login, String tableName, String newTableName, boolean flush, Map<String,String> propertiesToSet, Set<String> propertiesToExclude, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      cloneTable_call method_call = new cloneTable_call(login, tableName, newTableName, flush, propertiesToSet, propertiesToExclude, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class cloneTable_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer login;
      private String tableName;
      private String newTableName;
      private boolean flush;
      private Map<String,String> propertiesToSet;
      private Set<String> propertiesToExclude;
      public cloneTable_call(ByteBuffer login, String tableName, String newTableName, boolean flush, Map<String,String> propertiesToSet, Set<String> propertiesToExclude, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.login = login;
        this.tableName = tableName;
        this.newTableName = newTableName;
        this.flush = flush;
        this.propertiesToSet = propertiesToSet;
        this.propertiesToExclude = propertiesToExclude;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("cloneTable", org.apache.thrift.protocol.TMessageType.CALL, 0));
        cloneTable_args args = new cloneTable_args();
        args.setLogin(login);
        args.setTableName(tableName);
        args.setNewTableName(newTableName);
        args.setFlush(flush);
        args.setPropertiesToSet(propertiesToSet);
        args.setPropertiesToExclude(propertiesToExclude);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws AccumuloException, AccumuloSecurityException, TableNotFoundException, TableExistsException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_cloneTable();
      }
    }

    public void compactTable(ByteBuffer login, String tableName, ByteBuffer startRow, ByteBuffer endRow, List<IteratorSetting> iterators, boolean flush, boolean wait, CompactionStrategyConfig compactionStrategy, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      compactTable_call method_call = new compactTable_call(login, tableName, startRow, endRow, iterators, flush, wait, compactionStrategy, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class compactTable_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer login;
      private String tableName;
      private ByteBuffer startRow;
      private ByteBuffer endRow;
      private List<IteratorSetting> iterators;
      private boolean flush;
      private boolean wait;
      private CompactionStrategyConfig compactionStrategy;
      public compactTable_call(ByteBuffer login, String tableName, ByteBuffer startRow, ByteBuffer endRow, List<IteratorSetting> iterators, boolean flush, boolean wait, CompactionStrategyConfig compactionStrategy, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.login = login;
        this.tableName = tableName;
        this.startRow = startRow;
        this.endRow = endRow;
        this.iterators = iterators;
        this.flush = flush;
        this.wait = wait;
        this.compactionStrategy = compactionStrategy;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("compactTable", org.apache.thrift.protocol.TMessageType.CALL, 0));
        compactTable_args args = new compactTable_args();
        args.setLogin(login);
        args.setTableName(tableName);
        args.setStartRow(startRow);
        args.setEndRow(endRow);
        args.setIterators(iterators);
        args.setFlush(flush);
        args.setWait(wait);
        args.setCompactionStrategy(compactionStrategy);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws AccumuloSecurityException, TableNotFoundException, AccumuloException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_compactTable();
      }
    }

    public void cancelCompaction(ByteBuffer login, String tableName, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      cancelCompaction_call method_call = new cancelCompaction_call(login, tableName, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class cancelCompaction_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer login;
      private String tableName;
      public cancelCompaction_call(ByteBuffer login, String tableName, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.login = login;
        this.tableName = tableName;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("cancelCompaction", org.apache.thrift.protocol.TMessageType.CALL, 0));
        cancelCompaction_args args = new cancelCompaction_args();
        args.setLogin(login);
        args.setTableName(tableName);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws AccumuloSecurityException, TableNotFoundException, AccumuloException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_cancelCompaction();
      }
    }

    public void createTable(ByteBuffer login, String tableName, boolean versioningIter, TimeType type, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      createTable_call method_call = new createTable_call(login, tableName, versioningIter, type, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class createTable_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer login;
      private String tableName;
      private boolean versioningIter;
      private TimeType type;
      public createTable_call(ByteBuffer login, String tableName, boolean versioningIter, TimeType type, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.login = login;
        this.tableName = tableName;
        this.versioningIter = versioningIter;
        this.type = type;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("createTable", org.apache.thrift.protocol.TMessageType.CALL, 0));
        createTable_args args = new createTable_args();
        args.setLogin(login);
        args.setTableName(tableName);
        args.setVersioningIter(versioningIter);
        args.setType(type);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws AccumuloException, AccumuloSecurityException, TableExistsException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_createTable();
      }
    }

    public void deleteTable(ByteBuffer login, String tableName, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      deleteTable_call method_call = new deleteTable_call(login, tableName, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class deleteTable_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer login;
      private String tableName;
      public deleteTable_call(ByteBuffer login, String tableName, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.login = login;
        this.tableName = tableName;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("deleteTable", org.apache.thrift.protocol.TMessageType.CALL, 0));
        deleteTable_args args = new deleteTable_args();
        args.setLogin(login);
        args.setTableName(tableName);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_deleteTable();
      }
    }

    public void deleteRows(ByteBuffer login, String tableName, ByteBuffer startRow, ByteBuffer endRow, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      deleteRows_call method_call = new deleteRows_call(login, tableName, startRow, endRow, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class deleteRows_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer login;
      private String tableName;
      private ByteBuffer startRow;
      private ByteBuffer endRow;
      public deleteRows_call(ByteBuffer login, String tableName, ByteBuffer startRow, ByteBuffer endRow, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.login = login;
        this.tableName = tableName;
        this.startRow = startRow;
        this.endRow = endRow;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("deleteRows", org.apache.thrift.protocol.TMessageType.CALL, 0));
        deleteRows_args args = new deleteRows_args();
        args.setLogin(login);
        args.setTableName(tableName);
        args.setStartRow(startRow);
        args.setEndRow(endRow);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_deleteRows();
      }
    }

    public void exportTable(ByteBuffer login, String tableName, String exportDir, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      exportTable_call method_call = new exportTable_call(login, tableName, exportDir, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class exportTable_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer login;
      private String tableName;
      private String exportDir;
      public exportTable_call(ByteBuffer login, String tableName, String exportDir, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.login = login;
        this.tableName = tableName;
        this.exportDir = exportDir;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("exportTable", org.apache.thrift.protocol.TMessageType.CALL, 0));
        exportTable_args args = new exportTable_args();
        args.setLogin(login);
        args.setTableName(tableName);
        args.setExportDir(exportDir);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_exportTable();
      }
    }

    public void flushTable(ByteBuffer login, String tableName, ByteBuffer startRow, ByteBuffer endRow, boolean wait, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      flushTable_call method_call = new flushTable_call(login, tableName, startRow, endRow, wait, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class flushTable_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer login;
      private String tableName;
      private ByteBuffer startRow;
      private ByteBuffer endRow;
      private boolean wait;
      public flushTable_call(ByteBuffer login, String tableName, ByteBuffer startRow, ByteBuffer endRow, boolean wait, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.login = login;
        this.tableName = tableName;
        this.startRow = startRow;
        this.endRow = endRow;
        this.wait = wait;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("flushTable", org.apache.thrift.protocol.TMessageType.CALL, 0));
        flushTable_args args = new flushTable_args();
        args.setLogin(login);
        args.setTableName(tableName);
        args.setStartRow(startRow);
        args.setEndRow(endRow);
        args.setWait(wait);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_flushTable();
      }
    }

    public void getDiskUsage(ByteBuffer login, Set<String> tables, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getDiskUsage_call method_call = new getDiskUsage_call(login, tables, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getDiskUsage_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer login;
      private Set<String> tables;
      public getDiskUsage_call(ByteBuffer login, Set<String> tables, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.login = login;
        this.tables = tables;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getDiskUsage", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getDiskUsage_args args = new getDiskUsage_args();
        args.setLogin(login);
        args.setTables(tables);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<DiskUsage> getResult() throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getDiskUsage();
      }
    }

    public void getLocalityGroups(ByteBuffer login, String tableName, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getLocalityGroups_call method_call = new getLocalityGroups_call(login, tableName, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getLocalityGroups_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer login;
      private String tableName;
      public getLocalityGroups_call(ByteBuffer login, String tableName, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.login = login;
        this.tableName = tableName;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getLocalityGroups", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getLocalityGroups_args args = new getLocalityGroups_args();
        args.setLogin(login);
        args.setTableName(tableName);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Map<String,Set<String>> getResult() throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getLocalityGroups();
      }
    }

    public void getIteratorSetting(ByteBuffer login, String tableName, String iteratorName, IteratorScope scope, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getIteratorSetting_call method_call = new getIteratorSetting_call(login, tableName, iteratorName, scope, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getIteratorSetting_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer login;
      private String tableName;
      private String iteratorName;
      private IteratorScope scope;
      public getIteratorSetting_call(ByteBuffer login, String tableName, String iteratorName, IteratorScope scope, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.login = login;
        this.tableName = tableName;
        this.iteratorName = iteratorName;
        this.scope = scope;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getIteratorSetting", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getIteratorSetting_args args = new getIteratorSetting_args();
        args.setLogin(login);
        args.setTableName(tableName);
        args.setIteratorName(iteratorName);
        args.setScope(scope);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public IteratorSetting getResult() throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getIteratorSetting();
      }
    }

    public void getMaxRow(ByteBuffer login, String tableName, Set<ByteBuffer> auths, ByteBuffer startRow, boolean startInclusive, ByteBuffer endRow, boolean endInclusive, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getMaxRow_call method_call = new getMaxRow_call(login, tableName, auths, startRow, startInclusive, endRow, endInclusive, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getMaxRow_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer login;
      private String tableName;
      private Set<ByteBuffer> auths;
      private ByteBuffer startRow;
      private boolean startInclusive;
      private ByteBuffer endRow;
      private boolean endInclusive;
      public getMaxRow_call(ByteBuffer login, String tableName, Set<ByteBuffer> auths, ByteBuffer startRow, boolean startInclusive, ByteBuffer endRow, boolean endInclusive, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.login = login;
        this.tableName = tableName;
        this.auths = auths;
        this.startRow = startRow;
        this.startInclusive = startInclusive;
        this.endRow = endRow;
        this.endInclusive = endInclusive;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getMaxRow", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getMaxRow_args args = new getMaxRow_args();
        args.setLogin(login);
        args.setTableName(tableName);
        args.setAuths(auths);
        args.setStartRow(startRow);
        args.setStartInclusive(startInclusive);
        args.setEndRow(endRow);
        args.setEndInclusive(endInclusive);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public ByteBuffer getResult() throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getMaxRow();
      }
    }

    public void getTableProperties(ByteBuffer login, String tableName, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getTableProperties_call method_call = new getTableProperties_call(login, tableName, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getTableProperties_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer login;
      private String tableName;
      public getTableProperties_call(ByteBuffer login, String tableName, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.login = login;
        this.tableName = tableName;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getTableProperties", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getTableProperties_args args = new getTableProperties_args();
        args.setLogin(login);
        args.setTableName(tableName);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Map<String,String> getResult() throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getTableProperties();
      }
    }

    public void importDirectory(ByteBuffer login, String tableName, String importDir, String failureDir, boolean setTime, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      importDirectory_call method_call = new importDirectory_call(login, tableName, importDir, failureDir, setTime, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class importDirectory_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer login;
      private String tableName;
      private String importDir;
      private String failureDir;
      private boolean setTime;
      public importDirectory_call(ByteBuffer login, String tableName, String importDir, String failureDir, boolean setTime, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.login = login;
        this.tableName = tableName;
        this.importDir = importDir;
        this.failureDir = failureDir;
        this.setTime = setTime;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("importDirectory", org.apache.thrift.protocol.TMessageType.CALL, 0));
        importDirectory_args args = new importDirectory_args();
        args.setLogin(login);
        args.setTableName(tableName);
        args.setImportDir(importDir);
        args.setFailureDir(failureDir);
        args.setSetTime(setTime);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws TableNotFoundException, AccumuloException, AccumuloSecurityException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_importDirectory();
      }
    }

    public void importTable(ByteBuffer login, String tableName, String importDir, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      importTable_call method_call = new importTable_call(login, tableName, importDir, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class importTable_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer login;
      private String tableName;
      private String importDir;
      public importTable_call(ByteBuffer login, String tableName, String importDir, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.login = login;
        this.tableName = tableName;
        this.importDir = importDir;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("importTable", org.apache.thrift.protocol.TMessageType.CALL, 0));
        importTable_args args = new importTable_args();
        args.setLogin(login);
        args.setTableName(tableName);
        args.setImportDir(importDir);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws TableExistsException, AccumuloException, AccumuloSecurityException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_importTable();
      }
    }

    public void listSplits(ByteBuffer login, String tableName, int maxSplits, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      listSplits_call method_call = new listSplits_call(login, tableName, maxSplits, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class listSplits_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer login;
      private String tableName;
      private int maxSplits;
      public listSplits_call(ByteBuffer login, String tableName, int maxSplits, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.login = login;
        this.tableName = tableName;
        this.maxSplits = maxSplits;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("listSplits", org.apache.thrift.protocol.TMessageType.CALL, 0));
        listSplits_args args = new listSplits_args();
        args.setLogin(login);
        args.setTableName(tableName);
        args.setMaxSplits(maxSplits);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<ByteBuffer> getResult() throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_listSplits();
      }
    }

    public void listTables(ByteBuffer login, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      listTables_call method_call = new listTables_call(login, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class listTables_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer login;
      public listTables_call(ByteBuffer login, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.login = login;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("listTables", org.apache.thrift.protocol.TMessageType.CALL, 0));
        listTables_args args = new listTables_args();
        args.setLogin(login);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Set<String> getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_listTables();
      }
    }

    public void listIterators(ByteBuffer login, String tableName, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      listIterators_call method_call = new listIterators_call(login, tableName, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class listIterators_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer login;
      private String tableName;
      public listIterators_call(ByteBuffer login, String tableName, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.login = login;
        this.tableName = tableName;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("listIterators", org.apache.thrift.protocol.TMessageType.CALL, 0));
        listIterators_args args = new listIterators_args();
        args.setLogin(login);
        args.setTableName(tableName);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Map<String,Set<IteratorScope>> getResult() throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_listIterators();
      }
    }

    public void listConstraints(ByteBuffer login, String tableName, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      listConstraints_call method_call = new listConstraints_call(login, tableName, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class listConstraints_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer login;
      private String tableName;
      public listConstraints_call(ByteBuffer login, String tableName, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.login = login;
        this.tableName = tableName;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("listConstraints", org.apache.thrift.protocol.TMessageType.CALL, 0));
        listConstraints_args args = new listConstraints_args();
        args.setLogin(login);
        args.setTableName(tableName);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Map<String,Integer> getResult() throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_listConstraints();
      }
    }

    public void mergeTablets(ByteBuffer login, String tableName, ByteBuffer startRow, ByteBuffer endRow, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      mergeTablets_call method_call = new mergeTablets_call(login, tableName, startRow, endRow, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class mergeTablets_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer login;
      private String tableName;
      private ByteBuffer startRow;
      private ByteBuffer endRow;
      public mergeTablets_call(ByteBuffer login, String tableName, ByteBuffer startRow, ByteBuffer endRow, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.login = login;
        this.tableName = tableName;
        this.startRow = startRow;
        this.endRow = endRow;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("mergeTablets", org.apache.thrift.protocol.TMessageType.CALL, 0));
        mergeTablets_args args = new mergeTablets_args();
        args.setLogin(login);
        args.setTableName(tableName);
        args.setStartRow(startRow);
        args.setEndRow(endRow);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_mergeTablets();
      }
    }

    public void offlineTable(ByteBuffer login, String tableName, boolean wait, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      offlineTable_call method_call = new offlineTable_call(login, tableName, wait, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class offlineTable_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer login;
      private String tableName;
      private boolean wait;
      public offlineTable_call(ByteBuffer login, String tableName, boolean wait, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.login = login;
        this.tableName = tableName;
        this.wait = wait;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("offlineTable", org.apache.thrift.protocol.TMessageType.CALL, 0));
        offlineTable_args args = new offlineTable_args();
        args.setLogin(login);
        args.setTableName(tableName);
        args.setWait(wait);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_offlineTable();
      }
    }

    public void onlineTable(ByteBuffer login, String tableName, boolean wait, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      onlineTable_call method_call = new onlineTable_call(login, tableName, wait, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class onlineTable_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer login;
      private String tableName;
      private boolean wait;
      public onlineTable_call(ByteBuffer login, String tableName, boolean wait, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.login = login;
        this.tableName = tableName;
        this.wait = wait;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("onlineTable", org.apache.thrift.protocol.TMessageType.CALL, 0));
        onlineTable_args args = new onlineTable_args();
        args.setLogin(login);
        args.setTableName(tableName);
        args.setWait(wait);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_onlineTable();
      }
    }

    public void removeConstraint(ByteBuffer login, String tableName, int constraint, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      removeConstraint_call method_call = new removeConstraint_call(login, tableName, constraint, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class removeConstraint_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer login;
      private String tableName;
      private int constraint;
      public removeConstraint_call(ByteBuffer login, String tableName, int constraint, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.login = login;
        this.tableName = tableName;
        this.constraint = constraint;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("removeConstraint", org.apache.thrift.protocol.TMessageType.CALL, 0));
        removeConstraint_args args = new removeConstraint_args();
        args.setLogin(login);
        args.setTableName(tableName);
        args.setConstraint(constraint);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_removeConstraint();
      }
    }

    public void removeIterator(ByteBuffer login, String tableName, String iterName, Set<IteratorScope> scopes, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      removeIterator_call method_call = new removeIterator_call(login, tableName, iterName, scopes, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class removeIterator_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer login;
      private String tableName;
      private String iterName;
      private Set<IteratorScope> scopes;
      public removeIterator_call(ByteBuffer login, String tableName, String iterName, Set<IteratorScope> scopes, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.login = login;
        this.tableName = tableName;
        this.iterName = iterName;
        this.scopes = scopes;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("removeIterator", org.apache.thrift.protocol.TMessageType.CALL, 0));
        removeIterator_args args = new removeIterator_args();
        args.setLogin(login);
        args.setTableName(tableName);
        args.setIterName(iterName);
        args.setScopes(scopes);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_removeIterator();
      }
    }

    public void removeTableProperty(ByteBuffer login, String tableName, String property, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      removeTableProperty_call method_call = new removeTableProperty_call(login, tableName, property, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class removeTableProperty_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer login;
      private String tableName;
      private String property;
      public removeTableProperty_call(ByteBuffer login, String tableName, String property, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.login = login;
        this.tableName = tableName;
        this.property = property;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("removeTableProperty", org.apache.thrift.protocol.TMessageType.CALL, 0));
        removeTableProperty_args args = new removeTableProperty_args();
        args.setLogin(login);
        args.setTableName(tableName);
        args.setProperty(property);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_removeTableProperty();
      }
    }

    public void renameTable(ByteBuffer login, String oldTableName, String newTableName, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      renameTable_call method_call = new renameTable_call(login, oldTableName, newTableName, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class renameTable_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer login;
      private String oldTableName;
      private String newTableName;
      public renameTable_call(ByteBuffer login, String oldTableName, String newTableName, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.login = login;
        this.oldTableName = oldTableName;
        this.newTableName = newTableName;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("renameTable", org.apache.thrift.protocol.TMessageType.CALL, 0));
        renameTable_args args = new renameTable_args();
        args.setLogin(login);
        args.setOldTableName(oldTableName);
        args.setNewTableName(newTableName);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws AccumuloException, AccumuloSecurityException, TableNotFoundException, TableExistsException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_renameTable();
      }
    }

    public void setLocalityGroups(ByteBuffer login, String tableName, Map<String,Set<String>> groups, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      setLocalityGroups_call method_call = new setLocalityGroups_call(login, tableName, groups, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class setLocalityGroups_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer login;
      private String tableName;
      private Map<String,Set<String>> groups;
      public setLocalityGroups_call(ByteBuffer login, String tableName, Map<String,Set<String>> groups, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.login = login;
        this.tableName = tableName;
        this.groups = groups;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("setLocalityGroups", org.apache.thrift.protocol.TMessageType.CALL, 0));
        setLocalityGroups_args args = new setLocalityGroups_args();
        args.setLogin(login);
        args.setTableName(tableName);
        args.setGroups(groups);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_setLocalityGroups();
      }
    }

    public void setTableProperty(ByteBuffer login, String tableName, String property, String value, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      setTableProperty_call method_call = new setTableProperty_call(login, tableName, property, value, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class setTableProperty_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer login;
      private String tableName;
      private String property;
      private String value;
      public setTableProperty_call(ByteBuffer login, String tableName, String property, String value, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.login = login;
        this.tableName = tableName;
        this.property = property;
        this.value = value;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("setTableProperty", org.apache.thrift.protocol.TMessageType.CALL, 0));
        setTableProperty_args args = new setTableProperty_args();
        args.setLogin(login);
        args.setTableName(tableName);
        args.setProperty(property);
        args.setValue(value);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_setTableProperty();
      }
    }

    public void splitRangeByTablets(ByteBuffer login, String tableName, Range range, int maxSplits, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      splitRangeByTablets_call method_call = new splitRangeByTablets_call(login, tableName, range, maxSplits, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class splitRangeByTablets_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer login;
      private String tableName;
      private Range range;
      private int maxSplits;
      public splitRangeByTablets_call(ByteBuffer login, String tableName, Range range, int maxSplits, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.login = login;
        this.tableName = tableName;
        this.range = range;
        this.maxSplits = maxSplits;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("splitRangeByTablets", org.apache.thrift.protocol.TMessageType.CALL, 0));
        splitRangeByTablets_args args = new splitRangeByTablets_args();
        args.setLogin(login);
        args.setTableName(tableName);
        args.setRange(range);
        args.setMaxSplits(maxSplits);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Set<Range> getResult() throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_splitRangeByTablets();
      }
    }

    public void tableExists(ByteBuffer login, String tableName, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      tableExists_call method_call = new tableExists_call(login, tableName, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class tableExists_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer login;
      private String tableName;
      public tableExists_call(ByteBuffer login, String tableName, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.login = login;
        this.tableName = tableName;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("tableExists", org.apache.thrift.protocol.TMessageType.CALL, 0));
        tableExists_args args = new tableExists_args();
        args.setLogin(login);
        args.setTableName(tableName);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_tableExists();
      }
    }

    public void tableIdMap(ByteBuffer login, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      tableIdMap_call method_call = new tableIdMap_call(login, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class tableIdMap_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer login;
      public tableIdMap_call(ByteBuffer login, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.login = login;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("tableIdMap", org.apache.thrift.protocol.TMessageType.CALL, 0));
        tableIdMap_args args = new tableIdMap_args();
        args.setLogin(login);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Map<String,String> getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_tableIdMap();
      }
    }

    public void testTableClassLoad(ByteBuffer login, String tableName, String className, String asTypeName, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      testTableClassLoad_call method_call = new testTableClassLoad_call(login, tableName, className, asTypeName, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class testTableClassLoad_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer login;
      private String tableName;
      private String className;
      private String asTypeName;
      public testTableClassLoad_call(ByteBuffer login, String tableName, String className, String asTypeName, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.login = login;
        this.tableName = tableName;
        this.className = className;
        this.asTypeName = asTypeName;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("testTableClassLoad", org.apache.thrift.protocol.TMessageType.CALL, 0));
        testTableClassLoad_args args = new testTableClassLoad_args();
        args.setLogin(login);
        args.setTableName(tableName);
        args.setClassName(className);
        args.setAsTypeName(asTypeName);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_testTableClassLoad();
      }
    }

    public void pingTabletServer(ByteBuffer login, String tserver, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      pingTabletServer_call method_call = new pingTabletServer_call(login, tserver, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class pingTabletServer_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer login;
      private String tserver;
      public pingTabletServer_call(ByteBuffer login, String tserver, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.login = login;
        this.tserver = tserver;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("pingTabletServer", org.apache.thrift.protocol.TMessageType.CALL, 0));
        pingTabletServer_args args = new pingTabletServer_args();
        args.setLogin(login);
        args.setTserver(tserver);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws AccumuloException, AccumuloSecurityException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_pingTabletServer();
      }
    }

    public void getActiveScans(ByteBuffer login, String tserver, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getActiveScans_call method_call = new getActiveScans_call(login, tserver, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getActiveScans_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer login;
      private String tserver;
      public getActiveScans_call(ByteBuffer login, String tserver, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.login = login;
        this.tserver = tserver;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getActiveScans", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getActiveScans_args args = new getActiveScans_args();
        args.setLogin(login);
        args.setTserver(tserver);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<ActiveScan> getResult() throws AccumuloException, AccumuloSecurityException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getActiveScans();
      }
    }

    public void getActiveCompactions(ByteBuffer login, String tserver, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getActiveCompactions_call method_call = new getActiveCompactions_call(login, tserver, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getActiveCompactions_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer login;
      private String tserver;
      public getActiveCompactions_call(ByteBuffer login, String tserver, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.login = login;
        this.tserver = tserver;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getActiveCompactions", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getActiveCompactions_args args = new getActiveCompactions_args();
        args.setLogin(login);
        args.setTserver(tserver);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<ActiveCompaction> getResult() throws AccumuloException, AccumuloSecurityException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getActiveCompactions();
      }
    }

    public void getSiteConfiguration(ByteBuffer login, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getSiteConfiguration_call method_call = new getSiteConfiguration_call(login, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getSiteConfiguration_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer login;
      public getSiteConfiguration_call(ByteBuffer login, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.login = login;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getSiteConfiguration", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getSiteConfiguration_args args = new getSiteConfiguration_args();
        args.setLogin(login);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Map<String,String> getResult() throws AccumuloException, AccumuloSecurityException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getSiteConfiguration();
      }
    }

    public void getSystemConfiguration(ByteBuffer login, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getSystemConfiguration_call method_call = new getSystemConfiguration_call(login, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getSystemConfiguration_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer login;
      public getSystemConfiguration_call(ByteBuffer login, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.login = login;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getSystemConfiguration", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getSystemConfiguration_args args = new getSystemConfiguration_args();
        args.setLogin(login);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Map<String,String> getResult() throws AccumuloException, AccumuloSecurityException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getSystemConfiguration();
      }
    }

    public void getTabletServers(ByteBuffer login, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getTabletServers_call method_call = new getTabletServers_call(login, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getTabletServers_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer login;
      public getTabletServers_call(ByteBuffer login, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.login = login;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getTabletServers", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getTabletServers_args args = new getTabletServers_args();
        args.setLogin(login);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<String> getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getTabletServers();
      }
    }

    public void removeProperty(ByteBuffer login, String property, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      removeProperty_call method_call = new removeProperty_call(login, property, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class removeProperty_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer login;
      private String property;
      public removeProperty_call(ByteBuffer login, String property, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.login = login;
        this.property = property;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("removeProperty", org.apache.thrift.protocol.TMessageType.CALL, 0));
        removeProperty_args args = new removeProperty_args();
        args.setLogin(login);
        args.setProperty(property);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws AccumuloException, AccumuloSecurityException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_removeProperty();
      }
    }

    public void setProperty(ByteBuffer login, String property, String value, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      setProperty_call method_call = new setProperty_call(login, property, value, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class setProperty_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer login;
      private String property;
      private String value;
      public setProperty_call(ByteBuffer login, String property, String value, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.login = login;
        this.property = property;
        this.value = value;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("setProperty", org.apache.thrift.protocol.TMessageType.CALL, 0));
        setProperty_args args = new setProperty_args();
        args.setLogin(login);
        args.setProperty(property);
        args.setValue(value);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws AccumuloException, AccumuloSecurityException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_setProperty();
      }
    }

    public void testClassLoad(ByteBuffer login, String className, String asTypeName, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      testClassLoad_call method_call = new testClassLoad_call(login, className, asTypeName, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class testClassLoad_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer login;
      private String className;
      private String asTypeName;
      public testClassLoad_call(ByteBuffer login, String className, String asTypeName, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.login = login;
        this.className = className;
        this.asTypeName = asTypeName;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("testClassLoad", org.apache.thrift.protocol.TMessageType.CALL, 0));
        testClassLoad_args args = new testClassLoad_args();
        args.setLogin(login);
        args.setClassName(className);
        args.setAsTypeName(asTypeName);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws AccumuloException, AccumuloSecurityException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_testClassLoad();
      }
    }

    public void authenticateUser(ByteBuffer login, String user, Map<String,String> properties, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      authenticateUser_call method_call = new authenticateUser_call(login, user, properties, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class authenticateUser_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer login;
      private String user;
      private Map<String,String> properties;
      public authenticateUser_call(ByteBuffer login, String user, Map<String,String> properties, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.login = login;
        this.user = user;
        this.properties = properties;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("authenticateUser", org.apache.thrift.protocol.TMessageType.CALL, 0));
        authenticateUser_args args = new authenticateUser_args();
        args.setLogin(login);
        args.setUser(user);
        args.setProperties(properties);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws AccumuloException, AccumuloSecurityException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_authenticateUser();
      }
    }

    public void changeUserAuthorizations(ByteBuffer login, String user, Set<ByteBuffer> authorizations, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      changeUserAuthorizations_call method_call = new changeUserAuthorizations_call(login, user, authorizations, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class changeUserAuthorizations_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer login;
      private String user;
      private Set<ByteBuffer> authorizations;
      public changeUserAuthorizations_call(ByteBuffer login, String user, Set<ByteBuffer> authorizations, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.login = login;
        this.user = user;
        this.authorizations = authorizations;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("changeUserAuthorizations", org.apache.thrift.protocol.TMessageType.CALL, 0));
        changeUserAuthorizations_args args = new changeUserAuthorizations_args();
        args.setLogin(login);
        args.setUser(user);
        args.setAuthorizations(authorizations);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws AccumuloException, AccumuloSecurityException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_changeUserAuthorizations();
      }
    }

    public void changeLocalUserPassword(ByteBuffer login, String user, ByteBuffer password, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      changeLocalUserPassword_call method_call = new changeLocalUserPassword_call(login, user, password, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class changeLocalUserPassword_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer login;
      private String user;
      private ByteBuffer password;
      public changeLocalUserPassword_call(ByteBuffer login, String user, ByteBuffer password, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.login = login;
        this.user = user;
        this.password = password;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("changeLocalUserPassword", org.apache.thrift.protocol.TMessageType.CALL, 0));
        changeLocalUserPassword_args args = new changeLocalUserPassword_args();
        args.setLogin(login);
        args.setUser(user);
        args.setPassword(password);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws AccumuloException, AccumuloSecurityException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_changeLocalUserPassword();
      }
    }

    public void createLocalUser(ByteBuffer login, String user, ByteBuffer password, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      createLocalUser_call method_call = new createLocalUser_call(login, user, password, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class createLocalUser_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer login;
      private String user;
      private ByteBuffer password;
      public createLocalUser_call(ByteBuffer login, String user, ByteBuffer password, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.login = login;
        this.user = user;
        this.password = password;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("createLocalUser", org.apache.thrift.protocol.TMessageType.CALL, 0));
        createLocalUser_args args = new createLocalUser_args();
        args.setLogin(login);
        args.setUser(user);
        args.setPassword(password);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws AccumuloException, AccumuloSecurityException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_createLocalUser();
      }
    }

    public void dropLocalUser(ByteBuffer login, String user, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      dropLocalUser_call method_call = new dropLocalUser_call(login, user, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class dropLocalUser_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer login;
      private String user;
      public dropLocalUser_call(ByteBuffer login, String user, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.login = login;
        this.user = user;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("dropLocalUser", org.apache.thrift.protocol.TMessageType.CALL, 0));
        dropLocalUser_args args = new dropLocalUser_args();
        args.setLogin(login);
        args.setUser(user);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws AccumuloException, AccumuloSecurityException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_dropLocalUser();
      }
    }

    public void getUserAuthorizations(ByteBuffer login, String user, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getUserAuthorizations_call method_call = new getUserAuthorizations_call(login, user, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getUserAuthorizations_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer login;
      private String user;
      public getUserAuthorizations_call(ByteBuffer login, String user, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.login = login;
        this.user = user;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getUserAuthorizations", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getUserAuthorizations_args args = new getUserAuthorizations_args();
        args.setLogin(login);
        args.setUser(user);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<ByteBuffer> getResult() throws AccumuloException, AccumuloSecurityException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getUserAuthorizations();
      }
    }

    public void grantSystemPermission(ByteBuffer login, String user, SystemPermission perm, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      grantSystemPermission_call method_call = new grantSystemPermission_call(login, user, perm, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class grantSystemPermission_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer login;
      private String user;
      private SystemPermission perm;
      public grantSystemPermission_call(ByteBuffer login, String user, SystemPermission perm, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.login = login;
        this.user = user;
        this.perm = perm;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("grantSystemPermission", org.apache.thrift.protocol.TMessageType.CALL, 0));
        grantSystemPermission_args args = new grantSystemPermission_args();
        args.setLogin(login);
        args.setUser(user);
        args.setPerm(perm);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws AccumuloException, AccumuloSecurityException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_grantSystemPermission();
      }
    }

    public void grantTablePermission(ByteBuffer login, String user, String table, TablePermission perm, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      grantTablePermission_call method_call = new grantTablePermission_call(login, user, table, perm, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class grantTablePermission_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer login;
      private String user;
      private String table;
      private TablePermission perm;
      public grantTablePermission_call(ByteBuffer login, String user, String table, TablePermission perm, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.login = login;
        this.user = user;
        this.table = table;
        this.perm = perm;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("grantTablePermission", org.apache.thrift.protocol.TMessageType.CALL, 0));
        grantTablePermission_args args = new grantTablePermission_args();
        args.setLogin(login);
        args.setUser(user);
        args.setTable(table);
        args.setPerm(perm);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_grantTablePermission();
      }
    }

    public void hasSystemPermission(ByteBuffer login, String user, SystemPermission perm, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      hasSystemPermission_call method_call = new hasSystemPermission_call(login, user, perm, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class hasSystemPermission_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer login;
      private String user;
      private SystemPermission perm;
      public hasSystemPermission_call(ByteBuffer login, String user, SystemPermission perm, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.login = login;
        this.user = user;
        this.perm = perm;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("hasSystemPermission", org.apache.thrift.protocol.TMessageType.CALL, 0));
        hasSystemPermission_args args = new hasSystemPermission_args();
        args.setLogin(login);
        args.setUser(user);
        args.setPerm(perm);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws AccumuloException, AccumuloSecurityException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_hasSystemPermission();
      }
    }

    public void hasTablePermission(ByteBuffer login, String user, String table, TablePermission perm, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      hasTablePermission_call method_call = new hasTablePermission_call(login, user, table, perm, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class hasTablePermission_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer login;
      private String user;
      private String table;
      private TablePermission perm;
      public hasTablePermission_call(ByteBuffer login, String user, String table, TablePermission perm, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.login = login;
        this.user = user;
        this.table = table;
        this.perm = perm;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("hasTablePermission", org.apache.thrift.protocol.TMessageType.CALL, 0));
        hasTablePermission_args args = new hasTablePermission_args();
        args.setLogin(login);
        args.setUser(user);
        args.setTable(table);
        args.setPerm(perm);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_hasTablePermission();
      }
    }

    public void listLocalUsers(ByteBuffer login, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      listLocalUsers_call method_call = new listLocalUsers_call(login, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class listLocalUsers_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer login;
      public listLocalUsers_call(ByteBuffer login, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.login = login;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("listLocalUsers", org.apache.thrift.protocol.TMessageType.CALL, 0));
        listLocalUsers_args args = new listLocalUsers_args();
        args.setLogin(login);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Set<String> getResult() throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_listLocalUsers();
      }
    }

    public void revokeSystemPermission(ByteBuffer login, String user, SystemPermission perm, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      revokeSystemPermission_call method_call = new revokeSystemPermission_call(login, user, perm, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class revokeSystemPermission_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer login;
      private String user;
      private SystemPermission perm;
      public revokeSystemPermission_call(ByteBuffer login, String user, SystemPermission perm, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.login = login;
        this.user = user;
        this.perm = perm;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("revokeSystemPermission", org.apache.thrift.protocol.TMessageType.CALL, 0));
        revokeSystemPermission_args args = new revokeSystemPermission_args();
        args.setLogin(login);
        args.setUser(user);
        args.setPerm(perm);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws AccumuloException, AccumuloSecurityException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_revokeSystemPermission();
      }
    }

    public void revokeTablePermission(ByteBuffer login, String user, String table, TablePermission perm, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      revokeTablePermission_call method_call = new revokeTablePermission_call(login, user, table, perm, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class revokeTablePermission_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer login;
      private String user;
      private String table;
      private TablePermission perm;
      public revokeTablePermission_call(ByteBuffer login, String user, String table, TablePermission perm, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.login = login;
        this.user = user;
        this.table = table;
        this.perm = perm;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("revokeTablePermission", org.apache.thrift.protocol.TMessageType.CALL, 0));
        revokeTablePermission_args args = new revokeTablePermission_args();
        args.setLogin(login);
        args.setUser(user);
        args.setTable(table);
        args.setPerm(perm);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_revokeTablePermission();
      }
    }

    public void grantNamespacePermission(ByteBuffer login, String user, String namespaceName, NamespacePermission perm, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      grantNamespacePermission_call method_call = new grantNamespacePermission_call(login, user, namespaceName, perm, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class grantNamespacePermission_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer login;
      private String user;
      private String namespaceName;
      private NamespacePermission perm;
      public grantNamespacePermission_call(ByteBuffer login, String user, String namespaceName, NamespacePermission perm, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.login = login;
        this.user = user;
        this.namespaceName = namespaceName;
        this.perm = perm;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("grantNamespacePermission", org.apache.thrift.protocol.TMessageType.CALL, 0));
        grantNamespacePermission_args args = new grantNamespacePermission_args();
        args.setLogin(login);
        args.setUser(user);
        args.setNamespaceName(namespaceName);
        args.setPerm(perm);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws AccumuloException, AccumuloSecurityException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_grantNamespacePermission();
      }
    }

    public void hasNamespacePermission(ByteBuffer login, String user, String namespaceName, NamespacePermission perm, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      hasNamespacePermission_call method_call = new hasNamespacePermission_call(login, user, namespaceName, perm, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class hasNamespacePermission_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer login;
      private String user;
      private String namespaceName;
      private NamespacePermission perm;
      public hasNamespacePermission_call(ByteBuffer login, String user, String namespaceName, NamespacePermission perm, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.login = login;
        this.user = user;
        this.namespaceName = namespaceName;
        this.perm = perm;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("hasNamespacePermission", org.apache.thrift.protocol.TMessageType.CALL, 0));
        hasNamespacePermission_args args = new hasNamespacePermission_args();
        args.setLogin(login);
        args.setUser(user);
        args.setNamespaceName(namespaceName);
        args.setPerm(perm);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws AccumuloException, AccumuloSecurityException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_hasNamespacePermission();
      }
    }

    public void revokeNamespacePermission(ByteBuffer login, String user, String namespaceName, NamespacePermission perm, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      revokeNamespacePermission_call method_call = new revokeNamespacePermission_call(login, user, namespaceName, perm, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class revokeNamespacePermission_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer login;
      private String user;
      private String namespaceName;
      private NamespacePermission perm;
      public revokeNamespacePermission_call(ByteBuffer login, String user, String namespaceName, NamespacePermission perm, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.login = login;
        this.user = user;
        this.namespaceName = namespaceName;
        this.perm = perm;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("revokeNamespacePermission", org.apache.thrift.protocol.TMessageType.CALL, 0));
        revokeNamespacePermission_args args = new revokeNamespacePermission_args();
        args.setLogin(login);
        args.setUser(user);
        args.setNamespaceName(namespaceName);
        args.setPerm(perm);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws AccumuloException, AccumuloSecurityException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_revokeNamespacePermission();
      }
    }

    public void createBatchScanner(ByteBuffer login, String tableName, BatchScanOptions options, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      createBatchScanner_call method_call = new createBatchScanner_call(login, tableName, options, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class createBatchScanner_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer login;
      private String tableName;
      private BatchScanOptions options;
      public createBatchScanner_call(ByteBuffer login, String tableName, BatchScanOptions options, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.login = login;
        this.tableName = tableName;
        this.options = options;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("createBatchScanner", org.apache.thrift.protocol.TMessageType.CALL, 0));
        createBatchScanner_args args = new createBatchScanner_args();
        args.setLogin(login);
        args.setTableName(tableName);
        args.setOptions(options);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_createBatchScanner();
      }
    }

    public void createScanner(ByteBuffer login, String tableName, ScanOptions options, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      createScanner_call method_call = new createScanner_call(login, tableName, options, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class createScanner_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer login;
      private String tableName;
      private ScanOptions options;
      public createScanner_call(ByteBuffer login, String tableName, ScanOptions options, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.login = login;
        this.tableName = tableName;
        this.options = options;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("createScanner", org.apache.thrift.protocol.TMessageType.CALL, 0));
        createScanner_args args = new createScanner_args();
        args.setLogin(login);
        args.setTableName(tableName);
        args.setOptions(options);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_createScanner();
      }
    }

    public void hasNext(String scanner, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      hasNext_call method_call = new hasNext_call(scanner, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class hasNext_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String scanner;
      public hasNext_call(String scanner, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.scanner = scanner;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("hasNext", org.apache.thrift.protocol.TMessageType.CALL, 0));
        hasNext_args args = new hasNext_args();
        args.setScanner(scanner);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws UnknownScanner, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_hasNext();
      }
    }

    public void nextEntry(String scanner, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      nextEntry_call method_call = new nextEntry_call(scanner, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class nextEntry_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String scanner;
      public nextEntry_call(String scanner, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.scanner = scanner;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("nextEntry", org.apache.thrift.protocol.TMessageType.CALL, 0));
        nextEntry_args args = new nextEntry_args();
        args.setScanner(scanner);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public KeyValueAndPeek getResult() throws NoMoreEntriesException, UnknownScanner, AccumuloSecurityException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_nextEntry();
      }
    }

    public void nextK(String scanner, int k, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      nextK_call method_call = new nextK_call(scanner, k, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class nextK_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String scanner;
      private int k;
      public nextK_call(String scanner, int k, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.scanner = scanner;
        this.k = k;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("nextK", org.apache.thrift.protocol.TMessageType.CALL, 0));
        nextK_args args = new nextK_args();
        args.setScanner(scanner);
        args.setK(k);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public ScanResult getResult() throws NoMoreEntriesException, UnknownScanner, AccumuloSecurityException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_nextK();
      }
    }

    public void closeScanner(String scanner, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      closeScanner_call method_call = new closeScanner_call(scanner, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class closeScanner_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String scanner;
      public closeScanner_call(String scanner, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.scanner = scanner;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("closeScanner", org.apache.thrift.protocol.TMessageType.CALL, 0));
        closeScanner_args args = new closeScanner_args();
        args.setScanner(scanner);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws UnknownScanner, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_closeScanner();
      }
    }

    public void updateAndFlush(ByteBuffer login, String tableName, Map<ByteBuffer,List<ColumnUpdate>> cells, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      updateAndFlush_call method_call = new updateAndFlush_call(login, tableName, cells, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class updateAndFlush_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer login;
      private String tableName;
      private Map<ByteBuffer,List<ColumnUpdate>> cells;
      public updateAndFlush_call(ByteBuffer login, String tableName, Map<ByteBuffer,List<ColumnUpdate>> cells, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.login = login;
        this.tableName = tableName;
        this.cells = cells;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("updateAndFlush", org.apache.thrift.protocol.TMessageType.CALL, 0));
        updateAndFlush_args args = new updateAndFlush_args();
        args.setLogin(login);
        args.setTableName(tableName);
        args.setCells(cells);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws AccumuloException, AccumuloSecurityException, TableNotFoundException, MutationsRejectedException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_updateAndFlush();
      }
    }

    public void createWriter(ByteBuffer login, String tableName, WriterOptions opts, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      createWriter_call method_call = new createWriter_call(login, tableName, opts, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class createWriter_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer login;
      private String tableName;
      private WriterOptions opts;
      public createWriter_call(ByteBuffer login, String tableName, WriterOptions opts, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.login = login;
        this.tableName = tableName;
        this.opts = opts;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("createWriter", org.apache.thrift.protocol.TMessageType.CALL, 0));
        createWriter_args args = new createWriter_args();
        args.setLogin(login);
        args.setTableName(tableName);
        args.setOpts(opts);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_createWriter();
      }
    }

    public void update(String writer, Map<ByteBuffer,List<ColumnUpdate>> cells, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      update_call method_call = new update_call(writer, cells, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class update_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String writer;
      private Map<ByteBuffer,List<ColumnUpdate>> cells;
      public update_call(String writer, Map<ByteBuffer,List<ColumnUpdate>> cells, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, true);
        this.writer = writer;
        this.cells = cells;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("update", org.apache.thrift.protocol.TMessageType.ONEWAY, 0));
        update_args args = new update_args();
        args.setWriter(writer);
        args.setCells(cells);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
      }
    }

    public void flush(String writer, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      flush_call method_call = new flush_call(writer, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class flush_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String writer;
      public flush_call(String writer, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.writer = writer;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("flush", org.apache.thrift.protocol.TMessageType.CALL, 0));
        flush_args args = new flush_args();
        args.setWriter(writer);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws UnknownWriter, MutationsRejectedException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_flush();
      }
    }

    public void closeWriter(String writer, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      closeWriter_call method_call = new closeWriter_call(writer, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class closeWriter_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String writer;
      public closeWriter_call(String writer, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.writer = writer;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("closeWriter", org.apache.thrift.protocol.TMessageType.CALL, 0));
        closeWriter_args args = new closeWriter_args();
        args.setWriter(writer);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws UnknownWriter, MutationsRejectedException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_closeWriter();
      }
    }

    public void updateRowConditionally(ByteBuffer login, String tableName, ByteBuffer row, ConditionalUpdates updates, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      updateRowConditionally_call method_call = new updateRowConditionally_call(login, tableName, row, updates, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class updateRowConditionally_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer login;
      private String tableName;
      private ByteBuffer row;
      private ConditionalUpdates updates;
      public updateRowConditionally_call(ByteBuffer login, String tableName, ByteBuffer row, ConditionalUpdates updates, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.login = login;
        this.tableName = tableName;
        this.row = row;
        this.updates = updates;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("updateRowConditionally", org.apache.thrift.protocol.TMessageType.CALL, 0));
        updateRowConditionally_args args = new updateRowConditionally_args();
        args.setLogin(login);
        args.setTableName(tableName);
        args.setRow(row);
        args.setUpdates(updates);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public ConditionalStatus getResult() throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_updateRowConditionally();
      }
    }

    public void createConditionalWriter(ByteBuffer login, String tableName, ConditionalWriterOptions options, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      createConditionalWriter_call method_call = new createConditionalWriter_call(login, tableName, options, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class createConditionalWriter_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer login;
      private String tableName;
      private ConditionalWriterOptions options;
      public createConditionalWriter_call(ByteBuffer login, String tableName, ConditionalWriterOptions options, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.login = login;
        this.tableName = tableName;
        this.options = options;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("createConditionalWriter", org.apache.thrift.protocol.TMessageType.CALL, 0));
        createConditionalWriter_args args = new createConditionalWriter_args();
        args.setLogin(login);
        args.setTableName(tableName);
        args.setOptions(options);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws AccumuloException, AccumuloSecurityException, TableNotFoundException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_createConditionalWriter();
      }
    }

    public void updateRowsConditionally(String conditionalWriter, Map<ByteBuffer,ConditionalUpdates> updates, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      updateRowsConditionally_call method_call = new updateRowsConditionally_call(conditionalWriter, updates, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class updateRowsConditionally_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String conditionalWriter;
      private Map<ByteBuffer,ConditionalUpdates> updates;
      public updateRowsConditionally_call(String conditionalWriter, Map<ByteBuffer,ConditionalUpdates> updates, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.conditionalWriter = conditionalWriter;
        this.updates = updates;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("updateRowsConditionally", org.apache.thrift.protocol.TMessageType.CALL, 0));
        updateRowsConditionally_args args = new updateRowsConditionally_args();
        args.setConditionalWriter(conditionalWriter);
        args.setUpdates(updates);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Map<ByteBuffer,ConditionalStatus> getResult() throws UnknownWriter, AccumuloException, AccumuloSecurityException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_updateRowsConditionally();
      }
    }

    public void closeConditionalWriter(String conditionalWriter, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      closeConditionalWriter_call method_call = new closeConditionalWriter_call(conditionalWriter, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class closeConditionalWriter_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String conditionalWriter;
      public closeConditionalWriter_call(String conditionalWriter, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.conditionalWriter = conditionalWriter;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("closeConditionalWriter", org.apache.thrift.protocol.TMessageType.CALL, 0));
        closeConditionalWriter_args args = new closeConditionalWriter_args();
        args.setConditionalWriter(conditionalWriter);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_closeConditionalWriter();
      }
    }

    public void getRowRange(ByteBuffer row, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getRowRange_call method_call = new getRowRange_call(row, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getRowRange_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer row;
      public getRowRange_call(ByteBuffer row, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.row = row;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getRowRange", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getRowRange_args args = new getRowRange_args();
        args.setRow(row);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Range getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getRowRange();
      }
    }

    public void getFollowing(Key key, PartialKey part, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getFollowing_call method_call = new getFollowing_call(key, part, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getFollowing_call extends org.apache.thrift.async.TAsyncMethodCall {
      private Key key;
      private PartialKey part;
      public getFollowing_call(Key key, PartialKey part, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.key = key;
        this.part = part;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getFollowing", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getFollowing_args args = new getFollowing_args();
        args.setKey(key);
        args.setPart(part);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Key getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getFollowing();
      }
    }

    public void systemNamespace(org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      systemNamespace_call method_call = new systemNamespace_call(resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class systemNamespace_call extends org.apache.thrift.async.TAsyncMethodCall {
      public systemNamespace_call(org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("systemNamespace", org.apache.thrift.protocol.TMessageType.CALL, 0));
        systemNamespace_args args = new systemNamespace_args();
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_systemNamespace();
      }
    }

    public void defaultNamespace(org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      defaultNamespace_call method_call = new defaultNamespace_call(resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class defaultNamespace_call extends org.apache.thrift.async.TAsyncMethodCall {
      public defaultNamespace_call(org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("defaultNamespace", org.apache.thrift.protocol.TMessageType.CALL, 0));
        defaultNamespace_args args = new defaultNamespace_args();
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_defaultNamespace();
      }
    }

    public void listNamespaces(ByteBuffer login, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      listNamespaces_call method_call = new listNamespaces_call(login, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class listNamespaces_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer login;
      public listNamespaces_call(ByteBuffer login, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.login = login;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("listNamespaces", org.apache.thrift.protocol.TMessageType.CALL, 0));
        listNamespaces_args args = new listNamespaces_args();
        args.setLogin(login);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<String> getResult() throws AccumuloException, AccumuloSecurityException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_listNamespaces();
      }
    }

    public void namespaceExists(ByteBuffer login, String namespaceName, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      namespaceExists_call method_call = new namespaceExists_call(login, namespaceName, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class namespaceExists_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer login;
      private String namespaceName;
      public namespaceExists_call(ByteBuffer login, String namespaceName, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.login = login;
        this.namespaceName = namespaceName;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("namespaceExists", org.apache.thrift.protocol.TMessageType.CALL, 0));
        namespaceExists_args args = new namespaceExists_args();
        args.setLogin(login);
        args.setNamespaceName(namespaceName);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws AccumuloException, AccumuloSecurityException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_namespaceExists();
      }
    }

    public void createNamespace(ByteBuffer login, String namespaceName, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      createNamespace_call method_call = new createNamespace_call(login, namespaceName, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class createNamespace_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer login;
      private String namespaceName;
      public createNamespace_call(ByteBuffer login, String namespaceName, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.login = login;
        this.namespaceName = namespaceName;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("createNamespace", org.apache.thrift.protocol.TMessageType.CALL, 0));
        createNamespace_args args = new createNamespace_args();
        args.setLogin(login);
        args.setNamespaceName(namespaceName);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws AccumuloException, AccumuloSecurityException, NamespaceExistsException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_createNamespace();
      }
    }

    public void deleteNamespace(ByteBuffer login, String namespaceName, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      deleteNamespace_call method_call = new deleteNamespace_call(login, namespaceName, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class deleteNamespace_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer login;
      private String namespaceName;
      public deleteNamespace_call(ByteBuffer login, String namespaceName, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.login = login;
        this.namespaceName = namespaceName;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("deleteNamespace", org.apache.thrift.protocol.TMessageType.CALL, 0));
        deleteNamespace_args args = new deleteNamespace_args();
        args.setLogin(login);
        args.setNamespaceName(namespaceName);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws AccumuloException, AccumuloSecurityException, NamespaceNotFoundException, NamespaceNotEmptyException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_deleteNamespace();
      }
    }

    public void renameNamespace(ByteBuffer login, String oldNamespaceName, String newNamespaceName, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      renameNamespace_call method_call = new renameNamespace_call(login, oldNamespaceName, newNamespaceName, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class renameNamespace_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer login;
      private String oldNamespaceName;
      private String newNamespaceName;
      public renameNamespace_call(ByteBuffer login, String oldNamespaceName, String newNamespaceName, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.login = login;
        this.oldNamespaceName = oldNamespaceName;
        this.newNamespaceName = newNamespaceName;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("renameNamespace", org.apache.thrift.protocol.TMessageType.CALL, 0));
        renameNamespace_args args = new renameNamespace_args();
        args.setLogin(login);
        args.setOldNamespaceName(oldNamespaceName);
        args.setNewNamespaceName(newNamespaceName);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws AccumuloException, AccumuloSecurityException, NamespaceNotFoundException, NamespaceExistsException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_renameNamespace();
      }
    }

    public void setNamespaceProperty(ByteBuffer login, String namespaceName, String property, String value, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      setNamespaceProperty_call method_call = new setNamespaceProperty_call(login, namespaceName, property, value, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class setNamespaceProperty_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer login;
      private String namespaceName;
      private String property;
      private String value;
      public setNamespaceProperty_call(ByteBuffer login, String namespaceName, String property, String value, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.login = login;
        this.namespaceName = namespaceName;
        this.property = property;
        this.value = value;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("setNamespaceProperty", org.apache.thrift.protocol.TMessageType.CALL, 0));
        setNamespaceProperty_args args = new setNamespaceProperty_args();
        args.setLogin(login);
        args.setNamespaceName(namespaceName);
        args.setProperty(property);
        args.setValue(value);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws AccumuloException, AccumuloSecurityException, NamespaceNotFoundException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_setNamespaceProperty();
      }
    }

    public void removeNamespaceProperty(ByteBuffer login, String namespaceName, String property, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      removeNamespaceProperty_call method_call = new removeNamespaceProperty_call(login, namespaceName, property, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class removeNamespaceProperty_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer login;
      private String namespaceName;
      private String property;
      public removeNamespaceProperty_call(ByteBuffer login, String namespaceName, String property, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.login = login;
        this.namespaceName = namespaceName;
        this.property = property;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("removeNamespaceProperty", org.apache.thrift.protocol.TMessageType.CALL, 0));
        removeNamespaceProperty_args args = new removeNamespaceProperty_args();
        args.setLogin(login);
        args.setNamespaceName(namespaceName);
        args.setProperty(property);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws AccumuloException, AccumuloSecurityException, NamespaceNotFoundException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_removeNamespaceProperty();
      }
    }

    public void getNamespaceProperties(ByteBuffer login, String namespaceName, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getNamespaceProperties_call method_call = new getNamespaceProperties_call(login, namespaceName, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getNamespaceProperties_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer login;
      private String namespaceName;
      public getNamespaceProperties_call(ByteBuffer login, String namespaceName, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.login = login;
        this.namespaceName = namespaceName;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getNamespaceProperties", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getNamespaceProperties_args args = new getNamespaceProperties_args();
        args.setLogin(login);
        args.setNamespaceName(namespaceName);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Map<String,String> getResult() throws AccumuloException, AccumuloSecurityException, NamespaceNotFoundException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getNamespaceProperties();
      }
    }

    public void namespaceIdMap(ByteBuffer login, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      namespaceIdMap_call method_call = new namespaceIdMap_call(login, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class namespaceIdMap_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer login;
      public namespaceIdMap_call(ByteBuffer login, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.login = login;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("namespaceIdMap", org.apache.thrift.protocol.TMessageType.CALL, 0));
        namespaceIdMap_args args = new namespaceIdMap_args();
        args.setLogin(login);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Map<String,String> getResult() throws AccumuloException, AccumuloSecurityException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_namespaceIdMap();
      }
    }

    public void attachNamespaceIterator(ByteBuffer login, String namespaceName, IteratorSetting setting, Set<IteratorScope> scopes, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      attachNamespaceIterator_call method_call = new attachNamespaceIterator_call(login, namespaceName, setting, scopes, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class attachNamespaceIterator_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer login;
      private String namespaceName;
      private IteratorSetting setting;
      private Set<IteratorScope> scopes;
      public attachNamespaceIterator_call(ByteBuffer login, String namespaceName, IteratorSetting setting, Set<IteratorScope> scopes, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.login = login;
        this.namespaceName = namespaceName;
        this.setting = setting;
        this.scopes = scopes;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("attachNamespaceIterator", org.apache.thrift.protocol.TMessageType.CALL, 0));
        attachNamespaceIterator_args args = new attachNamespaceIterator_args();
        args.setLogin(login);
        args.setNamespaceName(namespaceName);
        args.setSetting(setting);
        args.setScopes(scopes);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws AccumuloException, AccumuloSecurityException, NamespaceNotFoundException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_attachNamespaceIterator();
      }
    }

    public void removeNamespaceIterator(ByteBuffer login, String namespaceName, String name, Set<IteratorScope> scopes, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      removeNamespaceIterator_call method_call = new removeNamespaceIterator_call(login, namespaceName, name, scopes, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class removeNamespaceIterator_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer login;
      private String namespaceName;
      private String name;
      private Set<IteratorScope> scopes;
      public removeNamespaceIterator_call(ByteBuffer login, String namespaceName, String name, Set<IteratorScope> scopes, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.login = login;
        this.namespaceName = namespaceName;
        this.name = name;
        this.scopes = scopes;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("removeNamespaceIterator", org.apache.thrift.protocol.TMessageType.CALL, 0));
        removeNamespaceIterator_args args = new removeNamespaceIterator_args();
        args.setLogin(login);
        args.setNamespaceName(namespaceName);
        args.setName(name);
        args.setScopes(scopes);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws AccumuloException, AccumuloSecurityException, NamespaceNotFoundException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_removeNamespaceIterator();
      }
    }

    public void getNamespaceIteratorSetting(ByteBuffer login, String namespaceName, String name, IteratorScope scope, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getNamespaceIteratorSetting_call method_call = new getNamespaceIteratorSetting_call(login, namespaceName, name, scope, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getNamespaceIteratorSetting_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer login;
      private String namespaceName;
      private String name;
      private IteratorScope scope;
      public getNamespaceIteratorSetting_call(ByteBuffer login, String namespaceName, String name, IteratorScope scope, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.login = login;
        this.namespaceName = namespaceName;
        this.name = name;
        this.scope = scope;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getNamespaceIteratorSetting", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getNamespaceIteratorSetting_args args = new getNamespaceIteratorSetting_args();
        args.setLogin(login);
        args.setNamespaceName(namespaceName);
        args.setName(name);
        args.setScope(scope);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public IteratorSetting getResult() throws AccumuloException, AccumuloSecurityException, NamespaceNotFoundException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getNamespaceIteratorSetting();
      }
    }

    public void listNamespaceIterators(ByteBuffer login, String namespaceName, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      listNamespaceIterators_call method_call = new listNamespaceIterators_call(login, namespaceName, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class listNamespaceIterators_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer login;
      private String namespaceName;
      public listNamespaceIterators_call(ByteBuffer login, String namespaceName, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.login = login;
        this.namespaceName = namespaceName;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("listNamespaceIterators", org.apache.thrift.protocol.TMessageType.CALL, 0));
        listNamespaceIterators_args args = new listNamespaceIterators_args();
        args.setLogin(login);
        args.setNamespaceName(namespaceName);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Map<String,Set<IteratorScope>> getResult() throws AccumuloException, AccumuloSecurityException, NamespaceNotFoundException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_listNamespaceIterators();
      }
    }

    public void checkNamespaceIteratorConflicts(ByteBuffer login, String namespaceName, IteratorSetting setting, Set<IteratorScope> scopes, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      checkNamespaceIteratorConflicts_call method_call = new checkNamespaceIteratorConflicts_call(login, namespaceName, setting, scopes, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class checkNamespaceIteratorConflicts_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer login;
      private String namespaceName;
      private IteratorSetting setting;
      private Set<IteratorScope> scopes;
      public checkNamespaceIteratorConflicts_call(ByteBuffer login, String namespaceName, IteratorSetting setting, Set<IteratorScope> scopes, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.login = login;
        this.namespaceName = namespaceName;
        this.setting = setting;
        this.scopes = scopes;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("checkNamespaceIteratorConflicts", org.apache.thrift.protocol.TMessageType.CALL, 0));
        checkNamespaceIteratorConflicts_args args = new checkNamespaceIteratorConflicts_args();
        args.setLogin(login);
        args.setNamespaceName(namespaceName);
        args.setSetting(setting);
        args.setScopes(scopes);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws AccumuloException, AccumuloSecurityException, NamespaceNotFoundException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_checkNamespaceIteratorConflicts();
      }
    }

    public void addNamespaceConstraint(ByteBuffer login, String namespaceName, String constraintClassName, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      addNamespaceConstraint_call method_call = new addNamespaceConstraint_call(login, namespaceName, constraintClassName, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class addNamespaceConstraint_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer login;
      private String namespaceName;
      private String constraintClassName;
      public addNamespaceConstraint_call(ByteBuffer login, String namespaceName, String constraintClassName, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.login = login;
        this.namespaceName = namespaceName;
        this.constraintClassName = constraintClassName;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("addNamespaceConstraint", org.apache.thrift.protocol.TMessageType.CALL, 0));
        addNamespaceConstraint_args args = new addNamespaceConstraint_args();
        args.setLogin(login);
        args.setNamespaceName(namespaceName);
        args.setConstraintClassName(constraintClassName);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public int getResult() throws AccumuloException, AccumuloSecurityException, NamespaceNotFoundException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_addNamespaceConstraint();
      }
    }

    public void removeNamespaceConstraint(ByteBuffer login, String namespaceName, int id, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      removeNamespaceConstraint_call method_call = new removeNamespaceConstraint_call(login, namespaceName, id, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class removeNamespaceConstraint_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer login;
      private String namespaceName;
      private int id;
      public removeNamespaceConstraint_call(ByteBuffer login, String namespaceName, int id, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.login = login;
        this.namespaceName = namespaceName;
        this.id = id;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("removeNamespaceConstraint", org.apache.thrift.protocol.TMessageType.CALL, 0));
        removeNamespaceConstraint_args args = new removeNamespaceConstraint_args();
        args.setLogin(login);
        args.setNamespaceName(namespaceName);
        args.setId(id);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws AccumuloException, AccumuloSecurityException, NamespaceNotFoundException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_removeNamespaceConstraint();
      }
    }

    public void listNamespaceConstraints(ByteBuffer login, String namespaceName, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      listNamespaceConstraints_call method_call = new listNamespaceConstraints_call(login, namespaceName, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class listNamespaceConstraints_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer login;
      private String namespaceName;
      public listNamespaceConstraints_call(ByteBuffer login, String namespaceName, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.login = login;
        this.namespaceName = namespaceName;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("listNamespaceConstraints", org.apache.thrift.protocol.TMessageType.CALL, 0));
        listNamespaceConstraints_args args = new listNamespaceConstraints_args();
        args.setLogin(login);
        args.setNamespaceName(namespaceName);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Map<String,Integer> getResult() throws AccumuloException, AccumuloSecurityException, NamespaceNotFoundException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_listNamespaceConstraints();
      }
    }

    public void testNamespaceClassLoad(ByteBuffer login, String namespaceName, String className, String asTypeName, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      testNamespaceClassLoad_call method_call = new testNamespaceClassLoad_call(login, namespaceName, className, asTypeName, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class testNamespaceClassLoad_call extends org.apache.thrift.async.TAsyncMethodCall {
      private ByteBuffer login;
      private String namespaceName;
      private String className;
      private String asTypeName;
      public testNamespaceClassLoad_call(ByteBuffer login, String namespaceName, String className, String asTypeName, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.login = login;
        this.namespaceName = namespaceName;
        this.className = className;
        this.asTypeName = asTypeName;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("testNamespaceClassLoad", org.apache.thrift.protocol.TMessageType.CALL, 0));
        testNamespaceClassLoad_args args = new testNamespaceClassLoad_args();
        args.setLogin(login);
        args.setNamespaceName(namespaceName);
        args.setClassName(className);
        args.setAsTypeName(asTypeName);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws AccumuloException, AccumuloSecurityException, NamespaceNotFoundException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_testNamespaceClassLoad();
      }
    }

  }

  public static class Processor<I extends Iface> extends org.apache.thrift.TBaseProcessor<I> implements org.apache.thrift.TProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(Processor.class.getName());
    public Processor(I iface) {
      super(iface, getProcessMap(new HashMap<String, org.apache.thrift.ProcessFunction<I, ? extends org.apache.thrift.TBase>>()));
    }

    protected Processor(I iface, Map<String,  org.apache.thrift.ProcessFunction<I, ? extends  org.apache.thrift.TBase>> processMap) {
      super(iface, getProcessMap(processMap));
    }

    private static <I extends Iface> Map<String,  org.apache.thrift.ProcessFunction<I, ? extends  org.apache.thrift.TBase>> getProcessMap(Map<String,  org.apache.thrift.ProcessFunction<I, ? extends  org.apache.thrift.TBase>> processMap) {
      processMap.put("login", new login());
      processMap.put("addConstraint", new addConstraint());
      processMap.put("addSplits", new addSplits());
      processMap.put("attachIterator", new attachIterator());
      processMap.put("checkIteratorConflicts", new checkIteratorConflicts());
      processMap.put("clearLocatorCache", new clearLocatorCache());
      processMap.put("cloneTable", new cloneTable());
      processMap.put("compactTable", new compactTable());
      processMap.put("cancelCompaction", new cancelCompaction());
      processMap.put("createTable", new createTable());
      processMap.put("deleteTable", new deleteTable());
      processMap.put("deleteRows", new deleteRows());
      processMap.put("exportTable", new exportTable());
      processMap.put("flushTable", new flushTable());
      processMap.put("getDiskUsage", new getDiskUsage());
      processMap.put("getLocalityGroups", new getLocalityGroups());
      processMap.put("getIteratorSetting", new getIteratorSetting());
      processMap.put("getMaxRow", new getMaxRow());
      processMap.put("getTableProperties", new getTableProperties());
      processMap.put("importDirectory", new importDirectory());
      processMap.put("importTable", new importTable());
      processMap.put("listSplits", new listSplits());
      processMap.put("listTables", new listTables());
      processMap.put("listIterators", new listIterators());
      processMap.put("listConstraints", new listConstraints());
      processMap.put("mergeTablets", new mergeTablets());
      processMap.put("offlineTable", new offlineTable());
      processMap.put("onlineTable", new onlineTable());
      processMap.put("removeConstraint", new removeConstraint());
      processMap.put("removeIterator", new removeIterator());
      processMap.put("removeTableProperty", new removeTableProperty());
      processMap.put("renameTable", new renameTable());
      processMap.put("setLocalityGroups", new setLocalityGroups());
      processMap.put("setTableProperty", new setTableProperty());
      processMap.put("splitRangeByTablets", new splitRangeByTablets());
      processMap.put("tableExists", new tableExists());
      processMap.put("tableIdMap", new tableIdMap());
      processMap.put("testTableClassLoad", new testTableClassLoad());
      processMap.put("pingTabletServer", new pingTabletServer());
      processMap.put("getActiveScans", new getActiveScans());
      processMap.put("getActiveCompactions", new getActiveCompactions());
      processMap.put("getSiteConfiguration", new getSiteConfiguration());
      processMap.put("getSystemConfiguration", new getSystemConfiguration());
      processMap.put("getTabletServers", new getTabletServers());
      processMap.put("removeProperty", new removeProperty());
      processMap.put("setProperty", new setProperty());
      processMap.put("testClassLoad", new testClassLoad());
      processMap.put("authenticateUser", new authenticateUser());
      processMap.put("changeUserAuthorizations", new changeUserAuthorizations());
      processMap.put("changeLocalUserPassword", new changeLocalUserPassword());
      processMap.put("createLocalUser", new createLocalUser());
      processMap.put("dropLocalUser", new dropLocalUser());
      processMap.put("getUserAuthorizations", new getUserAuthorizations());
      processMap.put("grantSystemPermission", new grantSystemPermission());
      processMap.put("grantTablePermission", new grantTablePermission());
      processMap.put("hasSystemPermission", new hasSystemPermission());
      processMap.put("hasTablePermission", new hasTablePermission());
      processMap.put("listLocalUsers", new listLocalUsers());
      processMap.put("revokeSystemPermission", new revokeSystemPermission());
      processMap.put("revokeTablePermission", new revokeTablePermission());
      processMap.put("grantNamespacePermission", new grantNamespacePermission());
      processMap.put("hasNamespacePermission", new hasNamespacePermission());
      processMap.put("revokeNamespacePermission", new revokeNamespacePermission());
      processMap.put("createBatchScanner", new createBatchScanner());
      processMap.put("createScanner", new createScanner());
      processMap.put("hasNext", new hasNext());
      processMap.put("nextEntry", new nextEntry());
      processMap.put("nextK", new nextK());
      processMap.put("closeScanner", new closeScanner());
      processMap.put("updateAndFlush", new updateAndFlush());
      processMap.put("createWriter", new createWriter());
      processMap.put("update", new update());
      processMap.put("flush", new flush());
      processMap.put("closeWriter", new closeWriter());
      processMap.put("updateRowConditionally", new updateRowConditionally());
      processMap.put("createConditionalWriter", new createConditionalWriter());
      processMap.put("updateRowsConditionally", new updateRowsConditionally());
      processMap.put("closeConditionalWriter", new closeConditionalWriter());
      processMap.put("getRowRange", new getRowRange());
      processMap.put("getFollowing", new getFollowing());
      processMap.put("systemNamespace", new systemNamespace());
      processMap.put("defaultNamespace", new defaultNamespace());
      processMap.put("listNamespaces", new listNamespaces());
      processMap.put("namespaceExists", new namespaceExists());
      processMap.put("createNamespace", new createNamespace());
      processMap.put("deleteNamespace", new deleteNamespace());
      processMap.put("renameNamespace", new renameNamespace());
      processMap.put("setNamespaceProperty", new setNamespaceProperty());
      processMap.put("removeNamespaceProperty", new removeNamespaceProperty());
      processMap.put("getNamespaceProperties", new getNamespaceProperties());
      processMap.put("namespaceIdMap", new namespaceIdMap());
      processMap.put("attachNamespaceIterator", new attachNamespaceIterator());
      processMap.put("removeNamespaceIterator", new removeNamespaceIterator());
      processMap.put("getNamespaceIteratorSetting", new getNamespaceIteratorSetting());
      processMap.put("listNamespaceIterators", new listNamespaceIterators());
      processMap.put("checkNamespaceIteratorConflicts", new checkNamespaceIteratorConflicts());
      processMap.put("addNamespaceConstraint", new addNamespaceConstraint());
      processMap.put("removeNamespaceConstraint", new removeNamespaceConstraint());
      processMap.put("listNamespaceConstraints", new listNamespaceConstraints());
      processMap.put("testNamespaceClassLoad", new testNamespaceClassLoad());
      return processMap;
    }

    public static class login<I extends Iface> extends org.apache.thrift.ProcessFunction<I, login_args> {
      public login() {
        super("login");
      }

      public login_args getEmptyArgsInstance() {
        return new login_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public login_result getResult(I iface, login_args args) throws org.apache.thrift.TException {
        login_result result = new login_result();
        try {
          result.success = iface.login(args.principal, args.loginProperties);
        } catch (AccumuloSecurityException ouch2) {
          result.ouch2 = ouch2;
        }
        return result;
      }
    }

    public static class addConstraint<I extends Iface> extends org.apache.thrift.ProcessFunction<I, addConstraint_args> {
      public addConstraint() {
        super("addConstraint");
      }

      public addConstraint_args getEmptyArgsInstance() {
        return new addConstraint_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public addConstraint_result getResult(I iface, addConstraint_args args) throws org.apache.thrift.TException {
        addConstraint_result result = new addConstraint_result();
        try {
          result.success = iface.addConstraint(args.login, args.tableName, args.constraintClassName);
          result.setSuccessIsSet(true);
        } catch (AccumuloException ouch1) {
          result.ouch1 = ouch1;
        } catch (AccumuloSecurityException ouch2) {
          result.ouch2 = ouch2;
        } catch (TableNotFoundException ouch3) {
          result.ouch3 = ouch3;
        }
        return result;
      }
    }

    public static class addSplits<I extends Iface> extends org.apache.thrift.ProcessFunction<I, addSplits_args> {
      public addSplits() {
        super("addSplits");
      }

      public addSplits_args getEmptyArgsInstance() {
        return new addSplits_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public addSplits_result getResult(I iface, addSplits_args args) throws org.apache.thrift.TException {
        addSplits_result result = new addSplits_result();
        try {
          iface.addSplits(args.login, args.tableName, args.splits);
        } catch (AccumuloException ouch1) {
          result.ouch1 = ouch1;
        } catch (AccumuloSecurityException ouch2) {
          result.ouch2 = ouch2;
        } catch (TableNotFoundException ouch3) {
          result.ouch3 = ouch3;
        }
        return result;
      }
    }

    public static class attachIterator<I extends Iface> extends org.apache.thrift.ProcessFunction<I, attachIterator_args> {
      public attachIterator() {
        super("attachIterator");
      }

      public attachIterator_args getEmptyArgsInstance() {
        return new attachIterator_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public attachIterator_result getResult(I iface, attachIterator_args args) throws org.apache.thrift.TException {
        attachIterator_result result = new attachIterator_result();
        try {
          iface.attachIterator(args.login, args.tableName, args.setting, args.scopes);
        } catch (AccumuloSecurityException ouch1) {
          result.ouch1 = ouch1;
        } catch (AccumuloException ouch2) {
          result.ouch2 = ouch2;
        } catch (TableNotFoundException ouch3) {
          result.ouch3 = ouch3;
        }
        return result;
      }
    }

    public static class checkIteratorConflicts<I extends Iface> extends org.apache.thrift.ProcessFunction<I, checkIteratorConflicts_args> {
      public checkIteratorConflicts() {
        super("checkIteratorConflicts");
      }

      public checkIteratorConflicts_args getEmptyArgsInstance() {
        return new checkIteratorConflicts_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public checkIteratorConflicts_result getResult(I iface, checkIteratorConflicts_args args) throws org.apache.thrift.TException {
        checkIteratorConflicts_result result = new checkIteratorConflicts_result();
        try {
          iface.checkIteratorConflicts(args.login, args.tableName, args.setting, args.scopes);
        } catch (AccumuloSecurityException ouch1) {
          result.ouch1 = ouch1;
        } catch (AccumuloException ouch2) {
          result.ouch2 = ouch2;
        } catch (TableNotFoundException ouch3) {
          result.ouch3 = ouch3;
        }
        return result;
      }
    }

    public static class clearLocatorCache<I extends Iface> extends org.apache.thrift.ProcessFunction<I, clearLocatorCache_args> {
      public clearLocatorCache() {
        super("clearLocatorCache");
      }

      public clearLocatorCache_args getEmptyArgsInstance() {
        return new clearLocatorCache_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public clearLocatorCache_result getResult(I iface, clearLocatorCache_args args) throws org.apache.thrift.TException {
        clearLocatorCache_result result = new clearLocatorCache_result();
        try {
          iface.clearLocatorCache(args.login, args.tableName);
        } catch (TableNotFoundException ouch1) {
          result.ouch1 = ouch1;
        }
        return result;
      }
    }

    public static class cloneTable<I extends Iface> extends org.apache.thrift.ProcessFunction<I, cloneTable_args> {
      public cloneTable() {
        super("cloneTable");
      }

      public cloneTable_args getEmptyArgsInstance() {
        return new cloneTable_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public cloneTable_result getResult(I iface, cloneTable_args args) throws org.apache.thrift.TException {
        cloneTable_result result = new cloneTable_result();
        try {
          iface.cloneTable(args.login, args.tableName, args.newTableName, args.flush, args.propertiesToSet, args.propertiesToExclude);
        } catch (AccumuloException ouch1) {
          result.ouch1 = ouch1;
        } catch (AccumuloSecurityException ouch2) {
          result.ouch2 = ouch2;
        } catch (TableNotFoundException ouch3) {
          result.ouch3 = ouch3;
        } catch (TableExistsException ouch4) {
          result.ouch4 = ouch4;
        }
        return result;
      }
    }

    public static class compactTable<I extends Iface> extends org.apache.thrift.ProcessFunction<I, compactTable_args> {
      public compactTable() {
        super("compactTable");
      }

      public compactTable_args getEmptyArgsInstance() {
        return new compactTable_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public compactTable_result getResult(I iface, compactTable_args args) throws org.apache.thrift.TException {
        compactTable_result result = new compactTable_result();
        try {
          iface.compactTable(args.login, args.tableName, args.startRow, args.endRow, args.iterators, args.flush, args.wait, args.compactionStrategy);
        } catch (AccumuloSecurityException ouch1) {
          result.ouch1 = ouch1;
        } catch (TableNotFoundException ouch2) {
          result.ouch2 = ouch2;
        } catch (AccumuloException ouch3) {
          result.ouch3 = ouch3;
        }
        return result;
      }
    }

    public static class cancelCompaction<I extends Iface> extends org.apache.thrift.ProcessFunction<I, cancelCompaction_args> {
      public cancelCompaction() {
        super("cancelCompaction");
      }

      public cancelCompaction_args getEmptyArgsInstance() {
        return new cancelCompaction_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public cancelCompaction_result getResult(I iface, cancelCompaction_args args) throws org.apache.thrift.TException {
        cancelCompaction_result result = new cancelCompaction_result();
        try {
          iface.cancelCompaction(args.login, args.tableName);
        } catch (AccumuloSecurityException ouch1) {
          result.ouch1 = ouch1;
        } catch (TableNotFoundException ouch2) {
          result.ouch2 = ouch2;
        } catch (AccumuloException ouch3) {
          result.ouch3 = ouch3;
        }
        return result;
      }
    }

    public static class createTable<I extends Iface> extends org.apache.thrift.ProcessFunction<I, createTable_args> {
      public createTable() {
        super("createTable");
      }

      public createTable_args getEmptyArgsInstance() {
        return new createTable_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public createTable_result getResult(I iface, createTable_args args) throws org.apache.thrift.TException {
        createTable_result result = new createTable_result();
        try {
          iface.createTable(args.login, args.tableName, args.versioningIter, args.type);
        } catch (AccumuloException ouch1) {
          result.ouch1 = ouch1;
        } catch (AccumuloSecurityException ouch2) {
          result.ouch2 = ouch2;
        } catch (TableExistsException ouch3) {
          result.ouch3 = ouch3;
        }
        return result;
      }
    }

    public static class deleteTable<I extends Iface> extends org.apache.thrift.ProcessFunction<I, deleteTable_args> {
      public deleteTable() {
        super("deleteTable");
      }

      public deleteTable_args getEmptyArgsInstance() {
        return new deleteTable_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public deleteTable_result getResult(I iface, deleteTable_args args) throws org.apache.thrift.TException {
        deleteTable_result result = new deleteTable_result();
        try {
          iface.deleteTable(args.login, args.tableName);
        } catch (AccumuloException ouch1) {
          result.ouch1 = ouch1;
        } catch (AccumuloSecurityException ouch2) {
          result.ouch2 = ouch2;
        } catch (TableNotFoundException ouch3) {
          result.ouch3 = ouch3;
        }
        return result;
      }
    }

    public static class deleteRows<I extends Iface> extends org.apache.thrift.ProcessFunction<I, deleteRows_args> {
      public deleteRows() {
        super("deleteRows");
      }

      public deleteRows_args getEmptyArgsInstance() {
        return new deleteRows_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public deleteRows_result getResult(I iface, deleteRows_args args) throws org.apache.thrift.TException {
        deleteRows_result result = new deleteRows_result();
        try {
          iface.deleteRows(args.login, args.tableName, args.startRow, args.endRow);
        } catch (AccumuloException ouch1) {
          result.ouch1 = ouch1;
        } catch (AccumuloSecurityException ouch2) {
          result.ouch2 = ouch2;
        } catch (TableNotFoundException ouch3) {
          result.ouch3 = ouch3;
        }
        return result;
      }
    }

    public static class exportTable<I extends Iface> extends org.apache.thrift.ProcessFunction<I, exportTable_args> {
      public exportTable() {
        super("exportTable");
      }

      public exportTable_args getEmptyArgsInstance() {
        return new exportTable_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public exportTable_result getResult(I iface, exportTable_args args) throws org.apache.thrift.TException {
        exportTable_result result = new exportTable_result();
        try {
          iface.exportTable(args.login, args.tableName, args.exportDir);
        } catch (AccumuloException ouch1) {
          result.ouch1 = ouch1;
        } catch (AccumuloSecurityException ouch2) {
          result.ouch2 = ouch2;
        } catch (TableNotFoundException ouch3) {
          result.ouch3 = ouch3;
        }
        return result;
      }
    }

    public static class flushTable<I extends Iface> extends org.apache.thrift.ProcessFunction<I, flushTable_args> {
      public flushTable() {
        super("flushTable");
      }

      public flushTable_args getEmptyArgsInstance() {
        return new flushTable_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public flushTable_result getResult(I iface, flushTable_args args) throws org.apache.thrift.TException {
        flushTable_result result = new flushTable_result();
        try {
          iface.flushTable(args.login, args.tableName, args.startRow, args.endRow, args.wait);
        } catch (AccumuloException ouch1) {
          result.ouch1 = ouch1;
        } catch (AccumuloSecurityException ouch2) {
          result.ouch2 = ouch2;
        } catch (TableNotFoundException ouch3) {
          result.ouch3 = ouch3;
        }
        return result;
      }
    }

    public static class getDiskUsage<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getDiskUsage_args> {
      public getDiskUsage() {
        super("getDiskUsage");
      }

      public getDiskUsage_args getEmptyArgsInstance() {
        return new getDiskUsage_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getDiskUsage_result getResult(I iface, getDiskUsage_args args) throws org.apache.thrift.TException {
        getDiskUsage_result result = new getDiskUsage_result();
        try {
          result.success = iface.getDiskUsage(args.login, args.tables);
        } catch (AccumuloException ouch1) {
          result.ouch1 = ouch1;
        } catch (AccumuloSecurityException ouch2) {
          result.ouch2 = ouch2;
        } catch (TableNotFoundException ouch3) {
          result.ouch3 = ouch3;
        }
        return result;
      }
    }

    public static class getLocalityGroups<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getLocalityGroups_args> {
      public getLocalityGroups() {
        super("getLocalityGroups");
      }

      public getLocalityGroups_args getEmptyArgsInstance() {
        return new getLocalityGroups_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getLocalityGroups_result getResult(I iface, getLocalityGroups_args args) throws org.apache.thrift.TException {
        getLocalityGroups_result result = new getLocalityGroups_result();
        try {
          result.success = iface.getLocalityGroups(args.login, args.tableName);
        } catch (AccumuloException ouch1) {
          result.ouch1 = ouch1;
        } catch (AccumuloSecurityException ouch2) {
          result.ouch2 = ouch2;
        } catch (TableNotFoundException ouch3) {
          result.ouch3 = ouch3;
        }
        return result;
      }
    }

    public static class getIteratorSetting<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getIteratorSetting_args> {
      public getIteratorSetting() {
        super("getIteratorSetting");
      }

      public getIteratorSetting_args getEmptyArgsInstance() {
        return new getIteratorSetting_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getIteratorSetting_result getResult(I iface, getIteratorSetting_args args) throws org.apache.thrift.TException {
        getIteratorSetting_result result = new getIteratorSetting_result();
        try {
          result.success = iface.getIteratorSetting(args.login, args.tableName, args.iteratorName, args.scope);
        } catch (AccumuloException ouch1) {
          result.ouch1 = ouch1;
        } catch (AccumuloSecurityException ouch2) {
          result.ouch2 = ouch2;
        } catch (TableNotFoundException ouch3) {
          result.ouch3 = ouch3;
        }
        return result;
      }
    }

    public static class getMaxRow<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getMaxRow_args> {
      public getMaxRow() {
        super("getMaxRow");
      }

      public getMaxRow_args getEmptyArgsInstance() {
        return new getMaxRow_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getMaxRow_result getResult(I iface, getMaxRow_args args) throws org.apache.thrift.TException {
        getMaxRow_result result = new getMaxRow_result();
        try {
          result.success = iface.getMaxRow(args.login, args.tableName, args.auths, args.startRow, args.startInclusive, args.endRow, args.endInclusive);
        } catch (AccumuloException ouch1) {
          result.ouch1 = ouch1;
        } catch (AccumuloSecurityException ouch2) {
          result.ouch2 = ouch2;
        } catch (TableNotFoundException ouch3) {
          result.ouch3 = ouch3;
        }
        return result;
      }
    }

    public static class getTableProperties<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getTableProperties_args> {
      public getTableProperties() {
        super("getTableProperties");
      }

      public getTableProperties_args getEmptyArgsInstance() {
        return new getTableProperties_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getTableProperties_result getResult(I iface, getTableProperties_args args) throws org.apache.thrift.TException {
        getTableProperties_result result = new getTableProperties_result();
        try {
          result.success = iface.getTableProperties(args.login, args.tableName);
        } catch (AccumuloException ouch1) {
          result.ouch1 = ouch1;
        } catch (AccumuloSecurityException ouch2) {
          result.ouch2 = ouch2;
        } catch (TableNotFoundException ouch3) {
          result.ouch3 = ouch3;
        }
        return result;
      }
    }

    public static class importDirectory<I extends Iface> extends org.apache.thrift.ProcessFunction<I, importDirectory_args> {
      public importDirectory() {
        super("importDirectory");
      }

      public importDirectory_args getEmptyArgsInstance() {
        return new importDirectory_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public importDirectory_result getResult(I iface, importDirectory_args args) throws org.apache.thrift.TException {
        importDirectory_result result = new importDirectory_result();
        try {
          iface.importDirectory(args.login, args.tableName, args.importDir, args.failureDir, args.setTime);
        } catch (TableNotFoundException ouch1) {
          result.ouch1 = ouch1;
        } catch (AccumuloException ouch3) {
          result.ouch3 = ouch3;
        } catch (AccumuloSecurityException ouch4) {
          result.ouch4 = ouch4;
        }
        return result;
      }
    }

    public static class importTable<I extends Iface> extends org.apache.thrift.ProcessFunction<I, importTable_args> {
      public importTable() {
        super("importTable");
      }

      public importTable_args getEmptyArgsInstance() {
        return new importTable_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public importTable_result getResult(I iface, importTable_args args) throws org.apache.thrift.TException {
        importTable_result result = new importTable_result();
        try {
          iface.importTable(args.login, args.tableName, args.importDir);
        } catch (TableExistsException ouch1) {
          result.ouch1 = ouch1;
        } catch (AccumuloException ouch2) {
          result.ouch2 = ouch2;
        } catch (AccumuloSecurityException ouch3) {
          result.ouch3 = ouch3;
        }
        return result;
      }
    }

    public static class listSplits<I extends Iface> extends org.apache.thrift.ProcessFunction<I, listSplits_args> {
      public listSplits() {
        super("listSplits");
      }

      public listSplits_args getEmptyArgsInstance() {
        return new listSplits_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public listSplits_result getResult(I iface, listSplits_args args) throws org.apache.thrift.TException {
        listSplits_result result = new listSplits_result();
        try {
          result.success = iface.listSplits(args.login, args.tableName, args.maxSplits);
        } catch (AccumuloException ouch1) {
          result.ouch1 = ouch1;
        } catch (AccumuloSecurityException ouch2) {
          result.ouch2 = ouch2;
        } catch (TableNotFoundException ouch3) {
          result.ouch3 = ouch3;
        }
        return result;
      }
    }

    public static class listTables<I extends Iface> extends org.apache.thrift.ProcessFunction<I, listTables_args> {
      public listTables() {
        super("listTables");
      }

      public listTables_args getEmptyArgsInstance() {
        return new listTables_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public listTables_result getResult(I iface, listTables_args args) throws org.apache.thrift.TException {
        listTables_result result = new listTables_result();
        result.success = iface.listTables(args.login);
        return result;
      }
    }

    public static class listIterators<I extends Iface> extends org.apache.thrift.ProcessFunction<I, listIterators_args> {
      public listIterators() {
        super("listIterators");
      }

      public listIterators_args getEmptyArgsInstance() {
        return new listIterators_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public listIterators_result getResult(I iface, listIterators_args args) throws org.apache.thrift.TException {
        listIterators_result result = new listIterators_result();
        try {
          result.success = iface.listIterators(args.login, args.tableName);
        } catch (AccumuloException ouch1) {
          result.ouch1 = ouch1;
        } catch (AccumuloSecurityException ouch2) {
          result.ouch2 = ouch2;
        } catch (TableNotFoundException ouch3) {
          result.ouch3 = ouch3;
        }
        return result;
      }
    }

    public static class listConstraints<I extends Iface> extends org.apache.thrift.ProcessFunction<I, listConstraints_args> {
      public listConstraints() {
        super("listConstraints");
      }

      public listConstraints_args getEmptyArgsInstance() {
        return new listConstraints_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public listConstraints_result getResult(I iface, listConstraints_args args) throws org.apache.thrift.TException {
        listConstraints_result result = new listConstraints_result();
        try {
          result.success = iface.listConstraints(args.login, args.tableName);
        } catch (AccumuloException ouch1) {
          result.ouch1 = ouch1;
        } catch (AccumuloSecurityException ouch2) {
          result.ouch2 = ouch2;
        } catch (TableNotFoundException ouch3) {
          result.ouch3 = ouch3;
        }
        return result;
      }
    }

    public static class mergeTablets<I extends Iface> extends org.apache.thrift.ProcessFunction<I, mergeTablets_args> {
      public mergeTablets() {
        super("mergeTablets");
      }

      public mergeTablets_args getEmptyArgsInstance() {
        return new mergeTablets_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public mergeTablets_result getResult(I iface, mergeTablets_args args) throws org.apache.thrift.TException {
        mergeTablets_result result = new mergeTablets_result();
        try {
          iface.mergeTablets(args.login, args.tableName, args.startRow, args.endRow);
        } catch (AccumuloException ouch1) {
          result.ouch1 = ouch1;
        } catch (AccumuloSecurityException ouch2) {
          result.ouch2 = ouch2;
        } catch (TableNotFoundException ouch3) {
          result.ouch3 = ouch3;
        }
        return result;
      }
    }

    public static class offlineTable<I extends Iface> extends org.apache.thrift.ProcessFunction<I, offlineTable_args> {
      public offlineTable() {
        super("offlineTable");
      }

      public offlineTable_args getEmptyArgsInstance() {
        return new offlineTable_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public offlineTable_result getResult(I iface, offlineTable_args args) throws org.apache.thrift.TException {
        offlineTable_result result = new offlineTable_result();
        try {
          iface.offlineTable(args.login, args.tableName, args.wait);
        } catch (AccumuloException ouch1) {
          result.ouch1 = ouch1;
        } catch (AccumuloSecurityException ouch2) {
          result.ouch2 = ouch2;
        } catch (TableNotFoundException ouch3) {
          result.ouch3 = ouch3;
        }
        return result;
      }
    }

    public static class onlineTable<I extends Iface> extends org.apache.thrift.ProcessFunction<I, onlineTable_args> {
      public onlineTable() {
        super("onlineTable");
      }

      public onlineTable_args getEmptyArgsInstance() {
        return new onlineTable_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public onlineTable_result getResult(I iface, onlineTable_args args) throws org.apache.thrift.TException {
        onlineTable_result result = new onlineTable_result();
        try {
          iface.onlineTable(args.login, args.tableName, args.wait);
        } catch (AccumuloException ouch1) {
          result.ouch1 = ouch1;
        } catch (AccumuloSecurityException ouch2) {
          result.ouch2 = ouch2;
        } catch (TableNotFoundException ouch3) {
          result.ouch3 = ouch3;
        }
        return result;
      }
    }

    public static class removeConstraint<I extends Iface> extends org.apache.thrift.ProcessFunction<I, removeConstraint_args> {
      public removeConstraint() {
        super("removeConstraint");
      }

      public removeConstraint_args getEmptyArgsInstance() {
        return new removeConstraint_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public removeConstraint_result getResult(I iface, removeConstraint_args args) throws org.apache.thrift.TException {
        removeConstraint_result result = new removeConstraint_result();
        try {
          iface.removeConstraint(args.login, args.tableName, args.constraint);
        } catch (AccumuloException ouch1) {
          result.ouch1 = ouch1;
        } catch (AccumuloSecurityException ouch2) {
          result.ouch2 = ouch2;
        } catch (TableNotFoundException ouch3) {
          result.ouch3 = ouch3;
        }
        return result;
      }
    }

    public static class removeIterator<I extends Iface> extends org.apache.thrift.ProcessFunction<I, removeIterator_args> {
      public removeIterator() {
        super("removeIterator");
      }

      public removeIterator_args getEmptyArgsInstance() {
        return new removeIterator_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public removeIterator_result getResult(I iface, removeIterator_args args) throws org.apache.thrift.TException {
        removeIterator_result result = new removeIterator_result();
        try {
          iface.removeIterator(args.login, args.tableName, args.iterName, args.scopes);
        } catch (AccumuloException ouch1) {
          result.ouch1 = ouch1;
        } catch (AccumuloSecurityException ouch2) {
          result.ouch2 = ouch2;
        } catch (TableNotFoundException ouch3) {
          result.ouch3 = ouch3;
        }
        return result;
      }
    }

    public static class removeTableProperty<I extends Iface> extends org.apache.thrift.ProcessFunction<I, removeTableProperty_args> {
      public removeTableProperty() {
        super("removeTableProperty");
      }

      public removeTableProperty_args getEmptyArgsInstance() {
        return new removeTableProperty_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public removeTableProperty_result getResult(I iface, removeTableProperty_args args) throws org.apache.thrift.TException {
        removeTableProperty_result result = new removeTableProperty_result();
        try {
          iface.removeTableProperty(args.login, args.tableName, args.property);
        } catch (AccumuloException ouch1) {
          result.ouch1 = ouch1;
        } catch (AccumuloSecurityException ouch2) {
          result.ouch2 = ouch2;
        } catch (TableNotFoundException ouch3) {
          result.ouch3 = ouch3;
        }
        return result;
      }
    }

    public static class renameTable<I extends Iface> extends org.apache.thrift.ProcessFunction<I, renameTable_args> {
      public renameTable() {
        super("renameTable");
      }

      public renameTable_args getEmptyArgsInstance() {
        return new renameTable_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public renameTable_result getResult(I iface, renameTable_args args) throws org.apache.thrift.TException {
        renameTable_result result = new renameTable_result();
        try {
          iface.renameTable(args.login, args.oldTableName, args.newTableName);
        } catch (AccumuloException ouch1) {
          result.ouch1 = ouch1;
        } catch (AccumuloSecurityException ouch2) {
          result.ouch2 = ouch2;
        } catch (TableNotFoundException ouch3) {
          result.ouch3 = ouch3;
        } catch (TableExistsException ouch4) {
          result.ouch4 = ouch4;
        }
        return result;
      }
    }

    public static class setLocalityGroups<I extends Iface> extends org.apache.thrift.ProcessFunction<I, setLocalityGroups_args> {
      public setLocalityGroups() {
        super("setLocalityGroups");
      }

      public setLocalityGroups_args getEmptyArgsInstance() {
        return new setLocalityGroups_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public setLocalityGroups_result getResult(I iface, setLocalityGroups_args args) throws org.apache.thrift.TException {
        setLocalityGroups_result result = new setLocalityGroups_result();
        try {
          iface.setLocalityGroups(args.login, args.tableName, args.groups);
        } catch (AccumuloException ouch1) {
          result.ouch1 = ouch1;
        } catch (AccumuloSecurityException ouch2) {
          result.ouch2 = ouch2;
        } catch (TableNotFoundException ouch3) {
          result.ouch3 = ouch3;
        }
        return result;
      }
    }

    public static class setTableProperty<I extends Iface> extends org.apache.thrift.ProcessFunction<I, setTableProperty_args> {
      public setTableProperty() {
        super("setTableProperty");
      }

      public setTableProperty_args getEmptyArgsInstance() {
        return new setTableProperty_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public setTableProperty_result getResult(I iface, setTableProperty_args args) throws org.apache.thrift.TException {
        setTableProperty_result result = new setTableProperty_result();
        try {
          iface.setTableProperty(args.login, args.tableName, args.property, args.value);
        } catch (AccumuloException ouch1) {
          result.ouch1 = ouch1;
        } catch (AccumuloSecurityException ouch2) {
          result.ouch2 = ouch2;
        } catch (TableNotFoundException ouch3) {
          result.ouch3 = ouch3;
        }
        return result;
      }
    }

    public static class splitRangeByTablets<I extends Iface> extends org.apache.thrift.ProcessFunction<I, splitRangeByTablets_args> {
      public splitRangeByTablets() {
        super("splitRangeByTablets");
      }

      public splitRangeByTablets_args getEmptyArgsInstance() {
        return new splitRangeByTablets_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public splitRangeByTablets_result getResult(I iface, splitRangeByTablets_args args) throws org.apache.thrift.TException {
        splitRangeByTablets_result result = new splitRangeByTablets_result();
        try {
          result.success = iface.splitRangeByTablets(args.login, args.tableName, args.range, args.maxSplits);
        } catch (AccumuloException ouch1) {
          result.ouch1 = ouch1;
        } catch (AccumuloSecurityException ouch2) {
          result.ouch2 = ouch2;
        } catch (TableNotFoundException ouch3) {
          result.ouch3 = ouch3;
        }
        return result;
      }
    }

    public static class tableExists<I extends Iface> extends org.apache.thrift.ProcessFunction<I, tableExists_args> {
      public tableExists() {
        super("tableExists");
      }

      public tableExists_args getEmptyArgsInstance() {
        return new tableExists_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public tableExists_result getResult(I iface, tableExists_args args) throws org.apache.thrift.TException {
        tableExists_result result = new tableExists_result();
        result.success = iface.tableExists(args.login, args.tableName);
        result.setSuccessIsSet(true);
        return result;
      }
    }

    public static class tableIdMap<I extends Iface> extends org.apache.thrift.ProcessFunction<I, tableIdMap_args> {
      public tableIdMap() {
        super("tableIdMap");
      }

      public tableIdMap_args getEmptyArgsInstance() {
        return new tableIdMap_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public tableIdMap_result getResult(I iface, tableIdMap_args args) throws org.apache.thrift.TException {
        tableIdMap_result result = new tableIdMap_result();
        result.success = iface.tableIdMap(args.login);
        return result;
      }
    }

    public static class testTableClassLoad<I extends Iface> extends org.apache.thrift.ProcessFunction<I, testTableClassLoad_args> {
      public testTableClassLoad() {
        super("testTableClassLoad");
      }

      public testTableClassLoad_args getEmptyArgsInstance() {
        return new testTableClassLoad_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public testTableClassLoad_result getResult(I iface, testTableClassLoad_args args) throws org.apache.thrift.TException {
        testTableClassLoad_result result = new testTableClassLoad_result();
        try {
          result.success = iface.testTableClassLoad(args.login, args.tableName, args.className, args.asTypeName);
          result.setSuccessIsSet(true);
        } catch (AccumuloException ouch1) {
          result.ouch1 = ouch1;
        } catch (AccumuloSecurityException ouch2) {
          result.ouch2 = ouch2;
        } catch (TableNotFoundException ouch3) {
          result.ouch3 = ouch3;
        }
        return result;
      }
    }

    public static class pingTabletServer<I extends Iface> extends org.apache.thrift.ProcessFunction<I, pingTabletServer_args> {
      public pingTabletServer() {
        super("pingTabletServer");
      }

      public pingTabletServer_args getEmptyArgsInstance() {
        return new pingTabletServer_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public pingTabletServer_result getResult(I iface, pingTabletServer_args args) throws org.apache.thrift.TException {
        pingTabletServer_result result = new pingTabletServer_result();
        try {
          iface.pingTabletServer(args.login, args.tserver);
        } catch (AccumuloException ouch1) {
          result.ouch1 = ouch1;
        } catch (AccumuloSecurityException ouch2) {
          result.ouch2 = ouch2;
        }
        return result;
      }
    }

    public static class getActiveScans<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getActiveScans_args> {
      public getActiveScans() {
        super("getActiveScans");
      }

      public getActiveScans_args getEmptyArgsInstance() {
        return new getActiveScans_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getActiveScans_result getResult(I iface, getActiveScans_args args) throws org.apache.thrift.TException {
        getActiveScans_result result = new getActiveScans_result();
        try {
          result.success = iface.getActiveScans(args.login, args.tserver);
        } catch (AccumuloException ouch1) {
          result.ouch1 = ouch1;
        } catch (AccumuloSecurityException ouch2) {
          result.ouch2 = ouch2;
        }
        return result;
      }
    }

    public static class getActiveCompactions<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getActiveCompactions_args> {
      public getActiveCompactions() {
        super("getActiveCompactions");
      }

      public getActiveCompactions_args getEmptyArgsInstance() {
        return new getActiveCompactions_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getActiveCompactions_result getResult(I iface, getActiveCompactions_args args) throws org.apache.thrift.TException {
        getActiveCompactions_result result = new getActiveCompactions_result();
        try {
          result.success = iface.getActiveCompactions(args.login, args.tserver);
        } catch (AccumuloException ouch1) {
          result.ouch1 = ouch1;
        } catch (AccumuloSecurityException ouch2) {
          result.ouch2 = ouch2;
        }
        return result;
      }
    }

    public static class getSiteConfiguration<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getSiteConfiguration_args> {
      public getSiteConfiguration() {
        super("getSiteConfiguration");
      }

      public getSiteConfiguration_args getEmptyArgsInstance() {
        return new getSiteConfiguration_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getSiteConfiguration_result getResult(I iface, getSiteConfiguration_args args) throws org.apache.thrift.TException {
        getSiteConfiguration_result result = new getSiteConfiguration_result();
        try {
          result.success = iface.getSiteConfiguration(args.login);
        } catch (AccumuloException ouch1) {
          result.ouch1 = ouch1;
        } catch (AccumuloSecurityException ouch2) {
          result.ouch2 = ouch2;
        }
        return result;
      }
    }

    public static class getSystemConfiguration<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getSystemConfiguration_args> {
      public getSystemConfiguration() {
        super("getSystemConfiguration");
      }

      public getSystemConfiguration_args getEmptyArgsInstance() {
        return new getSystemConfiguration_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getSystemConfiguration_result getResult(I iface, getSystemConfiguration_args args) throws org.apache.thrift.TException {
        getSystemConfiguration_result result = new getSystemConfiguration_result();
        try {
          result.success = iface.getSystemConfiguration(args.login);
        } catch (AccumuloException ouch1) {
          result.ouch1 = ouch1;
        } catch (AccumuloSecurityException ouch2) {
          result.ouch2 = ouch2;
        }
        return result;
      }
    }

    public static class getTabletServers<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getTabletServers_args> {
      public getTabletServers() {
        super("getTabletServers");
      }

      public getTabletServers_args getEmptyArgsInstance() {
        return new getTabletServers_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getTabletServers_result getResult(I iface, getTabletServers_args args) throws org.apache.thrift.TException {
        getTabletServers_result result = new getTabletServers_result();
        result.success = iface.getTabletServers(args.login);
        return result;
      }
    }

    public static class removeProperty<I extends Iface> extends org.apache.thrift.ProcessFunction<I, removeProperty_args> {
      public removeProperty() {
        super("removeProperty");
      }

      public removeProperty_args getEmptyArgsInstance() {
        return new removeProperty_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public removeProperty_result getResult(I iface, removeProperty_args args) throws org.apache.thrift.TException {
        removeProperty_result result = new removeProperty_result();
        try {
          iface.removeProperty(args.login, args.property);
        } catch (AccumuloException ouch1) {
          result.ouch1 = ouch1;
        } catch (AccumuloSecurityException ouch2) {
          result.ouch2 = ouch2;
        }
        return result;
      }
    }

    public static class setProperty<I extends Iface> extends org.apache.thrift.ProcessFunction<I, setProperty_args> {
      public setProperty() {
        super("setProperty");
      }

      public setProperty_args getEmptyArgsInstance() {
        return new setProperty_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public setProperty_result getResult(I iface, setProperty_args args) throws org.apache.thrift.TException {
        setProperty_result result = new setProperty_result();
        try {
          iface.setProperty(args.login, args.property, args.value);
        } catch (AccumuloException ouch1) {
          result.ouch1 = ouch1;
        } catch (AccumuloSecurityException ouch2) {
          result.ouch2 = ouch2;
        }
        return result;
      }
    }

    public static class testClassLoad<I extends Iface> extends org.apache.thrift.ProcessFunction<I, testClassLoad_args> {
      public testClassLoad() {
        super("testClassLoad");
      }

      public testClassLoad_args getEmptyArgsInstance() {
        return new testClassLoad_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public testClassLoad_result getResult(I iface, testClassLoad_args args) throws org.apache.thrift.TException {
        testClassLoad_result result = new testClassLoad_result();
        try {
          result.success = iface.testClassLoad(args.login, args.className, args.asTypeName);
          result.setSuccessIsSet(true);
        } catch (AccumuloException ouch1) {
          result.ouch1 = ouch1;
        } catch (AccumuloSecurityException ouch2) {
          result.ouch2 = ouch2;
        }
        return result;
      }
    }

    public static class authenticateUser<I extends Iface> extends org.apache.thrift.ProcessFunction<I, authenticateUser_args> {
      public authenticateUser() {
        super("authenticateUser");
      }

      public authenticateUser_args getEmptyArgsInstance() {
        return new authenticateUser_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public authenticateUser_result getResult(I iface, authenticateUser_args args) throws org.apache.thrift.TException {
        authenticateUser_result result = new authenticateUser_result();
        try {
          result.success = iface.authenticateUser(args.login, args.user, args.properties);
          result.setSuccessIsSet(true);
        } catch (AccumuloException ouch1) {
          result.ouch1 = ouch1;
        } catch (AccumuloSecurityException ouch2) {
          result.ouch2 = ouch2;
        }
        return result;
      }
    }

    public static class changeUserAuthorizations<I extends Iface> extends org.apache.thrift.ProcessFunction<I, changeUserAuthorizations_args> {
      public changeUserAuthorizations() {
        super("changeUserAuthorizations");
      }

      public changeUserAuthorizations_args getEmptyArgsInstance() {
        return new changeUserAuthorizations_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public changeUserAuthorizations_result getResult(I iface, changeUserAuthorizations_args args) throws org.apache.thrift.TException {
        changeUserAuthorizations_result result = new changeUserAuthorizations_result();
        try {
          iface.changeUserAuthorizations(args.login, args.user, args.authorizations);
        } catch (AccumuloException ouch1) {
          result.ouch1 = ouch1;
        } catch (AccumuloSecurityException ouch2) {
          result.ouch2 = ouch2;
        }
        return result;
      }
    }

    public static class changeLocalUserPassword<I extends Iface> extends org.apache.thrift.ProcessFunction<I, changeLocalUserPassword_args> {
      public changeLocalUserPassword() {
        super("changeLocalUserPassword");
      }

      public changeLocalUserPassword_args getEmptyArgsInstance() {
        return new changeLocalUserPassword_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public changeLocalUserPassword_result getResult(I iface, changeLocalUserPassword_args args) throws org.apache.thrift.TException {
        changeLocalUserPassword_result result = new changeLocalUserPassword_result();
        try {
          iface.changeLocalUserPassword(args.login, args.user, args.password);
        } catch (AccumuloException ouch1) {
          result.ouch1 = ouch1;
        } catch (AccumuloSecurityException ouch2) {
          result.ouch2 = ouch2;
        }
        return result;
      }
    }

    public static class createLocalUser<I extends Iface> extends org.apache.thrift.ProcessFunction<I, createLocalUser_args> {
      public createLocalUser() {
        super("createLocalUser");
      }

      public createLocalUser_args getEmptyArgsInstance() {
        return new createLocalUser_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public createLocalUser_result getResult(I iface, createLocalUser_args args) throws org.apache.thrift.TException {
        createLocalUser_result result = new createLocalUser_result();
        try {
          iface.createLocalUser(args.login, args.user, args.password);
        } catch (AccumuloException ouch1) {
          result.ouch1 = ouch1;
        } catch (AccumuloSecurityException ouch2) {
          result.ouch2 = ouch2;
        }
        return result;
      }
    }

    public static class dropLocalUser<I extends Iface> extends org.apache.thrift.ProcessFunction<I, dropLocalUser_args> {
      public dropLocalUser() {
        super("dropLocalUser");
      }

      public dropLocalUser_args getEmptyArgsInstance() {
        return new dropLocalUser_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public dropLocalUser_result getResult(I iface, dropLocalUser_args args) throws org.apache.thrift.TException {
        dropLocalUser_result result = new dropLocalUser_result();
        try {
          iface.dropLocalUser(args.login, args.user);
        } catch (AccumuloException ouch1) {
          result.ouch1 = ouch1;
        } catch (AccumuloSecurityException ouch2) {
          result.ouch2 = ouch2;
        }
        return result;
      }
    }

    public static class getUserAuthorizations<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getUserAuthorizations_args> {
      public getUserAuthorizations() {
        super("getUserAuthorizations");
      }

      public getUserAuthorizations_args getEmptyArgsInstance() {
        return new getUserAuthorizations_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getUserAuthorizations_result getResult(I iface, getUserAuthorizations_args args) throws org.apache.thrift.TException {
        getUserAuthorizations_result result = new getUserAuthorizations_result();
        try {
          result.success = iface.getUserAuthorizations(args.login, args.user);
        } catch (AccumuloException ouch1) {
          result.ouch1 = ouch1;
        } catch (AccumuloSecurityException ouch2) {
          result.ouch2 = ouch2;
        }
        return result;
      }
    }

    public static class grantSystemPermission<I extends Iface> extends org.apache.thrift.ProcessFunction<I, grantSystemPermission_args> {
      public grantSystemPermission() {
        super("grantSystemPermission");
      }

      public grantSystemPermission_args getEmptyArgsInstance() {
        return new grantSystemPermission_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public grantSystemPermission_result getResult(I iface, grantSystemPermission_args args) throws org.apache.thrift.TException {
        grantSystemPermission_result result = new grantSystemPermission_result();
        try {
          iface.grantSystemPermission(args.login, args.user, args.perm);
        } catch (AccumuloException ouch1) {
          result.ouch1 = ouch1;
        } catch (AccumuloSecurityException ouch2) {
          result.ouch2 = ouch2;
        }
        return result;
      }
    }

    public static class grantTablePermission<I extends Iface> extends org.apache.thrift.ProcessFunction<I, grantTablePermission_args> {
      public grantTablePermission() {
        super("grantTablePermission");
      }

      public grantTablePermission_args getEmptyArgsInstance() {
        return new grantTablePermission_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public grantTablePermission_result getResult(I iface, grantTablePermission_args args) throws org.apache.thrift.TException {
        grantTablePermission_result result = new grantTablePermission_result();
        try {
          iface.grantTablePermission(args.login, args.user, args.table, args.perm);
        } catch (AccumuloException ouch1) {
          result.ouch1 = ouch1;
        } catch (AccumuloSecurityException ouch2) {
          result.ouch2 = ouch2;
        } catch (TableNotFoundException ouch3) {
          result.ouch3 = ouch3;
        }
        return result;
      }
    }

    public static class hasSystemPermission<I extends Iface> extends org.apache.thrift.ProcessFunction<I, hasSystemPermission_args> {
      public hasSystemPermission() {
        super("hasSystemPermission");
      }

      public hasSystemPermission_args getEmptyArgsInstance() {
        return new hasSystemPermission_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public hasSystemPermission_result getResult(I iface, hasSystemPermission_args args) throws org.apache.thrift.TException {
        hasSystemPermission_result result = new hasSystemPermission_result();
        try {
          result.success = iface.hasSystemPermission(args.login, args.user, args.perm);
          result.setSuccessIsSet(true);
        } catch (AccumuloException ouch1) {
          result.ouch1 = ouch1;
        } catch (AccumuloSecurityException ouch2) {
          result.ouch2 = ouch2;
        }
        return result;
      }
    }

    public static class hasTablePermission<I extends Iface> extends org.apache.thrift.ProcessFunction<I, hasTablePermission_args> {
      public hasTablePermission() {
        super("hasTablePermission");
      }

      public hasTablePermission_args getEmptyArgsInstance() {
        return new hasTablePermission_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public hasTablePermission_result getResult(I iface, hasTablePermission_args args) throws org.apache.thrift.TException {
        hasTablePermission_result result = new hasTablePermission_result();
        try {
          result.success = iface.hasTablePermission(args.login, args.user, args.table, args.perm);
          result.setSuccessIsSet(true);
        } catch (AccumuloException ouch1) {
          result.ouch1 = ouch1;
        } catch (AccumuloSecurityException ouch2) {
          result.ouch2 = ouch2;
        } catch (TableNotFoundException ouch3) {
          result.ouch3 = ouch3;
        }
        return result;
      }
    }

    public static class listLocalUsers<I extends Iface> extends org.apache.thrift.ProcessFunction<I, listLocalUsers_args> {
      public listLocalUsers() {
        super("listLocalUsers");
      }

      public listLocalUsers_args getEmptyArgsInstance() {
        return new listLocalUsers_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public listLocalUsers_result getResult(I iface, listLocalUsers_args args) throws org.apache.thrift.TException {
        listLocalUsers_result result = new listLocalUsers_result();
        try {
          result.success = iface.listLocalUsers(args.login);
        } catch (AccumuloException ouch1) {
          result.ouch1 = ouch1;
        } catch (AccumuloSecurityException ouch2) {
          result.ouch2 = ouch2;
        } catch (TableNotFoundException ouch3) {
          result.ouch3 = ouch3;
        }
        return result;
      }
    }

    public static class revokeSystemPermission<I extends Iface> extends org.apache.thrift.ProcessFunction<I, revokeSystemPermission_args> {
      public revokeSystemPermission() {
        super("revokeSystemPermission");
      }

      public revokeSystemPermission_args getEmptyArgsInstance() {
        return new revokeSystemPermission_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public revokeSystemPermission_result getResult(I iface, revokeSystemPermission_args args) throws org.apache.thrift.TException {
        revokeSystemPermission_result result = new revokeSystemPermission_result();
        try {
          iface.revokeSystemPermission(args.login, args.user, args.perm);
        } catch (AccumuloException ouch1) {
          result.ouch1 = ouch1;
        } catch (AccumuloSecurityException ouch2) {
          result.ouch2 = ouch2;
        }
        return result;
      }
    }

    public static class revokeTablePermission<I extends Iface> extends org.apache.thrift.ProcessFunction<I, revokeTablePermission_args> {
      public revokeTablePermission() {
        super("revokeTablePermission");
      }

      public revokeTablePermission_args getEmptyArgsInstance() {
        return new revokeTablePermission_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public revokeTablePermission_result getResult(I iface, revokeTablePermission_args args) throws org.apache.thrift.TException {
        revokeTablePermission_result result = new revokeTablePermission_result();
        try {
          iface.revokeTablePermission(args.login, args.user, args.table, args.perm);
        } catch (AccumuloException ouch1) {
          result.ouch1 = ouch1;
        } catch (AccumuloSecurityException ouch2) {
          result.ouch2 = ouch2;
        } catch (TableNotFoundException ouch3) {
          result.ouch3 = ouch3;
        }
        return result;
      }
    }

    public static class grantNamespacePermission<I extends Iface> extends org.apache.thrift.ProcessFunction<I, grantNamespacePermission_args> {
      public grantNamespacePermission() {
        super("grantNamespacePermission");
      }

      public grantNamespacePermission_args getEmptyArgsInstance() {
        return new grantNamespacePermission_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public grantNamespacePermission_result getResult(I iface, grantNamespacePermission_args args) throws org.apache.thrift.TException {
        grantNamespacePermission_result result = new grantNamespacePermission_result();
        try {
          iface.grantNamespacePermission(args.login, args.user, args.namespaceName, args.perm);
        } catch (AccumuloException ouch1) {
          result.ouch1 = ouch1;
        } catch (AccumuloSecurityException ouch2) {
          result.ouch2 = ouch2;
        }
        return result;
      }
    }

    public static class hasNamespacePermission<I extends Iface> extends org.apache.thrift.ProcessFunction<I, hasNamespacePermission_args> {
      public hasNamespacePermission() {
        super("hasNamespacePermission");
      }

      public hasNamespacePermission_args getEmptyArgsInstance() {
        return new hasNamespacePermission_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public hasNamespacePermission_result getResult(I iface, hasNamespacePermission_args args) throws org.apache.thrift.TException {
        hasNamespacePermission_result result = new hasNamespacePermission_result();
        try {
          result.success = iface.hasNamespacePermission(args.login, args.user, args.namespaceName, args.perm);
          result.setSuccessIsSet(true);
        } catch (AccumuloException ouch1) {
          result.ouch1 = ouch1;
        } catch (AccumuloSecurityException ouch2) {
          result.ouch2 = ouch2;
        }
        return result;
      }
    }

    public static class revokeNamespacePermission<I extends Iface> extends org.apache.thrift.ProcessFunction<I, revokeNamespacePermission_args> {
      public revokeNamespacePermission() {
        super("revokeNamespacePermission");
      }

      public revokeNamespacePermission_args getEmptyArgsInstance() {
        return new revokeNamespacePermission_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public revokeNamespacePermission_result getResult(I iface, revokeNamespacePermission_args args) throws org.apache.thrift.TException {
        revokeNamespacePermission_result result = new revokeNamespacePermission_result();
        try {
          iface.revokeNamespacePermission(args.login, args.user, args.namespaceName, args.perm);
        } catch (AccumuloException ouch1) {
          result.ouch1 = ouch1;
        } catch (AccumuloSecurityException ouch2) {
          result.ouch2 = ouch2;
        }
        return result;
      }
    }

    public static class createBatchScanner<I extends Iface> extends org.apache.thrift.ProcessFunction<I, createBatchScanner_args> {
      public createBatchScanner() {
        super("createBatchScanner");
      }

      public createBatchScanner_args getEmptyArgsInstance() {
        return new createBatchScanner_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public createBatchScanner_result getResult(I iface, createBatchScanner_args args) throws org.apache.thrift.TException {
        createBatchScanner_result result = new createBatchScanner_result();
        try {
          result.success = iface.createBatchScanner(args.login, args.tableName, args.options);
        } catch (AccumuloException ouch1) {
          result.ouch1 = ouch1;
        } catch (AccumuloSecurityException ouch2) {
          result.ouch2 = ouch2;
        } catch (TableNotFoundException ouch3) {
          result.ouch3 = ouch3;
        }
        return result;
      }
    }

    public static class createScanner<I extends Iface> extends org.apache.thrift.ProcessFunction<I, createScanner_args> {
      public createScanner() {
        super("createScanner");
      }

      public createScanner_args getEmptyArgsInstance() {
        return new createScanner_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public createScanner_result getResult(I iface, createScanner_args args) throws org.apache.thrift.TException {
        createScanner_result result = new createScanner_result();
        try {
          result.success = iface.createScanner(args.login, args.tableName, args.options);
        } catch (AccumuloException ouch1) {
          result.ouch1 = ouch1;
        } catch (AccumuloSecurityException ouch2) {
          result.ouch2 = ouch2;
        } catch (TableNotFoundException ouch3) {
          result.ouch3 = ouch3;
        }
        return result;
      }
    }

    public static class hasNext<I extends Iface> extends org.apache.thrift.ProcessFunction<I, hasNext_args> {
      public hasNext() {
        super("hasNext");
      }

      public hasNext_args getEmptyArgsInstance() {
        return new hasNext_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public hasNext_result getResult(I iface, hasNext_args args) throws org.apache.thrift.TException {
        hasNext_result result = new hasNext_result();
        try {
          result.success = iface.hasNext(args.scanner);
          result.setSuccessIsSet(true);
        } catch (UnknownScanner ouch1) {
          result.ouch1 = ouch1;
        }
        return result;
      }
    }

    public static class nextEntry<I extends Iface> extends org.apache.thrift.ProcessFunction<I, nextEntry_args> {
      public nextEntry() {
        super("nextEntry");
      }

      public nextEntry_args getEmptyArgsInstance() {
        return new nextEntry_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public nextEntry_result getResult(I iface, nextEntry_args args) throws org.apache.thrift.TException {
        nextEntry_result result = new nextEntry_result();
        try {
          result.success = iface.nextEntry(args.scanner);
        } catch (NoMoreEntriesException ouch1) {
          result.ouch1 = ouch1;
        } catch (UnknownScanner ouch2) {
          result.ouch2 = ouch2;
        } catch (AccumuloSecurityException ouch3) {
          result.ouch3 = ouch3;
        }
        return result;
      }
    }

    public static class nextK<I extends Iface> extends org.apache.thrift.ProcessFunction<I, nextK_args> {
      public nextK() {
        super("nextK");
      }

      public nextK_args getEmptyArgsInstance() {
        return new nextK_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public nextK_result getResult(I iface, nextK_args args) throws org.apache.thrift.TException {
        nextK_result result = new nextK_result();
        try {
          result.success = iface.nextK(args.scanner, args.k);
        } catch (NoMoreEntriesException ouch1) {
          result.ouch1 = ouch1;
        } catch (UnknownScanner ouch2) {
          result.ouch2 = ouch2;
        } catch (AccumuloSecurityException ouch3) {
          result.ouch3 = ouch3;
        }
        return result;
      }
    }

    public static class closeScanner<I extends Iface> extends org.apache.thrift.ProcessFunction<I, closeScanner_args> {
      public closeScanner() {
        super("closeScanner");
      }

      public closeScanner_args getEmptyArgsInstance() {
        return new closeScanner_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public closeScanner_result getResult(I iface, closeScanner_args args) throws org.apache.thrift.TException {
        closeScanner_result result = new closeScanner_result();
        try {
          iface.closeScanner(args.scanner);
        } catch (UnknownScanner ouch1) {
          result.ouch1 = ouch1;
        }
        return result;
      }
    }

    public static class updateAndFlush<I extends Iface> extends org.apache.thrift.ProcessFunction<I, updateAndFlush_args> {
      public updateAndFlush() {
        super("updateAndFlush");
      }

      public updateAndFlush_args getEmptyArgsInstance() {
        return new updateAndFlush_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public updateAndFlush_result getResult(I iface, updateAndFlush_args args) throws org.apache.thrift.TException {
        updateAndFlush_result result = new updateAndFlush_result();
        try {
          iface.updateAndFlush(args.login, args.tableName, args.cells);
        } catch (AccumuloException outch1) {
          result.outch1 = outch1;
        } catch (AccumuloSecurityException ouch2) {
          result.ouch2 = ouch2;
        } catch (TableNotFoundException ouch3) {
          result.ouch3 = ouch3;
        } catch (MutationsRejectedException ouch4) {
          result.ouch4 = ouch4;
        }
        return result;
      }
    }

    public static class createWriter<I extends Iface> extends org.apache.thrift.ProcessFunction<I, createWriter_args> {
      public createWriter() {
        super("createWriter");
      }

      public createWriter_args getEmptyArgsInstance() {
        return new createWriter_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public createWriter_result getResult(I iface, createWriter_args args) throws org.apache.thrift.TException {
        createWriter_result result = new createWriter_result();
        try {
          result.success = iface.createWriter(args.login, args.tableName, args.opts);
        } catch (AccumuloException outch1) {
          result.outch1 = outch1;
        } catch (AccumuloSecurityException ouch2) {
          result.ouch2 = ouch2;
        } catch (TableNotFoundException ouch3) {
          result.ouch3 = ouch3;
        }
        return result;
      }
    }

    public static class update<I extends Iface> extends org.apache.thrift.ProcessFunction<I, update_args> {
      public update() {
        super("update");
      }

      public update_args getEmptyArgsInstance() {
        return new update_args();
      }

      protected boolean isOneway() {
        return true;
      }

      public org.apache.thrift.TBase getResult(I iface, update_args args) throws org.apache.thrift.TException {
        iface.update(args.writer, args.cells);
        return null;
      }
    }

    public static class flush<I extends Iface> extends org.apache.thrift.ProcessFunction<I, flush_args> {
      public flush() {
        super("flush");
      }

      public flush_args getEmptyArgsInstance() {
        return new flush_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public flush_result getResult(I iface, flush_args args) throws org.apache.thrift.TException {
        flush_result result = new flush_result();
        try {
          iface.flush(args.writer);
        } catch (UnknownWriter ouch1) {
          result.ouch1 = ouch1;
        } catch (MutationsRejectedException ouch2) {
          result.ouch2 = ouch2;
        }
        return result;
      }
    }

    public static class closeWriter<I extends Iface> extends org.apache.thrift.ProcessFunction<I, closeWriter_args> {
      public closeWriter() {
        super("closeWriter");
      }

      public closeWriter_args getEmptyArgsInstance() {
        return new closeWriter_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public closeWriter_result getResult(I iface, closeWriter_args args) throws org.apache.thrift.TException {
        closeWriter_result result = new closeWriter_result();
        try {
          iface.closeWriter(args.writer);
        } catch (UnknownWriter ouch1) {
          result.ouch1 = ouch1;
        } catch (MutationsRejectedException ouch2) {
          result.ouch2 = ouch2;
        }
        return result;
      }
    }

    public static class updateRowConditionally<I extends Iface> extends org.apache.thrift.ProcessFunction<I, updateRowConditionally_args> {
      public updateRowConditionally() {
        super("updateRowConditionally");
      }

      public updateRowConditionally_args getEmptyArgsInstance() {
        return new updateRowConditionally_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public updateRowConditionally_result getResult(I iface, updateRowConditionally_args args) throws org.apache.thrift.TException {
        updateRowConditionally_result result = new updateRowConditionally_result();
        try {
          result.success = iface.updateRowConditionally(args.login, args.tableName, args.row, args.updates);
        } catch (AccumuloException ouch1) {
          result.ouch1 = ouch1;
        } catch (AccumuloSecurityException ouch2) {
          result.ouch2 = ouch2;
        } catch (TableNotFoundException ouch3) {
          result.ouch3 = ouch3;
        }
        return result;
      }
    }

    public static class createConditionalWriter<I extends Iface> extends org.apache.thrift.ProcessFunction<I, createConditionalWriter_args> {
      public createConditionalWriter() {
        super("createConditionalWriter");
      }

      public createConditionalWriter_args getEmptyArgsInstance() {
        return new createConditionalWriter_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public createConditionalWriter_result getResult(I iface, createConditionalWriter_args args) throws org.apache.thrift.TException {
        createConditionalWriter_result result = new createConditionalWriter_result();
        try {
          result.success = iface.createConditionalWriter(args.login, args.tableName, args.options);
        } catch (AccumuloException ouch1) {
          result.ouch1 = ouch1;
        } catch (AccumuloSecurityException ouch2) {
          result.ouch2 = ouch2;
        } catch (TableNotFoundException ouch3) {
          result.ouch3 = ouch3;
        }
        return result;
      }
    }

    public static class updateRowsConditionally<I extends Iface> extends org.apache.thrift.ProcessFunction<I, updateRowsConditionally_args> {
      public updateRowsConditionally() {
        super("updateRowsConditionally");
      }

      public updateRowsConditionally_args getEmptyArgsInstance() {
        return new updateRowsConditionally_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public updateRowsConditionally_result getResult(I iface, updateRowsConditionally_args args) throws org.apache.thrift.TException {
        updateRowsConditionally_result result = new updateRowsConditionally_result();
        try {
          result.success = iface.updateRowsConditionally(args.conditionalWriter, args.updates);
        } catch (UnknownWriter ouch1) {
          result.ouch1 = ouch1;
        } catch (AccumuloException ouch2) {
          result.ouch2 = ouch2;
        } catch (AccumuloSecurityException ouch3) {
          result.ouch3 = ouch3;
        }
        return result;
      }
    }

    public static class closeConditionalWriter<I extends Iface> extends org.apache.thrift.ProcessFunction<I, closeConditionalWriter_args> {
      public closeConditionalWriter() {
        super("closeConditionalWriter");
      }

      public closeConditionalWriter_args getEmptyArgsInstance() {
        return new closeConditionalWriter_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public closeConditionalWriter_result getResult(I iface, closeConditionalWriter_args args) throws org.apache.thrift.TException {
        closeConditionalWriter_result result = new closeConditionalWriter_result();
        iface.closeConditionalWriter(args.conditionalWriter);
        return result;
      }
    }

    public static class getRowRange<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getRowRange_args> {
      public getRowRange() {
        super("getRowRange");
      }

      public getRowRange_args getEmptyArgsInstance() {
        return new getRowRange_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getRowRange_result getResult(I iface, getRowRange_args args) throws org.apache.thrift.TException {
        getRowRange_result result = new getRowRange_result();
        result.success = iface.getRowRange(args.row);
        return result;
      }
    }

    public static class getFollowing<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getFollowing_args> {
      public getFollowing() {
        super("getFollowing");
      }

      public getFollowing_args getEmptyArgsInstance() {
        return new getFollowing_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getFollowing_result getResult(I iface, getFollowing_args args) throws org.apache.thrift.TException {
        getFollowing_result result = new getFollowing_result();
        result.success = iface.getFollowing(args.key, args.part);
        return result;
      }
    }

    public static class systemNamespace<I extends Iface> extends org.apache.thrift.ProcessFunction<I, systemNamespace_args> {
      public systemNamespace() {
        super("systemNamespace");
      }

      public systemNamespace_args getEmptyArgsInstance() {
        return new systemNamespace_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public systemNamespace_result getResult(I iface, systemNamespace_args args) throws org.apache.thrift.TException {
        systemNamespace_result result = new systemNamespace_result();
        result.success = iface.systemNamespace();
        return result;
      }
    }

    public static class defaultNamespace<I extends Iface> extends org.apache.thrift.ProcessFunction<I, defaultNamespace_args> {
      public defaultNamespace() {
        super("defaultNamespace");
      }

      public defaultNamespace_args getEmptyArgsInstance() {
        return new defaultNamespace_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public defaultNamespace_result getResult(I iface, defaultNamespace_args args) throws org.apache.thrift.TException {
        defaultNamespace_result result = new defaultNamespace_result();
        result.success = iface.defaultNamespace();
        return result;
      }
    }

    public static class listNamespaces<I extends Iface> extends org.apache.thrift.ProcessFunction<I, listNamespaces_args> {
      public listNamespaces() {
        super("listNamespaces");
      }

      public listNamespaces_args getEmptyArgsInstance() {
        return new listNamespaces_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public listNamespaces_result getResult(I iface, listNamespaces_args args) throws org.apache.thrift.TException {
        listNamespaces_result result = new listNamespaces_result();
        try {
          result.success = iface.listNamespaces(args.login);
        } catch (AccumuloException ouch1) {
          result.ouch1 = ouch1;
        } catch (AccumuloSecurityException ouch2) {
          result.ouch2 = ouch2;
        }
        return result;
      }
    }

    public static class namespaceExists<I extends Iface> extends org.apache.thrift.ProcessFunction<I, namespaceExists_args> {
      public namespaceExists() {
        super("namespaceExists");
      }

      public namespaceExists_args getEmptyArgsInstance() {
        return new namespaceExists_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public namespaceExists_result getResult(I iface, namespaceExists_args args) throws org.apache.thrift.TException {
        namespaceExists_result result = new namespaceExists_result();
        try {
          result.success = iface.namespaceExists(args.login, args.namespaceName);
          result.setSuccessIsSet(true);
        } catch (AccumuloException ouch1) {
          result.ouch1 = ouch1;
        } catch (AccumuloSecurityException ouch2) {
          result.ouch2 = ouch2;
        }
        return result;
      }
    }

    public static class createNamespace<I extends Iface> extends org.apache.thrift.ProcessFunction<I, createNamespace_args> {
      public createNamespace() {
        super("createNamespace");
      }

      public createNamespace_args getEmptyArgsInstance() {
        return new createNamespace_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public createNamespace_result getResult(I iface, createNamespace_args args) throws org.apache.thrift.TException {
        createNamespace_result result = new createNamespace_result();
        try {
          iface.createNamespace(args.login, args.namespaceName);
        } catch (AccumuloException ouch1) {
          result.ouch1 = ouch1;
        } catch (AccumuloSecurityException ouch2) {
          result.ouch2 = ouch2;
        } catch (NamespaceExistsException ouch3) {
          result.ouch3 = ouch3;
        }
        return result;
      }
    }

    public static class deleteNamespace<I extends Iface> extends org.apache.thrift.ProcessFunction<I, deleteNamespace_args> {
      public deleteNamespace() {
        super("deleteNamespace");
      }

      public deleteNamespace_args getEmptyArgsInstance() {
        return new deleteNamespace_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public deleteNamespace_result getResult(I iface, deleteNamespace_args args) throws org.apache.thrift.TException {
        deleteNamespace_result result = new deleteNamespace_result();
        try {
          iface.deleteNamespace(args.login, args.namespaceName);
        } catch (AccumuloException ouch1) {
          result.ouch1 = ouch1;
        } catch (AccumuloSecurityException ouch2) {
          result.ouch2 = ouch2;
        } catch (NamespaceNotFoundException ouch3) {
          result.ouch3 = ouch3;
        } catch (NamespaceNotEmptyException ouch4) {
          result.ouch4 = ouch4;
        }
        return result;
      }
    }

    public static class renameNamespace<I extends Iface> extends org.apache.thrift.ProcessFunction<I, renameNamespace_args> {
      public renameNamespace() {
        super("renameNamespace");
      }

      public renameNamespace_args getEmptyArgsInstance() {
        return new renameNamespace_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public renameNamespace_result getResult(I iface, renameNamespace_args args) throws org.apache.thrift.TException {
        renameNamespace_result result = new renameNamespace_result();
        try {
          iface.renameNamespace(args.login, args.oldNamespaceName, args.newNamespaceName);
        } catch (AccumuloException ouch1) {
          result.ouch1 = ouch1;
        } catch (AccumuloSecurityException ouch2) {
          result.ouch2 = ouch2;
        } catch (NamespaceNotFoundException ouch3) {
          result.ouch3 = ouch3;
        } catch (NamespaceExistsException ouch4) {
          result.ouch4 = ouch4;
        }
        return result;
      }
    }

    public static class setNamespaceProperty<I extends Iface> extends org.apache.thrift.ProcessFunction<I, setNamespaceProperty_args> {
      public setNamespaceProperty() {
        super("setNamespaceProperty");
      }

      public setNamespaceProperty_args getEmptyArgsInstance() {
        return new setNamespaceProperty_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public setNamespaceProperty_result getResult(I iface, setNamespaceProperty_args args) throws org.apache.thrift.TException {
        setNamespaceProperty_result result = new setNamespaceProperty_result();
        try {
          iface.setNamespaceProperty(args.login, args.namespaceName, args.property, args.value);
        } catch (AccumuloException ouch1) {
          result.ouch1 = ouch1;
        } catch (AccumuloSecurityException ouch2) {
          result.ouch2 = ouch2;
        } catch (NamespaceNotFoundException ouch3) {
          result.ouch3 = ouch3;
        }
        return result;
      }
    }

    public static class removeNamespaceProperty<I extends Iface> extends org.apache.thrift.ProcessFunction<I, removeNamespaceProperty_args> {
      public removeNamespaceProperty() {
        super("removeNamespaceProperty");
      }

      public removeNamespaceProperty_args getEmptyArgsInstance() {
        return new removeNamespaceProperty_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public removeNamespaceProperty_result getResult(I iface, removeNamespaceProperty_args args) throws org.apache.thrift.TException {
        removeNamespaceProperty_result result = new removeNamespaceProperty_result();
        try {
          iface.removeNamespaceProperty(args.login, args.namespaceName, args.property);
        } catch (AccumuloException ouch1) {
          result.ouch1 = ouch1;
        } catch (AccumuloSecurityException ouch2) {
          result.ouch2 = ouch2;
        } catch (NamespaceNotFoundException ouch3) {
          result.ouch3 = ouch3;
        }
        return result;
      }
    }

    public static class getNamespaceProperties<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getNamespaceProperties_args> {
      public getNamespaceProperties() {
        super("getNamespaceProperties");
      }

      public getNamespaceProperties_args getEmptyArgsInstance() {
        return new getNamespaceProperties_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getNamespaceProperties_result getResult(I iface, getNamespaceProperties_args args) throws org.apache.thrift.TException {
        getNamespaceProperties_result result = new getNamespaceProperties_result();
        try {
          result.success = iface.getNamespaceProperties(args.login, args.namespaceName);
        } catch (AccumuloException ouch1) {
          result.ouch1 = ouch1;
        } catch (AccumuloSecurityException ouch2) {
          result.ouch2 = ouch2;
        } catch (NamespaceNotFoundException ouch3) {
          result.ouch3 = ouch3;
        }
        return result;
      }
    }

    public static class namespaceIdMap<I extends Iface> extends org.apache.thrift.ProcessFunction<I, namespaceIdMap_args> {
      public namespaceIdMap() {
        super("namespaceIdMap");
      }

      public namespaceIdMap_args getEmptyArgsInstance() {
        return new namespaceIdMap_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public namespaceIdMap_result getResult(I iface, namespaceIdMap_args args) throws org.apache.thrift.TException {
        namespaceIdMap_result result = new namespaceIdMap_result();
        try {
          result.success = iface.namespaceIdMap(args.login);
        } catch (AccumuloException ouch1) {
          result.ouch1 = ouch1;
        } catch (AccumuloSecurityException ouch2) {
          result.ouch2 = ouch2;
        }
        return result;
      }
    }

    public static class attachNamespaceIterator<I extends Iface> extends org.apache.thrift.ProcessFunction<I, attachNamespaceIterator_args> {
      public attachNamespaceIterator() {
        super("attachNamespaceIterator");
      }

      public attachNamespaceIterator_args getEmptyArgsInstance() {
        return new attachNamespaceIterator_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public attachNamespaceIterator_result getResult(I iface, attachNamespaceIterator_args args) throws org.apache.thrift.TException {
        attachNamespaceIterator_result result = new attachNamespaceIterator_result();
        try {
          iface.attachNamespaceIterator(args.login, args.namespaceName, args.setting, args.scopes);
        } catch (AccumuloException ouch1) {
          result.ouch1 = ouch1;
        } catch (AccumuloSecurityException ouch2) {
          result.ouch2 = ouch2;
        } catch (NamespaceNotFoundException ouch3) {
          result.ouch3 = ouch3;
        }
        return result;
      }
    }

    public static class removeNamespaceIterator<I extends Iface> extends org.apache.thrift.ProcessFunction<I, removeNamespaceIterator_args> {
      public removeNamespaceIterator() {
        super("removeNamespaceIterator");
      }

      public removeNamespaceIterator_args getEmptyArgsInstance() {
        return new removeNamespaceIterator_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public removeNamespaceIterator_result getResult(I iface, removeNamespaceIterator_args args) throws org.apache.thrift.TException {
        removeNamespaceIterator_result result = new removeNamespaceIterator_result();
        try {
          iface.removeNamespaceIterator(args.login, args.namespaceName, args.name, args.scopes);
        } catch (AccumuloException ouch1) {
          result.ouch1 = ouch1;
        } catch (AccumuloSecurityException ouch2) {
          result.ouch2 = ouch2;
        } catch (NamespaceNotFoundException ouch3) {
          result.ouch3 = ouch3;
        }
        return result;
      }
    }

    public static class getNamespaceIteratorSetting<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getNamespaceIteratorSetting_args> {
      public getNamespaceIteratorSetting() {
        super("getNamespaceIteratorSetting");
      }

      public getNamespaceIteratorSetting_args getEmptyArgsInstance() {
        return new getNamespaceIteratorSetting_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getNamespaceIteratorSetting_result getResult(I iface, getNamespaceIteratorSetting_args args) throws org.apache.thrift.TException {
        getNamespaceIteratorSetting_result result = new getNamespaceIteratorSetting_result();
        try {
          result.success = iface.getNamespaceIteratorSetting(args.login, args.namespaceName, args.name, args.scope);
        } catch (AccumuloException ouch1) {
          result.ouch1 = ouch1;
        } catch (AccumuloSecurityException ouch2) {
          result.ouch2 = ouch2;
        } catch (NamespaceNotFoundException ouch3) {
          result.ouch3 = ouch3;
        }
        return result;
      }
    }

    public static class listNamespaceIterators<I extends Iface> extends org.apache.thrift.ProcessFunction<I, listNamespaceIterators_args> {
      public listNamespaceIterators() {
        super("listNamespaceIterators");
      }

      public listNamespaceIterators_args getEmptyArgsInstance() {
        return new listNamespaceIterators_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public listNamespaceIterators_result getResult(I iface, listNamespaceIterators_args args) throws org.apache.thrift.TException {
        listNamespaceIterators_result result = new listNamespaceIterators_result();
        try {
          result.success = iface.listNamespaceIterators(args.login, args.namespaceName);
        } catch (AccumuloException ouch1) {
          result.ouch1 = ouch1;
        } catch (AccumuloSecurityException ouch2) {
          result.ouch2 = ouch2;
        } catch (NamespaceNotFoundException ouch3) {
          result.ouch3 = ouch3;
        }
        return result;
      }
    }

    public static class checkNamespaceIteratorConflicts<I extends Iface> extends org.apache.thrift.ProcessFunction<I, checkNamespaceIteratorConflicts_args> {
      public checkNamespaceIteratorConflicts() {
        super("checkNamespaceIteratorConflicts");
      }

      public checkNamespaceIteratorConflicts_args getEmptyArgsInstance() {
        return new checkNamespaceIteratorConflicts_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public checkNamespaceIteratorConflicts_result getResult(I iface, checkNamespaceIteratorConflicts_args args) throws org.apache.thrift.TException {
        checkNamespaceIteratorConflicts_result result = new checkNamespaceIteratorConflicts_result();
        try {
          iface.checkNamespaceIteratorConflicts(args.login, args.namespaceName, args.setting, args.scopes);
        } catch (AccumuloException ouch1) {
          result.ouch1 = ouch1;
        } catch (AccumuloSecurityException ouch2) {
          result.ouch2 = ouch2;
        } catch (NamespaceNotFoundException ouch3) {
          result.ouch3 = ouch3;
        }
        return result;
      }
    }

    public static class addNamespaceConstraint<I extends Iface> extends org.apache.thrift.ProcessFunction<I, addNamespaceConstraint_args> {
      public addNamespaceConstraint() {
        super("addNamespaceConstraint");
      }

      public addNamespaceConstraint_args getEmptyArgsInstance() {
        return new addNamespaceConstraint_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public addNamespaceConstraint_result getResult(I iface, addNamespaceConstraint_args args) throws org.apache.thrift.TException {
        addNamespaceConstraint_result result = new addNamespaceConstraint_result();
        try {
          result.success = iface.addNamespaceConstraint(args.login, args.namespaceName, args.constraintClassName);
          result.setSuccessIsSet(true);
        } catch (AccumuloException ouch1) {
          result.ouch1 = ouch1;
        } catch (AccumuloSecurityException ouch2) {
          result.ouch2 = ouch2;
        } catch (NamespaceNotFoundException ouch3) {
          result.ouch3 = ouch3;
        }
        return result;
      }
    }

    public static class removeNamespaceConstraint<I extends Iface> extends org.apache.thrift.ProcessFunction<I, removeNamespaceConstraint_args> {
      public removeNamespaceConstraint() {
        super("removeNamespaceConstraint");
      }

      public removeNamespaceConstraint_args getEmptyArgsInstance() {
        return new removeNamespaceConstraint_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public removeNamespaceConstraint_result getResult(I iface, removeNamespaceConstraint_args args) throws org.apache.thrift.TException {
        removeNamespaceConstraint_result result = new removeNamespaceConstraint_result();
        try {
          iface.removeNamespaceConstraint(args.login, args.namespaceName, args.id);
        } catch (AccumuloException ouch1) {
          result.ouch1 = ouch1;
        } catch (AccumuloSecurityException ouch2) {
          result.ouch2 = ouch2;
        } catch (NamespaceNotFoundException ouch3) {
          result.ouch3 = ouch3;
        }
        return result;
      }
    }

    public static class listNamespaceConstraints<I extends Iface> extends org.apache.thrift.ProcessFunction<I, listNamespaceConstraints_args> {
      public listNamespaceConstraints() {
        super("listNamespaceConstraints");
      }

      public listNamespaceConstraints_args getEmptyArgsInstance() {
        return new listNamespaceConstraints_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public listNamespaceConstraints_result getResult(I iface, listNamespaceConstraints_args args) throws org.apache.thrift.TException {
        listNamespaceConstraints_result result = new listNamespaceConstraints_result();
        try {
          result.success = iface.listNamespaceConstraints(args.login, args.namespaceName);
        } catch (AccumuloException ouch1) {
          result.ouch1 = ouch1;
        } catch (AccumuloSecurityException ouch2) {
          result.ouch2 = ouch2;
        } catch (NamespaceNotFoundException ouch3) {
          result.ouch3 = ouch3;
        }
        return result;
      }
    }

    public static class testNamespaceClassLoad<I extends Iface> extends org.apache.thrift.ProcessFunction<I, testNamespaceClassLoad_args> {
      public testNamespaceClassLoad() {
        super("testNamespaceClassLoad");
      }

      public testNamespaceClassLoad_args getEmptyArgsInstance() {
        return new testNamespaceClassLoad_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public testNamespaceClassLoad_result getResult(I iface, testNamespaceClassLoad_args args) throws org.apache.thrift.TException {
        testNamespaceClassLoad_result result = new testNamespaceClassLoad_result();
        try {
          result.success = iface.testNamespaceClassLoad(args.login, args.namespaceName, args.className, args.asTypeName);
          result.setSuccessIsSet(true);
        } catch (AccumuloException ouch1) {
          result.ouch1 = ouch1;
        } catch (AccumuloSecurityException ouch2) {
          result.ouch2 = ouch2;
        } catch (NamespaceNotFoundException ouch3) {
          result.ouch3 = ouch3;
        }
        return result;
      }
    }

  }

  public static class AsyncProcessor<I extends AsyncIface> extends org.apache.thrift.TBaseAsyncProcessor<I> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncProcessor.class.getName());
    public AsyncProcessor(I iface) {
      super(iface, getProcessMap(new HashMap<String, org.apache.thrift.AsyncProcessFunction<I, ? extends org.apache.thrift.TBase, ?>>()));
    }

    protected AsyncProcessor(I iface, Map<String,  org.apache.thrift.AsyncProcessFunction<I, ? extends  org.apache.thrift.TBase, ?>> processMap) {
      super(iface, getProcessMap(processMap));
    }

    private static <I extends AsyncIface> Map<String,  org.apache.thrift.AsyncProcessFunction<I, ? extends  org.apache.thrift.TBase,?>> getProcessMap(Map<String,  org.apache.thrift.AsyncProcessFunction<I, ? extends  org.apache.thrift.TBase, ?>> processMap) {
      processMap.put("login", new login());
      processMap.put("addConstraint", new addConstraint());
      processMap.put("addSplits", new addSplits());
      processMap.put("attachIterator", new attachIterator());
      processMap.put("checkIteratorConflicts", new checkIteratorConflicts());
      processMap.put("clearLocatorCache", new clearLocatorCache());
      processMap.put("cloneTable", new cloneTable());
      processMap.put("compactTable", new compactTable());
      processMap.put("cancelCompaction", new cancelCompaction());
      processMap.put("createTable", new createTable());
      processMap.put("deleteTable", new deleteTable());
      processMap.put("deleteRows", new deleteRows());
      processMap.put("exportTable", new exportTable());
      processMap.put("flushTable", new flushTable());
      processMap.put("getDiskUsage", new getDiskUsage());
      processMap.put("getLocalityGroups", new getLocalityGroups());
      processMap.put("getIteratorSetting", new getIteratorSetting());
      processMap.put("getMaxRow", new getMaxRow());
      processMap.put("getTableProperties", new getTableProperties());
      processMap.put("importDirectory", new importDirectory());
      processMap.put("importTable", new importTable());
      processMap.put("listSplits", new listSplits());
      processMap.put("listTables", new listTables());
      processMap.put("listIterators", new listIterators());
      processMap.put("listConstraints", new listConstraints());
      processMap.put("mergeTablets", new mergeTablets());
      processMap.put("offlineTable", new offlineTable());
      processMap.put("onlineTable", new onlineTable());
      processMap.put("removeConstraint", new removeConstraint());
      processMap.put("removeIterator", new removeIterator());
      processMap.put("removeTableProperty", new removeTableProperty());
      processMap.put("renameTable", new renameTable());
      processMap.put("setLocalityGroups", new setLocalityGroups());
      processMap.put("setTableProperty", new setTableProperty());
      processMap.put("splitRangeByTablets", new splitRangeByTablets());
      processMap.put("tableExists", new tableExists());
      processMap.put("tableIdMap", new tableIdMap());
      processMap.put("testTableClassLoad", new testTableClassLoad());
      processMap.put("pingTabletServer", new pingTabletServer());
      processMap.put("getActiveScans", new getActiveScans());
      processMap.put("getActiveCompactions", new getActiveCompactions());
      processMap.put("getSiteConfiguration", new getSiteConfiguration());
      processMap.put("getSystemConfiguration", new getSystemConfiguration());
      processMap.put("getTabletServers", new getTabletServers());
      processMap.put("removeProperty", new removeProperty());
      processMap.put("setProperty", new setProperty());
      processMap.put("testClassLoad", new testClassLoad());
      processMap.put("authenticateUser", new authenticateUser());
      processMap.put("changeUserAuthorizations", new changeUserAuthorizations());
      processMap.put("changeLocalUserPassword", new changeLocalUserPassword());
      processMap.put("createLocalUser", new createLocalUser());
      processMap.put("dropLocalUser", new dropLocalUser());
      processMap.put("getUserAuthorizations", new getUserAuthorizations());
      processMap.put("grantSystemPermission", new grantSystemPermission());
      processMap.put("grantTablePermission", new grantTablePermission());
      processMap.put("hasSystemPermission", new hasSystemPermission());
      processMap.put("hasTablePermission", new hasTablePermission());
      processMap.put("listLocalUsers", new listLocalUsers());
      processMap.put("revokeSystemPermission", new revokeSystemPermission());
      processMap.put("revokeTablePermission", new revokeTablePermission());
      processMap.put("grantNamespacePermission", new grantNamespacePermission());
      processMap.put("hasNamespacePermission", new hasNamespacePermission());
      processMap.put("revokeNamespacePermission", new revokeNamespacePermission());
      processMap.put("createBatchScanner", new createBatchScanner());
      processMap.put("createScanner", new createScanner());
      processMap.put("hasNext", new hasNext());
      processMap.put("nextEntry", new nextEntry());
      processMap.put("nextK", new nextK());
      processMap.put("closeScanner", new closeScanner());
      processMap.put("updateAndFlush", new updateAndFlush());
      processMap.put("createWriter", new createWriter());
      processMap.put("update", new update());
      processMap.put("flush", new flush());
      processMap.put("closeWriter", new closeWriter());
      processMap.put("updateRowConditionally", new updateRowConditionally());
      processMap.put("createConditionalWriter", new createConditionalWriter());
      processMap.put("updateRowsConditionally", new updateRowsConditionally());
      processMap.put("closeConditionalWriter", new closeConditionalWriter());
      processMap.put("getRowRange", new getRowRange());
      processMap.put("getFollowing", new getFollowing());
      processMap.put("systemNamespace", new systemNamespace());
      processMap.put("defaultNamespace", new defaultNamespace());
      processMap.put("listNamespaces", new listNamespaces());
      processMap.put("namespaceExists", new namespaceExists());
      processMap.put("createNamespace", new createNamespace());
      processMap.put("deleteNamespace", new deleteNamespace());
      processMap.put("renameNamespace", new renameNamespace());
      processMap.put("setNamespaceProperty", new setNamespaceProperty());
      processMap.put("removeNamespaceProperty", new removeNamespaceProperty());
      processMap.put("getNamespaceProperties", new getNamespaceProperties());
      processMap.put("namespaceIdMap", new namespaceIdMap());
      processMap.put("attachNamespaceIterator", new attachNamespaceIterator());
      processMap.put("removeNamespaceIterator", new removeNamespaceIterator());
      processMap.put("getNamespaceIteratorSetting", new getNamespaceIteratorSetting());
      processMap.put("listNamespaceIterators", new listNamespaceIterators());
      processMap.put("checkNamespaceIteratorConflicts", new checkNamespaceIteratorConflicts());
      processMap.put("addNamespaceConstraint", new addNamespaceConstraint());
      processMap.put("removeNamespaceConstraint", new removeNamespaceConstraint());
      processMap.put("listNamespaceConstraints", new listNamespaceConstraints());
      processMap.put("testNamespaceClassLoad", new testNamespaceClassLoad());
      return processMap;
    }

    public static class login<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, login_args, ByteBuffer> {
      public login() {
        super("login");
      }

      public login_args getEmptyArgsInstance() {
        return new login_args();
      }

      public AsyncMethodCallback<ByteBuffer> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<ByteBuffer>() { 
          public void onComplete(ByteBuffer o) {
            login_result result = new login_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            login_result result = new login_result();
            if (e instanceof AccumuloSecurityException) {
                        result.ouch2 = (AccumuloSecurityException) e;
                        result.setOuch2IsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, login_args args, org.apache.thrift.async.AsyncMethodCallback<ByteBuffer> resultHandler) throws TException {
        iface.login(args.principal, args.loginProperties,resultHandler);
      }
    }

    public static class addConstraint<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, addConstraint_args, Integer> {
      public addConstraint() {
        super("addConstraint");
      }

      public addConstraint_args getEmptyArgsInstance() {
        return new addConstraint_args();
      }

      public AsyncMethodCallback<Integer> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Integer>() { 
          public void onComplete(Integer o) {
            addConstraint_result result = new addConstraint_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            addConstraint_result result = new addConstraint_result();
            if (e instanceof AccumuloException) {
                        result.ouch1 = (AccumuloException) e;
                        result.setOuch1IsSet(true);
                        msg = result;
            }
            else             if (e instanceof AccumuloSecurityException) {
                        result.ouch2 = (AccumuloSecurityException) e;
                        result.setOuch2IsSet(true);
                        msg = result;
            }
            else             if (e instanceof TableNotFoundException) {
                        result.ouch3 = (TableNotFoundException) e;
                        result.setOuch3IsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, addConstraint_args args, org.apache.thrift.async.AsyncMethodCallback<Integer> resultHandler) throws TException {
        iface.addConstraint(args.login, args.tableName, args.constraintClassName,resultHandler);
      }
    }

    public static class addSplits<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, addSplits_args, Void> {
      public addSplits() {
        super("addSplits");
      }

      public addSplits_args getEmptyArgsInstance() {
        return new addSplits_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            addSplits_result result = new addSplits_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            addSplits_result result = new addSplits_result();
            if (e instanceof AccumuloException) {
                        result.ouch1 = (AccumuloException) e;
                        result.setOuch1IsSet(true);
                        msg = result;
            }
            else             if (e instanceof AccumuloSecurityException) {
                        result.ouch2 = (AccumuloSecurityException) e;
                        result.setOuch2IsSet(true);
                        msg = result;
            }
            else             if (e instanceof TableNotFoundException) {
                        result.ouch3 = (TableNotFoundException) e;
                        result.setOuch3IsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, addSplits_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.addSplits(args.login, args.tableName, args.splits,resultHandler);
      }
    }

    public static class attachIterator<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, attachIterator_args, Void> {
      public attachIterator() {
        super("attachIterator");
      }

      public attachIterator_args getEmptyArgsInstance() {
        return new attachIterator_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            attachIterator_result result = new attachIterator_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            attachIterator_result result = new attachIterator_result();
            if (e instanceof AccumuloSecurityException) {
                        result.ouch1 = (AccumuloSecurityException) e;
                        result.setOuch1IsSet(true);
                        msg = result;
            }
            else             if (e instanceof AccumuloException) {
                        result.ouch2 = (AccumuloException) e;
                        result.setOuch2IsSet(true);
                        msg = result;
            }
            else             if (e instanceof TableNotFoundException) {
                        result.ouch3 = (TableNotFoundException) e;
                        result.setOuch3IsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, attachIterator_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.attachIterator(args.login, args.tableName, args.setting, args.scopes,resultHandler);
      }
    }

    public static class checkIteratorConflicts<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, checkIteratorConflicts_args, Void> {
      public checkIteratorConflicts() {
        super("checkIteratorConflicts");
      }

      public checkIteratorConflicts_args getEmptyArgsInstance() {
        return new checkIteratorConflicts_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            checkIteratorConflicts_result result = new checkIteratorConflicts_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            checkIteratorConflicts_result result = new checkIteratorConflicts_result();
            if (e instanceof AccumuloSecurityException) {
                        result.ouch1 = (AccumuloSecurityException) e;
                        result.setOuch1IsSet(true);
                        msg = result;
            }
            else             if (e instanceof AccumuloException) {
                        result.ouch2 = (AccumuloException) e;
                        result.setOuch2IsSet(true);
                        msg = result;
            }
            else             if (e instanceof TableNotFoundException) {
                        result.ouch3 = (TableNotFoundException) e;
                        result.setOuch3IsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, checkIteratorConflicts_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.checkIteratorConflicts(args.login, args.tableName, args.setting, args.scopes,resultHandler);
      }
    }

    public static class clearLocatorCache<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, clearLocatorCache_args, Void> {
      public clearLocatorCache() {
        super("clearLocatorCache");
      }

      public clearLocatorCache_args getEmptyArgsInstance() {
        return new clearLocatorCache_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            clearLocatorCache_result result = new clearLocatorCache_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            clearLocatorCache_result result = new clearLocatorCache_result();
            if (e instanceof TableNotFoundException) {
                        result.ouch1 = (TableNotFoundException) e;
                        result.setOuch1IsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, clearLocatorCache_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.clearLocatorCache(args.login, args.tableName,resultHandler);
      }
    }

    public static class cloneTable<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, cloneTable_args, Void> {
      public cloneTable() {
        super("cloneTable");
      }

      public cloneTable_args getEmptyArgsInstance() {
        return new cloneTable_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            cloneTable_result result = new cloneTable_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            cloneTable_result result = new cloneTable_result();
            if (e instanceof AccumuloException) {
                        result.ouch1 = (AccumuloException) e;
                        result.setOuch1IsSet(true);
                        msg = result;
            }
            else             if (e instanceof AccumuloSecurityException) {
                        result.ouch2 = (AccumuloSecurityException) e;
                        result.setOuch2IsSet(true);
                        msg = result;
            }
            else             if (e instanceof TableNotFoundException) {
                        result.ouch3 = (TableNotFoundException) e;
                        result.setOuch3IsSet(true);
                        msg = result;
            }
            else             if (e instanceof TableExistsException) {
                        result.ouch4 = (TableExistsException) e;
                        result.setOuch4IsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, cloneTable_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.cloneTable(args.login, args.tableName, args.newTableName, args.flush, args.propertiesToSet, args.propertiesToExclude,resultHandler);
      }
    }

    public static class compactTable<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, compactTable_args, Void> {
      public compactTable() {
        super("compactTable");
      }

      public compactTable_args getEmptyArgsInstance() {
        return new compactTable_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            compactTable_result result = new compactTable_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            compactTable_result result = new compactTable_result();
            if (e instanceof AccumuloSecurityException) {
                        result.ouch1 = (AccumuloSecurityException) e;
                        result.setOuch1IsSet(true);
                        msg = result;
            }
            else             if (e instanceof TableNotFoundException) {
                        result.ouch2 = (TableNotFoundException) e;
                        result.setOuch2IsSet(true);
                        msg = result;
            }
            else             if (e instanceof AccumuloException) {
                        result.ouch3 = (AccumuloException) e;
                        result.setOuch3IsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, compactTable_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.compactTable(args.login, args.tableName, args.startRow, args.endRow, args.iterators, args.flush, args.wait, args.compactionStrategy,resultHandler);
      }
    }

    public static class cancelCompaction<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, cancelCompaction_args, Void> {
      public cancelCompaction() {
        super("cancelCompaction");
      }

      public cancelCompaction_args getEmptyArgsInstance() {
        return new cancelCompaction_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            cancelCompaction_result result = new cancelCompaction_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            cancelCompaction_result result = new cancelCompaction_result();
            if (e instanceof AccumuloSecurityException) {
                        result.ouch1 = (AccumuloSecurityException) e;
                        result.setOuch1IsSet(true);
                        msg = result;
            }
            else             if (e instanceof TableNotFoundException) {
                        result.ouch2 = (TableNotFoundException) e;
                        result.setOuch2IsSet(true);
                        msg = result;
            }
            else             if (e instanceof AccumuloException) {
                        result.ouch3 = (AccumuloException) e;
                        result.setOuch3IsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, cancelCompaction_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.cancelCompaction(args.login, args.tableName,resultHandler);
      }
    }

    public static class createTable<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, createTable_args, Void> {
      public createTable() {
        super("createTable");
      }

      public createTable_args getEmptyArgsInstance() {
        return new createTable_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            createTable_result result = new createTable_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            createTable_result result = new createTable_result();
            if (e instanceof AccumuloException) {
                        result.ouch1 = (AccumuloException) e;
                        result.setOuch1IsSet(true);
                        msg = result;
            }
            else             if (e instanceof AccumuloSecurityException) {
                        result.ouch2 = (AccumuloSecurityException) e;
                        result.setOuch2IsSet(true);
                        msg = result;
            }
            else             if (e instanceof TableExistsException) {
                        result.ouch3 = (TableExistsException) e;
                        result.setOuch3IsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, createTable_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.createTable(args.login, args.tableName, args.versioningIter, args.type,resultHandler);
      }
    }

    public static class deleteTable<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, deleteTable_args, Void> {
      public deleteTable() {
        super("deleteTable");
      }

      public deleteTable_args getEmptyArgsInstance() {
        return new deleteTable_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            deleteTable_result result = new deleteTable_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            deleteTable_result result = new deleteTable_result();
            if (e instanceof AccumuloException) {
                        result.ouch1 = (AccumuloException) e;
                        result.setOuch1IsSet(true);
                        msg = result;
            }
            else             if (e instanceof AccumuloSecurityException) {
                        result.ouch2 = (AccumuloSecurityException) e;
                        result.setOuch2IsSet(true);
                        msg = result;
            }
            else             if (e instanceof TableNotFoundException) {
                        result.ouch3 = (TableNotFoundException) e;
                        result.setOuch3IsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, deleteTable_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.deleteTable(args.login, args.tableName,resultHandler);
      }
    }

    public static class deleteRows<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, deleteRows_args, Void> {
      public deleteRows() {
        super("deleteRows");
      }

      public deleteRows_args getEmptyArgsInstance() {
        return new deleteRows_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            deleteRows_result result = new deleteRows_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            deleteRows_result result = new deleteRows_result();
            if (e instanceof AccumuloException) {
                        result.ouch1 = (AccumuloException) e;
                        result.setOuch1IsSet(true);
                        msg = result;
            }
            else             if (e instanceof AccumuloSecurityException) {
                        result.ouch2 = (AccumuloSecurityException) e;
                        result.setOuch2IsSet(true);
                        msg = result;
            }
            else             if (e instanceof TableNotFoundException) {
                        result.ouch3 = (TableNotFoundException) e;
                        result.setOuch3IsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, deleteRows_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.deleteRows(args.login, args.tableName, args.startRow, args.endRow,resultHandler);
      }
    }

    public static class exportTable<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, exportTable_args, Void> {
      public exportTable() {
        super("exportTable");
      }

      public exportTable_args getEmptyArgsInstance() {
        return new exportTable_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            exportTable_result result = new exportTable_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            exportTable_result result = new exportTable_result();
            if (e instanceof AccumuloException) {
                        result.ouch1 = (AccumuloException) e;
                        result.setOuch1IsSet(true);
                        msg = result;
            }
            else             if (e instanceof AccumuloSecurityException) {
                        result.ouch2 = (AccumuloSecurityException) e;
                        result.setOuch2IsSet(true);
                        msg = result;
            }
            else             if (e instanceof TableNotFoundException) {
                        result.ouch3 = (TableNotFoundException) e;
                        result.setOuch3IsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, exportTable_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.exportTable(args.login, args.tableName, args.exportDir,resultHandler);
      }
    }

    public static class flushTable<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, flushTable_args, Void> {
      public flushTable() {
        super("flushTable");
      }

      public flushTable_args getEmptyArgsInstance() {
        return new flushTable_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            flushTable_result result = new flushTable_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            flushTable_result result = new flushTable_result();
            if (e instanceof AccumuloException) {
                        result.ouch1 = (AccumuloException) e;
                        result.setOuch1IsSet(true);
                        msg = result;
            }
            else             if (e instanceof AccumuloSecurityException) {
                        result.ouch2 = (AccumuloSecurityException) e;
                        result.setOuch2IsSet(true);
                        msg = result;
            }
            else             if (e instanceof TableNotFoundException) {
                        result.ouch3 = (TableNotFoundException) e;
                        result.setOuch3IsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, flushTable_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.flushTable(args.login, args.tableName, args.startRow, args.endRow, args.wait,resultHandler);
      }
    }

    public static class getDiskUsage<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getDiskUsage_args, List<DiskUsage>> {
      public getDiskUsage() {
        super("getDiskUsage");
      }

      public getDiskUsage_args getEmptyArgsInstance() {
        return new getDiskUsage_args();
      }

      public AsyncMethodCallback<List<DiskUsage>> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<List<DiskUsage>>() { 
          public void onComplete(List<DiskUsage> o) {
            getDiskUsage_result result = new getDiskUsage_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            getDiskUsage_result result = new getDiskUsage_result();
            if (e instanceof AccumuloException) {
                        result.ouch1 = (AccumuloException) e;
                        result.setOuch1IsSet(true);
                        msg = result;
            }
            else             if (e instanceof AccumuloSecurityException) {
                        result.ouch2 = (AccumuloSecurityException) e;
                        result.setOuch2IsSet(true);
                        msg = result;
            }
            else             if (e instanceof TableNotFoundException) {
                        result.ouch3 = (TableNotFoundException) e;
                        result.setOuch3IsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getDiskUsage_args args, org.apache.thrift.async.AsyncMethodCallback<List<DiskUsage>> resultHandler) throws TException {
        iface.getDiskUsage(args.login, args.tables,resultHandler);
      }
    }

    public static class getLocalityGroups<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getLocalityGroups_args, Map<String,Set<String>>> {
      public getLocalityGroups() {
        super("getLocalityGroups");
      }

      public getLocalityGroups_args getEmptyArgsInstance() {
        return new getLocalityGroups_args();
      }

      public AsyncMethodCallback<Map<String,Set<String>>> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Map<String,Set<String>>>() { 
          public void onComplete(Map<String,Set<String>> o) {
            getLocalityGroups_result result = new getLocalityGroups_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            getLocalityGroups_result result = new getLocalityGroups_result();
            if (e instanceof AccumuloException) {
                        result.ouch1 = (AccumuloException) e;
                        result.setOuch1IsSet(true);
                        msg = result;
            }
            else             if (e instanceof AccumuloSecurityException) {
                        result.ouch2 = (AccumuloSecurityException) e;
                        result.setOuch2IsSet(true);
                        msg = result;
            }
            else             if (e instanceof TableNotFoundException) {
                        result.ouch3 = (TableNotFoundException) e;
                        result.setOuch3IsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getLocalityGroups_args args, org.apache.thrift.async.AsyncMethodCallback<Map<String,Set<String>>> resultHandler) throws TException {
        iface.getLocalityGroups(args.login, args.tableName,resultHandler);
      }
    }

    public static class getIteratorSetting<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getIteratorSetting_args, IteratorSetting> {
      public getIteratorSetting() {
        super("getIteratorSetting");
      }

      public getIteratorSetting_args getEmptyArgsInstance() {
        return new getIteratorSetting_args();
      }

      public AsyncMethodCallback<IteratorSetting> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<IteratorSetting>() { 
          public void onComplete(IteratorSetting o) {
            getIteratorSetting_result result = new getIteratorSetting_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            getIteratorSetting_result result = new getIteratorSetting_result();
            if (e instanceof AccumuloException) {
                        result.ouch1 = (AccumuloException) e;
                        result.setOuch1IsSet(true);
                        msg = result;
            }
            else             if (e instanceof AccumuloSecurityException) {
                        result.ouch2 = (AccumuloSecurityException) e;
                        result.setOuch2IsSet(true);
                        msg = result;
            }
            else             if (e instanceof TableNotFoundException) {
                        result.ouch3 = (TableNotFoundException) e;
                        result.setOuch3IsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getIteratorSetting_args args, org.apache.thrift.async.AsyncMethodCallback<IteratorSetting> resultHandler) throws TException {
        iface.getIteratorSetting(args.login, args.tableName, args.iteratorName, args.scope,resultHandler);
      }
    }

    public static class getMaxRow<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getMaxRow_args, ByteBuffer> {
      public getMaxRow() {
        super("getMaxRow");
      }

      public getMaxRow_args getEmptyArgsInstance() {
        return new getMaxRow_args();
      }

      public AsyncMethodCallback<ByteBuffer> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<ByteBuffer>() { 
          public void onComplete(ByteBuffer o) {
            getMaxRow_result result = new getMaxRow_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            getMaxRow_result result = new getMaxRow_result();
            if (e instanceof AccumuloException) {
                        result.ouch1 = (AccumuloException) e;
                        result.setOuch1IsSet(true);
                        msg = result;
            }
            else             if (e instanceof AccumuloSecurityException) {
                        result.ouch2 = (AccumuloSecurityException) e;
                        result.setOuch2IsSet(true);
                        msg = result;
            }
            else             if (e instanceof TableNotFoundException) {
                        result.ouch3 = (TableNotFoundException) e;
                        result.setOuch3IsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getMaxRow_args args, org.apache.thrift.async.AsyncMethodCallback<ByteBuffer> resultHandler) throws TException {
        iface.getMaxRow(args.login, args.tableName, args.auths, args.startRow, args.startInclusive, args.endRow, args.endInclusive,resultHandler);
      }
    }

    public static class getTableProperties<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getTableProperties_args, Map<String,String>> {
      public getTableProperties() {
        super("getTableProperties");
      }

      public getTableProperties_args getEmptyArgsInstance() {
        return new getTableProperties_args();
      }

      public AsyncMethodCallback<Map<String,String>> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Map<String,String>>() { 
          public void onComplete(Map<String,String> o) {
            getTableProperties_result result = new getTableProperties_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            getTableProperties_result result = new getTableProperties_result();
            if (e instanceof AccumuloException) {
                        result.ouch1 = (AccumuloException) e;
                        result.setOuch1IsSet(true);
                        msg = result;
            }
            else             if (e instanceof AccumuloSecurityException) {
                        result.ouch2 = (AccumuloSecurityException) e;
                        result.setOuch2IsSet(true);
                        msg = result;
            }
            else             if (e instanceof TableNotFoundException) {
                        result.ouch3 = (TableNotFoundException) e;
                        result.setOuch3IsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getTableProperties_args args, org.apache.thrift.async.AsyncMethodCallback<Map<String,String>> resultHandler) throws TException {
        iface.getTableProperties(args.login, args.tableName,resultHandler);
      }
    }

    public static class importDirectory<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, importDirectory_args, Void> {
      public importDirectory() {
        super("importDirectory");
      }

      public importDirectory_args getEmptyArgsInstance() {
        return new importDirectory_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            importDirectory_result result = new importDirectory_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            importDirectory_result result = new importDirectory_result();
            if (e instanceof TableNotFoundException) {
                        result.ouch1 = (TableNotFoundException) e;
                        result.setOuch1IsSet(true);
                        msg = result;
            }
            else             if (e instanceof AccumuloException) {
                        result.ouch3 = (AccumuloException) e;
                        result.setOuch3IsSet(true);
                        msg = result;
            }
            else             if (e instanceof AccumuloSecurityException) {
                        result.ouch4 = (AccumuloSecurityException) e;
                        result.setOuch4IsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, importDirectory_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.importDirectory(args.login, args.tableName, args.importDir, args.failureDir, args.setTime,resultHandler);
      }
    }

    public static class importTable<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, importTable_args, Void> {
      public importTable() {
        super("importTable");
      }

      public importTable_args getEmptyArgsInstance() {
        return new importTable_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            importTable_result result = new importTable_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            importTable_result result = new importTable_result();
            if (e instanceof TableExistsException) {
                        result.ouch1 = (TableExistsException) e;
                        result.setOuch1IsSet(true);
                        msg = result;
            }
            else             if (e instanceof AccumuloException) {
                        result.ouch2 = (AccumuloException) e;
                        result.setOuch2IsSet(true);
                        msg = result;
            }
            else             if (e instanceof AccumuloSecurityException) {
                        result.ouch3 = (AccumuloSecurityException) e;
                        result.setOuch3IsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, importTable_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.importTable(args.login, args.tableName, args.importDir,resultHandler);
      }
    }

    public static class listSplits<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, listSplits_args, List<ByteBuffer>> {
      public listSplits() {
        super("listSplits");
      }

      public listSplits_args getEmptyArgsInstance() {
        return new listSplits_args();
      }

      public AsyncMethodCallback<List<ByteBuffer>> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<List<ByteBuffer>>() { 
          public void onComplete(List<ByteBuffer> o) {
            listSplits_result result = new listSplits_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            listSplits_result result = new listSplits_result();
            if (e instanceof AccumuloException) {
                        result.ouch1 = (AccumuloException) e;
                        result.setOuch1IsSet(true);
                        msg = result;
            }
            else             if (e instanceof AccumuloSecurityException) {
                        result.ouch2 = (AccumuloSecurityException) e;
                        result.setOuch2IsSet(true);
                        msg = result;
            }
            else             if (e instanceof TableNotFoundException) {
                        result.ouch3 = (TableNotFoundException) e;
                        result.setOuch3IsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, listSplits_args args, org.apache.thrift.async.AsyncMethodCallback<List<ByteBuffer>> resultHandler) throws TException {
        iface.listSplits(args.login, args.tableName, args.maxSplits,resultHandler);
      }
    }

    public static class listTables<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, listTables_args, Set<String>> {
      public listTables() {
        super("listTables");
      }

      public listTables_args getEmptyArgsInstance() {
        return new listTables_args();
      }

      public AsyncMethodCallback<Set<String>> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Set<String>>() { 
          public void onComplete(Set<String> o) {
            listTables_result result = new listTables_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            listTables_result result = new listTables_result();
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, listTables_args args, org.apache.thrift.async.AsyncMethodCallback<Set<String>> resultHandler) throws TException {
        iface.listTables(args.login,resultHandler);
      }
    }

    public static class listIterators<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, listIterators_args, Map<String,Set<IteratorScope>>> {
      public listIterators() {
        super("listIterators");
      }

      public listIterators_args getEmptyArgsInstance() {
        return new listIterators_args();
      }

      public AsyncMethodCallback<Map<String,Set<IteratorScope>>> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Map<String,Set<IteratorScope>>>() { 
          public void onComplete(Map<String,Set<IteratorScope>> o) {
            listIterators_result result = new listIterators_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            listIterators_result result = new listIterators_result();
            if (e instanceof AccumuloException) {
                        result.ouch1 = (AccumuloException) e;
                        result.setOuch1IsSet(true);
                        msg = result;
            }
            else             if (e instanceof AccumuloSecurityException) {
                        result.ouch2 = (AccumuloSecurityException) e;
                        result.setOuch2IsSet(true);
                        msg = result;
            }
            else             if (e instanceof TableNotFoundException) {
                        result.ouch3 = (TableNotFoundException) e;
                        result.setOuch3IsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, listIterators_args args, org.apache.thrift.async.AsyncMethodCallback<Map<String,Set<IteratorScope>>> resultHandler) throws TException {
        iface.listIterators(args.login, args.tableName,resultHandler);
      }
    }

    public static class listConstraints<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, listConstraints_args, Map<String,Integer>> {
      public listConstraints() {
        super("listConstraints");
      }

      public listConstraints_args getEmptyArgsInstance() {
        return new listConstraints_args();
      }

      public AsyncMethodCallback<Map<String,Integer>> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Map<String,Integer>>() { 
          public void onComplete(Map<String,Integer> o) {
            listConstraints_result result = new listConstraints_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            listConstraints_result result = new listConstraints_result();
            if (e instanceof AccumuloException) {
                        result.ouch1 = (AccumuloException) e;
                        result.setOuch1IsSet(true);
                        msg = result;
            }
            else             if (e instanceof AccumuloSecurityException) {
                        result.ouch2 = (AccumuloSecurityException) e;
                        result.setOuch2IsSet(true);
                        msg = result;
            }
            else             if (e instanceof TableNotFoundException) {
                        result.ouch3 = (TableNotFoundException) e;
                        result.setOuch3IsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, listConstraints_args args, org.apache.thrift.async.AsyncMethodCallback<Map<String,Integer>> resultHandler) throws TException {
        iface.listConstraints(args.login, args.tableName,resultHandler);
      }
    }

    public static class mergeTablets<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, mergeTablets_args, Void> {
      public mergeTablets() {
        super("mergeTablets");
      }

      public mergeTablets_args getEmptyArgsInstance() {
        return new mergeTablets_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            mergeTablets_result result = new mergeTablets_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            mergeTablets_result result = new mergeTablets_result();
            if (e instanceof AccumuloException) {
                        result.ouch1 = (AccumuloException) e;
                        result.setOuch1IsSet(true);
                        msg = result;
            }
            else             if (e instanceof AccumuloSecurityException) {
                        result.ouch2 = (AccumuloSecurityException) e;
                        result.setOuch2IsSet(true);
                        msg = result;
            }
            else             if (e instanceof TableNotFoundException) {
                        result.ouch3 = (TableNotFoundException) e;
                        result.setOuch3IsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, mergeTablets_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.mergeTablets(args.login, args.tableName, args.startRow, args.endRow,resultHandler);
      }
    }

    public static class offlineTable<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, offlineTable_args, Void> {
      public offlineTable() {
        super("offlineTable");
      }

      public offlineTable_args getEmptyArgsInstance() {
        return new offlineTable_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            offlineTable_result result = new offlineTable_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            offlineTable_result result = new offlineTable_result();
            if (e instanceof AccumuloException) {
                        result.ouch1 = (AccumuloException) e;
                        result.setOuch1IsSet(true);
                        msg = result;
            }
            else             if (e instanceof AccumuloSecurityException) {
                        result.ouch2 = (AccumuloSecurityException) e;
                        result.setOuch2IsSet(true);
                        msg = result;
            }
            else             if (e instanceof TableNotFoundException) {
                        result.ouch3 = (TableNotFoundException) e;
                        result.setOuch3IsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, offlineTable_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.offlineTable(args.login, args.tableName, args.wait,resultHandler);
      }
    }

    public static class onlineTable<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, onlineTable_args, Void> {
      public onlineTable() {
        super("onlineTable");
      }

      public onlineTable_args getEmptyArgsInstance() {
        return new onlineTable_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            onlineTable_result result = new onlineTable_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            onlineTable_result result = new onlineTable_result();
            if (e instanceof AccumuloException) {
                        result.ouch1 = (AccumuloException) e;
                        result.setOuch1IsSet(true);
                        msg = result;
            }
            else             if (e instanceof AccumuloSecurityException) {
                        result.ouch2 = (AccumuloSecurityException) e;
                        result.setOuch2IsSet(true);
                        msg = result;
            }
            else             if (e instanceof TableNotFoundException) {
                        result.ouch3 = (TableNotFoundException) e;
                        result.setOuch3IsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, onlineTable_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.onlineTable(args.login, args.tableName, args.wait,resultHandler);
      }
    }

    public static class removeConstraint<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, removeConstraint_args, Void> {
      public removeConstraint() {
        super("removeConstraint");
      }

      public removeConstraint_args getEmptyArgsInstance() {
        return new removeConstraint_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            removeConstraint_result result = new removeConstraint_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            removeConstraint_result result = new removeConstraint_result();
            if (e instanceof AccumuloException) {
                        result.ouch1 = (AccumuloException) e;
                        result.setOuch1IsSet(true);
                        msg = result;
            }
            else             if (e instanceof AccumuloSecurityException) {
                        result.ouch2 = (AccumuloSecurityException) e;
                        result.setOuch2IsSet(true);
                        msg = result;
            }
            else             if (e instanceof TableNotFoundException) {
                        result.ouch3 = (TableNotFoundException) e;
                        result.setOuch3IsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, removeConstraint_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.removeConstraint(args.login, args.tableName, args.constraint,resultHandler);
      }
    }

    public static class removeIterator<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, removeIterator_args, Void> {
      public removeIterator() {
        super("removeIterator");
      }

      public removeIterator_args getEmptyArgsInstance() {
        return new removeIterator_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            removeIterator_result result = new removeIterator_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            removeIterator_result result = new removeIterator_result();
            if (e instanceof AccumuloException) {
                        result.ouch1 = (AccumuloException) e;
                        result.setOuch1IsSet(true);
                        msg = result;
            }
            else             if (e instanceof AccumuloSecurityException) {
                        result.ouch2 = (AccumuloSecurityException) e;
                        result.setOuch2IsSet(true);
                        msg = result;
            }
            else             if (e instanceof TableNotFoundException) {
                        result.ouch3 = (TableNotFoundException) e;
                        result.setOuch3IsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, removeIterator_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.removeIterator(args.login, args.tableName, args.iterName, args.scopes,resultHandler);
      }
    }

    public static class removeTableProperty<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, removeTableProperty_args, Void> {
      public removeTableProperty() {
        super("removeTableProperty");
      }

      public removeTableProperty_args getEmptyArgsInstance() {
        return new removeTableProperty_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            removeTableProperty_result result = new removeTableProperty_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            removeTableProperty_result result = new removeTableProperty_result();
            if (e instanceof AccumuloException) {
                        result.ouch1 = (AccumuloException) e;
                        result.setOuch1IsSet(true);
                        msg = result;
            }
            else             if (e instanceof AccumuloSecurityException) {
                        result.ouch2 = (AccumuloSecurityException) e;
                        result.setOuch2IsSet(true);
                        msg = result;
            }
            else             if (e instanceof TableNotFoundException) {
                        result.ouch3 = (TableNotFoundException) e;
                        result.setOuch3IsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, removeTableProperty_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.removeTableProperty(args.login, args.tableName, args.property,resultHandler);
      }
    }

    public static class renameTable<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, renameTable_args, Void> {
      public renameTable() {
        super("renameTable");
      }

      public renameTable_args getEmptyArgsInstance() {
        return new renameTable_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            renameTable_result result = new renameTable_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            renameTable_result result = new renameTable_result();
            if (e instanceof AccumuloException) {
                        result.ouch1 = (AccumuloException) e;
                        result.setOuch1IsSet(true);
                        msg = result;
            }
            else             if (e instanceof AccumuloSecurityException) {
                        result.ouch2 = (AccumuloSecurityException) e;
                        result.setOuch2IsSet(true);
                        msg = result;
            }
            else             if (e instanceof TableNotFoundException) {
                        result.ouch3 = (TableNotFoundException) e;
                        result.setOuch3IsSet(true);
                        msg = result;
            }
            else             if (e instanceof TableExistsException) {
                        result.ouch4 = (TableExistsException) e;
                        result.setOuch4IsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, renameTable_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.renameTable(args.login, args.oldTableName, args.newTableName,resultHandler);
      }
    }

    public static class setLocalityGroups<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, setLocalityGroups_args, Void> {
      public setLocalityGroups() {
        super("setLocalityGroups");
      }

      public setLocalityGroups_args getEmptyArgsInstance() {
        return new setLocalityGroups_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            setLocalityGroups_result result = new setLocalityGroups_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            setLocalityGroups_result result = new setLocalityGroups_result();
            if (e instanceof AccumuloException) {
                        result.ouch1 = (AccumuloException) e;
                        result.setOuch1IsSet(true);
                        msg = result;
            }
            else             if (e instanceof AccumuloSecurityException) {
                        result.ouch2 = (AccumuloSecurityException) e;
                        result.setOuch2IsSet(true);
                        msg = result;
            }
            else             if (e instanceof TableNotFoundException) {
                        result.ouch3 = (TableNotFoundException) e;
                        result.setOuch3IsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, setLocalityGroups_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.setLocalityGroups(args.login, args.tableName, args.groups,resultHandler);
      }
    }

    public static class setTableProperty<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, setTableProperty_args, Void> {
      public setTableProperty() {
        super("setTableProperty");
      }

      public setTableProperty_args getEmptyArgsInstance() {
        return new setTableProperty_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            setTableProperty_result result = new setTableProperty_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            setTableProperty_result result = new setTableProperty_result();
            if (e instanceof AccumuloException) {
                        result.ouch1 = (AccumuloException) e;
                        result.setOuch1IsSet(true);
                        msg = result;
            }
            else             if (e instanceof AccumuloSecurityException) {
                        result.ouch2 = (AccumuloSecurityException) e;
                        result.setOuch2IsSet(true);
                        msg = result;
            }
            else             if (e instanceof TableNotFoundException) {
                        result.ouch3 = (TableNotFoundException) e;
                        result.setOuch3IsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, setTableProperty_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.setTableProperty(args.login, args.tableName, args.property, args.value,resultHandler);
      }
    }

    public static class splitRangeByTablets<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, splitRangeByTablets_args, Set<Range>> {
      public splitRangeByTablets() {
        super("splitRangeByTablets");
      }

      public splitRangeByTablets_args getEmptyArgsInstance() {
        return new splitRangeByTablets_args();
      }

      public AsyncMethodCallback<Set<Range>> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Set<Range>>() { 
          public void onComplete(Set<Range> o) {
            splitRangeByTablets_result result = new splitRangeByTablets_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            splitRangeByTablets_result result = new splitRangeByTablets_result();
            if (e instanceof AccumuloException) {
                        result.ouch1 = (AccumuloException) e;
                        result.setOuch1IsSet(true);
                        msg = result;
            }
            else             if (e instanceof AccumuloSecurityException) {
                        result.ouch2 = (AccumuloSecurityException) e;
                        result.setOuch2IsSet(true);
                        msg = result;
            }
            else             if (e instanceof TableNotFoundException) {
                        result.ouch3 = (TableNotFoundException) e;
                        result.setOuch3IsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, splitRangeByTablets_args args, org.apache.thrift.async.AsyncMethodCallback<Set<Range>> resultHandler) throws TException {
        iface.splitRangeByTablets(args.login, args.tableName, args.range, args.maxSplits,resultHandler);
      }
    }

    public static class tableExists<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, tableExists_args, Boolean> {
      public tableExists() {
        super("tableExists");
      }

      public tableExists_args getEmptyArgsInstance() {
        return new tableExists_args();
      }

      public AsyncMethodCallback<Boolean> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Boolean>() { 
          public void onComplete(Boolean o) {
            tableExists_result result = new tableExists_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            tableExists_result result = new tableExists_result();
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, tableExists_args args, org.apache.thrift.async.AsyncMethodCallback<Boolean> resultHandler) throws TException {
        iface.tableExists(args.login, args.tableName,resultHandler);
      }
    }

    public static class tableIdMap<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, tableIdMap_args, Map<String,String>> {
      public tableIdMap() {
        super("tableIdMap");
      }

      public tableIdMap_args getEmptyArgsInstance() {
        return new tableIdMap_args();
      }

      public AsyncMethodCallback<Map<String,String>> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Map<String,String>>() { 
          public void onComplete(Map<String,String> o) {
            tableIdMap_result result = new tableIdMap_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            tableIdMap_result result = new tableIdMap_result();
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, tableIdMap_args args, org.apache.thrift.async.AsyncMethodCallback<Map<String,String>> resultHandler) throws TException {
        iface.tableIdMap(args.login,resultHandler);
      }
    }

    public static class testTableClassLoad<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, testTableClassLoad_args, Boolean> {
      public testTableClassLoad() {
        super("testTableClassLoad");
      }

      public testTableClassLoad_args getEmptyArgsInstance() {
        return new testTableClassLoad_args();
      }

      public AsyncMethodCallback<Boolean> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Boolean>() { 
          public void onComplete(Boolean o) {
            testTableClassLoad_result result = new testTableClassLoad_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            testTableClassLoad_result result = new testTableClassLoad_result();
            if (e instanceof AccumuloException) {
                        result.ouch1 = (AccumuloException) e;
                        result.setOuch1IsSet(true);
                        msg = result;
            }
            else             if (e instanceof AccumuloSecurityException) {
                        result.ouch2 = (AccumuloSecurityException) e;
                        result.setOuch2IsSet(true);
                        msg = result;
            }
            else             if (e instanceof TableNotFoundException) {
                        result.ouch3 = (TableNotFoundException) e;
                        result.setOuch3IsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, testTableClassLoad_args args, org.apache.thrift.async.AsyncMethodCallback<Boolean> resultHandler) throws TException {
        iface.testTableClassLoad(args.login, args.tableName, args.className, args.asTypeName,resultHandler);
      }
    }

    public static class pingTabletServer<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, pingTabletServer_args, Void> {
      public pingTabletServer() {
        super("pingTabletServer");
      }

      public pingTabletServer_args getEmptyArgsInstance() {
        return new pingTabletServer_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            pingTabletServer_result result = new pingTabletServer_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            pingTabletServer_result result = new pingTabletServer_result();
            if (e instanceof AccumuloException) {
                        result.ouch1 = (AccumuloException) e;
                        result.setOuch1IsSet(true);
                        msg = result;
            }
            else             if (e instanceof AccumuloSecurityException) {
                        result.ouch2 = (AccumuloSecurityException) e;
                        result.setOuch2IsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, pingTabletServer_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.pingTabletServer(args.login, args.tserver,resultHandler);
      }
    }

    public static class getActiveScans<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getActiveScans_args, List<ActiveScan>> {
      public getActiveScans() {
        super("getActiveScans");
      }

      public getActiveScans_args getEmptyArgsInstance() {
        return new getActiveScans_args();
      }

      public AsyncMethodCallback<List<ActiveScan>> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<List<ActiveScan>>() { 
          public void onComplete(List<ActiveScan> o) {
            getActiveScans_result result = new getActiveScans_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            getActiveScans_result result = new getActiveScans_result();
            if (e instanceof AccumuloException) {
                        result.ouch1 = (AccumuloException) e;
                        result.setOuch1IsSet(true);
                        msg = result;
            }
            else             if (e instanceof AccumuloSecurityException) {
                        result.ouch2 = (AccumuloSecurityException) e;
                        result.setOuch2IsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getActiveScans_args args, org.apache.thrift.async.AsyncMethodCallback<List<ActiveScan>> resultHandler) throws TException {
        iface.getActiveScans(args.login, args.tserver,resultHandler);
      }
    }

    public static class getActiveCompactions<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getActiveCompactions_args, List<ActiveCompaction>> {
      public getActiveCompactions() {
        super("getActiveCompactions");
      }

      public getActiveCompactions_args getEmptyArgsInstance() {
        return new getActiveCompactions_args();
      }

      public AsyncMethodCallback<List<ActiveCompaction>> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<List<ActiveCompaction>>() { 
          public void onComplete(List<ActiveCompaction> o) {
            getActiveCompactions_result result = new getActiveCompactions_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            getActiveCompactions_result result = new getActiveCompactions_result();
            if (e instanceof AccumuloException) {
                        result.ouch1 = (AccumuloException) e;
                        result.setOuch1IsSet(true);
                        msg = result;
            }
            else             if (e instanceof AccumuloSecurityException) {
                        result.ouch2 = (AccumuloSecurityException) e;
                        result.setOuch2IsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getActiveCompactions_args args, org.apache.thrift.async.AsyncMethodCallback<List<ActiveCompaction>> resultHandler) throws TException {
        iface.getActiveCompactions(args.login, args.tserver,resultHandler);
      }
    }

    public static class getSiteConfiguration<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getSiteConfiguration_args, Map<String,String>> {
      public getSiteConfiguration() {
        super("getSiteConfiguration");
      }

      public getSiteConfiguration_args getEmptyArgsInstance() {
        return new getSiteConfiguration_args();
      }

      public AsyncMethodCallback<Map<String,String>> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Map<String,String>>() { 
          public void onComplete(Map<String,String> o) {
            getSiteConfiguration_result result = new getSiteConfiguration_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            getSiteConfiguration_result result = new getSiteConfiguration_result();
            if (e instanceof AccumuloException) {
                        result.ouch1 = (AccumuloException) e;
                        result.setOuch1IsSet(true);
                        msg = result;
            }
            else             if (e instanceof AccumuloSecurityException) {
                        result.ouch2 = (AccumuloSecurityException) e;
                        result.setOuch2IsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getSiteConfiguration_args args, org.apache.thrift.async.AsyncMethodCallback<Map<String,String>> resultHandler) throws TException {
        iface.getSiteConfiguration(args.login,resultHandler);
      }
    }

    public static class getSystemConfiguration<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getSystemConfiguration_args, Map<String,String>> {
      public getSystemConfiguration() {
        super("getSystemConfiguration");
      }

      public getSystemConfiguration_args getEmptyArgsInstance() {
        return new getSystemConfiguration_args();
      }

      public AsyncMethodCallback<Map<String,String>> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Map<String,String>>() { 
          public void onComplete(Map<String,String> o) {
            getSystemConfiguration_result result = new getSystemConfiguration_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            getSystemConfiguration_result result = new getSystemConfiguration_result();
            if (e instanceof AccumuloException) {
                        result.ouch1 = (AccumuloException) e;
                        result.setOuch1IsSet(true);
                        msg = result;
            }
            else             if (e instanceof AccumuloSecurityException) {
                        result.ouch2 = (AccumuloSecurityException) e;
                        result.setOuch2IsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getSystemConfiguration_args args, org.apache.thrift.async.AsyncMethodCallback<Map<String,String>> resultHandler) throws TException {
        iface.getSystemConfiguration(args.login,resultHandler);
      }
    }

    public static class getTabletServers<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getTabletServers_args, List<String>> {
      public getTabletServers() {
        super("getTabletServers");
      }

      public getTabletServers_args getEmptyArgsInstance() {
        return new getTabletServers_args();
      }

      public AsyncMethodCallback<List<String>> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<List<String>>() { 
          public void onComplete(List<String> o) {
            getTabletServers_result result = new getTabletServers_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            getTabletServers_result result = new getTabletServers_result();
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getTabletServers_args args, org.apache.thrift.async.AsyncMethodCallback<List<String>> resultHandler) throws TException {
        iface.getTabletServers(args.login,resultHandler);
      }
    }

    public static class removeProperty<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, removeProperty_args, Void> {
      public removeProperty() {
        super("removeProperty");
      }

      public removeProperty_args getEmptyArgsInstance() {
        return new removeProperty_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            removeProperty_result result = new removeProperty_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            removeProperty_result result = new removeProperty_result();
            if (e instanceof AccumuloException) {
                        result.ouch1 = (AccumuloException) e;
                        result.setOuch1IsSet(true);
                        msg = result;
            }
            else             if (e instanceof AccumuloSecurityException) {
                        result.ouch2 = (AccumuloSecurityException) e;
                        result.setOuch2IsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, removeProperty_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.removeProperty(args.login, args.property,resultHandler);
      }
    }

    public static class setProperty<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, setProperty_args, Void> {
      public setProperty() {
        super("setProperty");
      }

      public setProperty_args getEmptyArgsInstance() {
        return new setProperty_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            setProperty_result result = new setProperty_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            setProperty_result result = new setProperty_result();
            if (e instanceof AccumuloException) {
                        result.ouch1 = (AccumuloException) e;
                        result.setOuch1IsSet(true);
                        msg = result;
            }
            else             if (e instanceof AccumuloSecurityException) {
                        result.ouch2 = (AccumuloSecurityException) e;
                        result.setOuch2IsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, setProperty_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.setProperty(args.login, args.property, args.value,resultHandler);
      }
    }

    public static class testClassLoad<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, testClassLoad_args, Boolean> {
      public testClassLoad() {
        super("testClassLoad");
      }

      public testClassLoad_args getEmptyArgsInstance() {
        return new testClassLoad_args();
      }

      public AsyncMethodCallback<Boolean> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Boolean>() { 
          public void onComplete(Boolean o) {
            testClassLoad_result result = new testClassLoad_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            testClassLoad_result result = new testClassLoad_result();
            if (e instanceof AccumuloException) {
                        result.ouch1 = (AccumuloException) e;
                        result.setOuch1IsSet(true);
                        msg = result;
            }
            else             if (e instanceof AccumuloSecurityException) {
                        result.ouch2 = (AccumuloSecurityException) e;
                        result.setOuch2IsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, testClassLoad_args args, org.apache.thrift.async.AsyncMethodCallback<Boolean> resultHandler) throws TException {
        iface.testClassLoad(args.login, args.className, args.asTypeName,resultHandler);
      }
    }

    public static class authenticateUser<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, authenticateUser_args, Boolean> {
      public authenticateUser() {
        super("authenticateUser");
      }

      public authenticateUser_args getEmptyArgsInstance() {
        return new authenticateUser_args();
      }

      public AsyncMethodCallback<Boolean> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Boolean>() { 
          public void onComplete(Boolean o) {
            authenticateUser_result result = new authenticateUser_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            authenticateUser_result result = new authenticateUser_result();
            if (e instanceof AccumuloException) {
                        result.ouch1 = (AccumuloException) e;
                        result.setOuch1IsSet(true);
                        msg = result;
            }
            else             if (e instanceof AccumuloSecurityException) {
                        result.ouch2 = (AccumuloSecurityException) e;
                        result.setOuch2IsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, authenticateUser_args args, org.apache.thrift.async.AsyncMethodCallback<Boolean> resultHandler) throws TException {
        iface.authenticateUser(args.login, args.user, args.properties,resultHandler);
      }
    }

    public static class changeUserAuthorizations<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, changeUserAuthorizations_args, Void> {
      public changeUserAuthorizations() {
        super("changeUserAuthorizations");
      }

      public changeUserAuthorizations_args getEmptyArgsInstance() {
        return new changeUserAuthorizations_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            changeUserAuthorizations_result result = new changeUserAuthorizations_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            changeUserAuthorizations_result result = new changeUserAuthorizations_result();
            if (e instanceof AccumuloException) {
                        result.ouch1 = (AccumuloException) e;
                        result.setOuch1IsSet(true);
                        msg = result;
            }
            else             if (e instanceof AccumuloSecurityException) {
                        result.ouch2 = (AccumuloSecurityException) e;
                        result.setOuch2IsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, changeUserAuthorizations_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.changeUserAuthorizations(args.login, args.user, args.authorizations,resultHandler);
      }
    }

    public static class changeLocalUserPassword<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, changeLocalUserPassword_args, Void> {
      public changeLocalUserPassword() {
        super("changeLocalUserPassword");
      }

      public changeLocalUserPassword_args getEmptyArgsInstance() {
        return new changeLocalUserPassword_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            changeLocalUserPassword_result result = new changeLocalUserPassword_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            changeLocalUserPassword_result result = new changeLocalUserPassword_result();
            if (e instanceof AccumuloException) {
                        result.ouch1 = (AccumuloException) e;
                        result.setOuch1IsSet(true);
                        msg = result;
            }
            else             if (e instanceof AccumuloSecurityException) {
                        result.ouch2 = (AccumuloSecurityException) e;
                        result.setOuch2IsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, changeLocalUserPassword_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.changeLocalUserPassword(args.login, args.user, args.password,resultHandler);
      }
    }

    public static class createLocalUser<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, createLocalUser_args, Void> {
      public createLocalUser() {
        super("createLocalUser");
      }

      public createLocalUser_args getEmptyArgsInstance() {
        return new createLocalUser_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            createLocalUser_result result = new createLocalUser_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            createLocalUser_result result = new createLocalUser_result();
            if (e instanceof AccumuloException) {
                        result.ouch1 = (AccumuloException) e;
                        result.setOuch1IsSet(true);
                        msg = result;
            }
            else             if (e instanceof AccumuloSecurityException) {
                        result.ouch2 = (AccumuloSecurityException) e;
                        result.setOuch2IsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, createLocalUser_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.createLocalUser(args.login, args.user, args.password,resultHandler);
      }
    }

    public static class dropLocalUser<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, dropLocalUser_args, Void> {
      public dropLocalUser() {
        super("dropLocalUser");
      }

      public dropLocalUser_args getEmptyArgsInstance() {
        return new dropLocalUser_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            dropLocalUser_result result = new dropLocalUser_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            dropLocalUser_result result = new dropLocalUser_result();
            if (e instanceof AccumuloException) {
                        result.ouch1 = (AccumuloException) e;
                        result.setOuch1IsSet(true);
                        msg = result;
            }
            else             if (e instanceof AccumuloSecurityException) {
                        result.ouch2 = (AccumuloSecurityException) e;
                        result.setOuch2IsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, dropLocalUser_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.dropLocalUser(args.login, args.user,resultHandler);
      }
    }

    public static class getUserAuthorizations<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getUserAuthorizations_args, List<ByteBuffer>> {
      public getUserAuthorizations() {
        super("getUserAuthorizations");
      }

      public getUserAuthorizations_args getEmptyArgsInstance() {
        return new getUserAuthorizations_args();
      }

      public AsyncMethodCallback<List<ByteBuffer>> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<List<ByteBuffer>>() { 
          public void onComplete(List<ByteBuffer> o) {
            getUserAuthorizations_result result = new getUserAuthorizations_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            getUserAuthorizations_result result = new getUserAuthorizations_result();
            if (e instanceof AccumuloException) {
                        result.ouch1 = (AccumuloException) e;
                        result.setOuch1IsSet(true);
                        msg = result;
            }
            else             if (e instanceof AccumuloSecurityException) {
                        result.ouch2 = (AccumuloSecurityException) e;
                        result.setOuch2IsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getUserAuthorizations_args args, org.apache.thrift.async.AsyncMethodCallback<List<ByteBuffer>> resultHandler) throws TException {
        iface.getUserAuthorizations(args.login, args.user,resultHandler);
      }
    }

    public static class grantSystemPermission<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, grantSystemPermission_args, Void> {
      public grantSystemPermission() {
        super("grantSystemPermission");
      }

      public grantSystemPermission_args getEmptyArgsInstance() {
        return new grantSystemPermission_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            grantSystemPermission_result result = new grantSystemPermission_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            grantSystemPermission_result result = new grantSystemPermission_result();
            if (e instanceof AccumuloException) {
                        result.ouch1 = (AccumuloException) e;
                        result.setOuch1IsSet(true);
                        msg = result;
            }
            else             if (e instanceof AccumuloSecurityException) {
                        result.ouch2 = (AccumuloSecurityException) e;
                        result.setOuch2IsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, grantSystemPermission_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.grantSystemPermission(args.login, args.user, args.perm,resultHandler);
      }
    }

    public static class grantTablePermission<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, grantTablePermission_args, Void> {
      public grantTablePermission() {
        super("grantTablePermission");
      }

      public grantTablePermission_args getEmptyArgsInstance() {
        return new grantTablePermission_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            grantTablePermission_result result = new grantTablePermission_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            grantTablePermission_result result = new grantTablePermission_result();
            if (e instanceof AccumuloException) {
                        result.ouch1 = (AccumuloException) e;
                        result.setOuch1IsSet(true);
                        msg = result;
            }
            else             if (e instanceof AccumuloSecurityException) {
                        result.ouch2 = (AccumuloSecurityException) e;
                        result.setOuch2IsSet(true);
                        msg = result;
            }
            else             if (e instanceof TableNotFoundException) {
                        result.ouch3 = (TableNotFoundException) e;
                        result.setOuch3IsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, grantTablePermission_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.grantTablePermission(args.login, args.user, args.table, args.perm,resultHandler);
      }
    }

    public static class hasSystemPermission<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, hasSystemPermission_args, Boolean> {
      public hasSystemPermission() {
        super("hasSystemPermission");
      }

      public hasSystemPermission_args getEmptyArgsInstance() {
        return new hasSystemPermission_args();
      }

      public AsyncMethodCallback<Boolean> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Boolean>() { 
          public void onComplete(Boolean o) {
            hasSystemPermission_result result = new hasSystemPermission_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            hasSystemPermission_result result = new hasSystemPermission_result();
            if (e instanceof AccumuloException) {
                        result.ouch1 = (AccumuloException) e;
                        result.setOuch1IsSet(true);
                        msg = result;
            }
            else             if (e instanceof AccumuloSecurityException) {
                        result.ouch2 = (AccumuloSecurityException) e;
                        result.setOuch2IsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, hasSystemPermission_args args, org.apache.thrift.async.AsyncMethodCallback<Boolean> resultHandler) throws TException {
        iface.hasSystemPermission(args.login, args.user, args.perm,resultHandler);
      }
    }

    public static class hasTablePermission<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, hasTablePermission_args, Boolean> {
      public hasTablePermission() {
        super("hasTablePermission");
      }

      public hasTablePermission_args getEmptyArgsInstance() {
        return new hasTablePermission_args();
      }

      public AsyncMethodCallback<Boolean> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Boolean>() { 
          public void onComplete(Boolean o) {
            hasTablePermission_result result = new hasTablePermission_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            hasTablePermission_result result = new hasTablePermission_result();
            if (e instanceof AccumuloException) {
                        result.ouch1 = (AccumuloException) e;
                        result.setOuch1IsSet(true);
                        msg = result;
            }
            else             if (e instanceof AccumuloSecurityException) {
                        result.ouch2 = (AccumuloSecurityException) e;
                        result.setOuch2IsSet(true);
                        msg = result;
            }
            else             if (e instanceof TableNotFoundException) {
                        result.ouch3 = (TableNotFoundException) e;
                        result.setOuch3IsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, hasTablePermission_args args, org.apache.thrift.async.AsyncMethodCallback<Boolean> resultHandler) throws TException {
        iface.hasTablePermission(args.login, args.user, args.table, args.perm,resultHandler);
      }
    }

    public static class listLocalUsers<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, listLocalUsers_args, Set<String>> {
      public listLocalUsers() {
        super("listLocalUsers");
      }

      public listLocalUsers_args getEmptyArgsInstance() {
        return new listLocalUsers_args();
      }

      public AsyncMethodCallback<Set<String>> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Set<String>>() { 
          public void onComplete(Set<String> o) {
            listLocalUsers_result result = new listLocalUsers_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            listLocalUsers_result result = new listLocalUsers_result();
            if (e instanceof AccumuloException) {
                        result.ouch1 = (AccumuloException) e;
                        result.setOuch1IsSet(true);
                        msg = result;
            }
            else             if (e instanceof AccumuloSecurityException) {
                        result.ouch2 = (AccumuloSecurityException) e;
                        result.setOuch2IsSet(true);
                        msg = result;
            }
            else             if (e instanceof TableNotFoundException) {
                        result.ouch3 = (TableNotFoundException) e;
                        result.setOuch3IsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, listLocalUsers_args args, org.apache.thrift.async.AsyncMethodCallback<Set<String>> resultHandler) throws TException {
        iface.listLocalUsers(args.login,resultHandler);
      }
    }

    public static class revokeSystemPermission<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, revokeSystemPermission_args, Void> {
      public revokeSystemPermission() {
        super("revokeSystemPermission");
      }

      public revokeSystemPermission_args getEmptyArgsInstance() {
        return new revokeSystemPermission_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            revokeSystemPermission_result result = new revokeSystemPermission_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            revokeSystemPermission_result result = new revokeSystemPermission_result();
            if (e instanceof AccumuloException) {
                        result.ouch1 = (AccumuloException) e;
                        result.setOuch1IsSet(true);
                        msg = result;
            }
            else             if (e instanceof AccumuloSecurityException) {
                        result.ouch2 = (AccumuloSecurityException) e;
                        result.setOuch2IsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, revokeSystemPermission_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.revokeSystemPermission(args.login, args.user, args.perm,resultHandler);
      }
    }

    public static class revokeTablePermission<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, revokeTablePermission_args, Void> {
      public revokeTablePermission() {
        super("revokeTablePermission");
      }

      public revokeTablePermission_args getEmptyArgsInstance() {
        return new revokeTablePermission_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            revokeTablePermission_result result = new revokeTablePermission_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            revokeTablePermission_result result = new revokeTablePermission_result();
            if (e instanceof AccumuloException) {
                        result.ouch1 = (AccumuloException) e;
                        result.setOuch1IsSet(true);
                        msg = result;
            }
            else             if (e instanceof AccumuloSecurityException) {
                        result.ouch2 = (AccumuloSecurityException) e;
                        result.setOuch2IsSet(true);
                        msg = result;
            }
            else             if (e instanceof TableNotFoundException) {
                        result.ouch3 = (TableNotFoundException) e;
                        result.setOuch3IsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, revokeTablePermission_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.revokeTablePermission(args.login, args.user, args.table, args.perm,resultHandler);
      }
    }

    public static class grantNamespacePermission<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, grantNamespacePermission_args, Void> {
      public grantNamespacePermission() {
        super("grantNamespacePermission");
      }

      public grantNamespacePermission_args getEmptyArgsInstance() {
        return new grantNamespacePermission_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            grantNamespacePermission_result result = new grantNamespacePermission_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            grantNamespacePermission_result result = new grantNamespacePermission_result();
            if (e instanceof AccumuloException) {
                        result.ouch1 = (AccumuloException) e;
                        result.setOuch1IsSet(true);
                        msg = result;
            }
            else             if (e instanceof AccumuloSecurityException) {
                        result.ouch2 = (AccumuloSecurityException) e;
                        result.setOuch2IsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, grantNamespacePermission_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.grantNamespacePermission(args.login, args.user, args.namespaceName, args.perm,resultHandler);
      }
    }

    public static class hasNamespacePermission<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, hasNamespacePermission_args, Boolean> {
      public hasNamespacePermission() {
        super("hasNamespacePermission");
      }

      public hasNamespacePermission_args getEmptyArgsInstance() {
        return new hasNamespacePermission_args();
      }

      public AsyncMethodCallback<Boolean> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Boolean>() { 
          public void onComplete(Boolean o) {
            hasNamespacePermission_result result = new hasNamespacePermission_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            hasNamespacePermission_result result = new hasNamespacePermission_result();
            if (e instanceof AccumuloException) {
                        result.ouch1 = (AccumuloException) e;
                        result.setOuch1IsSet(true);
                        msg = result;
            }
            else             if (e instanceof AccumuloSecurityException) {
                        result.ouch2 = (AccumuloSecurityException) e;
                        result.setOuch2IsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, hasNamespacePermission_args args, org.apache.thrift.async.AsyncMethodCallback<Boolean> resultHandler) throws TException {
        iface.hasNamespacePermission(args.login, args.user, args.namespaceName, args.perm,resultHandler);
      }
    }

    public static class revokeNamespacePermission<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, revokeNamespacePermission_args, Void> {
      public revokeNamespacePermission() {
        super("revokeNamespacePermission");
      }

      public revokeNamespacePermission_args getEmptyArgsInstance() {
        return new revokeNamespacePermission_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            revokeNamespacePermission_result result = new revokeNamespacePermission_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            revokeNamespacePermission_result result = new revokeNamespacePermission_result();
            if (e instanceof AccumuloException) {
                        result.ouch1 = (AccumuloException) e;
                        result.setOuch1IsSet(true);
                        msg = result;
            }
            else             if (e instanceof AccumuloSecurityException) {
                        result.ouch2 = (AccumuloSecurityException) e;
                        result.setOuch2IsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, revokeNamespacePermission_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.revokeNamespacePermission(args.login, args.user, args.namespaceName, args.perm,resultHandler);
      }
    }

    public static class createBatchScanner<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, createBatchScanner_args, String> {
      public createBatchScanner() {
        super("createBatchScanner");
      }

      public createBatchScanner_args getEmptyArgsInstance() {
        return new createBatchScanner_args();
      }

      public AsyncMethodCallback<String> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<String>() { 
          public void onComplete(String o) {
            createBatchScanner_result result = new createBatchScanner_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            createBatchScanner_result result = new createBatchScanner_result();
            if (e instanceof AccumuloException) {
                        result.ouch1 = (AccumuloException) e;
                        result.setOuch1IsSet(true);
                        msg = result;
            }
            else             if (e instanceof AccumuloSecurityException) {
                        result.ouch2 = (AccumuloSecurityException) e;
                        result.setOuch2IsSet(true);
                        msg = result;
            }
            else             if (e instanceof TableNotFoundException) {
                        result.ouch3 = (TableNotFoundException) e;
                        result.setOuch3IsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, createBatchScanner_args args, org.apache.thrift.async.AsyncMethodCallback<String> resultHandler) throws TException {
        iface.createBatchScanner(args.login, args.tableName, args.options,resultHandler);
      }
    }

    public static class createScanner<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, createScanner_args, String> {
      public createScanner() {
        super("createScanner");
      }

      public createScanner_args getEmptyArgsInstance() {
        return new createScanner_args();
      }

      public AsyncMethodCallback<String> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<String>() { 
          public void onComplete(String o) {
            createScanner_result result = new createScanner_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            createScanner_result result = new createScanner_result();
            if (e instanceof AccumuloException) {
                        result.ouch1 = (AccumuloException) e;
                        result.setOuch1IsSet(true);
                        msg = result;
            }
            else             if (e instanceof AccumuloSecurityException) {
                        result.ouch2 = (AccumuloSecurityException) e;
                        result.setOuch2IsSet(true);
                        msg = result;
            }
            else             if (e instanceof TableNotFoundException) {
                        result.ouch3 = (TableNotFoundException) e;
                        result.setOuch3IsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, createScanner_args args, org.apache.thrift.async.AsyncMethodCallback<String> resultHandler) throws TException {
        iface.createScanner(args.login, args.tableName, args.options,resultHandler);
      }
    }

    public static class hasNext<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, hasNext_args, Boolean> {
      public hasNext() {
        super("hasNext");
      }

      public hasNext_args getEmptyArgsInstance() {
        return new hasNext_args();
      }

      public AsyncMethodCallback<Boolean> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Boolean>() { 
          public void onComplete(Boolean o) {
            hasNext_result result = new hasNext_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            hasNext_result result = new hasNext_result();
            if (e instanceof UnknownScanner) {
                        result.ouch1 = (UnknownScanner) e;
                        result.setOuch1IsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, hasNext_args args, org.apache.thrift.async.AsyncMethodCallback<Boolean> resultHandler) throws TException {
        iface.hasNext(args.scanner,resultHandler);
      }
    }

    public static class nextEntry<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, nextEntry_args, KeyValueAndPeek> {
      public nextEntry() {
        super("nextEntry");
      }

      public nextEntry_args getEmptyArgsInstance() {
        return new nextEntry_args();
      }

      public AsyncMethodCallback<KeyValueAndPeek> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<KeyValueAndPeek>() { 
          public void onComplete(KeyValueAndPeek o) {
            nextEntry_result result = new nextEntry_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            nextEntry_result result = new nextEntry_result();
            if (e instanceof NoMoreEntriesException) {
                        result.ouch1 = (NoMoreEntriesException) e;
                        result.setOuch1IsSet(true);
                        msg = result;
            }
            else             if (e instanceof UnknownScanner) {
                        result.ouch2 = (UnknownScanner) e;
                        result.setOuch2IsSet(true);
                        msg = result;
            }
            else             if (e instanceof AccumuloSecurityException) {
                        result.ouch3 = (AccumuloSecurityException) e;
                        result.setOuch3IsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, nextEntry_args args, org.apache.thrift.async.AsyncMethodCallback<KeyValueAndPeek> resultHandler) throws TException {
        iface.nextEntry(args.scanner,resultHandler);
      }
    }

    public static class nextK<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, nextK_args, ScanResult> {
      public nextK() {
        super("nextK");
      }

      public nextK_args getEmptyArgsInstance() {
        return new nextK_args();
      }

      public AsyncMethodCallback<ScanResult> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<ScanResult>() { 
          public void onComplete(ScanResult o) {
            nextK_result result = new nextK_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            nextK_result result = new nextK_result();
            if (e instanceof NoMoreEntriesException) {
                        result.ouch1 = (NoMoreEntriesException) e;
                        result.setOuch1IsSet(true);
                        msg = result;
            }
            else             if (e instanceof UnknownScanner) {
                        result.ouch2 = (UnknownScanner) e;
                        result.setOuch2IsSet(true);
                        msg = result;
            }
            else             if (e instanceof AccumuloSecurityException) {
                        result.ouch3 = (AccumuloSecurityException) e;
                        result.setOuch3IsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, nextK_args args, org.apache.thrift.async.AsyncMethodCallback<ScanResult> resultHandler) throws TException {
        iface.nextK(args.scanner, args.k,resultHandler);
      }
    }

    public static class closeScanner<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, closeScanner_args, Void> {
      public closeScanner() {
        super("closeScanner");
      }

      public closeScanner_args getEmptyArgsInstance() {
        return new closeScanner_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            closeScanner_result result = new closeScanner_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            closeScanner_result result = new closeScanner_result();
            if (e instanceof UnknownScanner) {
                        result.ouch1 = (UnknownScanner) e;
                        result.setOuch1IsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, closeScanner_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.closeScanner(args.scanner,resultHandler);
      }
    }

    public static class updateAndFlush<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, updateAndFlush_args, Void> {
      public updateAndFlush() {
        super("updateAndFlush");
      }

      public updateAndFlush_args getEmptyArgsInstance() {
        return new updateAndFlush_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            updateAndFlush_result result = new updateAndFlush_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            updateAndFlush_result result = new updateAndFlush_result();
            if (e instanceof AccumuloException) {
                        result.outch1 = (AccumuloException) e;
                        result.setOutch1IsSet(true);
                        msg = result;
            }
            else             if (e instanceof AccumuloSecurityException) {
                        result.ouch2 = (AccumuloSecurityException) e;
                        result.setOuch2IsSet(true);
                        msg = result;
            }
            else             if (e instanceof TableNotFoundException) {
                        result.ouch3 = (TableNotFoundException) e;
                        result.setOuch3IsSet(true);
                        msg = result;
            }
            else             if (e instanceof MutationsRejectedException) {
                        result.ouch4 = (MutationsRejectedException) e;
                        result.setOuch4IsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, updateAndFlush_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.updateAndFlush(args.login, args.tableName, args.cells,resultHandler);
      }
    }

    public static class createWriter<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, createWriter_args, String> {
      public createWriter() {
        super("createWriter");
      }

      public createWriter_args getEmptyArgsInstance() {
        return new createWriter_args();
      }

      public AsyncMethodCallback<String> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<String>() { 
          public void onComplete(String o) {
            createWriter_result result = new createWriter_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            createWriter_result result = new createWriter_result();
            if (e instanceof AccumuloException) {
                        result.outch1 = (AccumuloException) e;
                        result.setOutch1IsSet(true);
                        msg = result;
            }
            else             if (e instanceof AccumuloSecurityException) {
                        result.ouch2 = (AccumuloSecurityException) e;
                        result.setOuch2IsSet(true);
                        msg = result;
            }
            else             if (e instanceof TableNotFoundException) {
                        result.ouch3 = (TableNotFoundException) e;
                        result.setOuch3IsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, createWriter_args args, org.apache.thrift.async.AsyncMethodCallback<String> resultHandler) throws TException {
        iface.createWriter(args.login, args.tableName, args.opts,resultHandler);
      }
    }

    public static class update<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, update_args, Void> {
      public update() {
        super("update");
      }

      public update_args getEmptyArgsInstance() {
        return new update_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
          }
          public void onError(Exception e) {
          }
        };
      }

      protected boolean isOneway() {
        return true;
      }

      public void start(I iface, update_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.update(args.writer, args.cells,resultHandler);
      }
    }

    public static class flush<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, flush_args, Void> {
      public flush() {
        super("flush");
      }

      public flush_args getEmptyArgsInstance() {
        return new flush_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            flush_result result = new flush_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            flush_result result = new flush_result();
            if (e instanceof UnknownWriter) {
                        result.ouch1 = (UnknownWriter) e;
                        result.setOuch1IsSet(true);
                        msg = result;
            }
            else             if (e instanceof MutationsRejectedException) {
                        result.ouch2 = (MutationsRejectedException) e;
                        result.setOuch2IsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, flush_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.flush(args.writer,resultHandler);
      }
    }

    public static class closeWriter<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, closeWriter_args, Void> {
      public closeWriter() {
        super("closeWriter");
      }

      public closeWriter_args getEmptyArgsInstance() {
        return new closeWriter_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            closeWriter_result result = new closeWriter_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            closeWriter_result result = new closeWriter_result();
            if (e instanceof UnknownWriter) {
                        result.ouch1 = (UnknownWriter) e;
                        result.setOuch1IsSet(true);
                        msg = result;
            }
            else             if (e instanceof MutationsRejectedException) {
                        result.ouch2 = (MutationsRejectedException) e;
                        result.setOuch2IsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, closeWriter_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.closeWriter(args.writer,resultHandler);
      }
    }

    public static class updateRowConditionally<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, updateRowConditionally_args, ConditionalStatus> {
      public updateRowConditionally() {
        super("updateRowConditionally");
      }

      public updateRowConditionally_args getEmptyArgsInstance() {
        return new updateRowConditionally_args();
      }

      public AsyncMethodCallback<ConditionalStatus> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<ConditionalStatus>() { 
          public void onComplete(ConditionalStatus o) {
            updateRowConditionally_result result = new updateRowConditionally_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            updateRowConditionally_result result = new updateRowConditionally_result();
            if (e instanceof AccumuloException) {
                        result.ouch1 = (AccumuloException) e;
                        result.setOuch1IsSet(true);
                        msg = result;
            }
            else             if (e instanceof AccumuloSecurityException) {
                        result.ouch2 = (AccumuloSecurityException) e;
                        result.setOuch2IsSet(true);
                        msg = result;
            }
            else             if (e instanceof TableNotFoundException) {
                        result.ouch3 = (TableNotFoundException) e;
                        result.setOuch3IsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, updateRowConditionally_args args, org.apache.thrift.async.AsyncMethodCallback<ConditionalStatus> resultHandler) throws TException {
        iface.updateRowConditionally(args.login, args.tableName, args.row, args.updates,resultHandler);
      }
    }

    public static class createConditionalWriter<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, createConditionalWriter_args, String> {
      public createConditionalWriter() {
        super("createConditionalWriter");
      }

      public createConditionalWriter_args getEmptyArgsInstance() {
        return new createConditionalWriter_args();
      }

      public AsyncMethodCallback<String> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<String>() { 
          public void onComplete(String o) {
            createConditionalWriter_result result = new createConditionalWriter_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            createConditionalWriter_result result = new createConditionalWriter_result();
            if (e instanceof AccumuloException) {
                        result.ouch1 = (AccumuloException) e;
                        result.setOuch1IsSet(true);
                        msg = result;
            }
            else             if (e instanceof AccumuloSecurityException) {
                        result.ouch2 = (AccumuloSecurityException) e;
                        result.setOuch2IsSet(true);
                        msg = result;
            }
            else             if (e instanceof TableNotFoundException) {
                        result.ouch3 = (TableNotFoundException) e;
                        result.setOuch3IsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, createConditionalWriter_args args, org.apache.thrift.async.AsyncMethodCallback<String> resultHandler) throws TException {
        iface.createConditionalWriter(args.login, args.tableName, args.options,resultHandler);
      }
    }

    public static class updateRowsConditionally<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, updateRowsConditionally_args, Map<ByteBuffer,ConditionalStatus>> {
      public updateRowsConditionally() {
        super("updateRowsConditionally");
      }

      public updateRowsConditionally_args getEmptyArgsInstance() {
        return new updateRowsConditionally_args();
      }

      public AsyncMethodCallback<Map<ByteBuffer,ConditionalStatus>> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Map<ByteBuffer,ConditionalStatus>>() { 
          public void onComplete(Map<ByteBuffer,ConditionalStatus> o) {
            updateRowsConditionally_result result = new updateRowsConditionally_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            updateRowsConditionally_result result = new updateRowsConditionally_result();
            if (e instanceof UnknownWriter) {
                        result.ouch1 = (UnknownWriter) e;
                        result.setOuch1IsSet(true);
                        msg = result;
            }
            else             if (e instanceof AccumuloException) {
                        result.ouch2 = (AccumuloException) e;
                        result.setOuch2IsSet(true);
                        msg = result;
            }
            else             if (e instanceof AccumuloSecurityException) {
                        result.ouch3 = (AccumuloSecurityException) e;
                        result.setOuch3IsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, updateRowsConditionally_args args, org.apache.thrift.async.AsyncMethodCallback<Map<ByteBuffer,ConditionalStatus>> resultHandler) throws TException {
        iface.updateRowsConditionally(args.conditionalWriter, args.updates,resultHandler);
      }
    }

    public static class closeConditionalWriter<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, closeConditionalWriter_args, Void> {
      public closeConditionalWriter() {
        super("closeConditionalWriter");
      }

      public closeConditionalWriter_args getEmptyArgsInstance() {
        return new closeConditionalWriter_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            closeConditionalWriter_result result = new closeConditionalWriter_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            closeConditionalWriter_result result = new closeConditionalWriter_result();
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, closeConditionalWriter_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.closeConditionalWriter(args.conditionalWriter,resultHandler);
      }
    }

    public static class getRowRange<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getRowRange_args, Range> {
      public getRowRange() {
        super("getRowRange");
      }

      public getRowRange_args getEmptyArgsInstance() {
        return new getRowRange_args();
      }

      public AsyncMethodCallback<Range> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Range>() { 
          public void onComplete(Range o) {
            getRowRange_result result = new getRowRange_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            getRowRange_result result = new getRowRange_result();
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getRowRange_args args, org.apache.thrift.async.AsyncMethodCallback<Range> resultHandler) throws TException {
        iface.getRowRange(args.row,resultHandler);
      }
    }

    public static class getFollowing<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getFollowing_args, Key> {
      public getFollowing() {
        super("getFollowing");
      }

      public getFollowing_args getEmptyArgsInstance() {
        return new getFollowing_args();
      }

      public AsyncMethodCallback<Key> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Key>() { 
          public void onComplete(Key o) {
            getFollowing_result result = new getFollowing_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            getFollowing_result result = new getFollowing_result();
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getFollowing_args args, org.apache.thrift.async.AsyncMethodCallback<Key> resultHandler) throws TException {
        iface.getFollowing(args.key, args.part,resultHandler);
      }
    }

    public static class systemNamespace<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, systemNamespace_args, String> {
      public systemNamespace() {
        super("systemNamespace");
      }

      public systemNamespace_args getEmptyArgsInstance() {
        return new systemNamespace_args();
      }

      public AsyncMethodCallback<String> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<String>() { 
          public void onComplete(String o) {
            systemNamespace_result result = new systemNamespace_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            systemNamespace_result result = new systemNamespace_result();
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, systemNamespace_args args, org.apache.thrift.async.AsyncMethodCallback<String> resultHandler) throws TException {
        iface.systemNamespace(resultHandler);
      }
    }

    public static class defaultNamespace<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, defaultNamespace_args, String> {
      public defaultNamespace() {
        super("defaultNamespace");
      }

      public defaultNamespace_args getEmptyArgsInstance() {
        return new defaultNamespace_args();
      }

      public AsyncMethodCallback<String> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<String>() { 
          public void onComplete(String o) {
            defaultNamespace_result result = new defaultNamespace_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            defaultNamespace_result result = new defaultNamespace_result();
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, defaultNamespace_args args, org.apache.thrift.async.AsyncMethodCallback<String> resultHandler) throws TException {
        iface.defaultNamespace(resultHandler);
      }
    }

    public static class listNamespaces<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, listNamespaces_args, List<String>> {
      public listNamespaces() {
        super("listNamespaces");
      }

      public listNamespaces_args getEmptyArgsInstance() {
        return new listNamespaces_args();
      }

      public AsyncMethodCallback<List<String>> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<List<String>>() { 
          public void onComplete(List<String> o) {
            listNamespaces_result result = new listNamespaces_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            listNamespaces_result result = new listNamespaces_result();
            if (e instanceof AccumuloException) {
                        result.ouch1 = (AccumuloException) e;
                        result.setOuch1IsSet(true);
                        msg = result;
            }
            else             if (e instanceof AccumuloSecurityException) {
                        result.ouch2 = (AccumuloSecurityException) e;
                        result.setOuch2IsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, listNamespaces_args args, org.apache.thrift.async.AsyncMethodCallback<List<String>> resultHandler) throws TException {
        iface.listNamespaces(args.login,resultHandler);
      }
    }

    public static class namespaceExists<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, namespaceExists_args, Boolean> {
      public namespaceExists() {
        super("namespaceExists");
      }

      public namespaceExists_args getEmptyArgsInstance() {
        return new namespaceExists_args();
      }

      public AsyncMethodCallback<Boolean> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Boolean>() { 
          public void onComplete(Boolean o) {
            namespaceExists_result result = new namespaceExists_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            namespaceExists_result result = new namespaceExists_result();
            if (e instanceof AccumuloException) {
                        result.ouch1 = (AccumuloException) e;
                        result.setOuch1IsSet(true);
                        msg = result;
            }
            else             if (e instanceof AccumuloSecurityException) {
                        result.ouch2 = (AccumuloSecurityException) e;
                        result.setOuch2IsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, namespaceExists_args args, org.apache.thrift.async.AsyncMethodCallback<Boolean> resultHandler) throws TException {
        iface.namespaceExists(args.login, args.namespaceName,resultHandler);
      }
    }

    public static class createNamespace<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, createNamespace_args, Void> {
      public createNamespace() {
        super("createNamespace");
      }

      public createNamespace_args getEmptyArgsInstance() {
        return new createNamespace_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            createNamespace_result result = new createNamespace_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            createNamespace_result result = new createNamespace_result();
            if (e instanceof AccumuloException) {
                        result.ouch1 = (AccumuloException) e;
                        result.setOuch1IsSet(true);
                        msg = result;
            }
            else             if (e instanceof AccumuloSecurityException) {
                        result.ouch2 = (AccumuloSecurityException) e;
                        result.setOuch2IsSet(true);
                        msg = result;
            }
            else             if (e instanceof NamespaceExistsException) {
                        result.ouch3 = (NamespaceExistsException) e;
                        result.setOuch3IsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, createNamespace_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.createNamespace(args.login, args.namespaceName,resultHandler);
      }
    }

    public static class deleteNamespace<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, deleteNamespace_args, Void> {
      public deleteNamespace() {
        super("deleteNamespace");
      }

      public deleteNamespace_args getEmptyArgsInstance() {
        return new deleteNamespace_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            deleteNamespace_result result = new deleteNamespace_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            deleteNamespace_result result = new deleteNamespace_result();
            if (e instanceof AccumuloException) {
                        result.ouch1 = (AccumuloException) e;
                        result.setOuch1IsSet(true);
                        msg = result;
            }
            else             if (e instanceof AccumuloSecurityException) {
                        result.ouch2 = (AccumuloSecurityException) e;
                        result.setOuch2IsSet(true);
                        msg = result;
            }
            else             if (e instanceof NamespaceNotFoundException) {
                        result.ouch3 = (NamespaceNotFoundException) e;
                        result.setOuch3IsSet(true);
                        msg = result;
            }
            else             if (e instanceof NamespaceNotEmptyException) {
                        result.ouch4 = (NamespaceNotEmptyException) e;
                        result.setOuch4IsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, deleteNamespace_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.deleteNamespace(args.login, args.namespaceName,resultHandler);
      }
    }

    public static class renameNamespace<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, renameNamespace_args, Void> {
      public renameNamespace() {
        super("renameNamespace");
      }

      public renameNamespace_args getEmptyArgsInstance() {
        return new renameNamespace_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            renameNamespace_result result = new renameNamespace_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            renameNamespace_result result = new renameNamespace_result();
            if (e instanceof AccumuloException) {
                        result.ouch1 = (AccumuloException) e;
                        result.setOuch1IsSet(true);
                        msg = result;
            }
            else             if (e instanceof AccumuloSecurityException) {
                        result.ouch2 = (AccumuloSecurityException) e;
                        result.setOuch2IsSet(true);
                        msg = result;
            }
            else             if (e instanceof NamespaceNotFoundException) {
                        result.ouch3 = (NamespaceNotFoundException) e;
                        result.setOuch3IsSet(true);
                        msg = result;
            }
            else             if (e instanceof NamespaceExistsException) {
                        result.ouch4 = (NamespaceExistsException) e;
                        result.setOuch4IsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, renameNamespace_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.renameNamespace(args.login, args.oldNamespaceName, args.newNamespaceName,resultHandler);
      }
    }

    public static class setNamespaceProperty<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, setNamespaceProperty_args, Void> {
      public setNamespaceProperty() {
        super("setNamespaceProperty");
      }

      public setNamespaceProperty_args getEmptyArgsInstance() {
        return new setNamespaceProperty_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            setNamespaceProperty_result result = new setNamespaceProperty_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            setNamespaceProperty_result result = new setNamespaceProperty_result();
            if (e instanceof AccumuloException) {
                        result.ouch1 = (AccumuloException) e;
                        result.setOuch1IsSet(true);
                        msg = result;
            }
            else             if (e instanceof AccumuloSecurityException) {
                        result.ouch2 = (AccumuloSecurityException) e;
                        result.setOuch2IsSet(true);
                        msg = result;
            }
            else             if (e instanceof NamespaceNotFoundException) {
                        result.ouch3 = (NamespaceNotFoundException) e;
                        result.setOuch3IsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, setNamespaceProperty_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.setNamespaceProperty(args.login, args.namespaceName, args.property, args.value,resultHandler);
      }
    }

    public static class removeNamespaceProperty<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, removeNamespaceProperty_args, Void> {
      public removeNamespaceProperty() {
        super("removeNamespaceProperty");
      }

      public removeNamespaceProperty_args getEmptyArgsInstance() {
        return new removeNamespaceProperty_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            removeNamespaceProperty_result result = new removeNamespaceProperty_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            removeNamespaceProperty_result result = new removeNamespaceProperty_result();
            if (e instanceof AccumuloException) {
                        result.ouch1 = (AccumuloException) e;
                        result.setOuch1IsSet(true);
                        msg = result;
            }
            else             if (e instanceof AccumuloSecurityException) {
                        result.ouch2 = (AccumuloSecurityException) e;
                        result.setOuch2IsSet(true);
                        msg = result;
            }
            else             if (e instanceof NamespaceNotFoundException) {
                        result.ouch3 = (NamespaceNotFoundException) e;
                        result.setOuch3IsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, removeNamespaceProperty_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.removeNamespaceProperty(args.login, args.namespaceName, args.property,resultHandler);
      }
    }

    public static class getNamespaceProperties<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getNamespaceProperties_args, Map<String,String>> {
      public getNamespaceProperties() {
        super("getNamespaceProperties");
      }

      public getNamespaceProperties_args getEmptyArgsInstance() {
        return new getNamespaceProperties_args();
      }

      public AsyncMethodCallback<Map<String,String>> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Map<String,String>>() { 
          public void onComplete(Map<String,String> o) {
            getNamespaceProperties_result result = new getNamespaceProperties_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            getNamespaceProperties_result result = new getNamespaceProperties_result();
            if (e instanceof AccumuloException) {
                        result.ouch1 = (AccumuloException) e;
                        result.setOuch1IsSet(true);
                        msg = result;
            }
            else             if (e instanceof AccumuloSecurityException) {
                        result.ouch2 = (AccumuloSecurityException) e;
                        result.setOuch2IsSet(true);
                        msg = result;
            }
            else             if (e instanceof NamespaceNotFoundException) {
                        result.ouch3 = (NamespaceNotFoundException) e;
                        result.setOuch3IsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getNamespaceProperties_args args, org.apache.thrift.async.AsyncMethodCallback<Map<String,String>> resultHandler) throws TException {
        iface.getNamespaceProperties(args.login, args.namespaceName,resultHandler);
      }
    }

    public static class namespaceIdMap<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, namespaceIdMap_args, Map<String,String>> {
      public namespaceIdMap() {
        super("namespaceIdMap");
      }

      public namespaceIdMap_args getEmptyArgsInstance() {
        return new namespaceIdMap_args();
      }

      public AsyncMethodCallback<Map<String,String>> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Map<String,String>>() { 
          public void onComplete(Map<String,String> o) {
            namespaceIdMap_result result = new namespaceIdMap_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            namespaceIdMap_result result = new namespaceIdMap_result();
            if (e instanceof AccumuloException) {
                        result.ouch1 = (AccumuloException) e;
                        result.setOuch1IsSet(true);
                        msg = result;
            }
            else             if (e instanceof AccumuloSecurityException) {
                        result.ouch2 = (AccumuloSecurityException) e;
                        result.setOuch2IsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, namespaceIdMap_args args, org.apache.thrift.async.AsyncMethodCallback<Map<String,String>> resultHandler) throws TException {
        iface.namespaceIdMap(args.login,resultHandler);
      }
    }

    public static class attachNamespaceIterator<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, attachNamespaceIterator_args, Void> {
      public attachNamespaceIterator() {
        super("attachNamespaceIterator");
      }

      public attachNamespaceIterator_args getEmptyArgsInstance() {
        return new attachNamespaceIterator_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            attachNamespaceIterator_result result = new attachNamespaceIterator_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            attachNamespaceIterator_result result = new attachNamespaceIterator_result();
            if (e instanceof AccumuloException) {
                        result.ouch1 = (AccumuloException) e;
                        result.setOuch1IsSet(true);
                        msg = result;
            }
            else             if (e instanceof AccumuloSecurityException) {
                        result.ouch2 = (AccumuloSecurityException) e;
                        result.setOuch2IsSet(true);
                        msg = result;
            }
            else             if (e instanceof NamespaceNotFoundException) {
                        result.ouch3 = (NamespaceNotFoundException) e;
                        result.setOuch3IsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, attachNamespaceIterator_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.attachNamespaceIterator(args.login, args.namespaceName, args.setting, args.scopes,resultHandler);
      }
    }

    public static class removeNamespaceIterator<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, removeNamespaceIterator_args, Void> {
      public removeNamespaceIterator() {
        super("removeNamespaceIterator");
      }

      public removeNamespaceIterator_args getEmptyArgsInstance() {
        return new removeNamespaceIterator_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            removeNamespaceIterator_result result = new removeNamespaceIterator_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            removeNamespaceIterator_result result = new removeNamespaceIterator_result();
            if (e instanceof AccumuloException) {
                        result.ouch1 = (AccumuloException) e;
                        result.setOuch1IsSet(true);
                        msg = result;
            }
            else             if (e instanceof AccumuloSecurityException) {
                        result.ouch2 = (AccumuloSecurityException) e;
                        result.setOuch2IsSet(true);
                        msg = result;
            }
            else             if (e instanceof NamespaceNotFoundException) {
                        result.ouch3 = (NamespaceNotFoundException) e;
                        result.setOuch3IsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, removeNamespaceIterator_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.removeNamespaceIterator(args.login, args.namespaceName, args.name, args.scopes,resultHandler);
      }
    }

    public static class getNamespaceIteratorSetting<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getNamespaceIteratorSetting_args, IteratorSetting> {
      public getNamespaceIteratorSetting() {
        super("getNamespaceIteratorSetting");
      }

      public getNamespaceIteratorSetting_args getEmptyArgsInstance() {
        return new getNamespaceIteratorSetting_args();
      }

      public AsyncMethodCallback<IteratorSetting> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<IteratorSetting>() { 
          public void onComplete(IteratorSetting o) {
            getNamespaceIteratorSetting_result result = new getNamespaceIteratorSetting_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            getNamespaceIteratorSetting_result result = new getNamespaceIteratorSetting_result();
            if (e instanceof AccumuloException) {
                        result.ouch1 = (AccumuloException) e;
                        result.setOuch1IsSet(true);
                        msg = result;
            }
            else             if (e instanceof AccumuloSecurityException) {
                        result.ouch2 = (AccumuloSecurityException) e;
                        result.setOuch2IsSet(true);
                        msg = result;
            }
            else             if (e instanceof NamespaceNotFoundException) {
                        result.ouch3 = (NamespaceNotFoundException) e;
                        result.setOuch3IsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getNamespaceIteratorSetting_args args, org.apache.thrift.async.AsyncMethodCallback<IteratorSetting> resultHandler) throws TException {
        iface.getNamespaceIteratorSetting(args.login, args.namespaceName, args.name, args.scope,resultHandler);
      }
    }

    public static class listNamespaceIterators<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, listNamespaceIterators_args, Map<String,Set<IteratorScope>>> {
      public listNamespaceIterators() {
        super("listNamespaceIterators");
      }

      public listNamespaceIterators_args getEmptyArgsInstance() {
        return new listNamespaceIterators_args();
      }

      public AsyncMethodCallback<Map<String,Set<IteratorScope>>> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Map<String,Set<IteratorScope>>>() { 
          public void onComplete(Map<String,Set<IteratorScope>> o) {
            listNamespaceIterators_result result = new listNamespaceIterators_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            listNamespaceIterators_result result = new listNamespaceIterators_result();
            if (e instanceof AccumuloException) {
                        result.ouch1 = (AccumuloException) e;
                        result.setOuch1IsSet(true);
                        msg = result;
            }
            else             if (e instanceof AccumuloSecurityException) {
                        result.ouch2 = (AccumuloSecurityException) e;
                        result.setOuch2IsSet(true);
                        msg = result;
            }
            else             if (e instanceof NamespaceNotFoundException) {
                        result.ouch3 = (NamespaceNotFoundException) e;
                        result.setOuch3IsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, listNamespaceIterators_args args, org.apache.thrift.async.AsyncMethodCallback<Map<String,Set<IteratorScope>>> resultHandler) throws TException {
        iface.listNamespaceIterators(args.login, args.namespaceName,resultHandler);
      }
    }

    public static class checkNamespaceIteratorConflicts<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, checkNamespaceIteratorConflicts_args, Void> {
      public checkNamespaceIteratorConflicts() {
        super("checkNamespaceIteratorConflicts");
      }

      public checkNamespaceIteratorConflicts_args getEmptyArgsInstance() {
        return new checkNamespaceIteratorConflicts_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            checkNamespaceIteratorConflicts_result result = new checkNamespaceIteratorConflicts_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            checkNamespaceIteratorConflicts_result result = new checkNamespaceIteratorConflicts_result();
            if (e instanceof AccumuloException) {
                        result.ouch1 = (AccumuloException) e;
                        result.setOuch1IsSet(true);
                        msg = result;
            }
            else             if (e instanceof AccumuloSecurityException) {
                        result.ouch2 = (AccumuloSecurityException) e;
                        result.setOuch2IsSet(true);
                        msg = result;
            }
            else             if (e instanceof NamespaceNotFoundException) {
                        result.ouch3 = (NamespaceNotFoundException) e;
                        result.setOuch3IsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, checkNamespaceIteratorConflicts_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.checkNamespaceIteratorConflicts(args.login, args.namespaceName, args.setting, args.scopes,resultHandler);
      }
    }

    public static class addNamespaceConstraint<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, addNamespaceConstraint_args, Integer> {
      public addNamespaceConstraint() {
        super("addNamespaceConstraint");
      }

      public addNamespaceConstraint_args getEmptyArgsInstance() {
        return new addNamespaceConstraint_args();
      }

      public AsyncMethodCallback<Integer> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Integer>() { 
          public void onComplete(Integer o) {
            addNamespaceConstraint_result result = new addNamespaceConstraint_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            addNamespaceConstraint_result result = new addNamespaceConstraint_result();
            if (e instanceof AccumuloException) {
                        result.ouch1 = (AccumuloException) e;
                        result.setOuch1IsSet(true);
                        msg = result;
            }
            else             if (e instanceof AccumuloSecurityException) {
                        result.ouch2 = (AccumuloSecurityException) e;
                        result.setOuch2IsSet(true);
                        msg = result;
            }
            else             if (e instanceof NamespaceNotFoundException) {
                        result.ouch3 = (NamespaceNotFoundException) e;
                        result.setOuch3IsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, addNamespaceConstraint_args args, org.apache.thrift.async.AsyncMethodCallback<Integer> resultHandler) throws TException {
        iface.addNamespaceConstraint(args.login, args.namespaceName, args.constraintClassName,resultHandler);
      }
    }

    public static class removeNamespaceConstraint<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, removeNamespaceConstraint_args, Void> {
      public removeNamespaceConstraint() {
        super("removeNamespaceConstraint");
      }

      public removeNamespaceConstraint_args getEmptyArgsInstance() {
        return new removeNamespaceConstraint_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            removeNamespaceConstraint_result result = new removeNamespaceConstraint_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            removeNamespaceConstraint_result result = new removeNamespaceConstraint_result();
            if (e instanceof AccumuloException) {
                        result.ouch1 = (AccumuloException) e;
                        result.setOuch1IsSet(true);
                        msg = result;
            }
            else             if (e instanceof AccumuloSecurityException) {
                        result.ouch2 = (AccumuloSecurityException) e;
                        result.setOuch2IsSet(true);
                        msg = result;
            }
            else             if (e instanceof NamespaceNotFoundException) {
                        result.ouch3 = (NamespaceNotFoundException) e;
                        result.setOuch3IsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, removeNamespaceConstraint_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.removeNamespaceConstraint(args.login, args.namespaceName, args.id,resultHandler);
      }
    }

    public static class listNamespaceConstraints<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, listNamespaceConstraints_args, Map<String,Integer>> {
      public listNamespaceConstraints() {
        super("listNamespaceConstraints");
      }

      public listNamespaceConstraints_args getEmptyArgsInstance() {
        return new listNamespaceConstraints_args();
      }

      public AsyncMethodCallback<Map<String,Integer>> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Map<String,Integer>>() { 
          public void onComplete(Map<String,Integer> o) {
            listNamespaceConstraints_result result = new listNamespaceConstraints_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            listNamespaceConstraints_result result = new listNamespaceConstraints_result();
            if (e instanceof AccumuloException) {
                        result.ouch1 = (AccumuloException) e;
                        result.setOuch1IsSet(true);
                        msg = result;
            }
            else             if (e instanceof AccumuloSecurityException) {
                        result.ouch2 = (AccumuloSecurityException) e;
                        result.setOuch2IsSet(true);
                        msg = result;
            }
            else             if (e instanceof NamespaceNotFoundException) {
                        result.ouch3 = (NamespaceNotFoundException) e;
                        result.setOuch3IsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, listNamespaceConstraints_args args, org.apache.thrift.async.AsyncMethodCallback<Map<String,Integer>> resultHandler) throws TException {
        iface.listNamespaceConstraints(args.login, args.namespaceName,resultHandler);
      }
    }

    public static class testNamespaceClassLoad<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, testNamespaceClassLoad_args, Boolean> {
      public testNamespaceClassLoad() {
        super("testNamespaceClassLoad");
      }

      public testNamespaceClassLoad_args getEmptyArgsInstance() {
        return new testNamespaceClassLoad_args();
      }

      public AsyncMethodCallback<Boolean> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Boolean>() { 
          public void onComplete(Boolean o) {
            testNamespaceClassLoad_result result = new testNamespaceClassLoad_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            testNamespaceClassLoad_result result = new testNamespaceClassLoad_result();
            if (e instanceof AccumuloException) {
                        result.ouch1 = (AccumuloException) e;
                        result.setOuch1IsSet(true);
                        msg = result;
            }
            else             if (e instanceof AccumuloSecurityException) {
                        result.ouch2 = (AccumuloSecurityException) e;
                        result.setOuch2IsSet(true);
                        msg = result;
            }
            else             if (e instanceof NamespaceNotFoundException) {
                        result.ouch3 = (NamespaceNotFoundException) e;
                        result.setOuch3IsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, testNamespaceClassLoad_args args, org.apache.thrift.async.AsyncMethodCallback<Boolean> resultHandler) throws TException {
        iface.testNamespaceClassLoad(args.login, args.namespaceName, args.className, args.asTypeName,resultHandler);
      }
    }

  }

  public static class login_args implements org.apache.thrift.TBase<login_args, login_args._Fields>, java.io.Serializable, Cloneable, Comparable<login_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("login_args");

    private static final org.apache.thrift.protocol.TField PRINCIPAL_FIELD_DESC = new org.apache.thrift.protocol.TField("principal", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField LOGIN_PROPERTIES_FIELD_DESC = new org.apache.thrift.protocol.TField("loginProperties", org.apache.thrift.protocol.TType.MAP, (short)2);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new login_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new login_argsTupleSchemeFactory());
    }

    public String principal; // required
    public Map<String,String> loginProperties; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      PRINCIPAL((short)1, "principal"),
      LOGIN_PROPERTIES((short)2, "loginProperties");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // PRINCIPAL
            return PRINCIPAL;
          case 2: // LOGIN_PROPERTIES
            return LOGIN_PROPERTIES;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.PRINCIPAL, new org.apache.thrift.meta_data.FieldMetaData("principal", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.LOGIN_PROPERTIES, new org.apache.thrift.meta_data.FieldMetaData("loginProperties", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.MapMetaData(org.apache.thrift.protocol.TType.MAP, 
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING), 
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING))));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(login_args.class, metaDataMap);
    }

    public login_args() {
    }

    public login_args(
      String principal,
      Map<String,String> loginProperties)
    {
      this();
      this.principal = principal;
      this.loginProperties = loginProperties;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public login_args(login_args other) {
      if (other.isSetPrincipal()) {
        this.principal = other.principal;
      }
      if (other.isSetLoginProperties()) {
        Map<String,String> __this__loginProperties = new HashMap<String,String>(other.loginProperties);
        this.loginProperties = __this__loginProperties;
      }
    }

    public login_args deepCopy() {
      return new login_args(this);
    }

    @Override
    public void clear() {
      this.principal = null;
      this.loginProperties = null;
    }

    public String getPrincipal() {
      return this.principal;
    }

    public login_args setPrincipal(String principal) {
      this.principal = principal;
      return this;
    }

    public void unsetPrincipal() {
      this.principal = null;
    }

    /** Returns true if field principal is set (has been assigned a value) and false otherwise */
    public boolean isSetPrincipal() {
      return this.principal != null;
    }

    public void setPrincipalIsSet(boolean value) {
      if (!value) {
        this.principal = null;
      }
    }

    public int getLoginPropertiesSize() {
      return (this.loginProperties == null) ? 0 : this.loginProperties.size();
    }

    public void putToLoginProperties(String key, String val) {
      if (this.loginProperties == null) {
        this.loginProperties = new HashMap<String,String>();
      }
      this.loginProperties.put(key, val);
    }

    public Map<String,String> getLoginProperties() {
      return this.loginProperties;
    }

    public login_args setLoginProperties(Map<String,String> loginProperties) {
      this.loginProperties = loginProperties;
      return this;
    }

    public void unsetLoginProperties() {
      this.loginProperties = null;
    }

    /** Returns true if field loginProperties is set (has been assigned a value) and false otherwise */
    public boolean isSetLoginProperties() {
      return this.loginProperties != null;
    }

    public void setLoginPropertiesIsSet(boolean value) {
      if (!value) {
        this.loginProperties = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case PRINCIPAL:
        if (value == null) {
          unsetPrincipal();
        } else {
          setPrincipal((String)value);
        }
        break;

      case LOGIN_PROPERTIES:
        if (value == null) {
          unsetLoginProperties();
        } else {
          setLoginProperties((Map<String,String>)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case PRINCIPAL:
        return getPrincipal();

      case LOGIN_PROPERTIES:
        return getLoginProperties();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case PRINCIPAL:
        return isSetPrincipal();
      case LOGIN_PROPERTIES:
        return isSetLoginProperties();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof login_args)
        return this.equals((login_args)that);
      return false;
    }

    public boolean equals(login_args that) {
      if (that == null)
        return false;

      boolean this_present_principal = true && this.isSetPrincipal();
      boolean that_present_principal = true && that.isSetPrincipal();
      if (this_present_principal || that_present_principal) {
        if (!(this_present_principal && that_present_principal))
          return false;
        if (!this.principal.equals(that.principal))
          return false;
      }

      boolean this_present_loginProperties = true && this.isSetLoginProperties();
      boolean that_present_loginProperties = true && that.isSetLoginProperties();
      if (this_present_loginProperties || that_present_loginProperties) {
        if (!(this_present_loginProperties && that_present_loginProperties))
          return false;
        if (!this.loginProperties.equals(that.loginProperties))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_principal = true && (isSetPrincipal());
      list.add(present_principal);
      if (present_principal)
        list.add(principal);

      boolean present_loginProperties = true && (isSetLoginProperties());
      list.add(present_loginProperties);
      if (present_loginProperties)
        list.add(loginProperties);

      return list.hashCode();
    }

    @Override
    public int compareTo(login_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetPrincipal()).compareTo(other.isSetPrincipal());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetPrincipal()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.principal, other.principal);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetLoginProperties()).compareTo(other.isSetLoginProperties());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetLoginProperties()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.loginProperties, other.loginProperties);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("login_args(");
      boolean first = true;

      sb.append("principal:");
      if (this.principal == null) {
        sb.append("null");
      } else {
        sb.append(this.principal);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("loginProperties:");
      if (this.loginProperties == null) {
        sb.append("null");
      } else {
        sb.append(this.loginProperties);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class login_argsStandardSchemeFactory implements SchemeFactory {
      public login_argsStandardScheme getScheme() {
        return new login_argsStandardScheme();
      }
    }

    private static class login_argsStandardScheme extends StandardScheme<login_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, login_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // PRINCIPAL
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.principal = iprot.readString();
                struct.setPrincipalIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // LOGIN_PROPERTIES
              if (schemeField.type == org.apache.thrift.protocol.TType.MAP) {
                {
                  org.apache.thrift.protocol.TMap _map164 = iprot.readMapBegin();
                  struct.loginProperties = new HashMap<String,String>(2*_map164.size);
                  String _key165;
                  String _val166;
                  for (int _i167 = 0; _i167 < _map164.size; ++_i167)
                  {
                    _key165 = iprot.readString();
                    _val166 = iprot.readString();
                    struct.loginProperties.put(_key165, _val166);
                  }
                  iprot.readMapEnd();
                }
                struct.setLoginPropertiesIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, login_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.principal != null) {
          oprot.writeFieldBegin(PRINCIPAL_FIELD_DESC);
          oprot.writeString(struct.principal);
          oprot.writeFieldEnd();
        }
        if (struct.loginProperties != null) {
          oprot.writeFieldBegin(LOGIN_PROPERTIES_FIELD_DESC);
          {
            oprot.writeMapBegin(new org.apache.thrift.protocol.TMap(org.apache.thrift.protocol.TType.STRING, org.apache.thrift.protocol.TType.STRING, struct.loginProperties.size()));
            for (Map.Entry<String, String> _iter168 : struct.loginProperties.entrySet())
            {
              oprot.writeString(_iter168.getKey());
              oprot.writeString(_iter168.getValue());
            }
            oprot.writeMapEnd();
          }
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class login_argsTupleSchemeFactory implements SchemeFactory {
      public login_argsTupleScheme getScheme() {
        return new login_argsTupleScheme();
      }
    }

    private static class login_argsTupleScheme extends TupleScheme<login_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, login_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetPrincipal()) {
          optionals.set(0);
        }
        if (struct.isSetLoginProperties()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetPrincipal()) {
          oprot.writeString(struct.principal);
        }
        if (struct.isSetLoginProperties()) {
          {
            oprot.writeI32(struct.loginProperties.size());
            for (Map.Entry<String, String> _iter169 : struct.loginProperties.entrySet())
            {
              oprot.writeString(_iter169.getKey());
              oprot.writeString(_iter169.getValue());
            }
          }
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, login_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.principal = iprot.readString();
          struct.setPrincipalIsSet(true);
        }
        if (incoming.get(1)) {
          {
            org.apache.thrift.protocol.TMap _map170 = new org.apache.thrift.protocol.TMap(org.apache.thrift.protocol.TType.STRING, org.apache.thrift.protocol.TType.STRING, iprot.readI32());
            struct.loginProperties = new HashMap<String,String>(2*_map170.size);
            String _key171;
            String _val172;
            for (int _i173 = 0; _i173 < _map170.size; ++_i173)
            {
              _key171 = iprot.readString();
              _val172 = iprot.readString();
              struct.loginProperties.put(_key171, _val172);
            }
          }
          struct.setLoginPropertiesIsSet(true);
        }
      }
    }

  }

  public static class login_result implements org.apache.thrift.TBase<login_result, login_result._Fields>, java.io.Serializable, Cloneable, Comparable<login_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("login_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRING, (short)0);
    private static final org.apache.thrift.protocol.TField OUCH2_FIELD_DESC = new org.apache.thrift.protocol.TField("ouch2", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new login_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new login_resultTupleSchemeFactory());
    }

    public ByteBuffer success; // required
    public AccumuloSecurityException ouch2; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      OUCH2((short)1, "ouch2");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // OUCH2
            return OUCH2;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , true)));
      tmpMap.put(_Fields.OUCH2, new org.apache.thrift.meta_data.FieldMetaData("ouch2", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(login_result.class, metaDataMap);
    }

    public login_result() {
    }

    public login_result(
      ByteBuffer success,
      AccumuloSecurityException ouch2)
    {
      this();
      this.success = org.apache.thrift.TBaseHelper.copyBinary(success);
      this.ouch2 = ouch2;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public login_result(login_result other) {
      if (other.isSetSuccess()) {
        this.success = org.apache.thrift.TBaseHelper.copyBinary(other.success);
      }
      if (other.isSetOuch2()) {
        this.ouch2 = new AccumuloSecurityException(other.ouch2);
      }
    }

    public login_result deepCopy() {
      return new login_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.ouch2 = null;
    }

    public byte[] getSuccess() {
      setSuccess(org.apache.thrift.TBaseHelper.rightSize(success));
      return success == null ? null : success.array();
    }

    public ByteBuffer bufferForSuccess() {
      return org.apache.thrift.TBaseHelper.copyBinary(success);
    }

    public login_result setSuccess(byte[] success) {
      this.success = success == null ? (ByteBuffer)null : ByteBuffer.wrap(Arrays.copyOf(success, success.length));
      return this;
    }

    public login_result setSuccess(ByteBuffer success) {
      this.success = org.apache.thrift.TBaseHelper.copyBinary(success);
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public AccumuloSecurityException getOuch2() {
      return this.ouch2;
    }

    public login_result setOuch2(AccumuloSecurityException ouch2) {
      this.ouch2 = ouch2;
      return this;
    }

    public void unsetOuch2() {
      this.ouch2 = null;
    }

    /** Returns true if field ouch2 is set (has been assigned a value) and false otherwise */
    public boolean isSetOuch2() {
      return this.ouch2 != null;
    }

    public void setOuch2IsSet(boolean value) {
      if (!value) {
        this.ouch2 = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((ByteBuffer)value);
        }
        break;

      case OUCH2:
        if (value == null) {
          unsetOuch2();
        } else {
          setOuch2((AccumuloSecurityException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case OUCH2:
        return getOuch2();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case OUCH2:
        return isSetOuch2();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof login_result)
        return this.equals((login_result)that);
      return false;
    }

    public boolean equals(login_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_ouch2 = true && this.isSetOuch2();
      boolean that_present_ouch2 = true && that.isSetOuch2();
      if (this_present_ouch2 || that_present_ouch2) {
        if (!(this_present_ouch2 && that_present_ouch2))
          return false;
        if (!this.ouch2.equals(that.ouch2))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_success = true && (isSetSuccess());
      list.add(present_success);
      if (present_success)
        list.add(success);

      boolean present_ouch2 = true && (isSetOuch2());
      list.add(present_ouch2);
      if (present_ouch2)
        list.add(ouch2);

      return list.hashCode();
    }

    @Override
    public int compareTo(login_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetOuch2()).compareTo(other.isSetOuch2());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetOuch2()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ouch2, other.ouch2);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("login_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        org.apache.thrift.TBaseHelper.toString(this.success, sb);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("ouch2:");
      if (this.ouch2 == null) {
        sb.append("null");
      } else {
        sb.append(this.ouch2);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class login_resultStandardSchemeFactory implements SchemeFactory {
      public login_resultStandardScheme getScheme() {
        return new login_resultStandardScheme();
      }
    }

    private static class login_resultStandardScheme extends StandardScheme<login_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, login_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.success = iprot.readBinary();
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // OUCH2
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.ouch2 = new AccumuloSecurityException();
                struct.ouch2.read(iprot);
                struct.setOuch2IsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, login_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          oprot.writeBinary(struct.success);
          oprot.writeFieldEnd();
        }
        if (struct.ouch2 != null) {
          oprot.writeFieldBegin(OUCH2_FIELD_DESC);
          struct.ouch2.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class login_resultTupleSchemeFactory implements SchemeFactory {
      public login_resultTupleScheme getScheme() {
        return new login_resultTupleScheme();
      }
    }

    private static class login_resultTupleScheme extends TupleScheme<login_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, login_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetOuch2()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          oprot.writeBinary(struct.success);
        }
        if (struct.isSetOuch2()) {
          struct.ouch2.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, login_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.success = iprot.readBinary();
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.ouch2 = new AccumuloSecurityException();
          struct.ouch2.read(iprot);
          struct.setOuch2IsSet(true);
        }
      }
    }

  }

  public static class addConstraint_args implements org.apache.thrift.TBase<addConstraint_args, addConstraint_args._Fields>, java.io.Serializable, Cloneable, Comparable<addConstraint_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("addConstraint_args");

    private static final org.apache.thrift.protocol.TField LOGIN_FIELD_DESC = new org.apache.thrift.protocol.TField("login", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField TABLE_NAME_FIELD_DESC = new org.apache.thrift.protocol.TField("tableName", org.apache.thrift.protocol.TType.STRING, (short)2);
    private static final org.apache.thrift.protocol.TField CONSTRAINT_CLASS_NAME_FIELD_DESC = new org.apache.thrift.protocol.TField("constraintClassName", org.apache.thrift.protocol.TType.STRING, (short)3);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new addConstraint_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new addConstraint_argsTupleSchemeFactory());
    }

    public ByteBuffer login; // required
    public String tableName; // required
    public String constraintClassName; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      LOGIN((short)1, "login"),
      TABLE_NAME((short)2, "tableName"),
      CONSTRAINT_CLASS_NAME((short)3, "constraintClassName");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // LOGIN
            return LOGIN;
          case 2: // TABLE_NAME
            return TABLE_NAME;
          case 3: // CONSTRAINT_CLASS_NAME
            return CONSTRAINT_CLASS_NAME;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.LOGIN, new org.apache.thrift.meta_data.FieldMetaData("login", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , true)));
      tmpMap.put(_Fields.TABLE_NAME, new org.apache.thrift.meta_data.FieldMetaData("tableName", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.CONSTRAINT_CLASS_NAME, new org.apache.thrift.meta_data.FieldMetaData("constraintClassName", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(addConstraint_args.class, metaDataMap);
    }

    public addConstraint_args() {
    }

    public addConstraint_args(
      ByteBuffer login,
      String tableName,
      String constraintClassName)
    {
      this();
      this.login = org.apache.thrift.TBaseHelper.copyBinary(login);
      this.tableName = tableName;
      this.constraintClassName = constraintClassName;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public addConstraint_args(addConstraint_args other) {
      if (other.isSetLogin()) {
        this.login = org.apache.thrift.TBaseHelper.copyBinary(other.login);
      }
      if (other.isSetTableName()) {
        this.tableName = other.tableName;
      }
      if (other.isSetConstraintClassName()) {
        this.constraintClassName = other.constraintClassName;
      }
    }

    public addConstraint_args deepCopy() {
      return new addConstraint_args(this);
    }

    @Override
    public void clear() {
      this.login = null;
      this.tableName = null;
      this.constraintClassName = null;
    }

    public byte[] getLogin() {
      setLogin(org.apache.thrift.TBaseHelper.rightSize(login));
      return login == null ? null : login.array();
    }

    public ByteBuffer bufferForLogin() {
      return org.apache.thrift.TBaseHelper.copyBinary(login);
    }

    public addConstraint_args setLogin(byte[] login) {
      this.login = login == null ? (ByteBuffer)null : ByteBuffer.wrap(Arrays.copyOf(login, login.length));
      return this;
    }

    public addConstraint_args setLogin(ByteBuffer login) {
      this.login = org.apache.thrift.TBaseHelper.copyBinary(login);
      return this;
    }

    public void unsetLogin() {
      this.login = null;
    }

    /** Returns true if field login is set (has been assigned a value) and false otherwise */
    public boolean isSetLogin() {
      return this.login != null;
    }

    public void setLoginIsSet(boolean value) {
      if (!value) {
        this.login = null;
      }
    }

    public String getTableName() {
      return this.tableName;
    }

    public addConstraint_args setTableName(String tableName) {
      this.tableName = tableName;
      return this;
    }

    public void unsetTableName() {
      this.tableName = null;
    }

    /** Returns true if field tableName is set (has been assigned a value) and false otherwise */
    public boolean isSetTableName() {
      return this.tableName != null;
    }

    public void setTableNameIsSet(boolean value) {
      if (!value) {
        this.tableName = null;
      }
    }

    public String getConstraintClassName() {
      return this.constraintClassName;
    }

    public addConstraint_args setConstraintClassName(String constraintClassName) {
      this.constraintClassName = constraintClassName;
      return this;
    }

    public void unsetConstraintClassName() {
      this.constraintClassName = null;
    }

    /** Returns true if field constraintClassName is set (has been assigned a value) and false otherwise */
    public boolean isSetConstraintClassName() {
      return this.constraintClassName != null;
    }

    public void setConstraintClassNameIsSet(boolean value) {
      if (!value) {
        this.constraintClassName = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case LOGIN:
        if (value == null) {
          unsetLogin();
        } else {
          setLogin((ByteBuffer)value);
        }
        break;

      case TABLE_NAME:
        if (value == null) {
          unsetTableName();
        } else {
          setTableName((String)value);
        }
        break;

      case CONSTRAINT_CLASS_NAME:
        if (value == null) {
          unsetConstraintClassName();
        } else {
          setConstraintClassName((String)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case LOGIN:
        return getLogin();

      case TABLE_NAME:
        return getTableName();

      case CONSTRAINT_CLASS_NAME:
        return getConstraintClassName();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case LOGIN:
        return isSetLogin();
      case TABLE_NAME:
        return isSetTableName();
      case CONSTRAINT_CLASS_NAME:
        return isSetConstraintClassName();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof addConstraint_args)
        return this.equals((addConstraint_args)that);
      return false;
    }

    public boolean equals(addConstraint_args that) {
      if (that == null)
        return false;

      boolean this_present_login = true && this.isSetLogin();
      boolean that_present_login = true && that.isSetLogin();
      if (this_present_login || that_present_login) {
        if (!(this_present_login && that_present_login))
          return false;
        if (!this.login.equals(that.login))
          return false;
      }

      boolean this_present_tableName = true && this.isSetTableName();
      boolean that_present_tableName = true && that.isSetTableName();
      if (this_present_tableName || that_present_tableName) {
        if (!(this_present_tableName && that_present_tableName))
          return false;
        if (!this.tableName.equals(that.tableName))
          return false;
      }

      boolean this_present_constraintClassName = true && this.isSetConstraintClassName();
      boolean that_present_constraintClassName = true && that.isSetConstraintClassName();
      if (this_present_constraintClassName || that_present_constraintClassName) {
        if (!(this_present_constraintClassName && that_present_constraintClassName))
          return false;
        if (!this.constraintClassName.equals(that.constraintClassName))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_login = true && (isSetLogin());
      list.add(present_login);
      if (present_login)
        list.add(login);

      boolean present_tableName = true && (isSetTableName());
      list.add(present_tableName);
      if (present_tableName)
        list.add(tableName);

      boolean present_constraintClassName = true && (isSetConstraintClassName());
      list.add(present_constraintClassName);
      if (present_constraintClassName)
        list.add(constraintClassName);

      return list.hashCode();
    }

    @Override
    public int compareTo(addConstraint_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetLogin()).compareTo(other.isSetLogin());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetLogin()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.login, other.login);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetTableName()).compareTo(other.isSetTableName());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTableName()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tableName, other.tableName);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetConstraintClassName()).compareTo(other.isSetConstraintClassName());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetConstraintClassName()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.constraintClassName, other.constraintClassName);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("addConstraint_args(");
      boolean first = true;

      sb.append("login:");
      if (this.login == null) {
        sb.append("null");
      } else {
        org.apache.thrift.TBaseHelper.toString(this.login, sb);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("tableName:");
      if (this.tableName == null) {
        sb.append("null");
      } else {
        sb.append(this.tableName);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("constraintClassName:");
      if (this.constraintClassName == null) {
        sb.append("null");
      } else {
        sb.append(this.constraintClassName);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class addConstraint_argsStandardSchemeFactory implements SchemeFactory {
      public addConstraint_argsStandardScheme getScheme() {
        return new addConstraint_argsStandardScheme();
      }
    }

    private static class addConstraint_argsStandardScheme extends StandardScheme<addConstraint_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, addConstraint_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // LOGIN
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.login = iprot.readBinary();
                struct.setLoginIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // TABLE_NAME
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.tableName = iprot.readString();
                struct.setTableNameIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // CONSTRAINT_CLASS_NAME
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.constraintClassName = iprot.readString();
                struct.setConstraintClassNameIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, addConstraint_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.login != null) {
          oprot.writeFieldBegin(LOGIN_FIELD_DESC);
          oprot.writeBinary(struct.login);
          oprot.writeFieldEnd();
        }
        if (struct.tableName != null) {
          oprot.writeFieldBegin(TABLE_NAME_FIELD_DESC);
          oprot.writeString(struct.tableName);
          oprot.writeFieldEnd();
        }
        if (struct.constraintClassName != null) {
          oprot.writeFieldBegin(CONSTRAINT_CLASS_NAME_FIELD_DESC);
          oprot.writeString(struct.constraintClassName);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class addConstraint_argsTupleSchemeFactory implements SchemeFactory {
      public addConstraint_argsTupleScheme getScheme() {
        return new addConstraint_argsTupleScheme();
      }
    }

    private static class addConstraint_argsTupleScheme extends TupleScheme<addConstraint_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, addConstraint_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetLogin()) {
          optionals.set(0);
        }
        if (struct.isSetTableName()) {
          optionals.set(1);
        }
        if (struct.isSetConstraintClassName()) {
          optionals.set(2);
        }
        oprot.writeBitSet(optionals, 3);
        if (struct.isSetLogin()) {
          oprot.writeBinary(struct.login);
        }
        if (struct.isSetTableName()) {
          oprot.writeString(struct.tableName);
        }
        if (struct.isSetConstraintClassName()) {
          oprot.writeString(struct.constraintClassName);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, addConstraint_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(3);
        if (incoming.get(0)) {
          struct.login = iprot.readBinary();
          struct.setLoginIsSet(true);
        }
        if (incoming.get(1)) {
          struct.tableName = iprot.readString();
          struct.setTableNameIsSet(true);
        }
        if (incoming.get(2)) {
          struct.constraintClassName = iprot.readString();
          struct.setConstraintClassNameIsSet(true);
        }
      }
    }

  }

  public static class addConstraint_result implements org.apache.thrift.TBase<addConstraint_result, addConstraint_result._Fields>, java.io.Serializable, Cloneable, Comparable<addConstraint_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("addConstraint_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.I32, (short)0);
    private static final org.apache.thrift.protocol.TField OUCH1_FIELD_DESC = new org.apache.thrift.protocol.TField("ouch1", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField OUCH2_FIELD_DESC = new org.apache.thrift.protocol.TField("ouch2", org.apache.thrift.protocol.TType.STRUCT, (short)2);
    private static final org.apache.thrift.protocol.TField OUCH3_FIELD_DESC = new org.apache.thrift.protocol.TField("ouch3", org.apache.thrift.protocol.TType.STRUCT, (short)3);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new addConstraint_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new addConstraint_resultTupleSchemeFactory());
    }

    public int success; // required
    public AccumuloException ouch1; // required
    public AccumuloSecurityException ouch2; // required
    public TableNotFoundException ouch3; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      OUCH1((short)1, "ouch1"),
      OUCH2((short)2, "ouch2"),
      OUCH3((short)3, "ouch3");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // OUCH1
            return OUCH1;
          case 2: // OUCH2
            return OUCH2;
          case 3: // OUCH3
            return OUCH3;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __SUCCESS_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I32)));
      tmpMap.put(_Fields.OUCH1, new org.apache.thrift.meta_data.FieldMetaData("ouch1", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.OUCH2, new org.apache.thrift.meta_data.FieldMetaData("ouch2", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.OUCH3, new org.apache.thrift.meta_data.FieldMetaData("ouch3", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(addConstraint_result.class, metaDataMap);
    }

    public addConstraint_result() {
    }

    public addConstraint_result(
      int success,
      AccumuloException ouch1,
      AccumuloSecurityException ouch2,
      TableNotFoundException ouch3)
    {
      this();
      this.success = success;
      setSuccessIsSet(true);
      this.ouch1 = ouch1;
      this.ouch2 = ouch2;
      this.ouch3 = ouch3;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public addConstraint_result(addConstraint_result other) {
      __isset_bitfield = other.__isset_bitfield;
      this.success = other.success;
      if (other.isSetOuch1()) {
        this.ouch1 = new AccumuloException(other.ouch1);
      }
      if (other.isSetOuch2()) {
        this.ouch2 = new AccumuloSecurityException(other.ouch2);
      }
      if (other.isSetOuch3()) {
        this.ouch3 = new TableNotFoundException(other.ouch3);
      }
    }

    public addConstraint_result deepCopy() {
      return new addConstraint_result(this);
    }

    @Override
    public void clear() {
      setSuccessIsSet(false);
      this.success = 0;
      this.ouch1 = null;
      this.ouch2 = null;
      this.ouch3 = null;
    }

    public int getSuccess() {
      return this.success;
    }

    public addConstraint_result setSuccess(int success) {
      this.success = success;
      setSuccessIsSet(true);
      return this;
    }

    public void unsetSuccess() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return EncodingUtils.testBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    public void setSuccessIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __SUCCESS_ISSET_ID, value);
    }

    public AccumuloException getOuch1() {
      return this.ouch1;
    }

    public addConstraint_result setOuch1(AccumuloException ouch1) {
      this.ouch1 = ouch1;
      return this;
    }

    public void unsetOuch1() {
      this.ouch1 = null;
    }

    /** Returns true if field ouch1 is set (has been assigned a value) and false otherwise */
    public boolean isSetOuch1() {
      return this.ouch1 != null;
    }

    public void setOuch1IsSet(boolean value) {
      if (!value) {
        this.ouch1 = null;
      }
    }

    public AccumuloSecurityException getOuch2() {
      return this.ouch2;
    }

    public addConstraint_result setOuch2(AccumuloSecurityException ouch2) {
      this.ouch2 = ouch2;
      return this;
    }

    public void unsetOuch2() {
      this.ouch2 = null;
    }

    /** Returns true if field ouch2 is set (has been assigned a value) and false otherwise */
    public boolean isSetOuch2() {
      return this.ouch2 != null;
    }

    public void setOuch2IsSet(boolean value) {
      if (!value) {
        this.ouch2 = null;
      }
    }

    public TableNotFoundException getOuch3() {
      return this.ouch3;
    }

    public addConstraint_result setOuch3(TableNotFoundException ouch3) {
      this.ouch3 = ouch3;
      return this;
    }

    public void unsetOuch3() {
      this.ouch3 = null;
    }

    /** Returns true if field ouch3 is set (has been assigned a value) and false otherwise */
    public boolean isSetOuch3() {
      return this.ouch3 != null;
    }

    public void setOuch3IsSet(boolean value) {
      if (!value) {
        this.ouch3 = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((Integer)value);
        }
        break;

      case OUCH1:
        if (value == null) {
          unsetOuch1();
        } else {
          setOuch1((AccumuloException)value);
        }
        break;

      case OUCH2:
        if (value == null) {
          unsetOuch2();
        } else {
          setOuch2((AccumuloSecurityException)value);
        }
        break;

      case OUCH3:
        if (value == null) {
          unsetOuch3();
        } else {
          setOuch3((TableNotFoundException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case OUCH1:
        return getOuch1();

      case OUCH2:
        return getOuch2();

      case OUCH3:
        return getOuch3();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case OUCH1:
        return isSetOuch1();
      case OUCH2:
        return isSetOuch2();
      case OUCH3:
        return isSetOuch3();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof addConstraint_result)
        return this.equals((addConstraint_result)that);
      return false;
    }

    public boolean equals(addConstraint_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true;
      boolean that_present_success = true;
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (this.success != that.success)
          return false;
      }

      boolean this_present_ouch1 = true && this.isSetOuch1();
      boolean that_present_ouch1 = true && that.isSetOuch1();
      if (this_present_ouch1 || that_present_ouch1) {
        if (!(this_present_ouch1 && that_present_ouch1))
          return false;
        if (!this.ouch1.equals(that.ouch1))
          return false;
      }

      boolean this_present_ouch2 = true && this.isSetOuch2();
      boolean that_present_ouch2 = true && that.isSetOuch2();
      if (this_present_ouch2 || that_present_ouch2) {
        if (!(this_present_ouch2 && that_present_ouch2))
          return false;
        if (!this.ouch2.equals(that.ouch2))
          return false;
      }

      boolean this_present_ouch3 = true && this.isSetOuch3();
      boolean that_present_ouch3 = true && that.isSetOuch3();
      if (this_present_ouch3 || that_present_ouch3) {
        if (!(this_present_ouch3 && that_present_ouch3))
          return false;
        if (!this.ouch3.equals(that.ouch3))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_success = true;
      list.add(present_success);
      if (present_success)
        list.add(success);

      boolean present_ouch1 = true && (isSetOuch1());
      list.add(present_ouch1);
      if (present_ouch1)
        list.add(ouch1);

      boolean present_ouch2 = true && (isSetOuch2());
      list.add(present_ouch2);
      if (present_ouch2)
        list.add(ouch2);

      boolean present_ouch3 = true && (isSetOuch3());
      list.add(present_ouch3);
      if (present_ouch3)
        list.add(ouch3);

      return list.hashCode();
    }

    @Override
    public int compareTo(addConstraint_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetOuch1()).compareTo(other.isSetOuch1());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetOuch1()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ouch1, other.ouch1);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetOuch2()).compareTo(other.isSetOuch2());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetOuch2()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ouch2, other.ouch2);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetOuch3()).compareTo(other.isSetOuch3());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetOuch3()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ouch3, other.ouch3);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("addConstraint_result(");
      boolean first = true;

      sb.append("success:");
      sb.append(this.success);
      first = false;
      if (!first) sb.append(", ");
      sb.append("ouch1:");
      if (this.ouch1 == null) {
        sb.append("null");
      } else {
        sb.append(this.ouch1);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("ouch2:");
      if (this.ouch2 == null) {
        sb.append("null");
      } else {
        sb.append(this.ouch2);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("ouch3:");
      if (this.ouch3 == null) {
        sb.append("null");
      } else {
        sb.append(this.ouch3);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class addConstraint_resultStandardSchemeFactory implements SchemeFactory {
      public addConstraint_resultStandardScheme getScheme() {
        return new addConstraint_resultStandardScheme();
      }
    }

    private static class addConstraint_resultStandardScheme extends StandardScheme<addConstraint_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, addConstraint_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.I32) {
                struct.success = iprot.readI32();
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // OUCH1
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.ouch1 = new AccumuloException();
                struct.ouch1.read(iprot);
                struct.setOuch1IsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // OUCH2
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.ouch2 = new AccumuloSecurityException();
                struct.ouch2.read(iprot);
                struct.setOuch2IsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // OUCH3
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.ouch3 = new TableNotFoundException();
                struct.ouch3.read(iprot);
                struct.setOuch3IsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, addConstraint_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.isSetSuccess()) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          oprot.writeI32(struct.success);
          oprot.writeFieldEnd();
        }
        if (struct.ouch1 != null) {
          oprot.writeFieldBegin(OUCH1_FIELD_DESC);
          struct.ouch1.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.ouch2 != null) {
          oprot.writeFieldBegin(OUCH2_FIELD_DESC);
          struct.ouch2.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.ouch3 != null) {
          oprot.writeFieldBegin(OUCH3_FIELD_DESC);
          struct.ouch3.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class addConstraint_resultTupleSchemeFactory implements SchemeFactory {
      public addConstraint_resultTupleScheme getScheme() {
        return new addConstraint_resultTupleScheme();
      }
    }

    private static class addConstraint_resultTupleScheme extends TupleScheme<addConstraint_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, addConstraint_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetOuch1()) {
          optionals.set(1);
        }
        if (struct.isSetOuch2()) {
          optionals.set(2);
        }
        if (struct.isSetOuch3()) {
          optionals.set(3);
        }
        oprot.writeBitSet(optionals, 4);
        if (struct.isSetSuccess()) {
          oprot.writeI32(struct.success);
        }
        if (struct.isSetOuch1()) {
          struct.ouch1.write(oprot);
        }
        if (struct.isSetOuch2()) {
          struct.ouch2.write(oprot);
        }
        if (struct.isSetOuch3()) {
          struct.ouch3.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, addConstraint_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(4);
        if (incoming.get(0)) {
          struct.success = iprot.readI32();
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.ouch1 = new AccumuloException();
          struct.ouch1.read(iprot);
          struct.setOuch1IsSet(true);
        }
        if (incoming.get(2)) {
          struct.ouch2 = new AccumuloSecurityException();
          struct.ouch2.read(iprot);
          struct.setOuch2IsSet(true);
        }
        if (incoming.get(3)) {
          struct.ouch3 = new TableNotFoundException();
          struct.ouch3.read(iprot);
          struct.setOuch3IsSet(true);
        }
      }
    }

  }

  public static class addSplits_args implements org.apache.thrift.TBase<addSplits_args, addSplits_args._Fields>, java.io.Serializable, Cloneable, Comparable<addSplits_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("addSplits_args");

    private static final org.apache.thrift.protocol.TField LOGIN_FIELD_DESC = new org.apache.thrift.protocol.TField("login", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField TABLE_NAME_FIELD_DESC = new org.apache.thrift.protocol.TField("tableName", org.apache.thrift.protocol.TType.STRING, (short)2);
    private static final org.apache.thrift.protocol.TField SPLITS_FIELD_DESC = new org.apache.thrift.protocol.TField("splits", org.apache.thrift.protocol.TType.SET, (short)3);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new addSplits_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new addSplits_argsTupleSchemeFactory());
    }

    public ByteBuffer login; // required
    public String tableName; // required
    public Set<ByteBuffer> splits; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      LOGIN((short)1, "login"),
      TABLE_NAME((short)2, "tableName"),
      SPLITS((short)3, "splits");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // LOGIN
            return LOGIN;
          case 2: // TABLE_NAME
            return TABLE_NAME;
          case 3: // SPLITS
            return SPLITS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.LOGIN, new org.apache.thrift.meta_data.FieldMetaData("login", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , true)));
      tmpMap.put(_Fields.TABLE_NAME, new org.apache.thrift.meta_data.FieldMetaData("tableName", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.SPLITS, new org.apache.thrift.meta_data.FieldMetaData("splits", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.SetMetaData(org.apache.thrift.protocol.TType.SET, 
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING              , true))));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(addSplits_args.class, metaDataMap);
    }

    public addSplits_args() {
    }

    public addSplits_args(
      ByteBuffer login,
      String tableName,
      Set<ByteBuffer> splits)
    {
      this();
      this.login = org.apache.thrift.TBaseHelper.copyBinary(login);
      this.tableName = tableName;
      this.splits = splits;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public addSplits_args(addSplits_args other) {
      if (other.isSetLogin()) {
        this.login = org.apache.thrift.TBaseHelper.copyBinary(other.login);
      }
      if (other.isSetTableName()) {
        this.tableName = other.tableName;
      }
      if (other.isSetSplits()) {
        Set<ByteBuffer> __this__splits = new HashSet<ByteBuffer>(other.splits);
        this.splits = __this__splits;
      }
    }

    public addSplits_args deepCopy() {
      return new addSplits_args(this);
    }

    @Override
    public void clear() {
      this.login = null;
      this.tableName = null;
      this.splits = null;
    }

    public byte[] getLogin() {
      setLogin(org.apache.thrift.TBaseHelper.rightSize(login));
      return login == null ? null : login.array();
    }

    public ByteBuffer bufferForLogin() {
      return org.apache.thrift.TBaseHelper.copyBinary(login);
    }

    public addSplits_args setLogin(byte[] login) {
      this.login = login == null ? (ByteBuffer)null : ByteBuffer.wrap(Arrays.copyOf(login, login.length));
      return this;
    }

    public addSplits_args setLogin(ByteBuffer login) {
      this.login = org.apache.thrift.TBaseHelper.copyBinary(login);
      return this;
    }

    public void unsetLogin() {
      this.login = null;
    }

    /** Returns true if field login is set (has been assigned a value) and false otherwise */
    public boolean isSetLogin() {
      return this.login != null;
    }

    public void setLoginIsSet(boolean value) {
      if (!value) {
        this.login = null;
      }
    }

    public String getTableName() {
      return this.tableName;
    }

    public addSplits_args setTableName(String tableName) {
      this.tableName = tableName;
      return this;
    }

    public void unsetTableName() {
      this.tableName = null;
    }

    /** Returns true if field tableName is set (has been assigned a value) and false otherwise */
    public boolean isSetTableName() {
      return this.tableName != null;
    }

    public void setTableNameIsSet(boolean value) {
      if (!value) {
        this.tableName = null;
      }
    }

    public int getSplitsSize() {
      return (this.splits == null) ? 0 : this.splits.size();
    }

    public java.util.Iterator<ByteBuffer> getSplitsIterator() {
      return (this.splits == null) ? null : this.splits.iterator();
    }

    public void addToSplits(ByteBuffer elem) {
      if (this.splits == null) {
        this.splits = new HashSet<ByteBuffer>();
      }
      this.splits.add(elem);
    }

    public Set<ByteBuffer> getSplits() {
      return this.splits;
    }

    public addSplits_args setSplits(Set<ByteBuffer> splits) {
      this.splits = splits;
      return this;
    }

    public void unsetSplits() {
      this.splits = null;
    }

    /** Returns true if field splits is set (has been assigned a value) and false otherwise */
    public boolean isSetSplits() {
      return this.splits != null;
    }

    public void setSplitsIsSet(boolean value) {
      if (!value) {
        this.splits = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case LOGIN:
        if (value == null) {
          unsetLogin();
        } else {
          setLogin((ByteBuffer)value);
        }
        break;

      case TABLE_NAME:
        if (value == null) {
          unsetTableName();
        } else {
          setTableName((String)value);
        }
        break;

      case SPLITS:
        if (value == null) {
          unsetSplits();
        } else {
          setSplits((Set<ByteBuffer>)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case LOGIN:
        return getLogin();

      case TABLE_NAME:
        return getTableName();

      case SPLITS:
        return getSplits();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case LOGIN:
        return isSetLogin();
      case TABLE_NAME:
        return isSetTableName();
      case SPLITS:
        return isSetSplits();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof addSplits_args)
        return this.equals((addSplits_args)that);
      return false;
    }

    public boolean equals(addSplits_args that) {
      if (that == null)
        return false;

      boolean this_present_login = true && this.isSetLogin();
      boolean that_present_login = true && that.isSetLogin();
      if (this_present_login || that_present_login) {
        if (!(this_present_login && that_present_login))
          return false;
        if (!this.login.equals(that.login))
          return false;
      }

      boolean this_present_tableName = true && this.isSetTableName();
      boolean that_present_tableName = true && that.isSetTableName();
      if (this_present_tableName || that_present_tableName) {
        if (!(this_present_tableName && that_present_tableName))
          return false;
        if (!this.tableName.equals(that.tableName))
          return false;
      }

      boolean this_present_splits = true && this.isSetSplits();
      boolean that_present_splits = true && that.isSetSplits();
      if (this_present_splits || that_present_splits) {
        if (!(this_present_splits && that_present_splits))
          return false;
        if (!this.splits.equals(that.splits))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_login = true && (isSetLogin());
      list.add(present_login);
      if (present_login)
        list.add(login);

      boolean present_tableName = true && (isSetTableName());
      list.add(present_tableName);
      if (present_tableName)
        list.add(tableName);

      boolean present_splits = true && (isSetSplits());
      list.add(present_splits);
      if (present_splits)
        list.add(splits);

      return list.hashCode();
    }

    @Override
    public int compareTo(addSplits_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetLogin()).compareTo(other.isSetLogin());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetLogin()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.login, other.login);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetTableName()).compareTo(other.isSetTableName());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTableName()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tableName, other.tableName);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetSplits()).compareTo(other.isSetSplits());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSplits()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.splits, other.splits);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("addSplits_args(");
      boolean first = true;

      sb.append("login:");
      if (this.login == null) {
        sb.append("null");
      } else {
        org.apache.thrift.TBaseHelper.toString(this.login, sb);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("tableName:");
      if (this.tableName == null) {
        sb.append("null");
      } else {
        sb.append(this.tableName);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("splits:");
      if (this.splits == null) {
        sb.append("null");
      } else {
        org.apache.thrift.TBaseHelper.toString(this.splits, sb);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class addSplits_argsStandardSchemeFactory implements SchemeFactory {
      public addSplits_argsStandardScheme getScheme() {
        return new addSplits_argsStandardScheme();
      }
    }

    private static class addSplits_argsStandardScheme extends StandardScheme<addSplits_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, addSplits_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // LOGIN
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.login = iprot.readBinary();
                struct.setLoginIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // TABLE_NAME
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.tableName = iprot.readString();
                struct.setTableNameIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // SPLITS
              if (schemeField.type == org.apache.thrift.protocol.TType.SET) {
                {
                  org.apache.thrift.protocol.TSet _set174 = iprot.readSetBegin();
                  struct.splits = new HashSet<ByteBuffer>(2*_set174.size);
                  ByteBuffer _elem175;
                  for (int _i176 = 0; _i176 < _set174.size; ++_i176)
                  {
                    _elem175 = iprot.readBinary();
                    struct.splits.add(_elem175);
                  }
                  iprot.readSetEnd();
                }
                struct.setSplitsIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, addSplits_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.login != null) {
          oprot.writeFieldBegin(LOGIN_FIELD_DESC);
          oprot.writeBinary(struct.login);
          oprot.writeFieldEnd();
        }
        if (struct.tableName != null) {
          oprot.writeFieldBegin(TABLE_NAME_FIELD_DESC);
          oprot.writeString(struct.tableName);
          oprot.writeFieldEnd();
        }
        if (struct.splits != null) {
          oprot.writeFieldBegin(SPLITS_FIELD_DESC);
          {
            oprot.writeSetBegin(new org.apache.thrift.protocol.TSet(org.apache.thrift.protocol.TType.STRING, struct.splits.size()));
            for (ByteBuffer _iter177 : struct.splits)
            {
              oprot.writeBinary(_iter177);
            }
            oprot.writeSetEnd();
          }
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class addSplits_argsTupleSchemeFactory implements SchemeFactory {
      public addSplits_argsTupleScheme getScheme() {
        return new addSplits_argsTupleScheme();
      }
    }

    private static class addSplits_argsTupleScheme extends TupleScheme<addSplits_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, addSplits_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetLogin()) {
          optionals.set(0);
        }
        if (struct.isSetTableName()) {
          optionals.set(1);
        }
        if (struct.isSetSplits()) {
          optionals.set(2);
        }
        oprot.writeBitSet(optionals, 3);
        if (struct.isSetLogin()) {
          oprot.writeBinary(struct.login);
        }
        if (struct.isSetTableName()) {
          oprot.writeString(struct.tableName);
        }
        if (struct.isSetSplits()) {
          {
            oprot.writeI32(struct.splits.size());
            for (ByteBuffer _iter178 : struct.splits)
            {
              oprot.writeBinary(_iter178);
            }
          }
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, addSplits_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(3);
        if (incoming.get(0)) {
          struct.login = iprot.readBinary();
          struct.setLoginIsSet(true);
        }
        if (incoming.get(1)) {
          struct.tableName = iprot.readString();
          struct.setTableNameIsSet(true);
        }
        if (incoming.get(2)) {
          {
            org.apache.thrift.protocol.TSet _set179 = new org.apache.thrift.protocol.TSet(org.apache.thrift.protocol.TType.STRING, iprot.readI32());
            struct.splits = new HashSet<ByteBuffer>(2*_set179.size);
            ByteBuffer _elem180;
            for (int _i181 = 0; _i181 < _set179.size; ++_i181)
            {
              _elem180 = iprot.readBinary();
              struct.splits.add(_elem180);
            }
          }
          struct.setSplitsIsSet(true);
        }
      }
    }

  }

  public static class addSplits_result implements org.apache.thrift.TBase<addSplits_result, addSplits_result._Fields>, java.io.Serializable, Cloneable, Comparable<addSplits_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("addSplits_result");

    private static final org.apache.thrift.protocol.TField OUCH1_FIELD_DESC = new org.apache.thrift.protocol.TField("ouch1", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField OUCH2_FIELD_DESC = new org.apache.thrift.protocol.TField("ouch2", org.apache.thrift.protocol.TType.STRUCT, (short)2);
    private static final org.apache.thrift.protocol.TField OUCH3_FIELD_DESC = new org.apache.thrift.protocol.TField("ouch3", org.apache.thrift.protocol.TType.STRUCT, (short)3);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new addSplits_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new addSplits_resultTupleSchemeFactory());
    }

    public AccumuloException ouch1; // required
    public AccumuloSecurityException ouch2; // required
    public TableNotFoundException ouch3; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      OUCH1((short)1, "ouch1"),
      OUCH2((short)2, "ouch2"),
      OUCH3((short)3, "ouch3");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // OUCH1
            return OUCH1;
          case 2: // OUCH2
            return OUCH2;
          case 3: // OUCH3
            return OUCH3;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.OUCH1, new org.apache.thrift.meta_data.FieldMetaData("ouch1", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.OUCH2, new org.apache.thrift.meta_data.FieldMetaData("ouch2", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.OUCH3, new org.apache.thrift.meta_data.FieldMetaData("ouch3", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(addSplits_result.class, metaDataMap);
    }

    public addSplits_result() {
    }

    public addSplits_result(
      AccumuloException ouch1,
      AccumuloSecurityException ouch2,
      TableNotFoundException ouch3)
    {
      this();
      this.ouch1 = ouch1;
      this.ouch2 = ouch2;
      this.ouch3 = ouch3;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public addSplits_result(addSplits_result other) {
      if (other.isSetOuch1()) {
        this.ouch1 = new AccumuloException(other.ouch1);
      }
      if (other.isSetOuch2()) {
        this.ouch2 = new AccumuloSecurityException(other.ouch2);
      }
      if (other.isSetOuch3()) {
        this.ouch3 = new TableNotFoundException(other.ouch3);
      }
    }

    public addSplits_result deepCopy() {
      return new addSplits_result(this);
    }

    @Override
    public void clear() {
      this.ouch1 = null;
      this.ouch2 = null;
      this.ouch3 = null;
    }

    public AccumuloException getOuch1() {
      return this.ouch1;
    }

    public addSplits_result setOuch1(AccumuloException ouch1) {
      this.ouch1 = ouch1;
      return this;
    }

    public void unsetOuch1() {
      this.ouch1 = null;
    }

    /** Returns true if field ouch1 is set (has been assigned a value) and false otherwise */
    public boolean isSetOuch1() {
      return this.ouch1 != null;
    }

    public void setOuch1IsSet(boolean value) {
      if (!value) {
        this.ouch1 = null;
      }
    }

    public AccumuloSecurityException getOuch2() {
      return this.ouch2;
    }

    public addSplits_result setOuch2(AccumuloSecurityException ouch2) {
      this.ouch2 = ouch2;
      return this;
    }

    public void unsetOuch2() {
      this.ouch2 = null;
    }

    /** Returns true if field ouch2 is set (has been assigned a value) and false otherwise */
    public boolean isSetOuch2() {
      return this.ouch2 != null;
    }

    public void setOuch2IsSet(boolean value) {
      if (!value) {
        this.ouch2 = null;
      }
    }

    public TableNotFoundException getOuch3() {
      return this.ouch3;
    }

    public addSplits_result setOuch3(TableNotFoundException ouch3) {
      this.ouch3 = ouch3;
      return this;
    }

    public void unsetOuch3() {
      this.ouch3 = null;
    }

    /** Returns true if field ouch3 is set (has been assigned a value) and false otherwise */
    public boolean isSetOuch3() {
      return this.ouch3 != null;
    }

    public void setOuch3IsSet(boolean value) {
      if (!value) {
        this.ouch3 = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case OUCH1:
        if (value == null) {
          unsetOuch1();
        } else {
          setOuch1((AccumuloException)value);
        }
        break;

      case OUCH2:
        if (value == null) {
          unsetOuch2();
        } else {
          setOuch2((AccumuloSecurityException)value);
        }
        break;

      case OUCH3:
        if (value == null) {
          unsetOuch3();
        } else {
          setOuch3((TableNotFoundException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case OUCH1:
        return getOuch1();

      case OUCH2:
        return getOuch2();

      case OUCH3:
        return getOuch3();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case OUCH1:
        return isSetOuch1();
      case OUCH2:
        return isSetOuch2();
      case OUCH3:
        return isSetOuch3();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof addSplits_result)
        return this.equals((addSplits_result)that);
      return false;
    }

    public boolean equals(addSplits_result that) {
      if (that == null)
        return false;

      boolean this_present_ouch1 = true && this.isSetOuch1();
      boolean that_present_ouch1 = true && that.isSetOuch1();
      if (this_present_ouch1 || that_present_ouch1) {
        if (!(this_present_ouch1 && that_present_ouch1))
          return false;
        if (!this.ouch1.equals(that.ouch1))
          return false;
      }

      boolean this_present_ouch2 = true && this.isSetOuch2();
      boolean that_present_ouch2 = true && that.isSetOuch2();
      if (this_present_ouch2 || that_present_ouch2) {
        if (!(this_present_ouch2 && that_present_ouch2))
          return false;
        if (!this.ouch2.equals(that.ouch2))
          return false;
      }

      boolean this_present_ouch3 = true && this.isSetOuch3();
      boolean that_present_ouch3 = true && that.isSetOuch3();
      if (this_present_ouch3 || that_present_ouch3) {
        if (!(this_present_ouch3 && that_present_ouch3))
          return false;
        if (!this.ouch3.equals(that.ouch3))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_ouch1 = true && (isSetOuch1());
      list.add(present_ouch1);
      if (present_ouch1)
        list.add(ouch1);

      boolean present_ouch2 = true && (isSetOuch2());
      list.add(present_ouch2);
      if (present_ouch2)
        list.add(ouch2);

      boolean present_ouch3 = true && (isSetOuch3());
      list.add(present_ouch3);
      if (present_ouch3)
        list.add(ouch3);

      return list.hashCode();
    }

    @Override
    public int compareTo(addSplits_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetOuch1()).compareTo(other.isSetOuch1());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetOuch1()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ouch1, other.ouch1);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetOuch2()).compareTo(other.isSetOuch2());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetOuch2()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ouch2, other.ouch2);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetOuch3()).compareTo(other.isSetOuch3());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetOuch3()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ouch3, other.ouch3);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("addSplits_result(");
      boolean first = true;

      sb.append("ouch1:");
      if (this.ouch1 == null) {
        sb.append("null");
      } else {
        sb.append(this.ouch1);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("ouch2:");
      if (this.ouch2 == null) {
        sb.append("null");
      } else {
        sb.append(this.ouch2);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("ouch3:");
      if (this.ouch3 == null) {
        sb.append("null");
      } else {
        sb.append(this.ouch3);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class addSplits_resultStandardSchemeFactory implements SchemeFactory {
      public addSplits_resultStandardScheme getScheme() {
        return new addSplits_resultStandardScheme();
      }
    }

    private static class addSplits_resultStandardScheme extends StandardScheme<addSplits_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, addSplits_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // OUCH1
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.ouch1 = new AccumuloException();
                struct.ouch1.read(iprot);
                struct.setOuch1IsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // OUCH2
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.ouch2 = new AccumuloSecurityException();
                struct.ouch2.read(iprot);
                struct.setOuch2IsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // OUCH3
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.ouch3 = new TableNotFoundException();
                struct.ouch3.read(iprot);
                struct.setOuch3IsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, addSplits_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.ouch1 != null) {
          oprot.writeFieldBegin(OUCH1_FIELD_DESC);
          struct.ouch1.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.ouch2 != null) {
          oprot.writeFieldBegin(OUCH2_FIELD_DESC);
          struct.ouch2.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.ouch3 != null) {
          oprot.writeFieldBegin(OUCH3_FIELD_DESC);
          struct.ouch3.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class addSplits_resultTupleSchemeFactory implements SchemeFactory {
      public addSplits_resultTupleScheme getScheme() {
        return new addSplits_resultTupleScheme();
      }
    }

    private static class addSplits_resultTupleScheme extends TupleScheme<addSplits_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, addSplits_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetOuch1()) {
          optionals.set(0);
        }
        if (struct.isSetOuch2()) {
          optionals.set(1);
        }
        if (struct.isSetOuch3()) {
          optionals.set(2);
        }
        oprot.writeBitSet(optionals, 3);
        if (struct.isSetOuch1()) {
          struct.ouch1.write(oprot);
        }
        if (struct.isSetOuch2()) {
          struct.ouch2.write(oprot);
        }
        if (struct.isSetOuch3()) {
          struct.ouch3.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, addSplits_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(3);
        if (incoming.get(0)) {
          struct.ouch1 = new AccumuloException();
          struct.ouch1.read(iprot);
          struct.setOuch1IsSet(true);
        }
        if (incoming.get(1)) {
          struct.ouch2 = new AccumuloSecurityException();
          struct.ouch2.read(iprot);
          struct.setOuch2IsSet(true);
        }
        if (incoming.get(2)) {
          struct.ouch3 = new TableNotFoundException();
          struct.ouch3.read(iprot);
          struct.setOuch3IsSet(true);
        }
      }
    }

  }

  public static class attachIterator_args implements org.apache.thrift.TBase<attachIterator_args, attachIterator_args._Fields>, java.io.Serializable, Cloneable, Comparable<attachIterator_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("attachIterator_args");

    private static final org.apache.thrift.protocol.TField LOGIN_FIELD_DESC = new org.apache.thrift.protocol.TField("login", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField TABLE_NAME_FIELD_DESC = new org.apache.thrift.protocol.TField("tableName", org.apache.thrift.protocol.TType.STRING, (short)2);
    private static final org.apache.thrift.protocol.TField SETTING_FIELD_DESC = new org.apache.thrift.protocol.TField("setting", org.apache.thrift.protocol.TType.STRUCT, (short)3);
    private static final org.apache.thrift.protocol.TField SCOPES_FIELD_DESC = new org.apache.thrift.protocol.TField("scopes", org.apache.thrift.protocol.TType.SET, (short)4);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new attachIterator_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new attachIterator_argsTupleSchemeFactory());
    }

    public ByteBuffer login; // required
    public String tableName; // required
    public IteratorSetting setting; // required
    public Set<IteratorScope> scopes; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      LOGIN((short)1, "login"),
      TABLE_NAME((short)2, "tableName"),
      SETTING((short)3, "setting"),
      SCOPES((short)4, "scopes");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // LOGIN
            return LOGIN;
          case 2: // TABLE_NAME
            return TABLE_NAME;
          case 3: // SETTING
            return SETTING;
          case 4: // SCOPES
            return SCOPES;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.LOGIN, new org.apache.thrift.meta_data.FieldMetaData("login", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , true)));
      tmpMap.put(_Fields.TABLE_NAME, new org.apache.thrift.meta_data.FieldMetaData("tableName", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.SETTING, new org.apache.thrift.meta_data.FieldMetaData("setting", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, IteratorSetting.class)));
      tmpMap.put(_Fields.SCOPES, new org.apache.thrift.meta_data.FieldMetaData("scopes", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.SetMetaData(org.apache.thrift.protocol.TType.SET, 
              new org.apache.thrift.meta_data.EnumMetaData(org.apache.thrift.protocol.TType.ENUM, IteratorScope.class))));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(attachIterator_args.class, metaDataMap);
    }

    public attachIterator_args() {
    }

    public attachIterator_args(
      ByteBuffer login,
      String tableName,
      IteratorSetting setting,
      Set<IteratorScope> scopes)
    {
      this();
      this.login = org.apache.thrift.TBaseHelper.copyBinary(login);
      this.tableName = tableName;
      this.setting = setting;
      this.scopes = scopes;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public attachIterator_args(attachIterator_args other) {
      if (other.isSetLogin()) {
        this.login = org.apache.thrift.TBaseHelper.copyBinary(other.login);
      }
      if (other.isSetTableName()) {
        this.tableName = other.tableName;
      }
      if (other.isSetSetting()) {
        this.setting = new IteratorSetting(other.setting);
      }
      if (other.isSetScopes()) {
        Set<IteratorScope> __this__scopes = new HashSet<IteratorScope>(other.scopes.size());
        for (IteratorScope other_element : other.scopes) {
          __this__scopes.add(other_element);
        }
        this.scopes = __this__scopes;
      }
    }

    public attachIterator_args deepCopy() {
      return new attachIterator_args(this);
    }

    @Override
    public void clear() {
      this.login = null;
      this.tableName = null;
      this.setting = null;
      this.scopes = null;
    }

    public byte[] getLogin() {
      setLogin(org.apache.thrift.TBaseHelper.rightSize(login));
      return login == null ? null : login.array();
    }

    public ByteBuffer bufferForLogin() {
      return org.apache.thrift.TBaseHelper.copyBinary(login);
    }

    public attachIterator_args setLogin(byte[] login) {
      this.login = login == null ? (ByteBuffer)null : ByteBuffer.wrap(Arrays.copyOf(login, login.length));
      return this;
    }

    public attachIterator_args setLogin(ByteBuffer login) {
      this.login = org.apache.thrift.TBaseHelper.copyBinary(login);
      return this;
    }

    public void unsetLogin() {
      this.login = null;
    }

    /** Returns true if field login is set (has been assigned a value) and false otherwise */
    public boolean isSetLogin() {
      return this.login != null;
    }

    public void setLoginIsSet(boolean value) {
      if (!value) {
        this.login = null;
      }
    }

    public String getTableName() {
      return this.tableName;
    }

    public attachIterator_args setTableName(String tableName) {
      this.tableName = tableName;
      return this;
    }

    public void unsetTableName() {
      this.tableName = null;
    }

    /** Returns true if field tableName is set (has been assigned a value) and false otherwise */
    public boolean isSetTableName() {
      return this.tableName != null;
    }

    public void setTableNameIsSet(boolean value) {
      if (!value) {
        this.tableName = null;
      }
    }

    public IteratorSetting getSetting() {
      return this.setting;
    }

    public attachIterator_args setSetting(IteratorSetting setting) {
      this.setting = setting;
      return this;
    }

    public void unsetSetting() {
      this.setting = null;
    }

    /** Returns true if field setting is set (has been assigned a value) and false otherwise */
    public boolean isSetSetting() {
      return this.setting != null;
    }

    public void setSettingIsSet(boolean value) {
      if (!value) {
        this.setting = null;
      }
    }

    public int getScopesSize() {
      return (this.scopes == null) ? 0 : this.scopes.size();
    }

    public java.util.Iterator<IteratorScope> getScopesIterator() {
      return (this.scopes == null) ? null : this.scopes.iterator();
    }

    public void addToScopes(IteratorScope elem) {
      if (this.scopes == null) {
        this.scopes = new HashSet<IteratorScope>();
      }
      this.scopes.add(elem);
    }

    public Set<IteratorScope> getScopes() {
      return this.scopes;
    }

    public attachIterator_args setScopes(Set<IteratorScope> scopes) {
      this.scopes = scopes;
      return this;
    }

    public void unsetScopes() {
      this.scopes = null;
    }

    /** Returns true if field scopes is set (has been assigned a value) and false otherwise */
    public boolean isSetScopes() {
      return this.scopes != null;
    }

    public void setScopesIsSet(boolean value) {
      if (!value) {
        this.scopes = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case LOGIN:
        if (value == null) {
          unsetLogin();
        } else {
          setLogin((ByteBuffer)value);
        }
        break;

      case TABLE_NAME:
        if (value == null) {
          unsetTableName();
        } else {
          setTableName((String)value);
        }
        break;

      case SETTING:
        if (value == null) {
          unsetSetting();
        } else {
          setSetting((IteratorSetting)value);
        }
        break;

      case SCOPES:
        if (value == null) {
          unsetScopes();
        } else {
          setScopes((Set<IteratorScope>)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case LOGIN:
        return getLogin();

      case TABLE_NAME:
        return getTableName();

      case SETTING:
        return getSetting();

      case SCOPES:
        return getScopes();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case LOGIN:
        return isSetLogin();
      case TABLE_NAME:
        return isSetTableName();
      case SETTING:
        return isSetSetting();
      case SCOPES:
        return isSetScopes();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof attachIterator_args)
        return this.equals((attachIterator_args)that);
      return false;
    }

    public boolean equals(attachIterator_args that) {
      if (that == null)
        return false;

      boolean this_present_login = true && this.isSetLogin();
      boolean that_present_login = true && that.isSetLogin();
      if (this_present_login || that_present_login) {
        if (!(this_present_login && that_present_login))
          return false;
        if (!this.login.equals(that.login))
          return false;
      }

      boolean this_present_tableName = true && this.isSetTableName();
      boolean that_present_tableName = true && that.isSetTableName();
      if (this_present_tableName || that_present_tableName) {
        if (!(this_present_tableName && that_present_tableName))
          return false;
        if (!this.tableName.equals(that.tableName))
          return false;
      }

      boolean this_present_setting = true && this.isSetSetting();
      boolean that_present_setting = true && that.isSetSetting();
      if (this_present_setting || that_present_setting) {
        if (!(this_present_setting && that_present_setting))
          return false;
        if (!this.setting.equals(that.setting))
          return false;
      }

      boolean this_present_scopes = true && this.isSetScopes();
      boolean that_present_scopes = true && that.isSetScopes();
      if (this_present_scopes || that_present_scopes) {
        if (!(this_present_scopes && that_present_scopes))
          return false;
        if (!this.scopes.equals(that.scopes))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_login = true && (isSetLogin());
      list.add(present_login);
      if (present_login)
        list.add(login);

      boolean present_tableName = true && (isSetTableName());
      list.add(present_tableName);
      if (present_tableName)
        list.add(tableName);

      boolean present_setting = true && (isSetSetting());
      list.add(present_setting);
      if (present_setting)
        list.add(setting);

      boolean present_scopes = true && (isSetScopes());
      list.add(present_scopes);
      if (present_scopes)
        list.add(scopes);

      return list.hashCode();
    }

    @Override
    public int compareTo(attachIterator_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetLogin()).compareTo(other.isSetLogin());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetLogin()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.login, other.login);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetTableName()).compareTo(other.isSetTableName());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTableName()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tableName, other.tableName);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetSetting()).compareTo(other.isSetSetting());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSetting()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.setting, other.setting);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetScopes()).compareTo(other.isSetScopes());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetScopes()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.scopes, other.scopes);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("attachIterator_args(");
      boolean first = true;

      sb.append("login:");
      if (this.login == null) {
        sb.append("null");
      } else {
        org.apache.thrift.TBaseHelper.toString(this.login, sb);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("tableName:");
      if (this.tableName == null) {
        sb.append("null");
      } else {
        sb.append(this.tableName);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("setting:");
      if (this.setting == null) {
        sb.append("null");
      } else {
        sb.append(this.setting);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("scopes:");
      if (this.scopes == null) {
        sb.append("null");
      } else {
        sb.append(this.scopes);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (setting != null) {
        setting.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class attachIterator_argsStandardSchemeFactory implements SchemeFactory {
      public attachIterator_argsStandardScheme getScheme() {
        return new attachIterator_argsStandardScheme();
      }
    }

    private static class attachIterator_argsStandardScheme extends StandardScheme<attachIterator_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, attachIterator_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // LOGIN
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.login = iprot.readBinary();
                struct.setLoginIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // TABLE_NAME
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.tableName = iprot.readString();
                struct.setTableNameIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // SETTING
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.setting = new IteratorSetting();
                struct.setting.read(iprot);
                struct.setSettingIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 4: // SCOPES
              if (schemeField.type == org.apache.thrift.protocol.TType.SET) {
                {
                  org.apache.thrift.protocol.TSet _set182 = iprot.readSetBegin();
                  struct.scopes = new HashSet<IteratorScope>(2*_set182.size);
                  IteratorScope _elem183;
                  for (int _i184 = 0; _i184 < _set182.size; ++_i184)
                  {
                    _elem183 = org.apache.accumulo.proxy.thrift.IteratorScope.findByValue(iprot.readI32());
                    struct.scopes.add(_elem183);
                  }
                  iprot.readSetEnd();
                }
                struct.setScopesIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, attachIterator_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.login != null) {
          oprot.writeFieldBegin(LOGIN_FIELD_DESC);
          oprot.writeBinary(struct.login);
          oprot.writeFieldEnd();
        }
        if (struct.tableName != null) {
          oprot.writeFieldBegin(TABLE_NAME_FIELD_DESC);
          oprot.writeString(struct.tableName);
          oprot.writeFieldEnd();
        }
        if (struct.setting != null) {
          oprot.writeFieldBegin(SETTING_FIELD_DESC);
          struct.setting.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.scopes != null) {
          oprot.writeFieldBegin(SCOPES_FIELD_DESC);
          {
            oprot.writeSetBegin(new org.apache.thrift.protocol.TSet(org.apache.thrift.protocol.TType.I32, struct.scopes.size()));
            for (IteratorScope _iter185 : struct.scopes)
            {
              oprot.writeI32(_iter185.getValue());
            }
            oprot.writeSetEnd();
          }
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class attachIterator_argsTupleSchemeFactory implements SchemeFactory {
      public attachIterator_argsTupleScheme getScheme() {
        return new attachIterator_argsTupleScheme();
      }
    }

    private static class attachIterator_argsTupleScheme extends TupleScheme<attachIterator_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, attachIterator_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetLogin()) {
          optionals.set(0);
        }
        if (struct.isSetTableName()) {
          optionals.set(1);
        }
        if (struct.isSetSetting()) {
          optionals.set(2);
        }
        if (struct.isSetScopes()) {
          optionals.set(3);
        }
        oprot.writeBitSet(optionals, 4);
        if (struct.isSetLogin()) {
          oprot.writeBinary(struct.login);
        }
        if (struct.isSetTableName()) {
          oprot.writeString(struct.tableName);
        }
        if (struct.isSetSetting()) {
          struct.setting.write(oprot);
        }
        if (struct.isSetScopes()) {
          {
            oprot.writeI32(struct.scopes.size());
            for (IteratorScope _iter186 : struct.scopes)
            {
              oprot.writeI32(_iter186.getValue());
            }
          }
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, attachIterator_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(4);
        if (incoming.get(0)) {
          struct.login = iprot.readBinary();
          struct.setLoginIsSet(true);
        }
        if (incoming.get(1)) {
          struct.tableName = iprot.readString();
          struct.setTableNameIsSet(true);
        }
        if (incoming.get(2)) {
          struct.setting = new IteratorSetting();
          struct.setting.read(iprot);
          struct.setSettingIsSet(true);
        }
        if (incoming.get(3)) {
          {
            org.apache.thrift.protocol.TSet _set187 = new org.apache.thrift.protocol.TSet(org.apache.thrift.protocol.TType.I32, iprot.readI32());
            struct.scopes = new HashSet<IteratorScope>(2*_set187.size);
            IteratorScope _elem188;
            for (int _i189 = 0; _i189 < _set187.size; ++_i189)
            {
              _elem188 = org.apache.accumulo.proxy.thrift.IteratorScope.findByValue(iprot.readI32());
              struct.scopes.add(_elem188);
            }
          }
          struct.setScopesIsSet(true);
        }
      }
    }

  }

  public static class attachIterator_result implements org.apache.thrift.TBase<attachIterator_result, attachIterator_result._Fields>, java.io.Serializable, Cloneable, Comparable<attachIterator_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("attachIterator_result");

    private static final org.apache.thrift.protocol.TField OUCH1_FIELD_DESC = new org.apache.thrift.protocol.TField("ouch1", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField OUCH2_FIELD_DESC = new org.apache.thrift.protocol.TField("ouch2", org.apache.thrift.protocol.TType.STRUCT, (short)2);
    private static final org.apache.thrift.protocol.TField OUCH3_FIELD_DESC = new org.apache.thrift.protocol.TField("ouch3", org.apache.thrift.protocol.TType.STRUCT, (short)3);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new attachIterator_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new attachIterator_resultTupleSchemeFactory());
    }

    public AccumuloSecurityException ouch1; // required
    public AccumuloException ouch2; // required
    public TableNotFoundException ouch3; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      OUCH1((short)1, "ouch1"),
      OUCH2((short)2, "ouch2"),
      OUCH3((short)3, "ouch3");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // OUCH1
            return OUCH1;
          case 2: // OUCH2
            return OUCH2;
          case 3: // OUCH3
            return OUCH3;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.OUCH1, new org.apache.thrift.meta_data.FieldMetaData("ouch1", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.OUCH2, new org.apache.thrift.meta_data.FieldMetaData("ouch2", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.OUCH3, new org.apache.thrift.meta_data.FieldMetaData("ouch3", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(attachIterator_result.class, metaDataMap);
    }

    public attachIterator_result() {
    }

    public attachIterator_result(
      AccumuloSecurityException ouch1,
      AccumuloException ouch2,
      TableNotFoundException ouch3)
    {
      this();
      this.ouch1 = ouch1;
      this.ouch2 = ouch2;
      this.ouch3 = ouch3;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public attachIterator_result(attachIterator_result other) {
      if (other.isSetOuch1()) {
        this.ouch1 = new AccumuloSecurityException(other.ouch1);
      }
      if (other.isSetOuch2()) {
        this.ouch2 = new AccumuloException(other.ouch2);
      }
      if (other.isSetOuch3()) {
        this.ouch3 = new TableNotFoundException(other.ouch3);
      }
    }

    public attachIterator_result deepCopy() {
      return new attachIterator_result(this);
    }

    @Override
    public void clear() {
      this.ouch1 = null;
      this.ouch2 = null;
      this.ouch3 = null;
    }

    public AccumuloSecurityException getOuch1() {
      return this.ouch1;
    }

    public attachIterator_result setOuch1(AccumuloSecurityException ouch1) {
      this.ouch1 = ouch1;
      return this;
    }

    public void unsetOuch1() {
      this.ouch1 = null;
    }

    /** Returns true if field ouch1 is set (has been assigned a value) and false otherwise */
    public boolean isSetOuch1() {
      return this.ouch1 != null;
    }

    public void setOuch1IsSet(boolean value) {
      if (!value) {
        this.ouch1 = null;
      }
    }

    public AccumuloException getOuch2() {
      return this.ouch2;
    }

    public attachIterator_result setOuch2(AccumuloException ouch2) {
      this.ouch2 = ouch2;
      return this;
    }

    public void unsetOuch2() {
      this.ouch2 = null;
    }

    /** Returns true if field ouch2 is set (has been assigned a value) and false otherwise */
    public boolean isSetOuch2() {
      return this.ouch2 != null;
    }

    public void setOuch2IsSet(boolean value) {
      if (!value) {
        this.ouch2 = null;
      }
    }

    public TableNotFoundException getOuch3() {
      return this.ouch3;
    }

    public attachIterator_result setOuch3(TableNotFoundException ouch3) {
      this.ouch3 = ouch3;
      return this;
    }

    public void unsetOuch3() {
      this.ouch3 = null;
    }

    /** Returns true if field ouch3 is set (has been assigned a value) and false otherwise */
    public boolean isSetOuch3() {
      return this.ouch3 != null;
    }

    public void setOuch3IsSet(boolean value) {
      if (!value) {
        this.ouch3 = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case OUCH1:
        if (value == null) {
          unsetOuch1();
        } else {
          setOuch1((AccumuloSecurityException)value);
        }
        break;

      case OUCH2:
        if (value == null) {
          unsetOuch2();
        } else {
          setOuch2((AccumuloException)value);
        }
        break;

      case OUCH3:
        if (value == null) {
          unsetOuch3();
        } else {
          setOuch3((TableNotFoundException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case OUCH1:
        return getOuch1();

      case OUCH2:
        return getOuch2();

      case OUCH3:
        return getOuch3();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case OUCH1:
        return isSetOuch1();
      case OUCH2:
        return isSetOuch2();
      case OUCH3:
        return isSetOuch3();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof attachIterator_result)
        return this.equals((attachIterator_result)that);
      return false;
    }

    public boolean equals(attachIterator_result that) {
      if (that == null)
        return false;

      boolean this_present_ouch1 = true && this.isSetOuch1();
      boolean that_present_ouch1 = true && that.isSetOuch1();
      if (this_present_ouch1 || that_present_ouch1) {
        if (!(this_present_ouch1 && that_present_ouch1))
          return false;
        if (!this.ouch1.equals(that.ouch1))
          return false;
      }

      boolean this_present_ouch2 = true && this.isSetOuch2();
      boolean that_present_ouch2 = true && that.isSetOuch2();
      if (this_present_ouch2 || that_present_ouch2) {
        if (!(this_present_ouch2 && that_present_ouch2))
          return false;
        if (!this.ouch2.equals(that.ouch2))
          return false;
      }

      boolean this_present_ouch3 = true && this.isSetOuch3();
      boolean that_present_ouch3 = true && that.isSetOuch3();
      if (this_present_ouch3 || that_present_ouch3) {
        if (!(this_present_ouch3 && that_present_ouch3))
          return false;
        if (!this.ouch3.equals(that.ouch3))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_ouch1 = true && (isSetOuch1());
      list.add(present_ouch1);
      if (present_ouch1)
        list.add(ouch1);

      boolean present_ouch2 = true && (isSetOuch2());
      list.add(present_ouch2);
      if (present_ouch2)
        list.add(ouch2);

      boolean present_ouch3 = true && (isSetOuch3());
      list.add(present_ouch3);
      if (present_ouch3)
        list.add(ouch3);

      return list.hashCode();
    }

    @Override
    public int compareTo(attachIterator_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetOuch1()).compareTo(other.isSetOuch1());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetOuch1()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ouch1, other.ouch1);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetOuch2()).compareTo(other.isSetOuch2());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetOuch2()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ouch2, other.ouch2);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetOuch3()).compareTo(other.isSetOuch3());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetOuch3()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ouch3, other.ouch3);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("attachIterator_result(");
      boolean first = true;

      sb.append("ouch1:");
      if (this.ouch1 == null) {
        sb.append("null");
      } else {
        sb.append(this.ouch1);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("ouch2:");
      if (this.ouch2 == null) {
        sb.append("null");
      } else {
        sb.append(this.ouch2);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("ouch3:");
      if (this.ouch3 == null) {
        sb.append("null");
      } else {
        sb.append(this.ouch3);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class attachIterator_resultStandardSchemeFactory implements SchemeFactory {
      public attachIterator_resultStandardScheme getScheme() {
        return new attachIterator_resultStandardScheme();
      }
    }

    private static class attachIterator_resultStandardScheme extends StandardScheme<attachIterator_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, attachIterator_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // OUCH1
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.ouch1 = new AccumuloSecurityException();
                struct.ouch1.read(iprot);
                struct.setOuch1IsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // OUCH2
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.ouch2 = new AccumuloException();
                struct.ouch2.read(iprot);
                struct.setOuch2IsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // OUCH3
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.ouch3 = new TableNotFoundException();
                struct.ouch3.read(iprot);
                struct.setOuch3IsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, attachIterator_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.ouch1 != null) {
          oprot.writeFieldBegin(OUCH1_FIELD_DESC);
          struct.ouch1.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.ouch2 != null) {
          oprot.writeFieldBegin(OUCH2_FIELD_DESC);
          struct.ouch2.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.ouch3 != null) {
          oprot.writeFieldBegin(OUCH3_FIELD_DESC);
          struct.ouch3.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class attachIterator_resultTupleSchemeFactory implements SchemeFactory {
      public attachIterator_resultTupleScheme getScheme() {
        return new attachIterator_resultTupleScheme();
      }
    }

    private static class attachIterator_resultTupleScheme extends TupleScheme<attachIterator_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, attachIterator_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetOuch1()) {
          optionals.set(0);
        }
        if (struct.isSetOuch2()) {
          optionals.set(1);
        }
        if (struct.isSetOuch3()) {
          optionals.set(2);
        }
        oprot.writeBitSet(optionals, 3);
        if (struct.isSetOuch1()) {
          struct.ouch1.write(oprot);
        }
        if (struct.isSetOuch2()) {
          struct.ouch2.write(oprot);
        }
        if (struct.isSetOuch3()) {
          struct.ouch3.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, attachIterator_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(3);
        if (incoming.get(0)) {
          struct.ouch1 = new AccumuloSecurityException();
          struct.ouch1.read(iprot);
          struct.setOuch1IsSet(true);
        }
        if (incoming.get(1)) {
          struct.ouch2 = new AccumuloException();
          struct.ouch2.read(iprot);
          struct.setOuch2IsSet(true);
        }
        if (incoming.get(2)) {
          struct.ouch3 = new TableNotFoundException();
          struct.ouch3.read(iprot);
          struct.setOuch3IsSet(true);
        }
      }
    }

  }

  public static class checkIteratorConflicts_args implements org.apache.thrift.TBase<checkIteratorConflicts_args, checkIteratorConflicts_args._Fields>, java.io.Serializable, Cloneable, Comparable<checkIteratorConflicts_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("checkIteratorConflicts_args");

    private static final org.apache.thrift.protocol.TField LOGIN_FIELD_DESC = new org.apache.thrift.protocol.TField("login", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField TABLE_NAME_FIELD_DESC = new org.apache.thrift.protocol.TField("tableName", org.apache.thrift.protocol.TType.STRING, (short)2);
    private static final org.apache.thrift.protocol.TField SETTING_FIELD_DESC = new org.apache.thrift.protocol.TField("setting", org.apache.thrift.protocol.TType.STRUCT, (short)3);
    private static final org.apache.thrift.protocol.TField SCOPES_FIELD_DESC = new org.apache.thrift.protocol.TField("scopes", org.apache.thrift.protocol.TType.SET, (short)4);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new checkIteratorConflicts_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new checkIteratorConflicts_argsTupleSchemeFactory());
    }

    public ByteBuffer login; // required
    public String tableName; // required
    public IteratorSetting setting; // required
    public Set<IteratorScope> scopes; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      LOGIN((short)1, "login"),
      TABLE_NAME((short)2, "tableName"),
      SETTING((short)3, "setting"),
      SCOPES((short)4, "scopes");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // LOGIN
            return LOGIN;
          case 2: // TABLE_NAME
            return TABLE_NAME;
          case 3: // SETTING
            return SETTING;
          case 4: // SCOPES
            return SCOPES;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.LOGIN, new org.apache.thrift.meta_data.FieldMetaData("login", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , true)));
      tmpMap.put(_Fields.TABLE_NAME, new org.apache.thrift.meta_data.FieldMetaData("tableName", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.SETTING, new org.apache.thrift.meta_data.FieldMetaData("setting", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, IteratorSetting.class)));
      tmpMap.put(_Fields.SCOPES, new org.apache.thrift.meta_data.FieldMetaData("scopes", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.SetMetaData(org.apache.thrift.protocol.TType.SET, 
              new org.apache.thrift.meta_data.EnumMetaData(org.apache.thrift.protocol.TType.ENUM, IteratorScope.class))));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(checkIteratorConflicts_args.class, metaDataMap);
    }

    public checkIteratorConflicts_args() {
    }

    public checkIteratorConflicts_args(
      ByteBuffer login,
      String tableName,
      IteratorSetting setting,
      Set<IteratorScope> scopes)
    {
      this();
      this.login = org.apache.thrift.TBaseHelper.copyBinary(login);
      this.tableName = tableName;
      this.setting = setting;
      this.scopes = scopes;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public checkIteratorConflicts_args(checkIteratorConflicts_args other) {
      if (other.isSetLogin()) {
        this.login = org.apache.thrift.TBaseHelper.copyBinary(other.login);
      }
      if (other.isSetTableName()) {
        this.tableName = other.tableName;
      }
      if (other.isSetSetting()) {
        this.setting = new IteratorSetting(other.setting);
      }
      if (other.isSetScopes()) {
        Set<IteratorScope> __this__scopes = new HashSet<IteratorScope>(other.scopes.size());
        for (IteratorScope other_element : other.scopes) {
          __this__scopes.add(other_element);
        }
        this.scopes = __this__scopes;
      }
    }

    public checkIteratorConflicts_args deepCopy() {
      return new checkIteratorConflicts_args(this);
    }

    @Override
    public void clear() {
      this.login = null;
      this.tableName = null;
      this.setting = null;
      this.scopes = null;
    }

    public byte[] getLogin() {
      setLogin(org.apache.thrift.TBaseHelper.rightSize(login));
      return login == null ? null : login.array();
    }

    public ByteBuffer bufferForLogin() {
      return org.apache.thrift.TBaseHelper.copyBinary(login);
    }

    public checkIteratorConflicts_args setLogin(byte[] login) {
      this.login = login == null ? (ByteBuffer)null : ByteBuffer.wrap(Arrays.copyOf(login, login.length));
      return this;
    }

    public checkIteratorConflicts_args setLogin(ByteBuffer login) {
      this.login = org.apache.thrift.TBaseHelper.copyBinary(login);
      return this;
    }

    public void unsetLogin() {
      this.login = null;
    }

    /** Returns true if field login is set (has been assigned a value) and false otherwise */
    public boolean isSetLogin() {
      return this.login != null;
    }

    public void setLoginIsSet(boolean value) {
      if (!value) {
        this.login = null;
      }
    }

    public String getTableName() {
      return this.tableName;
    }

    public checkIteratorConflicts_args setTableName(String tableName) {
      this.tableName = tableName;
      return this;
    }

    public void unsetTableName() {
      this.tableName = null;
    }

    /** Returns true if field tableName is set (has been assigned a value) and false otherwise */
    public boolean isSetTableName() {
      return this.tableName != null;
    }

    public void setTableNameIsSet(boolean value) {
      if (!value) {
        this.tableName = null;
      }
    }

    public IteratorSetting getSetting() {
      return this.setting;
    }

    public checkIteratorConflicts_args setSetting(IteratorSetting setting) {
      this.setting = setting;
      return this;
    }

    public void unsetSetting() {
      this.setting = null;
    }

    /** Returns true if field setting is set (has been assigned a value) and false otherwise */
    public boolean isSetSetting() {
      return this.setting != null;
    }

    public void setSettingIsSet(boolean value) {
      if (!value) {
        this.setting = null;
      }
    }

    public int getScopesSize() {
      return (this.scopes == null) ? 0 : this.scopes.size();
    }

    public java.util.Iterator<IteratorScope> getScopesIterator() {
      return (this.scopes == null) ? null : this.scopes.iterator();
    }

    public void addToScopes(IteratorScope elem) {
      if (this.scopes == null) {
        this.scopes = new HashSet<IteratorScope>();
      }
      this.scopes.add(elem);
    }

    public Set<IteratorScope> getScopes() {
      return this.scopes;
    }

    public checkIteratorConflicts_args setScopes(Set<IteratorScope> scopes) {
      this.scopes = scopes;
      return this;
    }

    public void unsetScopes() {
      this.scopes = null;
    }

    /** Returns true if field scopes is set (has been assigned a value) and false otherwise */
    public boolean isSetScopes() {
      return this.scopes != null;
    }

    public void setScopesIsSet(boolean value) {
      if (!value) {
        this.scopes = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case LOGIN:
        if (value == null) {
          unsetLogin();
        } else {
          setLogin((ByteBuffer)value);
        }
        break;

      case TABLE_NAME:
        if (value == null) {
          unsetTableName();
        } else {
          setTableName((String)value);
        }
        break;

      case SETTING:
        if (value == null) {
          unsetSetting();
        } else {
          setSetting((IteratorSetting)value);
        }
        break;

      case SCOPES:
        if (value == null) {
          unsetScopes();
        } else {
          setScopes((Set<IteratorScope>)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case LOGIN:
        return getLogin();

      case TABLE_NAME:
        return getTableName();

      case SETTING:
        return getSetting();

      case SCOPES:
        return getScopes();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case LOGIN:
        return isSetLogin();
      case TABLE_NAME:
        return isSetTableName();
      case SETTING:
        return isSetSetting();
      case SCOPES:
        return isSetScopes();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof checkIteratorConflicts_args)
        return this.equals((checkIteratorConflicts_args)that);
      return false;
    }

    public boolean equals(checkIteratorConflicts_args that) {
      if (that == null)
        return false;

      boolean this_present_login = true && this.isSetLogin();
      boolean that_present_login = true && that.isSetLogin();
      if (this_present_login || that_present_login) {
        if (!(this_present_login && that_present_login))
          return false;
        if (!this.login.equals(that.login))
          return false;
      }

      boolean this_present_tableName = true && this.isSetTableName();
      boolean that_present_tableName = true && that.isSetTableName();
      if (this_present_tableName || that_present_tableName) {
        if (!(this_present_tableName && that_present_tableName))
          return false;
        if (!this.tableName.equals(that.tableName))
          return false;
      }

      boolean this_present_setting = true && this.isSetSetting();
      boolean that_present_setting = true && that.isSetSetting();
      if (this_present_setting || that_present_setting) {
        if (!(this_present_setting && that_present_setting))
          return false;
        if (!this.setting.equals(that.setting))
          return false;
      }

      boolean this_present_scopes = true && this.isSetScopes();
      boolean that_present_scopes = true && that.isSetScopes();
      if (this_present_scopes || that_present_scopes) {
        if (!(this_present_scopes && that_present_scopes))
          return false;
        if (!this.scopes.equals(that.scopes))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_login = true && (isSetLogin());
      list.add(present_login);
      if (present_login)
        list.add(login);

      boolean present_tableName = true && (isSetTableName());
      list.add(present_tableName);
      if (present_tableName)
        list.add(tableName);

      boolean present_setting = true && (isSetSetting());
      list.add(present_setting);
      if (present_setting)
        list.add(setting);

      boolean present_scopes = true && (isSetScopes());
      list.add(present_scopes);
      if (present_scopes)
        list.add(scopes);

      return list.hashCode();
    }

    @Override
    public int compareTo(checkIteratorConflicts_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetLogin()).compareTo(other.isSetLogin());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetLogin()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.login, other.login);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetTableName()).compareTo(other.isSetTableName());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTableName()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tableName, other.tableName);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetSetting()).compareTo(other.isSetSetting());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSetting()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.setting, other.setting);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetScopes()).compareTo(other.isSetScopes());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetScopes()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.scopes, other.scopes);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("checkIteratorConflicts_args(");
      boolean first = true;

      sb.append("login:");
      if (this.login == null) {
        sb.append("null");
      } else {
        org.apache.thrift.TBaseHelper.toString(this.login, sb);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("tableName:");
      if (this.tableName == null) {
        sb.append("null");
      } else {
        sb.append(this.tableName);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("setting:");
      if (this.setting == null) {
        sb.append("null");
      } else {
        sb.append(this.setting);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("scopes:");
      if (this.scopes == null) {
        sb.append("null");
      } else {
        sb.append(this.scopes);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (setting != null) {
        setting.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class checkIteratorConflicts_argsStandardSchemeFactory implements SchemeFactory {
      public checkIteratorConflicts_argsStandardScheme getScheme() {
        return new checkIteratorConflicts_argsStandardScheme();
      }
    }

    private static class checkIteratorConflicts_argsStandardScheme extends StandardScheme<checkIteratorConflicts_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, checkIteratorConflicts_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // LOGIN
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.login = iprot.readBinary();
                struct.setLoginIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // TABLE_NAME
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.tableName = iprot.readString();
                struct.setTableNameIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // SETTING
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.setting = new IteratorSetting();
                struct.setting.read(iprot);
                struct.setSettingIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 4: // SCOPES
              if (schemeField.type == org.apache.thrift.protocol.TType.SET) {
                {
                  org.apache.thrift.protocol.TSet _set190 = iprot.readSetBegin();
                  struct.scopes = new HashSet<IteratorScope>(2*_set190.size);
                  IteratorScope _elem191;
                  for (int _i192 = 0; _i192 < _set190.size; ++_i192)
                  {
                    _elem191 = org.apache.accumulo.proxy.thrift.IteratorScope.findByValue(iprot.readI32());
                    struct.scopes.add(_elem191);
                  }
                  iprot.readSetEnd();
                }
                struct.setScopesIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, checkIteratorConflicts_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.login != null) {
          oprot.writeFieldBegin(LOGIN_FIELD_DESC);
          oprot.writeBinary(struct.login);
          oprot.writeFieldEnd();
        }
        if (struct.tableName != null) {
          oprot.writeFieldBegin(TABLE_NAME_FIELD_DESC);
          oprot.writeString(struct.tableName);
          oprot.writeFieldEnd();
        }
        if (struct.setting != null) {
          oprot.writeFieldBegin(SETTING_FIELD_DESC);
          struct.setting.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.scopes != null) {
          oprot.writeFieldBegin(SCOPES_FIELD_DESC);
          {
            oprot.writeSetBegin(new org.apache.thrift.protocol.TSet(org.apache.thrift.protocol.TType.I32, struct.scopes.size()));
            for (IteratorScope _iter193 : struct.scopes)
            {
              oprot.writeI32(_iter193.getValue());
            }
            oprot.writeSetEnd();
          }
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class checkIteratorConflicts_argsTupleSchemeFactory implements SchemeFactory {
      public checkIteratorConflicts_argsTupleScheme getScheme() {
        return new checkIteratorConflicts_argsTupleScheme();
      }
    }

    private static class checkIteratorConflicts_argsTupleScheme extends TupleScheme<checkIteratorConflicts_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, checkIteratorConflicts_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetLogin()) {
          optionals.set(0);
        }
        if (struct.isSetTableName()) {
          optionals.set(1);
        }
        if (struct.isSetSetting()) {
          optionals.set(2);
        }
        if (struct.isSetScopes()) {
          optionals.set(3);
        }
        oprot.writeBitSet(optionals, 4);
        if (struct.isSetLogin()) {
          oprot.writeBinary(struct.login);
        }
        if (struct.isSetTableName()) {
          oprot.writeString(struct.tableName);
        }
        if (struct.isSetSetting()) {
          struct.setting.write(oprot);
        }
        if (struct.isSetScopes()) {
          {
            oprot.writeI32(struct.scopes.size());
            for (IteratorScope _iter194 : struct.scopes)
            {
              oprot.writeI32(_iter194.getValue());
            }
          }
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, checkIteratorConflicts_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(4);
        if (incoming.get(0)) {
          struct.login = iprot.readBinary();
          struct.setLoginIsSet(true);
        }
        if (incoming.get(1)) {
          struct.tableName = iprot.readString();
          struct.setTableNameIsSet(true);
        }
        if (incoming.get(2)) {
          struct.setting = new IteratorSetting();
          struct.setting.read(iprot);
          struct.setSettingIsSet(true);
        }
        if (incoming.get(3)) {
          {
            org.apache.thrift.protocol.TSet _set195 = new org.apache.thrift.protocol.TSet(org.apache.thrift.protocol.TType.I32, iprot.readI32());
            struct.scopes = new HashSet<IteratorScope>(2*_set195.size);
            IteratorScope _elem196;
            for (int _i197 = 0; _i197 < _set195.size; ++_i197)
            {
              _elem196 = org.apache.accumulo.proxy.thrift.IteratorScope.findByValue(iprot.readI32());
              struct.scopes.add(_elem196);
            }
          }
          struct.setScopesIsSet(true);
        }
      }
    }

  }

  public static class checkIteratorConflicts_result implements org.apache.thrift.TBase<checkIteratorConflicts_result, checkIteratorConflicts_result._Fields>, java.io.Serializable, Cloneable, Comparable<checkIteratorConflicts_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("checkIteratorConflicts_result");

    private static final org.apache.thrift.protocol.TField OUCH1_FIELD_DESC = new org.apache.thrift.protocol.TField("ouch1", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField OUCH2_FIELD_DESC = new org.apache.thrift.protocol.TField("ouch2", org.apache.thrift.protocol.TType.STRUCT, (short)2);
    private static final org.apache.thrift.protocol.TField OUCH3_FIELD_DESC = new org.apache.thrift.protocol.TField("ouch3", org.apache.thrift.protocol.TType.STRUCT, (short)3);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new checkIteratorConflicts_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new checkIteratorConflicts_resultTupleSchemeFactory());
    }

    public AccumuloSecurityException ouch1; // required
    public AccumuloException ouch2; // required
    public TableNotFoundException ouch3; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      OUCH1((short)1, "ouch1"),
      OUCH2((short)2, "ouch2"),
      OUCH3((short)3, "ouch3");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // OUCH1
            return OUCH1;
          case 2: // OUCH2
            return OUCH2;
          case 3: // OUCH3
            return OUCH3;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.OUCH1, new org.apache.thrift.meta_data.FieldMetaData("ouch1", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.OUCH2, new org.apache.thrift.meta_data.FieldMetaData("ouch2", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.OUCH3, new org.apache.thrift.meta_data.FieldMetaData("ouch3", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(checkIteratorConflicts_result.class, metaDataMap);
    }

    public checkIteratorConflicts_result() {
    }

    public checkIteratorConflicts_result(
      AccumuloSecurityException ouch1,
      AccumuloException ouch2,
      TableNotFoundException ouch3)
    {
      this();
      this.ouch1 = ouch1;
      this.ouch2 = ouch2;
      this.ouch3 = ouch3;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public checkIteratorConflicts_result(checkIteratorConflicts_result other) {
      if (other.isSetOuch1()) {
        this.ouch1 = new AccumuloSecurityException(other.ouch1);
      }
      if (other.isSetOuch2()) {
        this.ouch2 = new AccumuloException(other.ouch2);
      }
      if (other.isSetOuch3()) {
        this.ouch3 = new TableNotFoundException(other.ouch3);
      }
    }

    public checkIteratorConflicts_result deepCopy() {
      return new checkIteratorConflicts_result(this);
    }

    @Override
    public void clear() {
      this.ouch1 = null;
      this.ouch2 = null;
      this.ouch3 = null;
    }

    public AccumuloSecurityException getOuch1() {
      return this.ouch1;
    }

    public checkIteratorConflicts_result setOuch1(AccumuloSecurityException ouch1) {
      this.ouch1 = ouch1;
      return this;
    }

    public void unsetOuch1() {
      this.ouch1 = null;
    }

    /** Returns true if field ouch1 is set (has been assigned a value) and false otherwise */
    public boolean isSetOuch1() {
      return this.ouch1 != null;
    }

    public void setOuch1IsSet(boolean value) {
      if (!value) {
        this.ouch1 = null;
      }
    }

    public AccumuloException getOuch2() {
      return this.ouch2;
    }

    public checkIteratorConflicts_result setOuch2(AccumuloException ouch2) {
      this.ouch2 = ouch2;
      return this;
    }

    public void unsetOuch2() {
      this.ouch2 = null;
    }

    /** Returns true if field ouch2 is set (has been assigned a value) and false otherwise */
    public boolean isSetOuch2() {
      return this.ouch2 != null;
    }

    public void setOuch2IsSet(boolean value) {
      if (!value) {
        this.ouch2 = null;
      }
    }

    public TableNotFoundException getOuch3() {
      return this.ouch3;
    }

    public checkIteratorConflicts_result setOuch3(TableNotFoundException ouch3) {
      this.ouch3 = ouch3;
      return this;
    }

    public void unsetOuch3() {
      this.ouch3 = null;
    }

    /** Returns true if field ouch3 is set (has been assigned a value) and false otherwise */
    public boolean isSetOuch3() {
      return this.ouch3 != null;
    }

    public void setOuch3IsSet(boolean value) {
      if (!value) {
        this.ouch3 = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case OUCH1:
        if (value == null) {
          unsetOuch1();
        } else {
          setOuch1((AccumuloSecurityException)value);
        }
        break;

      case OUCH2:
        if (value == null) {
          unsetOuch2();
        } else {
          setOuch2((AccumuloException)value);
        }
        break;

      case OUCH3:
        if (value == null) {
          unsetOuch3();
        } else {
          setOuch3((TableNotFoundException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case OUCH1:
        return getOuch1();

      case OUCH2:
        return getOuch2();

      case OUCH3:
        return getOuch3();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case OUCH1:
        return isSetOuch1();
      case OUCH2:
        return isSetOuch2();
      case OUCH3:
        return isSetOuch3();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof checkIteratorConflicts_result)
        return this.equals((checkIteratorConflicts_result)that);
      return false;
    }

    public boolean equals(checkIteratorConflicts_result that) {
      if (that == null)
        return false;

      boolean this_present_ouch1 = true && this.isSetOuch1();
      boolean that_present_ouch1 = true && that.isSetOuch1();
      if (this_present_ouch1 || that_present_ouch1) {
        if (!(this_present_ouch1 && that_present_ouch1))
          return false;
        if (!this.ouch1.equals(that.ouch1))
          return false;
      }

      boolean this_present_ouch2 = true && this.isSetOuch2();
      boolean that_present_ouch2 = true && that.isSetOuch2();
      if (this_present_ouch2 || that_present_ouch2) {
        if (!(this_present_ouch2 && that_present_ouch2))
          return false;
        if (!this.ouch2.equals(that.ouch2))
          return false;
      }

      boolean this_present_ouch3 = true && this.isSetOuch3();
      boolean that_present_ouch3 = true && that.isSetOuch3();
      if (this_present_ouch3 || that_present_ouch3) {
        if (!(this_present_ouch3 && that_present_ouch3))
          return false;
        if (!this.ouch3.equals(that.ouch3))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_ouch1 = true && (isSetOuch1());
      list.add(present_ouch1);
      if (present_ouch1)
        list.add(ouch1);

      boolean present_ouch2 = true && (isSetOuch2());
      list.add(present_ouch2);
      if (present_ouch2)
        list.add(ouch2);

      boolean present_ouch3 = true && (isSetOuch3());
      list.add(present_ouch3);
      if (present_ouch3)
        list.add(ouch3);

      return list.hashCode();
    }

    @Override
    public int compareTo(checkIteratorConflicts_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetOuch1()).compareTo(other.isSetOuch1());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetOuch1()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ouch1, other.ouch1);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetOuch2()).compareTo(other.isSetOuch2());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetOuch2()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ouch2, other.ouch2);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetOuch3()).compareTo(other.isSetOuch3());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetOuch3()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ouch3, other.ouch3);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("checkIteratorConflicts_result(");
      boolean first = true;

      sb.append("ouch1:");
      if (this.ouch1 == null) {
        sb.append("null");
      } else {
        sb.append(this.ouch1);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("ouch2:");
      if (this.ouch2 == null) {
        sb.append("null");
      } else {
        sb.append(this.ouch2);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("ouch3:");
      if (this.ouch3 == null) {
        sb.append("null");
      } else {
        sb.append(this.ouch3);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class checkIteratorConflicts_resultStandardSchemeFactory implements SchemeFactory {
      public checkIteratorConflicts_resultStandardScheme getScheme() {
        return new checkIteratorConflicts_resultStandardScheme();
      }
    }

    private static class checkIteratorConflicts_resultStandardScheme extends StandardScheme<checkIteratorConflicts_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, checkIteratorConflicts_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // OUCH1
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.ouch1 = new AccumuloSecurityException();
                struct.ouch1.read(iprot);
                struct.setOuch1IsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // OUCH2
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.ouch2 = new AccumuloException();
                struct.ouch2.read(iprot);
                struct.setOuch2IsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // OUCH3
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.ouch3 = new TableNotFoundException();
                struct.ouch3.read(iprot);
                struct.setOuch3IsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, checkIteratorConflicts_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.ouch1 != null) {
          oprot.writeFieldBegin(OUCH1_FIELD_DESC);
          struct.ouch1.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.ouch2 != null) {
          oprot.writeFieldBegin(OUCH2_FIELD_DESC);
          struct.ouch2.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.ouch3 != null) {
          oprot.writeFieldBegin(OUCH3_FIELD_DESC);
          struct.ouch3.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class checkIteratorConflicts_resultTupleSchemeFactory implements SchemeFactory {
      public checkIteratorConflicts_resultTupleScheme getScheme() {
        return new checkIteratorConflicts_resultTupleScheme();
      }
    }

    private static class checkIteratorConflicts_resultTupleScheme extends TupleScheme<checkIteratorConflicts_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, checkIteratorConflicts_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetOuch1()) {
          optionals.set(0);
        }
        if (struct.isSetOuch2()) {
          optionals.set(1);
        }
        if (struct.isSetOuch3()) {
          optionals.set(2);
        }
        oprot.writeBitSet(optionals, 3);
        if (struct.isSetOuch1()) {
          struct.ouch1.write(oprot);
        }
        if (struct.isSetOuch2()) {
          struct.ouch2.write(oprot);
        }
        if (struct.isSetOuch3()) {
          struct.ouch3.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, checkIteratorConflicts_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(3);
        if (incoming.get(0)) {
          struct.ouch1 = new AccumuloSecurityException();
          struct.ouch1.read(iprot);
          struct.setOuch1IsSet(true);
        }
        if (incoming.get(1)) {
          struct.ouch2 = new AccumuloException();
          struct.ouch2.read(iprot);
          struct.setOuch2IsSet(true);
        }
        if (incoming.get(2)) {
          struct.ouch3 = new TableNotFoundException();
          struct.ouch3.read(iprot);
          struct.setOuch3IsSet(true);
        }
      }
    }

  }

  public static class clearLocatorCache_args implements org.apache.thrift.TBase<clearLocatorCache_args, clearLocatorCache_args._Fields>, java.io.Serializable, Cloneable, Comparable<clearLocatorCache_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("clearLocatorCache_args");

    private static final org.apache.thrift.protocol.TField LOGIN_FIELD_DESC = new org.apache.thrift.protocol.TField("login", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField TABLE_NAME_FIELD_DESC = new org.apache.thrift.protocol.TField("tableName", org.apache.thrift.protocol.TType.STRING, (short)2);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new clearLocatorCache_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new clearLocatorCache_argsTupleSchemeFactory());
    }

    public ByteBuffer login; // required
    public String tableName; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      LOGIN((short)1, "login"),
      TABLE_NAME((short)2, "tableName");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // LOGIN
            return LOGIN;
          case 2: // TABLE_NAME
            return TABLE_NAME;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.LOGIN, new org.apache.thrift.meta_data.FieldMetaData("login", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , true)));
      tmpMap.put(_Fields.TABLE_NAME, new org.apache.thrift.meta_data.FieldMetaData("tableName", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(clearLocatorCache_args.class, metaDataMap);
    }

    public clearLocatorCache_args() {
    }

    public clearLocatorCache_args(
      ByteBuffer login,
      String tableName)
    {
      this();
      this.login = org.apache.thrift.TBaseHelper.copyBinary(login);
      this.tableName = tableName;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public clearLocatorCache_args(clearLocatorCache_args other) {
      if (other.isSetLogin()) {
        this.login = org.apache.thrift.TBaseHelper.copyBinary(other.login);
      }
      if (other.isSetTableName()) {
        this.tableName = other.tableName;
      }
    }

    public clearLocatorCache_args deepCopy() {
      return new clearLocatorCache_args(this);
    }

    @Override
    public void clear() {
      this.login = null;
      this.tableName = null;
    }

    public byte[] getLogin() {
      setLogin(org.apache.thrift.TBaseHelper.rightSize(login));
      return login == null ? null : login.array();
    }

    public ByteBuffer bufferForLogin() {
      return org.apache.thrift.TBaseHelper.copyBinary(login);
    }

    public clearLocatorCache_args setLogin(byte[] login) {
      this.login = login == null ? (ByteBuffer)null : ByteBuffer.wrap(Arrays.copyOf(login, login.length));
      return this;
    }

    public clearLocatorCache_args setLogin(ByteBuffer login) {
      this.login = org.apache.thrift.TBaseHelper.copyBinary(login);
      return this;
    }

    public void unsetLogin() {
      this.login = null;
    }

    /** Returns true if field login is set (has been assigned a value) and false otherwise */
    public boolean isSetLogin() {
      return this.login != null;
    }

    public void setLoginIsSet(boolean value) {
      if (!value) {
        this.login = null;
      }
    }

    public String getTableName() {
      return this.tableName;
    }

    public clearLocatorCache_args setTableName(String tableName) {
      this.tableName = tableName;
      return this;
    }

    public void unsetTableName() {
      this.tableName = null;
    }

    /** Returns true if field tableName is set (has been assigned a value) and false otherwise */
    public boolean isSetTableName() {
      return this.tableName != null;
    }

    public void setTableNameIsSet(boolean value) {
      if (!value) {
        this.tableName = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case LOGIN:
        if (value == null) {
          unsetLogin();
        } else {
          setLogin((ByteBuffer)value);
        }
        break;

      case TABLE_NAME:
        if (value == null) {
          unsetTableName();
        } else {
          setTableName((String)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case LOGIN:
        return getLogin();

      case TABLE_NAME:
        return getTableName();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case LOGIN:
        return isSetLogin();
      case TABLE_NAME:
        return isSetTableName();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof clearLocatorCache_args)
        return this.equals((clearLocatorCache_args)that);
      return false;
    }

    public boolean equals(clearLocatorCache_args that) {
      if (that == null)
        return false;

      boolean this_present_login = true && this.isSetLogin();
      boolean that_present_login = true && that.isSetLogin();
      if (this_present_login || that_present_login) {
        if (!(this_present_login && that_present_login))
          return false;
        if (!this.login.equals(that.login))
          return false;
      }

      boolean this_present_tableName = true && this.isSetTableName();
      boolean that_present_tableName = true && that.isSetTableName();
      if (this_present_tableName || that_present_tableName) {
        if (!(this_present_tableName && that_present_tableName))
          return false;
        if (!this.tableName.equals(that.tableName))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_login = true && (isSetLogin());
      list.add(present_login);
      if (present_login)
        list.add(login);

      boolean present_tableName = true && (isSetTableName());
      list.add(present_tableName);
      if (present_tableName)
        list.add(tableName);

      return list.hashCode();
    }

    @Override
    public int compareTo(clearLocatorCache_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetLogin()).compareTo(other.isSetLogin());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetLogin()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.login, other.login);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetTableName()).compareTo(other.isSetTableName());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTableName()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tableName, other.tableName);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("clearLocatorCache_args(");
      boolean first = true;

      sb.append("login:");
      if (this.login == null) {
        sb.append("null");
      } else {
        org.apache.thrift.TBaseHelper.toString(this.login, sb);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("tableName:");
      if (this.tableName == null) {
        sb.append("null");
      } else {
        sb.append(this.tableName);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class clearLocatorCache_argsStandardSchemeFactory implements SchemeFactory {
      public clearLocatorCache_argsStandardScheme getScheme() {
        return new clearLocatorCache_argsStandardScheme();
      }
    }

    private static class clearLocatorCache_argsStandardScheme extends StandardScheme<clearLocatorCache_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, clearLocatorCache_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // LOGIN
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.login = iprot.readBinary();
                struct.setLoginIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // TABLE_NAME
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.tableName = iprot.readString();
                struct.setTableNameIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, clearLocatorCache_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.login != null) {
          oprot.writeFieldBegin(LOGIN_FIELD_DESC);
          oprot.writeBinary(struct.login);
          oprot.writeFieldEnd();
        }
        if (struct.tableName != null) {
          oprot.writeFieldBegin(TABLE_NAME_FIELD_DESC);
          oprot.writeString(struct.tableName);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class clearLocatorCache_argsTupleSchemeFactory implements SchemeFactory {
      public clearLocatorCache_argsTupleScheme getScheme() {
        return new clearLocatorCache_argsTupleScheme();
      }
    }

    private static class clearLocatorCache_argsTupleScheme extends TupleScheme<clearLocatorCache_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, clearLocatorCache_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetLogin()) {
          optionals.set(0);
        }
        if (struct.isSetTableName()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetLogin()) {
          oprot.writeBinary(struct.login);
        }
        if (struct.isSetTableName()) {
          oprot.writeString(struct.tableName);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, clearLocatorCache_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.login = iprot.readBinary();
          struct.setLoginIsSet(true);
        }
        if (incoming.get(1)) {
          struct.tableName = iprot.readString();
          struct.setTableNameIsSet(true);
        }
      }
    }

  }

  public static class clearLocatorCache_result implements org.apache.thrift.TBase<clearLocatorCache_result, clearLocatorCache_result._Fields>, java.io.Serializable, Cloneable, Comparable<clearLocatorCache_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("clearLocatorCache_result");

    private static final org.apache.thrift.protocol.TField OUCH1_FIELD_DESC = new org.apache.thrift.protocol.TField("ouch1", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new clearLocatorCache_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new clearLocatorCache_resultTupleSchemeFactory());
    }

    public TableNotFoundException ouch1; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      OUCH1((short)1, "ouch1");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // OUCH1
            return OUCH1;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.OUCH1, new org.apache.thrift.meta_data.FieldMetaData("ouch1", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(clearLocatorCache_result.class, metaDataMap);
    }

    public clearLocatorCache_result() {
    }

    public clearLocatorCache_result(
      TableNotFoundException ouch1)
    {
      this();
      this.ouch1 = ouch1;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public clearLocatorCache_result(clearLocatorCache_result other) {
      if (other.isSetOuch1()) {
        this.ouch1 = new TableNotFoundException(other.ouch1);
      }
    }

    public clearLocatorCache_result deepCopy() {
      return new clearLocatorCache_result(this);
    }

    @Override
    public void clear() {
      this.ouch1 = null;
    }

    public TableNotFoundException getOuch1() {
      return this.ouch1;
    }

    public clearLocatorCache_result setOuch1(TableNotFoundException ouch1) {
      this.ouch1 = ouch1;
      return this;
    }

    public void unsetOuch1() {
      this.ouch1 = null;
    }

    /** Returns true if field ouch1 is set (has been assigned a value) and false otherwise */
    public boolean isSetOuch1() {
      return this.ouch1 != null;
    }

    public void setOuch1IsSet(boolean value) {
      if (!value) {
        this.ouch1 = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case OUCH1:
        if (value == null) {
          unsetOuch1();
        } else {
          setOuch1((TableNotFoundException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case OUCH1:
        return getOuch1();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case OUCH1:
        return isSetOuch1();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof clearLocatorCache_result)
        return this.equals((clearLocatorCache_result)that);
      return false;
    }

    public boolean equals(clearLocatorCache_result that) {
      if (that == null)
        return false;

      boolean this_present_ouch1 = true && this.isSetOuch1();
      boolean that_present_ouch1 = true && that.isSetOuch1();
      if (this_present_ouch1 || that_present_ouch1) {
        if (!(this_present_ouch1 && that_present_ouch1))
          return false;
        if (!this.ouch1.equals(that.ouch1))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_ouch1 = true && (isSetOuch1());
      list.add(present_ouch1);
      if (present_ouch1)
        list.add(ouch1);

      return list.hashCode();
    }

    @Override
    public int compareTo(clearLocatorCache_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetOuch1()).compareTo(other.isSetOuch1());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetOuch1()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ouch1, other.ouch1);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("clearLocatorCache_result(");
      boolean first = true;

      sb.append("ouch1:");
      if (this.ouch1 == null) {
        sb.append("null");
      } else {
        sb.append(this.ouch1);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class clearLocatorCache_resultStandardSchemeFactory implements SchemeFactory {
      public clearLocatorCache_resultStandardScheme getScheme() {
        return new clearLocatorCache_resultStandardScheme();
      }
    }

    private static class clearLocatorCache_resultStandardScheme extends StandardScheme<clearLocatorCache_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, clearLocatorCache_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // OUCH1
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.ouch1 = new TableNotFoundException();
                struct.ouch1.read(iprot);
                struct.setOuch1IsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, clearLocatorCache_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.ouch1 != null) {
          oprot.writeFieldBegin(OUCH1_FIELD_DESC);
          struct.ouch1.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class clearLocatorCache_resultTupleSchemeFactory implements SchemeFactory {
      public clearLocatorCache_resultTupleScheme getScheme() {
        return new clearLocatorCache_resultTupleScheme();
      }
    }

    private static class clearLocatorCache_resultTupleScheme extends TupleScheme<clearLocatorCache_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, clearLocatorCache_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetOuch1()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetOuch1()) {
          struct.ouch1.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, clearLocatorCache_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.ouch1 = new TableNotFoundException();
          struct.ouch1.read(iprot);
          struct.setOuch1IsSet(true);
        }
      }
    }

  }

  public static class cloneTable_args implements org.apache.thrift.TBase<cloneTable_args, cloneTable_args._Fields>, java.io.Serializable, Cloneable, Comparable<cloneTable_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("cloneTable_args");

    private static final org.apache.thrift.protocol.TField LOGIN_FIELD_DESC = new org.apache.thrift.protocol.TField("login", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField TABLE_NAME_FIELD_DESC = new org.apache.thrift.protocol.TField("tableName", org.apache.thrift.protocol.TType.STRING, (short)2);
    private static final org.apache.thrift.protocol.TField NEW_TABLE_NAME_FIELD_DESC = new org.apache.thrift.protocol.TField("newTableName", org.apache.thrift.protocol.TType.STRING, (short)3);
    private static final org.apache.thrift.protocol.TField FLUSH_FIELD_DESC = new org.apache.thrift.protocol.TField("flush", org.apache.thrift.protocol.TType.BOOL, (short)4);
    private static final org.apache.thrift.protocol.TField PROPERTIES_TO_SET_FIELD_DESC = new org.apache.thrift.protocol.TField("propertiesToSet", org.apache.thrift.protocol.TType.MAP, (short)5);
    private static final org.apache.thrift.protocol.TField PROPERTIES_TO_EXCLUDE_FIELD_DESC = new org.apache.thrift.protocol.TField("propertiesToExclude", org.apache.thrift.protocol.TType.SET, (short)6);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new cloneTable_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new cloneTable_argsTupleSchemeFactory());
    }

    public ByteBuffer login; // required
    public String tableName; // required
    public String newTableName; // required
    public boolean flush; // required
    public Map<String,String> propertiesToSet; // required
    public Set<String> propertiesToExclude; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      LOGIN((short)1, "login"),
      TABLE_NAME((short)2, "tableName"),
      NEW_TABLE_NAME((short)3, "newTableName"),
      FLUSH((short)4, "flush"),
      PROPERTIES_TO_SET((short)5, "propertiesToSet"),
      PROPERTIES_TO_EXCLUDE((short)6, "propertiesToExclude");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // LOGIN
            return LOGIN;
          case 2: // TABLE_NAME
            return TABLE_NAME;
          case 3: // NEW_TABLE_NAME
            return NEW_TABLE_NAME;
          case 4: // FLUSH
            return FLUSH;
          case 5: // PROPERTIES_TO_SET
            return PROPERTIES_TO_SET;
          case 6: // PROPERTIES_TO_EXCLUDE
            return PROPERTIES_TO_EXCLUDE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __FLUSH_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.LOGIN, new org.apache.thrift.meta_data.FieldMetaData("login", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , true)));
      tmpMap.put(_Fields.TABLE_NAME, new org.apache.thrift.meta_data.FieldMetaData("tableName", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.NEW_TABLE_NAME, new org.apache.thrift.meta_data.FieldMetaData("newTableName", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.FLUSH, new org.apache.thrift.meta_data.FieldMetaData("flush", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.BOOL)));
      tmpMap.put(_Fields.PROPERTIES_TO_SET, new org.apache.thrift.meta_data.FieldMetaData("propertiesToSet", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.MapMetaData(org.apache.thrift.protocol.TType.MAP, 
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING), 
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING))));
      tmpMap.put(_Fields.PROPERTIES_TO_EXCLUDE, new org.apache.thrift.meta_data.FieldMetaData("propertiesToExclude", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.SetMetaData(org.apache.thrift.protocol.TType.SET, 
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING))));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(cloneTable_args.class, metaDataMap);
    }

    public cloneTable_args() {
    }

    public cloneTable_args(
      ByteBuffer login,
      String tableName,
      String newTableName,
      boolean flush,
      Map<String,String> propertiesToSet,
      Set<String> propertiesToExclude)
    {
      this();
      this.login = org.apache.thrift.TBaseHelper.copyBinary(login);
      this.tableName = tableName;
      this.newTableName = newTableName;
      this.flush = flush;
      setFlushIsSet(true);
      this.propertiesToSet = propertiesToSet;
      this.propertiesToExclude = propertiesToExclude;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public cloneTable_args(cloneTable_args other) {
      __isset_bitfield = other.__isset_bitfield;
      if (other.isSetLogin()) {
        this.login = org.apache.thrift.TBaseHelper.copyBinary(other.login);
      }
      if (other.isSetTableName()) {
        this.tableName = other.tableName;
      }
      if (other.isSetNewTableName()) {
        this.newTableName = other.newTableName;
      }
      this.flush = other.flush;
      if (other.isSetPropertiesToSet()) {
        Map<String,String> __this__propertiesToSet = new HashMap<String,String>(other.propertiesToSet);
        this.propertiesToSet = __this__propertiesToSet;
      }
      if (other.isSetPropertiesToExclude()) {
        Set<String> __this__propertiesToExclude = new HashSet<String>(other.propertiesToExclude);
        this.propertiesToExclude = __this__propertiesToExclude;
      }
    }

    public cloneTable_args deepCopy() {
      return new cloneTable_args(this);
    }

    @Override
    public void clear() {
      this.login = null;
      this.tableName = null;
      this.newTableName = null;
      setFlushIsSet(false);
      this.flush = false;
      this.propertiesToSet = null;
      this.propertiesToExclude = null;
    }

    public byte[] getLogin() {
      setLogin(org.apache.thrift.TBaseHelper.rightSize(login));
      return login == null ? null : login.array();
    }

    public ByteBuffer bufferForLogin() {
      return org.apache.thrift.TBaseHelper.copyBinary(login);
    }

    public cloneTable_args setLogin(byte[] login) {
      this.login = login == null ? (ByteBuffer)null : ByteBuffer.wrap(Arrays.copyOf(login, login.length));
      return this;
    }

    public cloneTable_args setLogin(ByteBuffer login) {
      this.login = org.apache.thrift.TBaseHelper.copyBinary(login);
      return this;
    }

    public void unsetLogin() {
      this.login = null;
    }

    /** Returns true if field login is set (has been assigned a value) and false otherwise */
    public boolean isSetLogin() {
      return this.login != null;
    }

    public void setLoginIsSet(boolean value) {
      if (!value) {
        this.login = null;
      }
    }

    public String getTableName() {
      return this.tableName;
    }

    public cloneTable_args setTableName(String tableName) {
      this.tableName = tableName;
      return this;
    }

    public void unsetTableName() {
      this.tableName = null;
    }

    /** Returns true if field tableName is set (has been assigned a value) and false otherwise */
    public boolean isSetTableName() {
      return this.tableName != null;
    }

    public void setTableNameIsSet(boolean value) {
      if (!value) {
        this.tableName = null;
      }
    }

    public String getNewTableName() {
      return this.newTableName;
    }

    public cloneTable_args setNewTableName(String newTableName) {
      this.newTableName = newTab