/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.randomwalk.security;

import java.util.Properties;
import java.util.Random;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.security.SystemPermission;
import org.apache.accumulo.test.randomwalk.Environment;
import org.apache.accumulo.test.randomwalk.State;
import org.apache.accumulo.test.randomwalk.Test;
import org.apache.accumulo.test.randomwalk.security.WalkingSecurity;

public class AlterSystemPerm
extends Test {
    @Override
    public void visit(State state, Environment env, Properties props) throws Exception {
        SystemPermission sysPerm;
        Connector conn = env.getConnector();
        WalkingSecurity ws = new WalkingSecurity(state, env);
        String action = props.getProperty("task", "toggle");
        String perm = props.getProperty("perm", "random");
        String targetUser = WalkingSecurity.get(state, env).getSysUserName();
        if (perm.equals("random")) {
            Random r = new Random();
            int i = r.nextInt(SystemPermission.values().length);
            sysPerm = SystemPermission.values()[i];
        } else {
            sysPerm = SystemPermission.valueOf((String)perm);
        }
        boolean hasPerm = ws.hasSystemPermission(targetUser, sysPerm);
        if (!"take".equals(action) && !"give".equals(action)) {
            if (hasPerm != conn.securityOperations().hasSystemPermission(targetUser, sysPerm)) {
                throw new AccumuloException("Test framework and accumulo are out of sync!");
            }
            action = hasPerm ? "take" : "give";
        }
        if ("take".equals(action)) {
            try {
                conn.securityOperations().revokeSystemPermission(targetUser, sysPerm);
            }
            catch (AccumuloSecurityException ae) {
                switch (ae.getSecurityErrorCode()) {
                    case GRANT_INVALID: {
                        if (sysPerm.equals((Object)SystemPermission.GRANT)) {
                            return;
                        }
                        throw new AccumuloException("Got GRANT_INVALID when not dealing with GRANT", (Throwable)ae);
                    }
                    case PERMISSION_DENIED: {
                        throw new AccumuloException("Test user doesn't have root", (Throwable)ae);
                    }
                    case USER_DOESNT_EXIST: {
                        throw new AccumuloException("System user doesn't exist and they SHOULD.", (Throwable)ae);
                    }
                }
                throw new AccumuloException("Got unexpected exception", (Throwable)ae);
            }
            ws.revokeSystemPermission(targetUser, sysPerm);
        } else if ("give".equals(action)) {
            try {
                conn.securityOperations().grantSystemPermission(targetUser, sysPerm);
            }
            catch (AccumuloSecurityException ae) {
                switch (ae.getSecurityErrorCode()) {
                    case GRANT_INVALID: {
                        if (sysPerm.equals((Object)SystemPermission.GRANT)) {
                            return;
                        }
                        throw new AccumuloException("Got GRANT_INVALID when not dealing with GRANT", (Throwable)ae);
                    }
                    case PERMISSION_DENIED: {
                        throw new AccumuloException("Test user doesn't have root", (Throwable)ae);
                    }
                    case USER_DOESNT_EXIST: {
                        throw new AccumuloException("System user doesn't exist and they SHOULD.", (Throwable)ae);
                    }
                }
                throw new AccumuloException("Got unexpected exception", (Throwable)ae);
            }
            ws.grantSystemPermission(targetUser, sysPerm);
        }
    }
}

