/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.randomwalk.conditional;

import java.util.Properties;
import java.util.Random;
import org.apache.accumulo.core.client.ConditionalWriter;
import org.apache.accumulo.core.client.ConditionalWriterConfig;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.test.randomwalk.Environment;
import org.apache.accumulo.test.randomwalk.State;
import org.apache.accumulo.test.randomwalk.Test;

public class Setup
extends Test {
    @Override
    public void visit(State state, Environment env, Properties props) throws Exception {
        Random rand = new Random();
        state.set("rand", rand);
        int numBanks = Integer.parseInt(props.getProperty("numBanks", "1000"));
        this.log.debug((Object)("numBanks = " + numBanks));
        state.set("numBanks", numBanks);
        int numAccts = Integer.parseInt(props.getProperty("numAccts", "10000"));
        this.log.debug((Object)("numAccts = " + numAccts));
        state.set("numAccts", numAccts);
        String tableName = "banks";
        state.set("tableName", tableName);
        try {
            env.getConnector().tableOperations().create(tableName);
            this.log.debug((Object)("created table " + tableName));
            boolean blockCache = rand.nextBoolean();
            env.getConnector().tableOperations().setProperty(tableName, Property.TABLE_BLOCKCACHE_ENABLED.getKey(), blockCache + "");
            this.log.debug((Object)("set " + Property.TABLE_BLOCKCACHE_ENABLED.getKey() + " " + blockCache));
        }
        catch (TableExistsException blockCache) {
            // empty catch block
        }
        ConditionalWriter cw = env.getConnector().createConditionalWriter(tableName, new ConditionalWriterConfig().setMaxWriteThreads(1));
        state.set("cw", cw);
    }
}

