/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.randomwalk.concurrent;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.impl.thrift.TableOperationExceptionType;
import org.apache.accumulo.core.client.impl.thrift.ThriftTableOperationException;
import org.apache.accumulo.core.security.NamespacePermission;
import org.apache.accumulo.core.security.SystemPermission;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.test.randomwalk.Environment;
import org.apache.accumulo.test.randomwalk.State;
import org.apache.accumulo.test.randomwalk.Test;

public class ChangePermissions
extends Test {
    @Override
    public void visit(State state, Environment env, Properties props) throws Exception {
        block8: {
            Connector conn = env.getConnector();
            Random rand = (Random)state.get("rand");
            List userNames = (List)state.get("users");
            String userName = (String)userNames.get(rand.nextInt(userNames.size()));
            List tableNames = (List)state.get("tables");
            String tableName = (String)tableNames.get(rand.nextInt(tableNames.size()));
            List namespaces = (List)state.get("namespaces");
            String namespace = (String)namespaces.get(rand.nextInt(namespaces.size()));
            try {
                int dice = rand.nextInt(3);
                if (dice == 0) {
                    this.changeSystemPermission(conn, rand, userName);
                } else if (dice == 1) {
                    this.changeTablePermission(conn, rand, userName, tableName);
                } else if (dice == 2) {
                    this.changeNamespacePermission(conn, rand, userName, namespace);
                }
            }
            catch (AccumuloSecurityException ex) {
                this.log.debug((Object)("Unable to change user permissions: " + ex.getCause()));
            }
            catch (AccumuloException ex) {
                Throwable cause = ex.getCause();
                if (cause == null || !(cause instanceof ThriftTableOperationException)) break block8;
                ThriftTableOperationException toe = (ThriftTableOperationException)cause.getCause();
                if (toe.type != TableOperationExceptionType.NAMESPACE_NOTFOUND) break block8;
                this.log.debug((Object)("Unable to change user permissions: " + toe));
                return;
            }
        }
    }

    private void changeTablePermission(Connector conn, Random rand, String userName, String tableName) throws AccumuloException, AccumuloSecurityException {
        EnumSet<TablePermission> perms = EnumSet.noneOf(TablePermission.class);
        for (TablePermission p : TablePermission.values()) {
            if (!conn.securityOperations().hasTablePermission(userName, tableName, p)) continue;
            perms.add(p);
        }
        EnumSet<TablePermission> more = EnumSet.allOf(TablePermission.class);
        more.removeAll(perms);
        if (rand.nextBoolean() && more.size() > 0) {
            ArrayList<TablePermission> moreList = new ArrayList<TablePermission>(more);
            TablePermission choice = (TablePermission)moreList.get(rand.nextInt(moreList.size()));
            this.log.debug((Object)("adding permission " + choice));
            conn.securityOperations().grantTablePermission(userName, tableName, choice);
        } else if (perms.size() > 0) {
            ArrayList<TablePermission> permList = new ArrayList<TablePermission>(perms);
            TablePermission choice = (TablePermission)permList.get(rand.nextInt(permList.size()));
            this.log.debug((Object)("removing permission " + choice));
            conn.securityOperations().revokeTablePermission(userName, tableName, choice);
        }
    }

    private void changeSystemPermission(Connector conn, Random rand, String userName) throws AccumuloException, AccumuloSecurityException {
        EnumSet<SystemPermission> perms = EnumSet.noneOf(SystemPermission.class);
        for (SystemPermission p : SystemPermission.values()) {
            if (!conn.securityOperations().hasSystemPermission(userName, p)) continue;
            perms.add(p);
        }
        EnumSet<SystemPermission> more = EnumSet.allOf(SystemPermission.class);
        more.removeAll(perms);
        more.remove(SystemPermission.GRANT);
        if (rand.nextBoolean() && more.size() > 0) {
            ArrayList<SystemPermission> moreList = new ArrayList<SystemPermission>(more);
            SystemPermission choice = (SystemPermission)moreList.get(rand.nextInt(moreList.size()));
            this.log.debug((Object)("adding permission " + choice));
            conn.securityOperations().grantSystemPermission(userName, choice);
        } else if (perms.size() > 0) {
            ArrayList<SystemPermission> permList = new ArrayList<SystemPermission>(perms);
            SystemPermission choice = (SystemPermission)permList.get(rand.nextInt(permList.size()));
            this.log.debug((Object)("removing permission " + choice));
            conn.securityOperations().revokeSystemPermission(userName, choice);
        }
    }

    private void changeNamespacePermission(Connector conn, Random rand, String userName, String namespace) throws AccumuloException, AccumuloSecurityException {
        EnumSet<NamespacePermission> perms = EnumSet.noneOf(NamespacePermission.class);
        for (NamespacePermission p : NamespacePermission.values()) {
            if (!conn.securityOperations().hasNamespacePermission(userName, namespace, p)) continue;
            perms.add(p);
        }
        EnumSet<NamespacePermission> more = EnumSet.allOf(NamespacePermission.class);
        more.removeAll(perms);
        if (rand.nextBoolean() && more.size() > 0) {
            ArrayList<NamespacePermission> moreList = new ArrayList<NamespacePermission>(more);
            NamespacePermission choice = (NamespacePermission)moreList.get(rand.nextInt(moreList.size()));
            this.log.debug((Object)("adding permission " + choice));
            conn.securityOperations().grantNamespacePermission(userName, namespace, choice);
        } else if (perms.size() > 0) {
            ArrayList<NamespacePermission> permList = new ArrayList<NamespacePermission>(perms);
            NamespacePermission choice = (NamespacePermission)permList.get(rand.nextInt(permList.size()));
            this.log.debug((Object)("removing permission " + choice));
            conn.securityOperations().revokeNamespacePermission(userName, namespace, choice);
        }
    }
}

