/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.util.Base64;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.minicluster.impl.MiniAccumuloConfigImpl;
import org.apache.accumulo.server.log.WalStateManager;
import org.apache.accumulo.test.functional.WALSunnyDayIT;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManyWriteAheadLogsIT
extends AccumuloClusterHarness {
    private static final Logger log = LoggerFactory.getLogger(ManyWriteAheadLogsIT.class);

    @Override
    public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setProperty(Property.TSERV_WALOG_MAX_SIZE, "1M");
        cfg.setProperty(Property.GC_CYCLE_DELAY, "1");
        cfg.setProperty(Property.GC_CYCLE_START, "1");
        cfg.setProperty(Property.MASTER_RECOVERY_DELAY, "1s");
        cfg.setProperty(Property.TSERV_MAJC_DELAY, "1");
        cfg.setProperty(Property.INSTANCE_ZK_TIMEOUT, "15s");
        cfg.setProperty(Property.TABLE_MINC_COMPACT_IDLETIME, "1h");
        cfg.setNumTservers(1);
        hadoopCoreSite.set("fs.file.impl", RawLocalFileSystem.class.getName());
    }

    @Override
    protected int defaultTimeoutSeconds() {
        return 600;
    }

    @Test
    public void testMany() throws Exception {
        TreeSet<Text> splits = new TreeSet<Text>();
        for (int i = 1; i < 100; ++i) {
            splits.add(new Text(String.format("%05x", i * 100)));
        }
        Connector c = this.getConnector();
        String[] tableNames = this.getUniqueNames(2);
        String manyWALsTable = tableNames[0];
        String rollWALsTable = tableNames[1];
        c.tableOperations().create(manyWALsTable);
        c.tableOperations().addSplits(manyWALsTable, splits);
        c.tableOperations().create(rollWALsTable);
        Random rand = new Random();
        HashSet<String> allWalsSeen = new HashSet<String>();
        this.addOpenWals(c, allWalsSeen);
        try (BatchWriter manyWALsWriter = c.createBatchWriter(manyWALsTable, new BatchWriterConfig());
             BatchWriter rollWALsWriter = c.createBatchWriter(rollWALsTable, new BatchWriterConfig());){
            byte[] val = new byte[768];
            for (int i = 0; i < 100; ++i) {
                int j;
                int startRow = i * 100;
                for (j = 0; j < 10; ++j) {
                    int row = startRow + j;
                    Mutation m = new Mutation((CharSequence)String.format("%05x", row));
                    rand.nextBytes(val);
                    m.put((CharSequence)"f", (CharSequence)"q", (CharSequence)"v");
                    manyWALsWriter.addMutation(m);
                }
                manyWALsWriter.flush();
                for (j = 0; j < 1000; ++j) {
                    Mutation m = new Mutation((CharSequence)String.format("%03d", j));
                    rand.nextBytes(val);
                    m.put((CharSequence)"f", (CharSequence)"q", (CharSequence)Base64.getEncoder().encodeToString(val));
                    rollWALsWriter.addMutation(m);
                }
                rollWALsWriter.flush();
                this.addOpenWals(c, allWalsSeen);
            }
        }
        Assert.assertTrue((String)("Number of WALs seen was less than expected " + allWalsSeen.size()), (allWalsSeen.size() >= 50 ? 1 : 0) != 0);
        int closedLogs = this.countClosedWals(c);
        while (closedLogs > 3) {
            log.debug("Waiting for wals to shrink " + closedLogs);
            Thread.sleep(250L);
            closedLogs = this.countClosedWals(c);
        }
    }

    private void addOpenWals(Connector c, Set<String> allWalsSeen) throws Exception {
        Map<String, WalStateManager.WalState> wals = WALSunnyDayIT._getWals(c);
        Set<Map.Entry<String, WalStateManager.WalState>> es = wals.entrySet();
        int open = 0;
        for (Map.Entry<String, WalStateManager.WalState> entry : es) {
            if (entry.getValue() != WalStateManager.WalState.OPEN) continue;
            ++open;
            allWalsSeen.add(entry.getKey());
        }
        Assert.assertTrue((String)("Open WALs not in expected range " + open), (open > 0 && open < 4 ? 1 : 0) != 0);
    }

    private int countClosedWals(Connector c) throws Exception {
        int count = 0;
        Map<String, WalStateManager.WalState> wals = WALSunnyDayIT._getWals(c);
        for (WalStateManager.WalState ws : wals.values()) {
            if (ws != WalStateManager.WalState.CLOSED) continue;
            ++count;
        }
        return count;
    }
}

