/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.minicluster.impl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.junit.Assert;
import org.junit.Test;

public class MultiTableRecoveryIT
extends ConfigurableMacBase {
    @Override
    protected void configure(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setProperty(Property.INSTANCE_ZK_TIMEOUT, "15s");
        hadoopCoreSite.set("fs.file.impl", RawLocalFileSystem.class.getName());
    }

    @Override
    protected int defaultTimeoutSeconds() {
        return 240;
    }

    @Test
    public void testRecoveryOverMultipleTables() throws Exception {
        int N = 3;
        Connector c = this.getConnector();
        String[] tables = this.getUniqueNames(3);
        BatchWriter[] writers = new BatchWriter[3];
        byte[][] values = new byte[3][];
        int i = 0;
        System.out.println("Creating tables");
        for (String tableName : tables) {
            c.tableOperations().create(tableName);
            values[i] = Integer.toString(i).getBytes();
            writers[i] = c.createBatchWriter(tableName, null);
            ++i;
        }
        System.out.println("Creating agitator");
        AtomicBoolean stop = new AtomicBoolean(false);
        Thread agitator = this.agitator(stop);
        agitator.start();
        System.out.println("writing");
        Random random = new Random();
        for (i = 0; i < 1000000; ++i) {
            long randomRow = random.nextLong() & Long.MAX_VALUE;
            Assert.assertTrue((randomRow >= 0L ? 1 : 0) != 0);
            int table = (int)(randomRow % 3L);
            Mutation m = new Mutation((CharSequence)Long.toHexString(randomRow));
            m.put(new byte[0], new byte[0], values[table]);
            writers[table].addMutation(m);
            if (i % 10000 != 0) continue;
            System.out.println("flushing");
            for (int w = 0; w < 3; ++w) {
                writers[w].flush();
            }
        }
        System.out.println("closing");
        for (int w = 0; w < 3; ++w) {
            writers[w].close();
        }
        System.out.println("stopping the agitator");
        stop.set(true);
        agitator.join();
        System.out.println("checking the data");
        long count = 0L;
        for (int w = 0; w < 3; ++w) {
            Scanner scanner = c.createScanner(tables[w], Authorizations.EMPTY);
            for (Map.Entry entry : scanner) {
                int value = Integer.parseInt(((Value)entry.getValue()).toString());
                Assert.assertEquals((long)w, (long)value);
                ++count;
            }
            scanner.close();
        }
        Assert.assertEquals((long)1000000L, (long)count);
    }

    private Thread agitator(final AtomicBoolean stop) {
        return new Thread(){

            @Override
            public void run() {
                try {
                    int i = 0;
                    while (!stop.get()) {
                        UtilWaitThread.sleepUninterruptibly((long)10L, (TimeUnit)TimeUnit.SECONDS);
                        System.out.println("Restarting");
                        MultiTableRecoveryIT.this.getCluster().getClusterControl().stop(ServerType.TABLET_SERVER);
                        MultiTableRecoveryIT.this.getCluster().start();
                        Iterators.size((Iterator)MultiTableRecoveryIT.this.getConnector().createScanner("accumulo.metadata", Authorizations.EMPTY).iterator());
                        ++i;
                    }
                    System.out.println("Restarted " + i + " times");
                }
                catch (Exception ex) {
                    ConfigurableMacBase.log.error("{}", (Object)ex.getMessage(), (Object)ex);
                }
            }
        };
    }
}

