/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.impl;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.SampleNotPresentException;
import org.apache.accumulo.core.client.TableDeletedException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.TableOfflineException;
import org.apache.accumulo.core.client.impl.ClientContext;
import org.apache.accumulo.core.client.impl.IsolationException;
import org.apache.accumulo.core.client.impl.ScannerOptions;
import org.apache.accumulo.core.client.impl.ThriftScanner;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.KeyValue;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.util.NamingThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScannerIterator
implements Iterator<Map.Entry<Key, Value>> {
    private static final Logger log = LoggerFactory.getLogger(ScannerIterator.class);
    private int timeOut;
    private Iterator<KeyValue> iter;
    private ThriftScanner.ScanState scanState;
    private ScannerOptions options;
    private ArrayBlockingQueue<Object> synchQ;
    private boolean finished = false;
    private boolean readaheadInProgress = false;
    private long batchCount = 0L;
    private long readaheadThreshold;
    private static final List<KeyValue> EMPTY_LIST = Collections.emptyList();
    private static ThreadPoolExecutor readaheadPool = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 3L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new NamingThreadFactory("Accumulo scanner read ahead thread"));

    ScannerIterator(ClientContext context, String tableId, Authorizations authorizations, Range range, int size, int timeOut, ScannerOptions options, boolean isolated, long readaheadThreshold) {
        this.timeOut = timeOut;
        this.readaheadThreshold = readaheadThreshold;
        this.options = new ScannerOptions(options);
        this.synchQ = new ArrayBlockingQueue(1);
        if (this.options.fetchedColumns.size() > 0) {
            range = range.bound(this.options.fetchedColumns.first(), this.options.fetchedColumns.last());
        }
        this.scanState = new ThriftScanner.ScanState(context, tableId, authorizations, new Range(range), options.fetchedColumns, size, options.serverSideIteratorList, options.serverSideIteratorOptions, isolated, readaheadThreshold, options.getSamplerConfiguration(), options.batchTimeout, options.classLoaderContext);
        if (0L == readaheadThreshold) {
            this.initiateReadAhead();
        }
        this.iter = null;
    }

    private void initiateReadAhead() {
        this.readaheadInProgress = true;
        readaheadPool.execute(new Reader());
    }

    @Override
    public boolean hasNext() {
        if (this.finished) {
            return false;
        }
        if (this.iter != null && this.iter.hasNext()) {
            return true;
        }
        try {
            Object obj;
            if (!this.readaheadInProgress) {
                new Reader().run();
            }
            if ((obj = this.synchQ.take()) instanceof Exception) {
                this.finished = true;
                if (obj instanceof RuntimeException) {
                    throw (RuntimeException)obj;
                }
                throw new RuntimeException((Exception)obj);
            }
            List currentBatch = (List)obj;
            if (currentBatch.size() == 0) {
                currentBatch = null;
                this.finished = true;
                return false;
            }
            this.iter = currentBatch.iterator();
            ++this.batchCount;
            if (this.batchCount > this.readaheadThreshold) {
                this.initiateReadAhead();
            }
        }
        catch (InterruptedException e1) {
            throw new RuntimeException(e1);
        }
        return true;
    }

    @Override
    public Map.Entry<Key, Value> next() {
        if (this.hasNext()) {
            return this.iter.next();
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove is not supported in Scanner");
    }

    private class Reader
    implements Runnable {
        private Reader() {
        }

        @Override
        public void run() {
            try {
                List<KeyValue> currentBatch;
                do {
                    if ((currentBatch = ThriftScanner.scan(((ScannerIterator)ScannerIterator.this).scanState.context, ScannerIterator.this.scanState, ScannerIterator.this.timeOut)) != null) continue;
                    ScannerIterator.this.synchQ.add(EMPTY_LIST);
                    return;
                } while (currentBatch.size() == 0);
                ScannerIterator.this.synchQ.add(currentBatch);
                return;
            }
            catch (AccumuloException | AccumuloSecurityException | SampleNotPresentException | TableDeletedException | TableOfflineException | IsolationException | ThriftScanner.ScanTimedOutException e) {
                log.trace("{}", (Object)e.getMessage(), (Object)e);
                ScannerIterator.this.synchQ.add(e);
            }
            catch (TableNotFoundException e) {
                log.warn("{}", (Object)e.getMessage(), (Object)e);
                ScannerIterator.this.synchQ.add(e);
            }
            catch (Exception e) {
                log.error("{}", (Object)e.getMessage(), (Object)e);
                ScannerIterator.this.synchQ.add(e);
            }
        }
    }
}

