/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.shell;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class Token {
    private Set<String> command = new HashSet<String>();
    private Set<Token> subcommands = new HashSet<Token>();
    private boolean caseSensitive = false;

    public Token() {
    }

    public Token(String commandName) {
        this();
        this.command.add(commandName);
    }

    public Token(Collection<String> commandNames) {
        this();
        this.command.addAll(commandNames);
    }

    public void setCaseSensitive(boolean cs) {
        this.caseSensitive = cs;
    }

    public boolean getCaseSensitive() {
        return this.caseSensitive;
    }

    public Set<String> getCommandNames() {
        return this.command;
    }

    public Set<Token> getSubcommandList() {
        return this.subcommands;
    }

    public Token getSubcommand(String name) {
        for (Token t : this.subcommands) {
            if (!t.containsCommand(name)) continue;
            return t;
        }
        return null;
    }

    public Set<String> getSubcommandNames() {
        HashSet<String> set = new HashSet<String>();
        for (Token t : this.subcommands) {
            set.addAll(t.getCommandNames());
        }
        return set;
    }

    public Set<String> getSubcommandNames(String startsWith) {
        Iterator<Token> iter = this.subcommands.iterator();
        HashSet<String> set = new HashSet<String>();
        while (iter.hasNext()) {
            Token t = iter.next();
            Set<String> subset = t.getCommandNames();
            for (String s : subset) {
                if (!t.getCaseSensitive()) {
                    if (!s.toLowerCase().startsWith(startsWith.toLowerCase())) continue;
                    set.add(s);
                    continue;
                }
                if (!s.startsWith(startsWith)) continue;
                set.add(s);
            }
        }
        return set;
    }

    public boolean containsCommand(String match) {
        for (String t : this.command) {
            if (!(this.caseSensitive ? t.equals(match) : t.equalsIgnoreCase(match))) continue;
            return true;
        }
        return false;
    }

    public void addSubcommand(Token t) {
        this.subcommands.add(t);
    }

    public void addSubcommand(Collection<String> t) {
        for (String a : t) {
            this.addSubcommand(new Token(a));
        }
    }

    public String toString() {
        return this.command.toString();
    }
}

