/******************************************************************
 * dirname - extract the directory name from a path     
 *
 * Author:  Oliver Brunner
 * License: Public Domain (do what you want)
 *
 * This is an AROS version of the UNIX dirname command,
 * which was written from scratch and works with
 * the AROS directory tree syntax.
 *
 * Examples:
 *
 *   1> dirname c/list
 *   c
 *
 *   1> dirname sys:c/list
 *   sys:c
 *
 *   1> dirname sys:
 *   sys:
 *
 *   1> dirname list
 *   "" 
 *
 ****************************************************************/

#include <string.h>
#include <stdio.h>

int main(int argc, char **argv) {
  char *p;

  if (argc < 2) {
        fprintf(stderr, "Usage: %s path\n", argv[0]);
        return(1);
  }

  if((p=rindex(argv[1], '/'))) {
    /* strip last '/' with following chars, if there is any / */
    p[0]=(char) 0;
  }
  else if ((p=rindex(argv[1], ':'))) {
    /* we have no '/' but a ':' */
    if(p[1] != (char) 0) {
      /* strip all parts after ':', if there are any */
      p[1]=(char) 0;
    }
  }
  else {
    /* neither ':' nor '/', simply return '""' */
    puts("\"\"");
    return(0);

  }

  puts(argv[1]);

  return(0);

}
