#include <string.h>
#include <stdlib.h>
#include <stdio.h>

int main(int argc, char **argv) {
  char  *c;
  char  *r;             /* result */
  int    suffix_index;  /* potential suffix start */
  
  if ((argc < 2) || (argc > 3)) {
    fprintf(stderr, "Usage: %s string [suffix]\n", argv[0]);
    return(1);
  }

  r=argv[1];

  /* maybe we have a ':' */
  if((c=rindex(r,':'))) {
    /* skip to char after ':' */
    r=c+1;
  }

  if((c=rindex(r,'/'))) {
    /* skip to char after '/' */
    r=c+1;
  }

  /* If we have a suffix, remove it.
   * If suffix is exactly the same as the basename so far,
   * return the basename, *not* ""
   * At least the Linux basename binary does this.
   */
  if (argc == 3) {
    suffix_index=strlen(r)-strlen(argv[2]);

    if(suffix_index>0) {
      /* AROS filenames are not case sensitive, so suffixes are neither */
      if (!stricmp(r+suffix_index, argv[2])) {
        /* strip off suffix */
        r[suffix_index]=(char) 0;
      }
    }
  }

  if(r[0]==(char) 0) {
    /* we stripped off everything, so just return "" */
    puts("\"\"");
    return(0);
  }

  puts(r);
  return(0);
}
