/*
	env.c, environmental variable handling for `read'.
	Copyright (c) 2004 Kalle Risnen.


	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef AROS
#	include <stdlib.h>
#endif

#include <string.h>
#include "read.h"

char *get_env(char *name)
{
#ifdef AROS
	char c, *buff;

	if(GetVar(name, &c, 1, GVF_BINARY_VAR) == 0)
		{
		LONG len = IoErr();
		buff = xmalloc(len + 1);
		
		GetVar(name, buff, len + 1, GVF_BINARY_VAR);

		return buff;
		}
#else
	if(getenv(name) != NULL)
		return getenv(name);
#endif
	else
		return NULL;
}

void set_env(char *name, char *value)
{
#ifdef AROS
	if(!SetVar(name, value, strlen(value), GVF_GLOBAL_ONLY | GVF_BINARY_VAR))
		error("SetVar(`%s', `%s', %d) failed!", name, value, strlen(value));
#else
	if(setenv(name, value, 1) != 0)
		error("setenv(`%s', `%s', 1) failed!", name, value);
#endif
}
