/*  AROS-Fortune v 0.4.2
    Copyright (c) 2002 - 2004 Kalle Risnen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>

#include "putreq.h"
 
#define getrandom(x) ((int)((double)rand() / ((double)RAND_MAX + 1) * x))

#define MCHAR        512
#define MAXLENTH   65536
#define MAXFILES     256
#define DELIMITER  "%\n"

#define DEFAULT_FILE "s:afortunes.txt"
#define INI_FILE     "s:.afortune"

#define HELPTEXT \
   "AROS-Fortune 0.4.2 Copyright (c) 2002 - 2004 Kalle Risnen.\n\n"\
   "Syntax: afortune [-t | --text] [fortfile | --help | -h]\n\n"\
   "\tfortfile    Fortune-file to collect fortunes from.\n"\
   "\t-t, --text  Text output (as opposed to GUI output).\n"\
   "\t-h, --help  Outputs this message.\n\n"\
   "By default, AROS-Fortune looks for a configuration file named '.afortune'\n"\
   "in the 's:' directory, which lists the fortune files to use.\n"\
   "If '.afortune' isn't found, AROS-Fortune looks for 's:afortunes.txt'.\n"\
	"\t`-h' and `-t' can be concatenated.\n\n"\
	"Report any bugs to <bugs@aros-stuff.tk>.\n"

char text[MAXLENTH], files = 0;

struct fstruct 
   { char namn[MCHAR]; } 
fort_files[MAXFILES];

int getfiles(char *filename)
{
   FILE *file;
   int i = 0;
   char s[MCHAR];
   
   if(!(file = fopen(filename, "r")))
      return 0;
   while(fgets(s, MCHAR, file) && i < MAXFILES)
      {
      if(s[0] != '#' && (strlen(s) > 1))
         {
         s[strlen(s)-1] = 0;
         strcpy(fort_files[i++].namn, s);
         }
      }
   fclose(file);
   if(files = i)
      return 1;
   return 0;   
}

/* count fortunes in a text-file */
int getprocs(FILE *fp)
{
   char c[MCHAR];
   int procs = 0;
   while(fgets(c, MCHAR, fp))
      if(!strcmp(c, DELIMITER)) procs++;
   rewind(fp);

   return procs-1;
}

/* get 'random' fortune */
void getfortune(FILE *file, int procent)
{
   char buffer[MCHAR];
   int procs = 0, quote_num;

   quote_num = getrandom(procent);
   text[0] = 0;

   while((fgets(buffer, MCHAR, file)) && (procs <= quote_num) && strlen(text) < MAXLENTH)
      {
      if(!strcmp(buffer, DELIMITER))
         procs++;
      if(procs == quote_num && strcmp(buffer, DELIMITER))
         {
         strcat(text, buffer);
         text[strlen(text)-1] = 0;
         strcat(text, "\n");
         }
      }
   text[strlen(text)] = 0;
}


/* open file, get fortune-count, get fortune, close file */
int file_open(char *file)
{
   FILE *myfile;
   int procent;

   if(myfile = fopen(file, "r"))
      {
      procent = getprocs(myfile);
      if(!procent) return 0;
      getfortune(myfile, procent);
      fclose(myfile);
      return 1;
      }
   else return 0;
}

void c_replace(char *s, unsigned char c)
{
   int i = 0;
   
   for(;i < strlen(s);i++)
      if(s[i] == c) s[i] = ' ';
}

int main(int argc, char **argv)
{
   int randomnum, i;
   char *filename = NULL, t = 0;
   
   srand((unsigned int)time((time_t *)NULL));

	text[0] = '\0';

   for(i = 1; i < argc; i++)
      {
      if(!strcmp(argv[i], "--help"))
         strcpy(text, HELPTEXT);
      else if(!strcmp(argv[i], "--text"))
         t++;
		else if(argv[i][0] == '-')
			{
			int j;
			for(j = 1; j < strlen(argv[i]); j++)
				{
				switch(argv[i][j])
					{
					case 'h': strcpy(text, HELPTEXT); break;
					case 't': t++;                    break;
					default: 
						sprintf(text, "%s: unknown option '%c'!\n", argv[0], argv[i][j]);
					}
				}
			}
      else if(filename)
         sprintf(text, "%s: unknown option %s!\n", argv[0], argv[i]);
      else
         filename = argv[i];
      } 

	if(!text[0])
		{
	   if(filename)
   	   {if(!file_open(argv[1])) sprintf(text, "%s isn't a fortune file!\n", argv[1]);}
   	else if(getfiles(INI_FILE))
      	{
      	randomnum = getrandom(files);
      	if(!file_open(fort_files[randomnum].namn))
         	sprintf(text, "%s isn't a fortune file!\n", fort_files[randomnum].namn);
      	}
   	else if(!file_open(DEFAULT_FILE))
      	sprintf(text, "Syntax: %s fortune-file", argv[0]);
		}

   c_replace(text, '\t');

   if(t)
      printf("%s", text);
   else if(!putreq("AROS-Fortune", text, "Ok"))
		{
		fprintf(stderr, "%s: Error opening requester.\n", argv[0]);
		return 10;
		}
   return 0;
}

