/* Prototypes for functions defined in
text.c
 */

int text(register char * p);

int bold(register char * p0,
         register char * p1,
         int size);

int center(register char * p);

int expand(register char * p0,
           int c,
           register char * s);

int justcntr(register char * p,
             char * q,
             int * limit);

int justleft(register char * p,
             char * q,
             int limit);

int justrite(register char * p,
             char * q,
             int limit);

int leadbl(register char * p);

int pfoot(void);

int phead(void);

int puttl(register char * p,
          int * lim,
          int pgno);

int putwrd(register char * wrdbuf);

int skip(register int n);

int spread(register char * p,
           int outp,
           int nextra,
           int outwds,
           int escapes);

int strkovr(register char * p,
            register char * q);

int underl(register char * p0,
           register char * p1,
           int size);

int width(register char * s);

int do_mc(char * p);

/* Prototypes for functions defined in
strings.c
 */

int defstr(register char * p);

int colstr(register char * p,
           char * d);

int putstr(register char * name,
           register char * p);

char * getstr(register char * name);

/* Prototypes for functions defined in
main.c
 */

extern struct docctl dc;

extern struct page pg;

extern struct cout co;

extern struct macros mac;

extern struct regs rg[100];

extern FILE * out_stream;

extern FILE * err_stream;

extern FILE * dbg_stream;

extern FILE * sofile[5];

extern int ignoring;

extern int hold_screen;

extern int debugging;

extern int stepping;

extern int mc_ing;

extern int mc_space;

extern char mc_char;

extern char tmpdir[256];

extern char termcap[1030];

extern char s_standout[20];

extern char e_standout[20];

extern char s_bold[20];

extern char e_bold[20];

extern char s_italic[20];

extern char e_italic[20];

extern char * dbgfile;

extern char * printer;

extern char * myname;

extern int patchlevel;

extern char VERsion[6];

extern char * version;

extern long __stack;

int main(int argc,
         char ** argv);

int usage(void);

int init(void);

int pswitch(register char * p,
            register int * q);

int profile(void);

/* Prototypes for functions defined in
macros.c
 */

int defmac(register char * p,
           FILE * infp);

int colmac(register char * p,
           char * d,
           register int i);

int putmac(char * name,
           char * p);

char * getmac(register char * name);

int maceval(register char * p,
            char * m);

int printmac(int opt);

/* Prototypes for functions defined in
low.c
 */

int atod(int c);

int robrk(void);

int ctod(register char * p);

int inptobu(char * ps);

int butochar(char * ps);

char * skipbl(register char * p);

char * skipwd(register char * p);

int space(int n);

char * getfield(register char * p,
                register char * q,
                int delim);

int getwrd(register char * p0,
           register char * p1);

int countesc(register char * p);

int itoda(int value,
          register char * p,
          register int size);

int itoROMAN(int value,
             register char * p,
             register int size);

int itoroman(int value,
             char * p,
             int size);

int itoLETTER(int value,
              register char * p,
              register int size);

int itoletter(int value,
              register char * p,
              register int size);

int min(register int v1,
        register int v2);

int max(register int v1,
        register int v2);

int err_exit(int code);

int wait_for_char(void);

/* Prototypes for functions defined in
io.c
 */

int getlin(char * p,
           FILE * in_buf);

int ngetc(FILE * infp);

int pbstr(char * p);

int putbak(int c);

int prchar(int c,
           FILE * fp);

int put(char * p);

int putlin(register char * p,
           FILE * pbuf);

int putc_lpr(int c,
             FILE * fp);

/* Prototypes for functions defined in
escape.c
 */

int expesc(char * p,
           char * q);

int specialchar(register char * s,
                register unsigned char * c);

int fontchange(int fnt,
               char * s);

int findreg(register char * name);

/* Prototypes for functions defined in
command.c
 */

int comand(register char * p);

int comtyp(register char * p,
           char * m);

int gettl(register char * p,
          register char * q,
          int * limit);

int getval(register char * p,
           register char * p_argtyp);

int getnumeric(register char * p);

int do_oper(int first,
            int oper,
            int second);

int set(register int * param,
        register int val,
        register int type,
        register int defval,
        register int minval,
        register int maxval);

int set_ireg(register char * name,
             register int val,
             register int opt);

int read_if(void);

