" Vim support file to define the syntax selection menu
" This file is normally sourced from menu.vim.
"
" Maintainer:	Bram Moolenaar <Bram@vim.org>
" Last Change:	2006 Apr 27

" Define the SetSyn function, used for the Syntax menu entries.
" Set 'filetype' and also 'syntax' if it is manually selected.
fun! SetSyn(name)
  if a:name == "fvwm1"
    let use_fvwm_1 = 1
    let use_fvwm_2 = 0
    let name = "fvwm"
  elseif a:name == "fvwm2"
    let use_fvwm_2 = 1
    let use_fvwm_1 = 0
    let name = "fvwm"
  else
    let name = a:name
  endif
  if !exists("s:syntax_menu_synonly")
    exe "set ft=" . name
    if exists("g:syntax_manual")
      exe "set syn=" . name
    endif
  else
    exe "set syn=" . name
  endif
endfun

" <> notation is used here, remove '<' from 'cpoptions'
let s:cpo_save = &cpo
set cpo&vim

" The following menu items are generated by makemenu.vim.
" The Start Of The Syntax Menu

an 50.10.90  &Syntax.-SEP4-                <Nop>
an 50.10.100 &Syntax.A2ps\ config :cal SetSyn("a2ps")<CR>
an 50.10.110 &Syntax.Aap :cal SetSyn("aap")<CR>
an 50.10.120 &Syntax.ABAP/4 :cal SetSyn("abap")<CR>
an 50.10.130 &Syntax.Abaqus :cal SetSyn("abaqus")<CR>
an 50.10.140 &Syntax.ABC\ music\ notation :cal SetSyn("abc")<CR>
an 50.10.150 &Syntax.ABEL :cal SetSyn("abel")<CR>
an 50.10.160 &Syntax.AceDB\ model :cal SetSyn("acedb")<CR>
an 50.10.170 &Syntax.Ada :cal SetSyn("ada")<CR>
an 50.10.180 &Syntax.AfLex :cal SetSyn("aflex")<CR>
an 50.10.190 &Syntax.ALSA\ config :cal SetSyn("alsaconf")<CR>
an 50.10.200 &Syntax.Altera\ AHDL :cal SetSyn("ahdl")<CR>
an 50.10.210 &Syntax.Amiga\ DOS :cal SetSyn("amiga")<CR>
an 50.10.220 &Syntax.AMPL :cal SetSyn("ampl")<CR>
an 50.10.230 &Syntax.Ant\ build\ file :cal SetSyn("ant")<CR>
an 50.10.240 &Syntax.ANTLR :cal SetSyn("antlr")<CR>
an 50.10.250 &Syntax.Apache\ config :cal SetSyn("apache")<CR>
an 50.10.260 &Syntax.Apache-style\ config :cal SetSyn("apachestyle")<CR>
an 50.10.270 &Syntax.Applix\ ELF :cal SetSyn("elf")<CR>
an 50.10.280 &Syntax.Arc\ Macro\ Language :cal SetSyn("aml")<CR>
an 50.10.290 &Syntax.Arch\ inventory :cal SetSyn("arch")<CR>
an 50.10.300 &Syntax.ART :cal SetSyn("art")<CR>
an 50.10.310 &Syntax.ASP\ with\ VBScript :cal SetSyn("aspvbs")<CR>
an 50.10.320 &Syntax.ASP\ with\ Perl :cal SetSyn("aspperl")<CR>
an 50.10.330 &Syntax.Assembly.680x0 :cal SetSyn("asm68k")<CR>
an 50.10.340 &Syntax.Assembly.Flat :cal SetSyn("fasm")<CR>
an 50.10.350 &Syntax.Assembly.GNU :cal SetSyn("asm")<CR>
an 50.10.360 &Syntax.Assembly.GNU\ H-8300 :cal SetSyn("asmh8300")<CR>
an 50.10.370 &Syntax.Assembly.Intel\ IA-64 :cal SetSyn("ia64")<CR>
an 50.10.380 &Syntax.Assembly.Microsoft :cal SetSyn("masm")<CR>
an 50.10.390 &Syntax.Assembly.Netwide :cal SetSyn("nasm")<CR>
an 50.10.400 &Syntax.Assembly.PIC :cal SetSyn("pic")<CR>
an 50.10.410 &Syntax.Assembly.Turbo :cal SetSyn("tasm")<CR>
an 50.10.420 &Syntax.Assembly.VAX\ Macro\ Assembly :cal SetSyn("vmasm")<CR>
an 50.10.430 &Syntax.Assembly.Z-80 :cal SetSyn("z8a")<CR>
an 50.10.440 &Syntax.Assembly.xa\ 6502\ cross\ assember :cal SetSyn("a65")<CR>
an 50.10.450 &Syntax.ASN\.1 :cal SetSyn("asn")<CR>
an 50.10.460 &Syntax.Asterisk\ config :cal SetSyn("asterisk")<CR>
an 50.10.470 &Syntax.Asterisk\ voicemail\ config :cal SetSyn("asteriskvm")<CR>
an 50.10.480 &Syntax.Atlas :cal SetSyn("atlas")<CR>
an 50.10.490 &Syntax.AutoHotKey :cal SetSyn("autohotkey")<CR>
an 50.10.500 &Syntax.AutoIt :cal SetSyn("autoit")<CR>
an 50.10.510 &Syntax.Automake :cal SetSyn("automake")<CR>
an 50.10.520 &Syntax.Avenue :cal SetSyn("ave")<CR>
an 50.10.530 &Syntax.Awk :cal SetSyn("awk")<CR>
an 50.10.540 &Syntax.AYacc :cal SetSyn("ayacc")<CR>
an 50.10.570 &Syntax.Baan :cal SetSyn("baan")<CR>
an 50.10.580 &Syntax.Basic.FreeBasic :cal SetSyn("freebasic")<CR>
an 50.10.590 &Syntax.Basic.IBasic :cal SetSyn("ibasic")<CR>
an 50.10.600 &Syntax.Basic.QBasic :cal SetSyn("basic")<CR>
an 50.10.610 &Syntax.Basic.Visual\ Basic :cal SetSyn("vb")<CR>
an 50.10.620 &Syntax.Bazaar\ commit\ file :cal SetSyn("bzr")<CR>
an 50.10.630 &Syntax.BC\ calculator :cal SetSyn("bc")<CR>
an 50.10.640 &Syntax.BDF\ font :cal SetSyn("bdf")<CR>
an 50.10.650 &Syntax.BibTeX.Bibliography\ database :cal SetSyn("bib")<CR>
an 50.10.660 &Syntax.BibTeX.Bibliography\ Style :cal SetSyn("bst")<CR>
an 50.10.670 &Syntax.BIND.BIND\ config :cal SetSyn("named")<CR>
an 50.10.680 &Syntax.BIND.BIND\ zone :cal SetSyn("bindzone")<CR>
an 50.10.690 &Syntax.Blank :cal SetSyn("blank")<CR>
an 50.20.100 &Syntax.C :cal SetSyn("c")<CR>
an 50.20.110 &Syntax.C++ :cal SetSyn("cpp")<CR>
an 50.20.120 &Syntax.C# :cal SetSyn("cs")<CR>
an 50.20.130 &Syntax.Calendar :cal SetSyn("calendar")<CR>
an 50.20.140 &Syntax.Cascading\ Style\ Sheets :cal SetSyn("css")<CR>
an 50.20.150 &Syntax.CDL :cal SetSyn("cdl")<CR>
an 50.20.160 &Syntax.Cdrdao\ TOC :cal SetSyn("cdrtoc")<CR>
an 50.20.170 &Syntax.Cdrdao\ config :cal SetSyn("cdrdaoconf")<CR>
an 50.20.180 &Syntax.Century\ Term :cal SetSyn("cterm")<CR>
an 50.20.190 &Syntax.CH\ script :cal SetSyn("ch")<CR>
an 50.20.200 &Syntax.ChangeLog :cal SetSyn("changelog")<CR>
an 50.20.210 &Syntax.Cheetah\ template :cal SetSyn("cheetah")<CR>
an 50.20.220 &Syntax.CHILL :cal SetSyn("chill")<CR>
an 50.20.230 &Syntax.ChordPro :cal SetSyn("chordpro")<CR>
an 50.20.240 &Syntax.Clean :cal SetSyn("clean")<CR>
an 50.20.250 &Syntax.Clever :cal SetSyn("cl")<CR>
an 50.20.260 &Syntax.Clipper :cal SetSyn("clipper")<CR>
an 50.20.270 &Syntax.Cmake :cal SetSyn("cmake")<CR>
an 50.20.280 &Syntax.Cmusrc :cal SetSyn("cmusrc")<CR>
an 50.20.290 &Syntax.Cobol :cal SetSyn("cobol")<CR>
an 50.20.300 &Syntax.Coco/R :cal SetSyn("coco")<CR>
an 50.20.310 &Syntax.Cold\ Fusion :cal SetSyn("cf")<CR>
an 50.20.320 &Syntax.Conary\ Recipe :cal SetSyn("conaryrecipe")<CR>
an 50.20.330 &Syntax.Config.Cfg\ Config\ file :cal SetSyn("cfg")<CR>
an 50.20.340 &Syntax.Config.Configure\.in :cal SetSyn("config")<CR>
an 50.20.350 &Syntax.Config.Generic\ Config\ file :cal SetSyn("conf")<CR>
an 50.20.360 &Syntax.CRM114 :cal SetSyn("crm")<CR>
an 50.20.370 &Syntax.Crontab :cal SetSyn("crontab")<CR>
an 50.20.380 &Syntax.CSP :cal SetSyn("csp")<CR>
an 50.20.390 &Syntax.Ctrl-H :cal SetSyn("ctrlh")<CR>
an 50.20.400 &Syntax.CUDA :cal SetSyn("cuda")<CR>
an 50.20.410 &Syntax.CUPL.CUPL :cal SetSyn("cupl")<CR>
an 50.20.420 &Syntax.CUPL.Simulation :cal SetSyn("cuplsim")<CR>
an 50.20.430 &Syntax.CVS.commit\ file :cal SetSyn("cvs")<CR>
an 50.20.440 &Syntax.CVS.cvsrc :cal SetSyn("cvsrc")<CR>
an 50.20.450 &Syntax.Cyn++ :cal SetSyn("cynpp")<CR>
an 50.20.460 &Syntax.Cynlib :cal SetSyn("cynlib")<CR>
an 50.30.100 &Syntax.D :cal SetSyn("d")<CR>
an 50.30.110 &Syntax.Debian.Debian\ ChangeLog :cal SetSyn("debchangelog")<CR>
an 50.30.120 &Syntax.Debian.Debian\ Control :cal SetSyn("debcontrol")<CR>
an 50.30.130 &Syntax.Debian.Debian\ Sources\.list :cal SetSyn("debsources")<CR>
an 50.30.140 &Syntax.Denyhosts :cal SetSyn("denyhosts")<CR>
an 50.30.150 &Syntax.Desktop :cal SetSyn("desktop")<CR>
an 50.30.160 &Syntax.Dict\ config :cal SetSyn("dictconf")<CR>
an 50.30.170 &Syntax.Dictd\ config :cal SetSyn("dictdconf")<CR>
an 50.30.180 &Syntax.Diff :cal SetSyn("diff")<CR>
an 50.30.190 &Syntax.Digital\ Command\ Lang :cal SetSyn("dcl")<CR>
an 50.30.200 &Syntax.Dircolors :cal SetSyn("dircolors")<CR>
an 50.30.210 &Syntax.Django\ template :cal SetSyn("django")<CR>
an 50.30.220 &Syntax.DNS/BIND\ zone :cal SetSyn("bindzone")<CR>
an 50.30.230 &Syntax.DocBook.auto-detect :cal SetSyn("docbk")<CR>
an 50.30.240 &Syntax.DocBook.SGML :cal SetSyn("docbksgml")<CR>
an 50.30.250 &Syntax.DocBook.XML :cal SetSyn("docbkxml")<CR>
an 50.30.260 &Syntax.Dot :cal SetSyn("dot")<CR>
an 50.30.270 &Syntax.Doxygen.C\ with\ doxygen :cal SetSyn("c.doxygen")<CR>
an 50.30.280 &Syntax.Doxygen.C++\ with\ doxygen :cal SetSyn("cpp.doxygen")<CR>
an 50.30.290 &Syntax.Doxygen.IDL\ with\ doxygen :cal SetSyn("idl.doxygen")<CR>
an 50.30.300 &Syntax.Doxygen.Java\ with\ doxygen :cal SetSyn("java.doxygen")<CR>
an 50.30.310 &Syntax.Dracula :cal SetSyn("dracula")<CR>
an 50.30.320 &Syntax.DSSSL :cal SetSyn("dsl")<CR>
an 50.30.330 &Syntax.DTD :cal SetSyn("dtd")<CR>
an 50.30.340 &Syntax.DTML\ (Zope) :cal SetSyn("dtml")<CR>
an 50.30.350 &Syntax.DTrace :cal SetSyn("dtrace")<CR>
an 50.30.360 &Syntax.Dylan.Dylan :cal SetSyn("dylan")<CR>
an 50.30.370 &Syntax.Dylan.Dylan\ interface :cal SetSyn("dylanintr")<CR>
an 50.30.380 &Syntax.Dylan.Dylan\ lid :cal SetSyn("dylanlid")<CR>
an 50.30.400 &Syntax.EDIF :cal SetSyn("edif")<CR>
an 50.30.410 &Syntax.Eiffel :cal SetSyn("eiffel")<CR>
an 50.30.420 &Syntax.Elinks\ config :cal SetSyn("elinks")<CR>
an 50.30.430 &Syntax.Elm\ filter\ rules :cal SetSyn("elmfilt")<CR>
an 50.30.440 &Syntax.Embedix\ Component\ Description :cal SetSyn("ecd")<CR>
an 50.30.450 &Syntax.ERicsson\ LANGuage :cal SetSyn("erlang")<CR>
an 50.30.460 &Syntax.ESMTP\ rc :cal SetSyn("esmtprc")<CR>
an 50.30.470 &Syntax.ESQL-C :cal SetSyn("esqlc")<CR>
an 50.30.480 &Syntax.Essbase\ script :cal SetSyn("csc")<CR>
an 50.30.490 &Syntax.Esterel :cal SetSyn("esterel")<CR>
an 50.30.500 &Syntax.Eterm\ config :cal SetSyn("eterm")<CR>
an 50.30.510 &Syntax.Eviews :cal SetSyn("eviews")<CR>
an 50.30.520 &Syntax.Exim\ conf :cal SetSyn("exim")<CR>
an 50.30.530 &Syntax.Expect :cal SetSyn("expect")<CR>
an 50.30.540 &Syntax.Exports :cal SetSyn("exports")<CR>
an 50.40.100 &Syntax.Fetchmail :cal SetSyn("fetchmail")<CR>
an 50.40.110 &Syntax.FlexWiki :cal SetSyn("flexwiki")<CR>
an 50.40.120 &Syntax.Focus\ Executable :cal SetSyn("focexec")<CR>
an 50.40.130 &Syntax.Focus\ Master :cal SetSyn("master")<CR>
an 50.40.140 &Syntax.FORM :cal SetSyn("form")<CR>
an 50.40.150 &Syntax.Forth :cal SetSyn("forth")<CR>
an 50.40.160 &Syntax.Fortran :cal SetSyn("fortran")<CR>
an 50.40.170 &Syntax.FoxPro :cal SetSyn("foxpro")<CR>
an 50.40.180 &Syntax.FrameScript :cal SetSyn("framescript")<CR>
an 50.40.190 &Syntax.Fstab :cal SetSyn("fstab")<CR>
an 50.40.200 &Syntax.Fvwm.Fvwm\ configuration :cal SetSyn("fvwm1")<CR>
an 50.40.210 &Syntax.Fvwm.Fvwm2\ configuration :cal SetSyn("fvwm2")<CR>
an 50.40.220 &Syntax.Fvwm.Fvwm2\ configuration\ with\ M4 :cal SetSyn("fvwm2m4")<CR>
an 50.40.240 &Syntax.GDB\ command\ file :cal SetSyn("gdb")<CR>
an 50.40.250 &Syntax.GDMO :cal SetSyn("gdmo")<CR>
an 50.40.260 &Syntax.Gedcom :cal SetSyn("gedcom")<CR>
an 50.40.270 &Syntax.Git.Output :cal SetSyn("git")<CR>
an 50.40.280 &Syntax.Git.Commit :cal SetSyn("gitcommit")<CR>
an 50.40.290 &Syntax.Git.Config :cal SetSyn("gitconfig")<CR>
an 50.40.300 &Syntax.Git.Rebase :cal SetSyn("gitrebase")<CR>
an 50.40.310 &Syntax.Git.Send\ Email :cal SetSyn("gitsendemail")<CR>
an 50.40.320 &Syntax.Gkrellmrc :cal SetSyn("gkrellmrc")<CR>
an 50.40.330 &Syntax.GP :cal SetSyn("gp")<CR>
an 50.40.340 &Syntax.GPG :cal SetSyn("gpg")<CR>
an 50.40.350 &Syntax.Group\ file :cal SetSyn("group")<CR>
an 50.40.360 &Syntax.Grub :cal SetSyn("grub")<CR>
an 50.40.370 &Syntax.GNU\ Server\ Pages :cal SetSyn("gsp")<CR>
an 50.40.380 &Syntax.GNUplot :cal SetSyn("gnuplot")<CR>
an 50.40.390 &Syntax.GrADS\ scripts :cal SetSyn("grads")<CR>
an 50.40.400 &Syntax.Gretl :cal SetSyn("gretl")<CR>
an 50.40.410 &Syntax.Groff :cal SetSyn("groff")<CR>
an 50.40.420 &Syntax.Groovy :cal SetSyn("groovy")<CR>
an 50.40.430 &Syntax.GTKrc :cal SetSyn("gtkrc")<CR>
an 50.50.100 &Syntax.Haml :cal SetSyn("haml")<CR>
an 50.50.110 &Syntax.Hamster :cal SetSyn("hamster")<CR>
an 50.50.120 &Syntax.Haskell.Haskell :cal SetSyn("haskell")<CR>
an 50.50.130 &Syntax.Haskell.Haskell-c2hs :cal SetSyn("chaskell")<CR>
an 50.50.140 &Syntax.Haskell.Haskell-literate :cal SetSyn("lhaskell")<CR>
an 50.50.150 &Syntax.HASTE :cal SetSyn("haste")<CR>
an 50.50.160 &Syntax.HASTE\ preproc :cal SetSyn("hastepreproc")<CR>
an 50.50.170 &Syntax.Hercules :cal SetSyn("hercules")<CR>
an 50.50.180 &Syntax.Hex\ dump.XXD :cal SetSyn("xxd")<CR>
an 50.50.190 &Syntax.Hex\ dump.Intel\ MCS51 :cal SetSyn("hex")<CR>
an 50.50.200 &Syntax.HTML.HTML :cal SetSyn("html")<CR>
an 50.50.210 &Syntax.HTML.HTML\ with\ M4 :cal SetSyn("htmlm4")<CR>
an 50.50.220 &Syntax.HTML.HTML\ with\ Ruby\ (eRuby) :cal SetSyn("eruby")<CR>
an 50.50.230 &Syntax.HTML.Cheetah\ HTML\ template :cal SetSyn("htmlcheetah")<CR>
an 50.50.240 &Syntax.HTML.Django\ HTML\ template :cal SetSyn("htmldjango")<CR>
an 50.50.250 &Syntax.HTML.HTML/OS :cal SetSyn("htmlos")<CR>
an 50.50.260 &Syntax.HTML.XHTML :cal SetSyn("xhtml")<CR>
an 50.50.270 &Syntax.Host\.conf :cal SetSyn("hostconf")<CR>
an 50.50.280 &Syntax.Hyper\ Builder :cal SetSyn("hb")<CR>
an 50.50.300 &Syntax.Icewm\ menu :cal SetSyn("icemenu")<CR>
an 50.50.310 &Syntax.Icon :cal SetSyn("icon")<CR>
an 50.50.320 &Syntax.IDL\Generic\ IDL :cal SetSyn("idl")<CR>
an 50.50.330 &Syntax.IDL\Microsoft\ IDL :cal SetSyn("msidl")<CR>
an 50.50.340 &Syntax.Indent\ profile :cal SetSyn("indent")<CR>
an 50.50.350 &Syntax.Inform :cal SetSyn("inform")<CR>
an 50.50.360 &Syntax.Informix\ 4GL :cal SetSyn("fgl")<CR>
an 50.50.370 &Syntax.Initng :cal SetSyn("initng")<CR>
an 50.50.380 &Syntax.Inittab :cal SetSyn("inittab")<CR>
an 50.50.390 &Syntax.Inno\ setup :cal SetSyn("iss")<CR>
an 50.50.400 &Syntax.InstallShield\ script :cal SetSyn("ishd")<CR>
an 50.50.410 &Syntax.Interactive\ Data\ Lang :cal SetSyn("idlang")<CR>
an 50.50.420 &Syntax.IPfilter :cal SetSyn("ipfilter")<CR>
an 50.50.440 &Syntax.JAL :cal SetSyn("jal")<CR>
an 50.50.450 &Syntax.JAM :cal SetSyn("jam")<CR>
an 50.50.460 &Syntax.Jargon :cal SetSyn("jargon")<CR>
an 50.50.470 &Syntax.Java.Java :cal SetSyn("java")<CR>
an 50.50.480 &Syntax.Java.JavaCC :cal SetSyn("javacc")<CR>
an 50.50.490 &Syntax.Java.Java\ Server\ Pages :cal SetSyn("jsp")<CR>
an 50.50.500 &Syntax.Java.Java\ Properties :cal SetSyn("jproperties")<CR>
an 50.50.510 &Syntax.JavaScript :cal SetSyn("javascript")<CR>
an 50.50.520 &Syntax.Jess :cal SetSyn("jess")<CR>
an 50.50.530 &Syntax.Jgraph :cal SetSyn("jgraph")<CR>
an 50.50.550 &Syntax.Kconfig :cal SetSyn("kconfig")<CR>
an 50.50.560 &Syntax.KDE\ script :cal SetSyn("kscript")<CR>
an 50.50.570 &Syntax.Kimwitu++ :cal SetSyn("kwt")<CR>
an 50.50.580 &Syntax.KixTart :cal SetSyn("kix")<CR>
an 50.60.100 &Syntax.Lace :cal SetSyn("lace")<CR>
an 50.60.110 &Syntax.LamdaProlog :cal SetSyn("lprolog")<CR>
an 50.60.120 &Syntax.Latte :cal SetSyn("latte")<CR>
an 50.60.130 &Syntax.Ld\ script :cal SetSyn("ld")<CR>
an 50.60.140 &Syntax.LDAP.LDIF :cal SetSyn("ldif")<CR>
an 50.60.150 &Syntax.LDAP.Configuration :cal SetSyn("ldapconf")<CR>
an 50.60.160 &Syntax.Lex :cal SetSyn("lex")<CR>
an 50.60.170 &Syntax.LFTP\ config :cal SetSyn("lftp")<CR>
an 50.60.180 &Syntax.Libao :cal SetSyn("libao")<CR>
an 50.60.190 &Syntax.LifeLines\ script :cal SetSyn("lifelines")<CR>
an 50.60.200 &Syntax.Lilo :cal SetSyn("lilo")<CR>
an 50.60.210 &Syntax.Limits\ config :cal SetSyn("limits")<CR>
an 50.60.220 &Syntax.Linden\ scripting :cal SetSyn("lsl")<CR>
an 50.60.230 &Syntax.Lisp :cal SetSyn("lisp")<CR>
an 50.60.240 &Syntax.Lite :cal SetSyn("lite")<CR>
an 50.60.250 &Syntax.LiteStep\ RC :cal SetSyn("litestep")<CR>
an 50.60.260 &Syntax.Locale\ Input :cal SetSyn("fdcc")<CR>
an 50.60.270 &Syntax.Login\.access :cal SetSyn("loginaccess")<CR>
an 50.60.280 &Syntax.Login\.defs :cal SetSyn("logindefs")<CR>
an 50.60.290 &Syntax.Logtalk :cal SetSyn("logtalk")<CR>
an 50.60.300 &Syntax.LOTOS :cal SetSyn("lotos")<CR>
an 50.60.310 &Syntax.LotusScript :cal SetSyn("lscript")<CR>
an 50.60.320 &Syntax.Lout :cal SetSyn("lout")<CR>
an 50.60.330 &Syntax.LPC :cal SetSyn("lpc")<CR>
an 50.60.340 &Syntax.Lua :cal SetSyn("lua")<CR>
an 50.60.350 &Syntax.Lynx\ Style :cal SetSyn("lss")<CR>
an 50.60.360 &Syntax.Lynx\ config :cal SetSyn("lynx")<CR>
an 50.60.380 &Syntax.M4 :cal SetSyn("m4")<CR>
an 50.60.390 &Syntax.MaGic\ Point :cal SetSyn("mgp")<CR>
an 50.60.400 &Syntax.Mail :cal SetSyn("mail")<CR>
an 50.60.410 &Syntax.Mail\ aliases :cal SetSyn("mailaliases")<CR>
an 50.60.420 &Syntax.Mailcap :cal SetSyn("mailcap")<CR>
an 50.60.430 &Syntax.Makefile :cal SetSyn("make")<CR>
an 50.60.440 &Syntax.MakeIndex :cal SetSyn("ist")<CR>
an 50.60.450 &Syntax.Man\ page :cal SetSyn("man")<CR>
an 50.60.460 &Syntax.Man\.conf :cal SetSyn("manconf")<CR>
an 50.60.470 &Syntax.Maple\ V :cal SetSyn("maple")<CR>
an 50.60.480 &Syntax.Mason :cal SetSyn("mason")<CR>
an 50.60.490 &Syntax.Mathematica :cal SetSyn("mma")<CR>
an 50.60.500 &Syntax.Matlab :cal SetSyn("matlab")<CR>
an 50.60.510 &Syntax.Maxima :cal SetSyn("maxima")<CR>
an 50.70.100 &Syntax.MEL\ (for\ Maya) :cal SetSyn("mel")<CR>
an 50.70.110 &Syntax.Messages\ (/var/log) :cal SetSyn("messages")<CR>
an 50.70.120 &Syntax.Metafont :cal SetSyn("mf")<CR>
an 50.70.130 &Syntax.MetaPost :cal SetSyn("mp")<CR>
an 50.70.140 &Syntax.MGL :cal SetSyn("mgl")<CR>
an 50.70.150 &Syntax.MMIX :cal SetSyn("mmix")<CR>
an 50.70.160 &Syntax.Modconf :cal SetSyn("modconf")<CR>
an 50.70.170 &Syntax.Model :cal SetSyn("model")<CR>
an 50.70.180 &Syntax.Modsim\ III :cal SetSyn("modsim3")<CR>
an 50.70.190 &Syntax.Modula\ 2 :cal SetSyn("modula2")<CR>
an 50.70.200 &Syntax.Modula\ 3 :cal SetSyn("modula3")<CR>
an 50.70.210 &Syntax.Monk :cal SetSyn("monk")<CR>
an 50.70.220 &Syntax.Mplayer\ config :cal SetSyn("mplayerconf")<CR>
an 50.70.230 &Syntax.MOO :cal SetSyn("moo")<CR>
an 50.70.240 &Syntax.Mrxvtrc :cal SetSyn("mrxvtrc")<CR>
an 50.70.250 &Syntax.MS-DOS/Windows.4DOS\ \.bat\ file :cal SetSyn("btm")<CR>
an 50.70.260 &Syntax.MS-DOS/Windows.\.bat\/\.cmd\ file :cal SetSyn("dosbatch")<CR>
an 50.70.270 &Syntax.MS-DOS/Windows.\.ini\ file :cal SetSyn("dosini")<CR>
an 50.70.280 &Syntax.MS-DOS/Windows.Message\ text :cal SetSyn("msmessages")<CR>
an 50.70.290 &Syntax.MS-DOS/Windows.Module\ Definition :cal SetSyn("def")<CR>
an 50.70.300 &Syntax.MS-DOS/Windows.Registry :cal SetSyn("registry")<CR>
an 50.70.310 &Syntax.MS-DOS/Windows.Resource\ file :cal SetSyn("rc")<CR>
an 50.70.320 &Syntax.Msql :cal SetSyn("msql")<CR>
an 50.70.330 &Syntax.MuPAD :cal SetSyn("mupad")<CR>
an 50.70.340 &Syntax.MUSHcode :cal SetSyn("mush")<CR>
an 50.70.350 &Syntax.Muttrc :cal SetSyn("muttrc")<CR>
an 50.70.370 &Syntax.Nanorc :cal SetSyn("nanorc")<CR>
an 50.70.380 &Syntax.Nastran\ input/DMAP :cal SetSyn("nastran")<CR>
an 50.70.390 &Syntax.Natural :cal SetSyn("natural")<CR>
an 50.70.400 &Syntax.Netrc :cal SetSyn("netrc")<CR>
an 50.70.410 &Syntax.Novell\ NCF\ batch :cal SetSyn("ncf")<CR>
an 50.70.420 &Syntax.Not\ Quite\ C\ (LEGO) :cal SetSyn("nqc")<CR>
an 50.70.430 &Syntax.Nroff :cal SetSyn("nroff")<CR>
an 50.70.440 &Syntax.NSIS\ script :cal SetSyn("nsis")<CR>
an 50.70.460 &Syntax.Objective\ C :cal SetSyn("objc")<CR>
an 50.70.470 &Syntax.Objective\ C++ :cal SetSyn("objcpp")<CR>
an 50.70.480 &Syntax.OCAML :cal SetSyn("ocaml")<CR>
an 50.70.490 &Syntax.Occam :cal SetSyn("occam")<CR>
an 50.70.500 &Syntax.Omnimark :cal SetSyn("omnimark")<CR>
an 50.70.510 &Syntax.OpenROAD :cal SetSyn("openroad")<CR>
an 50.70.520 &Syntax.Open\ Psion\ Lang :cal SetSyn("opl")<CR>
an 50.70.530 &Syntax.Oracle\ config :cal SetSyn("ora")<CR>
an 50.80.100 &Syntax.Packet\ filter\ conf :cal SetSyn("pf")<CR>
an 50.80.110 &Syntax.Palm\ resource\ compiler :cal SetSyn("pilrc")<CR>
an 50.80.120 &Syntax.Pam\ config :cal SetSyn("pamconf")<CR>
an 50.80.130 &Syntax.PApp :cal SetSyn("papp")<CR>
an 50.80.140 &Syntax.Pascal :cal SetSyn("pascal")<CR>
an 50.80.150 &Syntax.Password\ file :cal SetSyn("passwd")<CR>
an 50.80.160 &Syntax.PCCTS :cal SetSyn("pccts")<CR>
an 50.80.170 &Syntax.PDF :cal SetSyn("pdf")<CR>
an 50.80.180 &Syntax.Perl.Perl :cal SetSyn("perl")<CR>
an 50.80.190 &Syntax.Perl.Perl\ POD :cal SetSyn("pod")<CR>
an 50.80.200 &Syntax.Perl.Perl\ XS :cal SetSyn("xs")<CR>
an 50.80.210 &Syntax.PHP.PHP\ 3-4 :cal SetSyn("php")<CR>
an 50.80.220 &Syntax.PHP.Phtml\ (PHP\ 2) :cal SetSyn("phtml")<CR>
an 50.80.230 &Syntax.Pike :cal SetSyn("pike")<CR>
an 50.80.240 &Syntax.Pine\ RC :cal SetSyn("pine")<CR>
an 50.80.250 &Syntax.Pinfo\ RC :cal SetSyn("pinfo")<CR>
an 50.80.260 &Syntax.PL/M :cal SetSyn("plm")<CR>
an 50.80.270 &Syntax.PL/SQL :cal SetSyn("plsql")<CR>
an 50.80.280 &Syntax.PLP :cal SetSyn("plp")<CR>
an 50.80.290 &Syntax.PO\ (GNU\ gettext) :cal SetSyn("po")<CR>
an 50.80.300 &Syntax.Postfix\ main\ config :cal SetSyn("pfmain")<CR>
an 50.80.310 &Syntax.PostScript.PostScript :cal SetSyn("postscr")<CR>
an 50.80.320 &Syntax.PostScript.PostScript\ Printer\ Description :cal SetSyn("ppd")<CR>
an 50.80.330 &Syntax.Povray.Povray\ scene\ descr :cal SetSyn("pov")<CR>
an 50.80.340 &Syntax.Povray.Povray\ configuration :cal SetSyn("povini")<CR>
an 50.80.350 &Syntax.PPWizard :cal SetSyn("ppwiz")<CR>
an 50.80.360 &Syntax.Prescribe\ (Kyocera) :cal SetSyn("prescribe")<CR>
an 50.80.370 &Syntax.Printcap :cal SetSyn("pcap")<CR>
an 50.80.380 &Syntax.Privoxy :cal SetSyn("privoxy")<CR>
an 50.80.390 &Syntax.Procmail :cal SetSyn("procmail")<CR>
an 50.80.400 &Syntax.Product\ Spec\ File :cal SetSyn("psf")<CR>
an 50.80.410 &Syntax.Progress :cal SetSyn("progress")<CR>
an 50.80.420 &Syntax.Prolog :cal SetSyn("prolog")<CR>
an 50.80.430 &Syntax.ProMeLa :cal SetSyn("promela")<CR>
an 50.80.440 &Syntax.Protocols :cal SetSyn("protocols")<CR>
an 50.80.450 &Syntax.Purify\ log :cal SetSyn("purifylog")<CR>
an 50.80.460 &Syntax.Pyrex :cal SetSyn("pyrex")<CR>
an 50.80.470 &Syntax.Python :cal SetSyn("python")<CR>
an 50.80.490 &Syntax.Quake :cal SetSyn("quake")<CR>
an 50.80.500 &Syntax.Quickfix\ window :cal SetSyn("qf")<CR>
an 50.90.100 &Syntax.R.R :cal SetSyn("r")<CR>
an 50.90.110 &Syntax.R.R\ help :cal SetSyn("rhelp")<CR>
an 50.90.120 &Syntax.R.R\ noweb :cal SetSyn("rnoweb")<CR>
an 50.90.130 &Syntax.Racc\ input :cal SetSyn("racc")<CR>
an 50.90.140 &Syntax.Radiance :cal SetSyn("radiance")<CR>
an 50.90.150 &Syntax.Ratpoison :cal SetSyn("ratpoison")<CR>
an 50.90.160 &Syntax.RCS.RCS\ log\ output :cal SetSyn("rcslog")<CR>
an 50.90.170 &Syntax.RCS.RCS\ file :cal SetSyn("rcs")<CR>
an 50.90.180 &Syntax.Readline\ config :cal SetSyn("readline")<CR>
an 50.90.190 &Syntax.Rebol :cal SetSyn("rebol")<CR>
an 50.90.200 &Syntax.Remind :cal SetSyn("remind")<CR>
an 50.90.210 &Syntax.Relax\ NG\ compact :cal SetSyn("rnc")<CR>
an 50.90.220 &Syntax.Renderman.Renderman\ Shader\ Lang :cal SetSyn("sl")<CR>
an 50.90.230 &Syntax.Renderman.Renderman\ Interface\ Bytestream :cal SetSyn("rib")<CR>
an 50.90.240 &Syntax.Resolv\.conf :cal SetSyn("resolv")<CR>
an 50.90.250 &Syntax.Reva\ Forth :cal SetSyn("reva")<CR>
an 50.90.260 &Syntax.Rexx :cal SetSyn("rexx")<CR>
an 50.90.270 &Syntax.Robots\.txt :cal SetSyn("robots")<CR>
an 50.90.280 &Syntax.RockLinux\ package\ desc\. :cal SetSyn("desc")<CR>
an 50.90.290 &Syntax.Rpcgen :cal SetSyn("rpcgen")<CR>
an 50.90.300 &Syntax.RPL/2 :cal SetSyn("rpl")<CR>
an 50.90.310 &Syntax.ReStructuredText :cal SetSyn("rst")<CR>
an 50.90.320 &Syntax.RTF :cal SetSyn("rtf")<CR>
an 50.90.330 &Syntax.Ruby :cal SetSyn("ruby")<CR>
an 50.90.350 &Syntax.S-Lang :cal SetSyn("slang")<CR>
an 50.90.360 &Syntax.Samba\ config :cal SetSyn("samba")<CR>
an 50.90.370 &Syntax.SAS :cal SetSyn("sas")<CR>
an 50.90.380 &Syntax.Sass :cal SetSyn("sass")<CR>
an 50.90.390 &Syntax.Sather :cal SetSyn("sather")<CR>
an 50.90.400 &Syntax.Scheme :cal SetSyn("scheme")<CR>
an 50.90.410 &Syntax.Scilab :cal SetSyn("scilab")<CR>
an 50.90.420 &Syntax.Screen\ RC :cal SetSyn("screen")<CR>
an 50.90.430 &Syntax.SDL :cal SetSyn("sdl")<CR>
an 50.90.440 &Syntax.Sed :cal SetSyn("sed")<CR>
an 50.90.450 &Syntax.Sendmail\.cf :cal SetSyn("sm")<CR>
an 50.90.460 &Syntax.Send-pr :cal SetSyn("sendpr")<CR>
an 50.90.470 &Syntax.Sensors\.conf :cal SetSyn("sensors")<CR>
an 50.90.480 &Syntax.Service\ Location\ config :cal SetSyn("slpconf")<CR>
an 50.90.490 &Syntax.Service\ Location\ registration :cal SetSyn("slpreg")<CR>
an 50.90.500 &Syntax.Service\ Location\ SPI :cal SetSyn("slpspi")<CR>
an 50.90.510 &Syntax.Services :cal SetSyn("services")<CR>
an 50.90.520 &Syntax.Setserial\ config :cal SetSyn("setserial")<CR>
an 50.90.530 &Syntax.SGML.SGML\ catalog :cal SetSyn("catalog")<CR>
an 50.90.540 &Syntax.SGML.SGML\ DTD :cal SetSyn("sgml")<CR>
an 50.90.550 &Syntax.SGML.SGML\ Declaration :cal SetSyn("sgmldecl")<CR>
an 50.90.560 &Syntax.SGML.SGML-linuxdoc :cal SetSyn("sgmllnx")<CR>
an 50.100.100 &Syntax.Shell\ script.sh\ and\ ksh :cal SetSyn("sh")<CR>
an 50.100.110 &Syntax.Shell\ script.csh :cal SetSyn("csh")<CR>
an 50.100.120 &Syntax.Shell\ script.tcsh :cal SetSyn("tcsh")<CR>
an 50.100.130 &Syntax.Shell\ script.zsh :cal SetSyn("zsh")<CR>
an 50.100.140 &Syntax.SiCAD :cal SetSyn("sicad")<CR>
an 50.100.150 &Syntax.Sieve :cal SetSyn("sieve")<CR>
an 50.100.160 &Syntax.Simula :cal SetSyn("simula")<CR>
an 50.100.170 &Syntax.Sinda.Sinda\ compare :cal SetSyn("sindacmp")<CR>
an 50.100.180 &Syntax.Sinda.Sinda\ input :cal SetSyn("sinda")<CR>
an 50.100.190 &Syntax.Sinda.Sinda\ output :cal SetSyn("sindaout")<CR>
an 50.100.200 &Syntax.SiSU :cal SetSyn("sisu")<CR>
an 50.100.210 &Syntax.SKILL.SKILL :cal SetSyn("skill")<CR>
an 50.100.220 &Syntax.SKILL.SKILL\ for\ Diva :cal SetSyn("diva")<CR>
an 50.100.230 &Syntax.Slice :cal SetSyn("slice")<CR>
an 50.100.240 &Syntax.SLRN.Slrn\ rc :cal SetSyn("slrnrc")<CR>
an 50.100.250 &Syntax.SLRN.Slrn\ score :cal SetSyn("slrnsc")<CR>
an 50.100.260 &Syntax.SmallTalk :cal SetSyn("st")<CR>
an 50.100.270 &Syntax.Smarty\ Templates :cal SetSyn("smarty")<CR>
an 50.100.280 &Syntax.SMIL :cal SetSyn("smil")<CR>
an 50.100.290 &Syntax.SMITH :cal SetSyn("smith")<CR>
an 50.100.300 &Syntax.SNMP\ MIB :cal SetSyn("mib")<CR>
an 50.100.310 &Syntax.SNNS.SNNS\ network :cal SetSyn("snnsnet")<CR>
an 50.100.320 &Syntax.SNNS.SNNS\ pattern :cal SetSyn("snnspat")<CR>
an 50.100.330 &Syntax.SNNS.SNNS\ result :cal SetSyn("snnsres")<CR>
an 50.100.340 &Syntax.Snobol4 :cal SetSyn("snobol4")<CR>
an 50.100.350 &Syntax.Snort\ Configuration :cal SetSyn("hog")<CR>
an 50.100.360 &Syntax.SPEC\ (Linux\ RPM) :cal SetSyn("spec")<CR>
an 50.100.370 &Syntax.Specman :cal SetSyn("specman")<CR>
an 50.100.380 &Syntax.Spice :cal SetSyn("spice")<CR>
an 50.100.390 &Syntax.Spyce :cal SetSyn("spyce")<CR>
an 50.100.400 &Syntax.Speedup :cal SetSyn("spup")<CR>
an 50.100.410 &Syntax.Splint :cal SetSyn("splint")<CR>
an 50.100.420 &Syntax.Squid\ config :cal SetSyn("squid")<CR>
an 50.100.430 &Syntax.SQL.ESQL-C :cal SetSyn("esqlc")<CR>
an 50.100.440 &Syntax.SQL.MySQL :cal SetSyn("mysql")<CR>
an 50.100.450 &Syntax.SQL.PL/SQL :cal SetSyn("plsql")<CR>
an 50.100.460 &Syntax.SQL.SQL\ Anywhere :cal SetSyn("sqlanywhere")<CR>
an 50.100.470 &Syntax.SQL.SQL\ (automatic) :cal SetSyn("sql")<CR>
an 50.100.480 &Syntax.SQL.SQL\ (Oracle) :cal SetSyn("sqloracle")<CR>
an 50.100.490 &Syntax.SQL.SQL\ Forms :cal SetSyn("sqlforms")<CR>
an 50.100.500 &Syntax.SQL.SQLJ :cal SetSyn("sqlj")<CR>
an 50.100.510 &Syntax.SQL.SQL-Informix :cal SetSyn("sqlinformix")<CR>
an 50.100.520 &Syntax.SQR :cal SetSyn("sqr")<CR>
an 50.100.530 &Syntax.Ssh.ssh_config :cal SetSyn("sshconfig")<CR>
an 50.100.540 &Syntax.Ssh.sshd_config :cal SetSyn("sshdconfig")<CR>
an 50.100.550 &Syntax.Standard\ ML :cal SetSyn("sml")<CR>
an 50.100.560 &Syntax.Stata.SMCL :cal SetSyn("smcl")<CR>
an 50.100.570 &Syntax.Stata.Stata :cal SetSyn("stata")<CR>
an 50.100.580 &Syntax.Stored\ Procedures :cal SetSyn("stp")<CR>
an 50.100.590 &Syntax.Strace :cal SetSyn("strace")<CR>
an 50.100.600 &Syntax.Streaming\ descriptor\ file :cal SetSyn("sd")<CR>
an 50.100.610 &Syntax.Subversion\ commit :cal SetSyn("svn")<CR>
an 50.100.620 &Syntax.Sudoers :cal SetSyn("sudoers")<CR>
an 50.100.630 &Syntax.Symbian\ meta-makefile :cal SetSyn("mmp")<CR>
an 50.100.640 &Syntax.Sysctl\.conf :cal SetSyn("sysctl")<CR>
an 50.110.100 &Syntax.TADS :cal SetSyn("tads")<CR>
an 50.110.110 &Syntax.Tags :cal SetSyn("tags")<CR>
an 50.110.120 &Syntax.TAK.TAK\ compare :cal SetSyn("takcmp")<CR>
an 50.110.130 &Syntax.TAK.TAK\ input :cal SetSyn("tak")<CR>
an 50.110.140 &Syntax.TAK.TAK\ output :cal SetSyn("takout")<CR>
an 50.110.150 &Syntax.Tcl/Tk :cal SetSyn("tcl")<CR>
an 50.110.160 &Syntax.TealInfo :cal SetSyn("tli")<CR>
an 50.110.170 &Syntax.Telix\ Salt :cal SetSyn("tsalt")<CR>
an 50.110.180 &Syntax.Termcap/Printcap :cal SetSyn("ptcap")<CR>
an 50.110.190 &Syntax.Terminfo :cal SetSyn("terminfo")<CR>
an 50.110.200 &Syntax.TeX.TeX/LaTeX :cal SetSyn("tex")<CR>
an 50.110.210 &Syntax.TeX.plain\ TeX :cal SetSyn("plaintex")<CR>
an 50.110.220 &Syntax.TeX.ConTeXt :cal SetSyn("context")<CR>
an 50.110.230 &Syntax.TeX.TeX\ configuration :cal SetSyn("texmf")<CR>
an 50.110.240 &Syntax.TeX.Texinfo :cal SetSyn("texinfo")<CR>
an 50.110.250 &Syntax.TF\ mud\ client :cal SetSyn("tf")<CR>
an 50.110.260 &Syntax.Tidy\ configuration :cal SetSyn("tidy")<CR>
an 50.110.270 &Syntax.Tilde :cal SetSyn("tilde")<CR>
an 50.110.280 &Syntax.TPP :cal SetSyn("tpp")<CR>
an 50.110.290 &Syntax.Trasys\ input :cal SetSyn("trasys")<CR>
an 50.110.300 &Syntax.Trustees :cal SetSyn("trustees")<CR>
an 50.110.310 &Syntax.TSS.Command\ Line :cal SetSyn("tsscl")<CR>
an 50.110.320 &Syntax.TSS.Geometry :cal SetSyn("tssgm")<CR>
an 50.110.330 &Syntax.TSS.Optics :cal SetSyn("tssop")<CR>
an 50.110.350 &Syntax.Udev\ config :cal SetSyn("udevconf")<CR>
an 50.110.360 &Syntax.Udev\ permissions :cal SetSyn("udevperm")<CR>
an 50.110.370 &Syntax.Udev\ rules :cal SetSyn("udevrules")<CR>
an 50.110.380 &Syntax.UIT/UIL :cal SetSyn("uil")<CR>
an 50.110.390 &Syntax.UnrealScript :cal SetSyn("uc")<CR>
an 50.110.400 &Syntax.Updatedb\.conf :cal SetSyn("updatedb")<CR>
an 50.110.420 &Syntax.Valgrind :cal SetSyn("valgrind")<CR>
an 50.110.430 &Syntax.Vera :cal SetSyn("vera")<CR>
an 50.110.440 &Syntax.Verilog-AMS\ HDL :cal SetSyn("verilogams")<CR>
an 50.110.450 &Syntax.Verilog\ HDL :cal SetSyn("verilog")<CR>
an 50.110.460 &Syntax.Vgrindefs :cal SetSyn("vgrindefs")<CR>
an 50.110.470 &Syntax.VHDL :cal SetSyn("vhdl")<CR>
an 50.110.480 &Syntax.Vim.Vim\ help\ file :cal SetSyn("help")<CR>
an 50.110.490 &Syntax.Vim.Vim\ script :cal SetSyn("vim")<CR>
an 50.110.500 &Syntax.Vim.Viminfo\ file :cal SetSyn("viminfo")<CR>
an 50.110.510 &Syntax.Virata\ config :cal SetSyn("virata")<CR>
an 50.110.520 &Syntax.Visual\ Basic :cal SetSyn("vb")<CR>
an 50.110.530 &Syntax.VOS\ CM\ macro :cal SetSyn("voscm")<CR>
an 50.110.540 &Syntax.VRML :cal SetSyn("vrml")<CR>
an 50.110.550 &Syntax.VSE\ JCL :cal SetSyn("vsejcl")<CR>
an 50.120.100 &Syntax.WEB.CWEB :cal SetSyn("cweb")<CR>
an 50.120.110 &Syntax.WEB.WEB :cal SetSyn("web")<CR>
an 50.120.120 &Syntax.WEB.WEB\ Changes :cal SetSyn("change")<CR>
an 50.120.130 &Syntax.Webmacro :cal SetSyn("webmacro")<CR>
an 50.120.140 &Syntax.Website\ MetaLanguage :cal SetSyn("wml")<CR>
an 50.120.160 &Syntax.wDiff :cal SetSyn("wdiff")<CR>
an 50.120.180 &Syntax.Wget\ config :cal SetSyn("wget")<CR>
an 50.120.190 &Syntax.Whitespace\ (add) :cal SetSyn("whitespace")<CR>
an 50.120.200 &Syntax.WildPackets\ EtherPeek\ Decoder :cal SetSyn("dcd")<CR>
an 50.120.210 &Syntax.WinBatch/Webbatch :cal SetSyn("winbatch")<CR>
an 50.120.220 &Syntax.Windows\ Scripting\ Host :cal SetSyn("wsh")<CR>
an 50.120.230 &Syntax.WSML :cal SetSyn("wsml")<CR>
an 50.120.240 &Syntax.WvDial :cal SetSyn("wvdial")<CR>
an 50.120.260 &Syntax.X\ Keyboard\ Extension :cal SetSyn("xkb")<CR>
an 50.120.270 &Syntax.X\ Pixmap :cal SetSyn("xpm")<CR>
an 50.120.280 &Syntax.X\ Pixmap\ (2) :cal SetSyn("xpm2")<CR>
an 50.120.290 &Syntax.X\ resources :cal SetSyn("xdefaults")<CR>
an 50.120.300 &Syntax.XBL :cal SetSyn("xbl")<CR>
an 50.120.310 &Syntax.Xinetd\.conf :cal SetSyn("xinetd")<CR>
an 50.120.320 &Syntax.Xmodmap :cal SetSyn("xmodmap")<CR>
an 50.120.330 &Syntax.Xmath :cal SetSyn("xmath")<CR>
an 50.120.340 &Syntax.XML :cal SetSyn("xml")<CR>
an 50.120.350 &Syntax.XML\ Schema\ (XSD) :cal SetSyn("xsd")<CR>
an 50.120.360 &Syntax.XQuery :cal SetSyn("xquery")<CR>
an 50.120.370 &Syntax.Xslt :cal SetSyn("xslt")<CR>
an 50.120.380 &Syntax.XFree86\ Config :cal SetSyn("xf86conf")<CR>
an 50.120.400 &Syntax.YAML :cal SetSyn("yaml")<CR>
an 50.120.410 &Syntax.Yacc :cal SetSyn("yacc")<CR>

" The End Of The Syntax Menu


an 50.195 &Syntax.-SEP1-			<Nop>

an <silent> 50.200 &Syntax.Set\ '&syntax'\ only :call <SID>Setsynonly()<CR>
fun! s:Setsynonly()
  let s:syntax_menu_synonly = 1
endfun
an <silent> 50.202 &Syntax.Set\ '&filetype'\ too :call <SID>Nosynonly()<CR>
fun! s:Nosynonly()
  if exists("s:syntax_menu_synonly")
    unlet s:syntax_menu_synonly
  endif
endfun

" Restore 'cpoptions'
let &cpo = s:cpo_save
unlet s:cpo_save
