# Makefile for AROS

CFLAGS     = -pipe -O2 --no-strict-aliasing -Wall -Iproto \
             -DUSE_TMPNAM -DFEAT_MBYTE -DFEAT_GUI -DFEAT_ASL -DFEAT_BROWSE \
             -DFEAT_MOUSE -DHAVE_STDARG_H -DFEAT_HUGE

PRG        = vim
LIBS       =
CC         = gcc
LD         = gcc
RM         = rm
STRIP      = strip
CP         = cp

SRCS       = buffer.c charset.c diff.c digraph.c edit.c eval.c ex_cmds.c ex_cmds2.c \
             ex_docmd.c ex_eval.c ex_getln.c fileio.c fold.c getchar.c hardcopy.c \
             hashtab.c main.c mark.c memfile.c memline.c menu.c message.c misc1.c \
             misc2.c move.c mbyte.c normal.c ops.c option.c os_aros.c popupmnu.c \
             quickfix.c regexp.c screen.c search.c spell.c syntax.c tag.c term.c \
             ui.c undo.c window.c version.c gui_aros.c gui.c

OBJS       = $(SRCS:.c=.o)

$(PRG): $(OBJS)
	${LD} lib:detach.o $(OBJS) -o bin:$(PRG) $(LIBS)
	ilbmtoicon vim.info.src vim48x48.png vim48x48.png bin:vim.info
	$(STRIP) --strip-unneeded bin:$(PRG)

.c.o:
	${CC} -c ${CFLAGS} $< -o $@

clean:
	$(RM) -fv $(OBJS) $(PRG)
