.TH LHA N "January 14,1997" "" "LHa for UNIX Users Manual"
.SH "NAME 名称"
LHa \- 高圧縮アーカイバ
.SH "SYNOPSIS 形式"
.B lha
.B key
[
.B modifiers
]
.I archive_file
[
.I flie
\&.\|.\|. ]
.br
.B lha
.I archive_file
.SH "DESCRIPTION 解説"
.B LHa
は効率の高い圧縮機能を持つファイルアーカイバです。
.br
.B key
に機能文字を指定し、file の追加、更新、抽出、削除、一覧表示
などを行ないます。引数に archive_file のみを指定した場合には、
機能文字に l を指定したのと同等の動作を行ないます。
.br
機能文字は以下の通りです。
.TP 8
.B a
追加。file を archive_file に追加します。
file がディレクトリであれば、そのディレクトリに含まれる
ファイルをすべて追加します。
.TP 8
.B u
更新。file が archive_file に格納されていないか、もしくは
格納されているものが古ければ、file を archive_file に追加
します。
.TP 8
.B "l または v"
一覧表示。archive_file に格納されている file の情報を一覧
表示します。file の指定がなければ archive_file 内の全ての
ファイルの情報を表示します。
v を指定すると l よりも詳しい情報を表示します。
.TP 8
.B "x または e"
抽出。archive_file から file を抽出します。file の指定が
なければ archive_file 内の全てのファイルを抽出します。
抽出すべきファイルがすでに存在している場合には、重ね書き
していいかの問い合わせを行ないます。
.TP 8
.B p
内容表示。archive_file から file の内容を取り出し、標準
出力へと出力します。file の指定がなければ、全ての内容を
出力します。
.TP 8
.B d
削除。archive_file から file を削除します。
.TP 8
.B m
移動。file を archive_file に追加した後、file を削除します。
これは、key に a を、modifiers に d を指定した時と同じ動作
を行ないます。
.TP 8
.B c
新規作成。archive_file を新たに作成し、file を追加します。
.PP
機能変更文字 modifiers を指定することによって key の動作の
詳細を変更することができます。modifiers は、以下の中から複
数指定することができます。


.TP 8
.B q<num>
表示の抑制。
対話的なメッセージの表示を抑制します。
<num> の値によって、INDICATOR の表示方法を変更できます。
.RS
.IP
.B q0   oo.... の表示を行なう。

.B q1   ファイル名表示のみ行なう。

.B q2   何も表示しない。
.RE
.IP
なお、値を入力しなかった際には、q2 と同等になります。
.TP 8
.B v
表示の冗長化。
表示するメッセージを冗長にします。
.TP 8
.B n
実行しない。
実際の更新や抽出の動作を行ないません。
実行内容の確認のために用意されています。
.TP 8
.B f
強制的な実行。
ファイルの抽出時に、存在するファイルの削除確認を
行なわず強制的に削除を行ないます。
.TP 8
.B t
テキストモードによる格納,抽出。
アーカイブファイルへのファイルの格納時には、
UNIX から MS-DOS への改行コード変換を行ないます。
ファイルの抽出時には逆に、MS-DOS から UNIX への
改行コード変換を行ないます。
.TP 8
.B o{num}
LHarc 互換アーカイブの生成、または圧縮アルゴリズムを指定する。
機能文字 a, u, m と共に指定し、抽出時には無視されます。
.RS
.IP
.B o  LHarc 互換アーカイブの生成を行う。

.RS
古い形式のアーカイブを生成します。圧縮アルゴリズムは-lh1-を使用します。
.RE

.B o5 圧縮アルゴリズムに -lh5- を使用する。

.B o6 圧縮アルゴリズムに -lh6- を使用する。

LHAの種類によっては、-lh6-で生成されたアーカイブは抽出できない
恐れがあるので、アーカイブを配布する際には注意してください。
MSDOS版の正規配布版では -lh6- の生成は行いません。
また、MSDOS版 LHA version 2.5x 以降のバージョンでは -lh6- の
抽出のみできます。
.RE
.TP 8
.B w=</dir>
格納および抽出時のワーク用ディレクトリ指定。
デフォルトでは、/tmp ですが、/tmp の大きさ以上の
ファイルを格納する際には必要です。
.TP 8
.B d
ファイル格納後のファイルの削除。
機能文字 a, もしくは u と共に用い、アーカイブ
ファイルへのファイルの格納の後にファイルを削
除します。
u に付加した場合、アーカイブファイルの内容の方が
新しい時にファイルが格納されずに削除されることに
なるので注意して下さい。
.TP 8
.B i
抽出時のディレクトリ名の無効化。
抽出時にディレクトリ名を無効にします。
.TP 8
.B z
非圧縮格納。
アーカイブへのファイルの格納時に圧縮を行ないません。
すでに圧縮を行なっていて圧縮効率を望めない場合などに使用します。
抽出時には無視されます。
.TP 8
.B g
[generic]アーカイブの作成。
UNIX 用の付加情報を持たないアーカイブファイルを生成します。
抽出時には無視されます。
.TP 8
.B 0/1/2
ヘッダレベル指定。
アーカイブの内部表現の形式を指定します。
デフォルトでは 1 です。0 は LHarc で用意されてい
た古い形式です。将来は 2 の形式に統一されるようです。
これはファイルの格納時のみ有効です。ファイルの抽出時
には自動的に形式を判断し処理します。
.PP
.I archive_file
にはアーカイブファイルを指定します。
.PP
.I archive_file
に
.I -
と書くことによって、アーカイブファイルを標準入出力
にすることが可能です。
.BR tar (1)
のように、アーカイブの作成、更新時には標準出力に、
アーカイブからのファイルの抽出時には標準入力になります。
.PP
抽出時に
.I archive_file
が存在しない時にはサフィックス
.B ".lzh"
をファイル名の後ろに付加して抽出を試みます。
.br
特に規定はありませんが、運用上サフィックスとして
.B ".lzh"
を用いるのが望ましいと思います。
日本以外では 
.B ".lha"
を使用しているケースがあるそうですので、適宜調整
して下さい。:-)
.br
サフィックスが
.B "com"
もしくは
.B ".exe"
の場合には、MS-DOS 版で作成された
.IR SFX (自己展開機能付きの圧縮ファイル)
形式かどうかをチェックし、対応します。
.br
サフィックスが
.B ".x"
の場合には、日本製 SHARP X68000 の OS, Human68k 版で
作成された SFX 形式かどうかをチェックし対応します。
.br
SFX 形式のアーカイブファイルに対して追加や削除を
行った場合には、サフィックスを
.B ".lzh"
に変更し、SFX の情報を削除します。
.PP
.SH "FILES ファイル"
.ta \w'*.com *.exe    'u
*.lzh		- LHa/LHarc アーカイブファイル
.br
*.bak		- バックアップファイル
.br
/tmp/lh*	- テンポラリファイル
.br
*.com *.exe	- MS-DOS SFX ファイル
.br
*.x		- Human68k SFX ファイル
.PP
.SH "SEE ALSO 関連項目"
.BR tar (1),
.BR ar (1),
.BR compress (1)
.SH "DISTRIBUTION 再配布について"
.PP
以下の条件で、再配布、転載、改変を許可します。
.IP 1.
著作権表示を削除しないこと。
.IP 2.
配布内容については、
.RS
.IP a.
配布の際に存在する内容(すなわちソースコード、ドキュメント、
プログラマーへの手引きなど)が再配布されたものの中に必ず存
在すること。改変されているならば、それを明示したドキュメ
ントを用意すること。
.IP b.
LHa に対する付加価値が付けられて再配布される場合にはそれら
もできるだけ含めるよう努力すること。また、その際には付加価
値が付けられていることを明示したドキュメントを用意すること。
.IP c.
バイナリのみの配布は許されない。(付加価値のものも含む)
.RE
.IP 3.
最新版の配布に務めること。(義務はない)
.RS
.IP 注.
なお、ネットでの配付は自由であるが、ネットにアクセスできない方（雑誌および、
CD-ROM などによる）配付は、配付前にこちらに E-Mail をお願いします。
配付前に出来ない際には、後日必ず E-Mail をお願いします。
.RE
.IP 4.
このプログラムの存在や使用したことによって生じた損害は全く保
証しない。
.IP 5.
作者は、このプログラムに不備があっても、それを訂正する義務を
負わない。
.IP 6.
このプログラムの一部、または全部を他のプログラムに組み込んで
利用してもかまわない。この場合、そのプログラムは LHa ではなく、
LHa と名乗ってはいけない。
.IP 7.
商利用に関しては、上記の条件に加え、下記の条件のもとにこれを
認める。
.RS
.IP a.
このプログラムをメインとする商利用は禁止する。
.IP b.
商利用の相手がこのプログラムの使用者として不適切と判断し
た場合には配布しない。
.IP c.
インストールの手段として使用する場合、このプログラムを使
うことを相手に強制しない。この場合、商利用者が作業を行う。
また、そのときの損害は、商利用者が全責任を負う。
.IP d.
商利用を付加価値として行いこのプログラムを使用する場合、
商利用者は、そのサポートを行う。
.RE
.PP
.SH "最後に(From Y.Tagawa)"
LZHUF 法の基礎となった LZARI 法を発表してくださった奥村晴彦氏、
それを NIFTY-Serve に紹介し、また、LArc の作者でもある三木和彦氏、
また、これらの要因から LZHUF 法及び、MS-DOS 版 LHarc を作成した
吉崎栄泰氏、LHarc UNIX の開発に協力した人達、こころよくメッセージ
の橋渡しをしてくれた石崎一明氏(MIX ID:k.ishi)、また、いろいろな
レポートをくれたみなさん、それを中継してくださった森公一郎
氏 (MIX ID:kmori)に感謝します。
.PP
.SH "最後に(From Masaru Oki)"
上記の方々はもちろん、加えて LHarc UNIX を作成した Y.Tagawa 氏、
それを OSK に移植し吉崎氏の LHx のアルゴリズムを組み込んだ H.S 氏、
JUNET の LHa for UNIX MailingList にて協力してくださったみなさんに
感謝致します。
.SH "最後に(From Nobutaka Watazaki)"
このプログラムの作成にかかわった方々、さらにここまで LHa を仕
上げてくださった 沖勝氏に感謝致します。
