unit matheparser;

{$mode objfpc}{$H+}

interface

// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// +++++++++++ MATHEPARSER +++++++++++++++++++++++++++++++++++++
// Syntaxcheck and calculate the value from the string ;)

uses
  Classes, SysUtils;

const Reserved:array[0..21] of string=
               ( 'pi','ln','lg','lb','sinr','cosr','tanr',
                 'atanr','asinr','acosr','sin','cos','tan',
                 'atan','asin','acos','rand','abs','exp',
                 'fak','int','sqrt'
                 );
      forbidden:array[0..26] of string=
               ( '+','-','/',':','*','.',',','-','!','"','§','$','%','&','(',')','?',
                 '´','`','''','#','~',';','<','>','|','\'
               );

Type TVariable=record
                 name:string;
                 value:extended;
               end;
     TVars=array of TVariable;

function Calculate(s:PChar; var Vari,form,err:PChar):extended;

function GetVarCount:integer;
function GetVarByIdx(i:integer;var name:PChar):extended;
function GetVarByName(Variable:PChar; var fValue:extended):integer;
procedure ClearVariables;

function IsInteger(const x: extended; eps_Genauigkeit: extended): boolean;




implementation


uses  math;

var Vars:TVars;
    aError:String;

procedure ClearVariables;
begin
  setLength(vars,0);
end;

function GetVarCount:integer;
begin
  result:=length(vars);
end;

function GetVarByIdx(i:integer;var name:PChar):extended;
begin
  Result:=0;
  Name:='';
  if (i>=low(vars)) and (i<=high(vars)) then
  begin
    name:=PChar(vars[i].name);
    Result:=vars[i].value;
  end;
end;

function GetVarByName(Variable:PChar; var fValue:extended):integer;
var i:integer;
    name:string;
begin
  result:=-1;
  name:=string(Variable);
  for i:=low(vars) to high(vars) do
  begin
    if name=vars[i].name then
    begin
      Result:=i;
      fValue:=vars[i].value;
      exit;
    end;
  end;
end;

function Checkvar(s:string):string;
var i:integer;
begin
  result:='';
  for i:=1 to length(s) do
  begin
    if not (s[i] in ['0'..'9','a'..'z','_']) then
    begin
      Result:=''''+s[i]+''' not allowed in variable names';
      exit;
    end;
  end;
  if s[1] in ['0'..'9'] then
  begin
    Result:='Variable names should not begin with a number';
    exit;
  end;
  if length(s)>1 then
  begin
    if (s[length(s)]='e') and (s[length(s)-1] in ['0'..'9']) then
    begin
      Result:='Variable names should not end with ''<number>e'' because numbers are formated in same way (1e-6)';
      exit;
    end;
  end;
  for i:=0 to high(forbidden) do
  begin
    if pos(forbidden[i],s)>0 then
    begin
      Result:=''''+forbidden[i]+''' not allowed in variable names';
      exit;
    end;
  end;
  for i:=0 to high(reserved) do
  begin
    if reserved[i]=s then
    begin
      Result:='Variable '''+s+''' is a reserved Word';
      exit;
    end;
  end;
end;


// ############### Binary to integer  #################

function bintoInt(s:string):extended;
var i:integer;
begin
  Result:=0;
  for i:=length(s) downto 1 do
  begin
    if s[i]='1' then Result:=Result+power(2,length(s)-i)
    else
      if s[i]<>'0' then
      begin
        aError:='Binary only 0 and 1 allowed';
        exit;
      end;
  end;
end;

// ############### Set Variable  #################

procedure setVariable(s:string;value:extended);
  var i:integer;
begin
  for i:=0 to high(vars) do
  begin
    if lowercase(vars[i].name)=lowercase(s) then
    begin
      vars[i].value:=value;
      exit;
    end;
  end;
  SetLength(vars,high(vars)+2);
  vars[high(vars)].name:=s;
  vars[high(vars)].value:=value;
end;

// ############### natural log  #################

function ln0(x:extended):extended;
begin
   if x<1E-15 then Begin
     aerror:='Log of '+FloatToStr(x);
   End else result := ln(x)
end;

// ############### IsInteger  #################

function IsInteger(const x: extended; eps_Genauigkeit: extended): boolean;
begin
  Result:=false;
  if ((x>1e-18) or (x<=0) )and (x<high(integer)) and (x>low(integer)) then
    result := frac(abs(x) + eps_Genauigkeit) < eps_Genauigkeit * 2;
end;

// ########### HochInt ########################
//               x^y

function HochInt(X: Extended; n: Integer): Extended;
begin
  if n < 0 then result := 1.0 / HochInt(x, -n) else
  Begin
    Result := 1.0;
    while n > 0 do begin
      while not Odd(n) do
      begin
        n := n shr 1;
        X := X * X
      end;
      Dec(n);
      Result := Result * X
    end;
  end;
end;

//############ HochReal #######################
//               x^y

function HochReal(x, y: Extended): Extended;
begin
  try
    result:=power(x,y)
  except
    aError:='Error on x^y';
  end;
end;

function makeSHR(x,y:extended):extended;
begin
  Result:= round(X) shr round(Y);
end;

function makeSHL(x,y:extended):extended;
begin
  Result:= round(X) shl round(Y);
end;

function makeXOR(x,y:extended):extended;
begin
  Result:= round(X) XOR round(Y);
end;

function makeAND(x,y:extended):extended;
begin
  Result:= round(X) AND round(Y);
end;

function makeOR(x,y:extended):extended;
begin
  Result:= round(X) OR round(Y);
end;


// ############## Tan ####################

function tan(x: extended): extended;
begin
  if cos(x)=0 then
  begin
    aError:='Illegal Value for tan, division by 0';
  end;
  try
    result := sin(x)/cos(x)
  except
    aError:='Error on Tan';
  End;
end;

// ############### ArcTan ################

function atan(x: extended): extended;
begin
  try
    result := ArcTan(x)
  except
    aError:='Error on ATan';
  End;
end;

// ############# ArcCos #################

function ACos(X: Extended): Extended;
begin
  if (x>1) or (x<0) then
  begin
    aError:='For acos, value must be between 0 and 1';
    exit;
  end;

  try
    Result := ArcCos(X);
  except
    aError:='Error on ACos';
  End;
end;

// ############ ArcSin ##################

function ASin(X: Extended): Extended;
begin
  if (x>1) or (x<0) then
  begin
    aError:='For asin, value must be between 0 and 1';
    exit;
  end;
  try
    Result:=ArcSin(X);
  except
    aError:='Error on ASin';
  End;
end;

// ########### Division #################

function division(x,y: extended): extended; //result := x/y
begin
  if y=0 then
  begin
    Result:=0;
    aError:='Division by zero';
    exit;
  end;
  try
    result := x/y
  except
    aError:='Divide Error';
  End;
end;

// ########### Square root ##############

function sqrt0(x: extended): extended;
begin
  if x<0 then
  begin
    Result:=-1;
    aError:='Square root of a negative number';
    exit;
  end;
  try
    result := sqrt(x)
  except
    aError:='Square root Error';
  End;
end;

//############  integer #####################

function int0(x:extended):extended;
begin
  result := int(x);
  if result > x then
    result := result - 1;
end;

// ############## x! ######################


function fakultaet(x: integer): Extended;
begin
  if x <= 1 then
    result := 1
  else
    result := x*fakultaet(x - 1); //recursive !
end;

function Faku(x:Extended):Extended;
begin
  // caluclate real Fakultät or Stirling formula
  if IsInteger(x,1e-18) then
    Result:=fakultaet(round(x))
  else
  begin
    x:=x+1;
    Result:=sqrt(2*Pi)*(x**(x-(1/2)))*exp(-x);
  end;
end;


//############## Main unit Term->string -> real value

function TermToReal(s:string;var Error:string):extended;

function TTR(s:string): extended;

     //--- help functions ---------------
      var u2,v2, u3,v3, u4, v4, u5, v5: string; //for functions
     //--- pos0 function ---------------
     //  find ( ) and operations

   function pos0(c:char;s:string):integer;
      var k,z:integer; //z numbers of brackets
   begin
     z:=0;
     for k:=length(s) downto 1 do Begin
       if s[k]='(' then inc(z);
       if s[k]=')' then dec(z);
       if (z=0) and (s[k]=c) then
       begin
         if (not ((s[k-2] in ['0'..'9']) and (s[k-1]='e') and (s[k]='-') and (s[k+1] in ['0'..'9']) )) then
         Begin
          result:=k; // FOUND
          exit;
        End;
       end;
    End;
    result:=0; //nothing Found
  end;

//-------- find start --------------

   function anfang(s:string;c:char):string;
   begin
     anfang:=copy(s,1,pos0(c,s)-1);
   end;

   function checkforVariable(s:string):boolean;
   var i:integer;
   begin
     Result:=false;
     for i:=0 to high(vars) do
     begin
       if lowercase(vars[i].name)=lowercase(s) then
       begin
         Result:=true;
         exit;
       end;
     end;
   end;

   function GetVariable(s:string):extended;
   var i:integer;
   begin
     Result:=0;
     for i:=0 to high(vars) do
     begin
       if lowercase(vars[i].name)=lowercase(s) then
       begin
         Result:=vars[i].value;
         exit;
       end;
     end;
   end;

// ---------- get the argument for the function -----------

   function copyab(const s:string; const i:integer):string;
     begin result:=copy(s,i,length(s)-i+1) end;

//-------------find the end  --------------------

   function ende(s:string; c:char):string;
   begin
     ende:=copyab(s,pos0(c,s)+1)
   end;

//------------ set the * between )( or number( or )number

   Procedure MalzeichenSetzten(var s:string);
     var k: integer;
   begin
     for k := 1 to length(s) - 1 do
       if ((s[k] in ['0'..'9',')']) and (s[k+1] in ['(']))
         or ((s[k+1] in ['0'..'9','(']) and (s[k] in [')']))
          then
       Begin
         s := copy(s,1,k) + '*' + copyab(s,k+1);
         MalzeichenSetzten(s); //rekursive
         exit;
       End;
   end;

// ------------------- MAIN FUNCTION ------------

 begin
  aError:='';
  Error:='';
  result := 1e101;
  if s = '' then exit;
  s := trim(s);
  if s[1]='-' then s:='0'+s; // add a 0 before a leading '-'
  MalzeichenSetzten(s);
  u2:=copy(s,1,2);  //for example  u2 = 'lg'
  v2:=copyab(s,3);
  u3:=copy(s,1,3);  //for example u3 = 'cos'
  v3:=copyab(s,4);
  u4:=copy(s,1,4);  //for example u4 = 'sqrt'
  v4:=copyab(s,5);
  u5:=copy(s,1,5);  //for example u4 = 'acosr'
  v5:=copyab(s,6);

  // make the calculations!

  if pos0('-',s)>0  then result:=TTR(anfang(s,'-'))-TTR(ende(s,'-')) else
  if pos0('+',s)>0  then result:=TTR(anfang(s,'+'))+TTR(ende(s,'+')) else
  if pos0('/',s)>0 then  result:=division(TTR(anfang(s,'/')),TTR(ende(s,'/'))) else
  if pos0('*',s)>0 then  result:=TTR(anfang(s,'*'))*TTR(ende(s,'*')) else
  if pos0('^',s)>0 then  result:=hochreal(TTR(anfang(s,'^')),TTR(ende(s,'^'))) else
  if pos0('>',s)>0  then result:=MakeSHR(TTR(anfang(s,'>')),TTR(ende(s,'>'))) else
  if pos0('<',s)>0  then result:=MakeSHL(TTR(anfang(s,'<')),TTR(ende(s,'<'))) else
  if pos0('#',s)>0  then result:=MakeXOR(TTR(anfang(s,'#')),TTR(ende(s,'#'))) else
  if pos0('&',s)>0  then result:=MakeAND(TTR(anfang(s,'&')),TTR(ende(s,'&'))) else
  if pos0('|',s)>0  then result:=MakeOR(TTR(anfang(s,'|')),TTR(ende(s,'|'))) else

  if checkforVariable(s) then result:=GetVariable(s) else

  if u2='pi'    then result:=Pi else
  if u2='ln'    then result:=ln0(TTR(v2)) else
  if u2='lg'    then result:=ln0(TTR(v2))/ln(10) else
  if u2='lb'    then result:=ln0(TTR(v2))/ln(2) else
  if u4='sinr'  then result:=sin(TTR(v4)) else
  if u4='cosr'  then result:=cos(TTR(v4)) else
  if u4='tanr'  then result:=tan(TTR(v4)) else
  if u5='atanr' then result:=atan(TTR(v5)) else
  if u5='asinr' then result:=asin(TTR(v5)) else
  if u5='acosr' then result:=acos(TTR(v5)) else
  if u3='sin'   then result:=sin(Pi/180*TTR(v3)) else
  if u3='cos'   then result:=cos(Pi/180*TTR(v3)) else
  if u3='tan'   then result:=tan(Pi/180*TTR(v3)) else
  if u4='atan'  then result:=atan(TTR(v4))*180/Pi else
  if u4='asin'  then result:=asin(TTR(v4))*180/Pi else
  if u4='acos'  then result:=acos(TTR(v4))*180/Pi else
  if u4='rand'  then result:=(random(100)*TTR(v4))/100 else
  if u3='abs'   then result:=abs(TTR(v3)) else
  if u3='exp'   then result:=exp(TTR(v3)) else
  if u3='fak'   then result:=faku(TTR(v3)) else
  if u3='int'   then result:=int0(TTR(v3)) else
  if u4='sqrt'  then result:=sqrt0(TTR(v4)) else
  if u5='round' then result:=round(TTR(v5)) else
  if u4='ceil'  then result:=ceil(TTR(v4)) else
  if u5='floor' then result:=floor(TTR(v5)) else
  // brackets
  if (s>'') and (s[1]='(') then
  begin
    s:=copy(s,2,length(s)-2);
    result:=TTR(s)
  end else
  begin
    if s[1]='%' then
    begin
      Delete(s,1,1);
      Result:=bintoInt(s);
    end else
    if s[1]='$' then
      try
        result:=StrToInt(s);
      except
        Result:=0;
        aError:='unknown identifier: '+s;
        exit;
      end
    else
      try
        result:=StrToFloat(s);
      except
        Result:=0;
        aError:='unknown identifier: '+s;
        exit;
      end;
  end;
 end;
begin // main start
  result := TTR(s);
  Error:=aError;
end;


function Calculate(s:PChar; var Vari,form,err:PChar):extended;
var Strings:TStringList;
    strTemp:string;
    variable,formula,error:string;
begin
  strTemp:=lowercase(s);
  strTemp:=StringReplace(strTemp,' ','',[rfReplaceAll]);
  Strings:=TStringList.create;
  formula:='';
  variable:='';
  try
    ExtractStrings(['='],[' '],PChar(strtemp),Strings);
    case Strings.count of
      0: Error:='No Formula';
      1: begin
           variable:='result';
           Formula:=strings[0];
         end;
      2: begin
           variable := strings[0];
           Formula  := strings[1];
         end;
      else
        Error:='too many =';
    end;
  finally
    Strings.free;
  end;
  if Variable<>'' then
  begin
    Error:=CheckVar(lowercase(variable));
  end;
  if Error<>'' then
  begin
    form:=PChar(formula);
    vari:=PChar(variable);
    Err:=PChar(Error);
    exit;
  end;
  Result:=TermToReal(formula, Error);
  if Error<>'' then
  begin
    form:=PChar(formula);
    vari:=PChar(variable);
    Err:=PChar(Error);
    exit;
  end;
  setVariable(variable,result);
  Err:=PChar(Error);
  vari:=Pchar(variable);
  form:=PChar(Formula);
end;

initialization

finalization

end.

