program Hex2;

uses
  matheparser, sysutils;

procedure ProcessInput(InputStr: PChar);
var
  strTemp:PChar;
  variable:PChar;
  formula:PChar;
  Error:PChar;
  Res:extended;
begin
  strTemp := PChar(InputStr);
  //formulas.Add(strTemp);
  writeln('> '+strTemp);
  res := Calculate(strTemp, variable, formula, Error);
  if Error<>'' then
  begin
    writeln('ERROR:'+Error);
    exit;
  end;
  writeln(variable+'='+floattostr(res));
  //ReDrawVars;
end;

procedure ShowVars;
var
  Count: LongInt;
  Value: extended;
  PName: PChar;
  i: LongInt;
begin
  Count := GetVarCount;
  for i := 0 to Count - 1 do
  begin
    Value := GetVarByIdx(i, PName);
    write(string(PName),#9) ;
    if IsInteger(value, 1E-18) then
    begin
      Write('Integer',#9);
      Write(inttostr(longint(round(Value))),#9);
      Writeln('$'+inttoHex(longint(round(Value)),8),#9);
      //Writeln(IntToBin(round(value),32,4));
    end else
    begin
      Write('Float',#9);
      Writeln(FloatToStr(Value));
    end;
  end;
end;

procedure ShowHelp;
begin
  writeln('Hex commands');
  writeln();
  writeln('Numbers:',#9,'5= Decimal, $5= Hexadecimal, %0101= Binary');
  writeln('Basic:  ',#9,'+, -, * /, ^');
  writeln('Binary: ',#9,'& = AND, | = OR, #=XOR, <= Shift left, >= Shift right');
  writeln('Trig:   ',#9,'sin = sinus, sinr = sinus with rad (same with cos and tan)');
  writeln('        ',#9,'asin = arcus sinus, asinr = arcus sinus with rad (same for cos and tan)');
  writeln('other:  ',#9,'sqrt (square root), exp, ln (log base e), lg (log base 10), lb (log base 2)');
  writeln('        ',#9,'abs, round, ceil, floor, int, rand (random), fak (fak(3)=1*2*3) ');
  writeln('Vars:   ',#9,'a=1 none of keywords above, must not start with an number');
  writeln('        ',#9,'b4=a+1  Variable ''result'' always keeps last result');
  writeln('        ',#9,'to see all variables just send an empty string, type ''exit'' to leave')
end;

var
  str: Ansistring;

begin
  writeln('Welcome to Hex');                              
  writeln('(c) Marcus Sackrow 2009-2011, alb42@alb42.de');
  writeln('type ''help'' for helptext and ''exit'' to leave');
  repeat
    write(':');
    readln(str);
    str := lowercase(Trim(str));
    if str = 'exit' then
      Exit;
    if str = '' then
      ShowVars
    else
    if str = 'help' then
      ShowHelp
    else 
      ProcessInput(PChar(str));
  until False;
end.
