require '_h2ph_pre.ph';

unless(defined(&_DEV_IEEE1394_FWOHCIREG_H_)) {
    eval 'sub _DEV_IEEE1394_FWOHCIREG_H_ () {1;}' unless defined(&_DEV_IEEE1394_FWOHCIREG_H_);
    eval 'sub PCI_INTERFACE_OHCI () {0x10;}' unless defined(&PCI_INTERFACE_OHCI);
    eval 'sub PCI_OHCI_MAP_REGISTER () {0x10;}' unless defined(&PCI_OHCI_MAP_REGISTER);
    eval 'sub PCI_OHCI_CONTROL_REGISTER () {0x40;}' unless defined(&PCI_OHCI_CONTROL_REGISTER);
    eval 'sub PCI_GLOBAL_SWAP_BE () {0x00000001;}' unless defined(&PCI_GLOBAL_SWAP_BE);
    eval 'sub OHCI_CONFIG_SIZE () {1024;}' unless defined(&OHCI_CONFIG_SIZE);
    eval 'sub OHCI_CONFIG_ALIGNMENT () {1024;}' unless defined(&OHCI_CONFIG_ALIGNMENT);
    eval 'sub OHCI_REG_Version () {0x000;}' unless defined(&OHCI_REG_Version);
    eval 'sub OHCI_REG_Guid_Rom () {0x004;}' unless defined(&OHCI_REG_Guid_Rom);
    eval 'sub OHCI_REG_ATRetries () {0x008;}' unless defined(&OHCI_REG_ATRetries);
    eval 'sub OHCI_REG_CsrReadData () {0x00c;}' unless defined(&OHCI_REG_CsrReadData);
    eval 'sub OHCI_REG_CsrCompareData () {0x010;}' unless defined(&OHCI_REG_CsrCompareData);
    eval 'sub OHCI_REG_CsrControl () {0x014;}' unless defined(&OHCI_REG_CsrControl);
    eval 'sub OHCI_REG_ConfigROMhdr () {0x018;}' unless defined(&OHCI_REG_ConfigROMhdr);
    eval 'sub OHCI_REG_BusId () {0x01c;}' unless defined(&OHCI_REG_BusId);
    eval 'sub OHCI_REG_BusOptions () {0x020;}' unless defined(&OHCI_REG_BusOptions);
    eval 'sub OHCI_REG_GUIDHi () {0x024;}' unless defined(&OHCI_REG_GUIDHi);
    eval 'sub OHCI_REG_GUIDLo () {0x028;}' unless defined(&OHCI_REG_GUIDLo);
    eval 'sub OHCI_REG_reserved_02c () {0x02c;}' unless defined(&OHCI_REG_reserved_02c);
    eval 'sub OHCI_REG_reserved_030 () {0x030;}' unless defined(&OHCI_REG_reserved_030);
    eval 'sub OHCI_REG_ConfigROMmap () {0x034;}' unless defined(&OHCI_REG_ConfigROMmap);
    eval 'sub OHCI_REG_PostedWriteAddressLo () {0x038;}' unless defined(&OHCI_REG_PostedWriteAddressLo);
    eval 'sub OHCI_REG_PostedWriteAddressHi () {0x03c;}' unless defined(&OHCI_REG_PostedWriteAddressHi);
    eval 'sub OHCI_REG_VendorId () {0x040;}' unless defined(&OHCI_REG_VendorId);
    eval 'sub OHCI_REG_reserved_044 () {0x044;}' unless defined(&OHCI_REG_reserved_044);
    eval 'sub OHCI_REG_reserved_048 () {0x048;}' unless defined(&OHCI_REG_reserved_048);
    eval 'sub OHCI_REG_reserved_04c () {0x04c;}' unless defined(&OHCI_REG_reserved_04c);
    eval 'sub OHCI_REG_HCControlSet () {0x050;}' unless defined(&OHCI_REG_HCControlSet);
    eval 'sub OHCI_REG_HCControlClear () {0x054;}' unless defined(&OHCI_REG_HCControlClear);
    eval 'sub OHCI_REG_reserved_058 () {0x058;}' unless defined(&OHCI_REG_reserved_058);
    eval 'sub OHCI_REG_reserved_05c () {0x05c;}' unless defined(&OHCI_REG_reserved_05c);
    eval 'sub OHCI_REG_reserved_060 () {0x060;}' unless defined(&OHCI_REG_reserved_060);
    eval 'sub OHCI_REG_SelfIDBuffer () {0x064;}' unless defined(&OHCI_REG_SelfIDBuffer);
    eval 'sub OHCI_REG_SelfIDCount () {0x068;}' unless defined(&OHCI_REG_SelfIDCount);
    eval 'sub OHCI_REG_reserved_06c () {0x06c;}' unless defined(&OHCI_REG_reserved_06c);
    eval 'sub OHCI_REG_IRMultiChanMaskHiSet () {0x070;}' unless defined(&OHCI_REG_IRMultiChanMaskHiSet);
    eval 'sub OHCI_REG_IRMultiChanMaskHiClear () {0x074;}' unless defined(&OHCI_REG_IRMultiChanMaskHiClear);
    eval 'sub OHCI_REG_IRMultiChanMaskLoSet () {0x078;}' unless defined(&OHCI_REG_IRMultiChanMaskLoSet);
    eval 'sub OHCI_REG_IRMultiChanMaskLoClear () {0x07c;}' unless defined(&OHCI_REG_IRMultiChanMaskLoClear);
    eval 'sub OHCI_REG_IntEventSet () {0x080;}' unless defined(&OHCI_REG_IntEventSet);
    eval 'sub OHCI_REG_IntEventClear () {0x084;}' unless defined(&OHCI_REG_IntEventClear);
    eval 'sub OHCI_REG_IntMaskSet () {0x088;}' unless defined(&OHCI_REG_IntMaskSet);
    eval 'sub OHCI_REG_IntMaskClear () {0x08c;}' unless defined(&OHCI_REG_IntMaskClear);
    eval 'sub OHCI_REG_IsoXmitIntEventSet () {0x090;}' unless defined(&OHCI_REG_IsoXmitIntEventSet);
    eval 'sub OHCI_REG_IsoXmitIntEventClear () {0x094;}' unless defined(&OHCI_REG_IsoXmitIntEventClear);
    eval 'sub OHCI_REG_IsoXmitIntMaskSet () {0x098;}' unless defined(&OHCI_REG_IsoXmitIntMaskSet);
    eval 'sub OHCI_REG_IsoXmitIntMaskClear () {0x09c;}' unless defined(&OHCI_REG_IsoXmitIntMaskClear);
    eval 'sub OHCI_REG_IsoRecvIntEventSet () {0x0a0;}' unless defined(&OHCI_REG_IsoRecvIntEventSet);
    eval 'sub OHCI_REG_IsoRecvIntEventClear () {0x0a4;}' unless defined(&OHCI_REG_IsoRecvIntEventClear);
    eval 'sub OHCI_REG_IsoRecvIntMaskSet () {0x0a8;}' unless defined(&OHCI_REG_IsoRecvIntMaskSet);
    eval 'sub OHCI_REG_IsoRecvIntMaskClear () {0x0ac;}' unless defined(&OHCI_REG_IsoRecvIntMaskClear);
    eval 'sub OHCI_REG_InitialBandwidthAvailable () {0x0b0;}' unless defined(&OHCI_REG_InitialBandwidthAvailable);
    eval 'sub OHCI_REG_InitialChannelsAvailableHi () {0x0b4;}' unless defined(&OHCI_REG_InitialChannelsAvailableHi);
    eval 'sub OHCI_REG_InitialChannelsAvailableLo () {0x0b8;}' unless defined(&OHCI_REG_InitialChannelsAvailableLo);
    eval 'sub OHCI_REG_reserved_0bc () {0x0bc;}' unless defined(&OHCI_REG_reserved_0bc);
    eval 'sub OHCI_REG_reserved_0c0 () {0x0c0;}' unless defined(&OHCI_REG_reserved_0c0);
    eval 'sub OHCI_REG_reserved_0c4 () {0x0c4;}' unless defined(&OHCI_REG_reserved_0c4);
    eval 'sub OHCI_REG_reserved_0c8 () {0x0c8;}' unless defined(&OHCI_REG_reserved_0c8);
    eval 'sub OHCI_REG_reserved_0cc () {0x0cc;}' unless defined(&OHCI_REG_reserved_0cc);
    eval 'sub OHCI_REG_reserved_0d0 () {0x0d0;}' unless defined(&OHCI_REG_reserved_0d0);
    eval 'sub OHCI_REG_reserved_0d4 () {0x0d4;}' unless defined(&OHCI_REG_reserved_0d4);
    eval 'sub OHCI_REG_reserved_0d8 () {0x0d8;}' unless defined(&OHCI_REG_reserved_0d8);
    eval 'sub OHCI_REG_FairnessConctrol () {0x0dc;}' unless defined(&OHCI_REG_FairnessConctrol);
    eval 'sub OHCI_REG_LinkControlSet () {0x0e0;}' unless defined(&OHCI_REG_LinkControlSet);
    eval 'sub OHCI_REG_LinkControlClear () {0x0e4;}' unless defined(&OHCI_REG_LinkControlClear);
    eval 'sub OHCI_REG_NodeId () {0x0e8;}' unless defined(&OHCI_REG_NodeId);
    eval 'sub OHCI_REG_PhyControl () {0x0ec;}' unless defined(&OHCI_REG_PhyControl);
    eval 'sub OHCI_REG_IsochronousCycleTimer () {0x0f0;}' unless defined(&OHCI_REG_IsochronousCycleTimer);
    eval 'sub OHCI_REG_reserved_0f0 () {0x0f4;}' unless defined(&OHCI_REG_reserved_0f0);
    eval 'sub OHCI_REG_reserved_0f8 () {0x0f8;}' unless defined(&OHCI_REG_reserved_0f8);
    eval 'sub OHCI_REG_reserved_0fc () {0x0fc;}' unless defined(&OHCI_REG_reserved_0fc);
    eval 'sub OHCI_REG_AsynchronousRequestFilterHiSet () {0x100;}' unless defined(&OHCI_REG_AsynchronousRequestFilterHiSet);
    eval 'sub OHCI_REG_AsynchronousRequestFilterHiClear () {0x104;}' unless defined(&OHCI_REG_AsynchronousRequestFilterHiClear);
    eval 'sub OHCI_REG_AsynchronousRequestFilterLoSet () {0x108;}' unless defined(&OHCI_REG_AsynchronousRequestFilterLoSet);
    eval 'sub OHCI_REG_AsynchronousRequestFilterLoClear () {0x10c;}' unless defined(&OHCI_REG_AsynchronousRequestFilterLoClear);
    eval 'sub OHCI_REG_PhysicalRequestFilterHiSet () {0x110;}' unless defined(&OHCI_REG_PhysicalRequestFilterHiSet);
    eval 'sub OHCI_REG_PhysicalRequestFilterHiClear () {0x114;}' unless defined(&OHCI_REG_PhysicalRequestFilterHiClear);
    eval 'sub OHCI_REG_PhysicalRequestFilterLoSet () {0x118;}' unless defined(&OHCI_REG_PhysicalRequestFilterLoSet);
    eval 'sub OHCI_REG_PhysicalRequestFilterLoClear () {0x11c;}' unless defined(&OHCI_REG_PhysicalRequestFilterLoClear);
    eval 'sub OHCI_REG_PhysicalUpperBound () {0x120;}' unless defined(&OHCI_REG_PhysicalUpperBound);
    eval 'sub OHCI_REG_reserved_124 () {0x124;}' unless defined(&OHCI_REG_reserved_124);
    eval 'sub OHCI_REG_reserved_128 () {0x128;}' unless defined(&OHCI_REG_reserved_128);
    eval 'sub OHCI_REG_reserved_12c () {0x12c;}' unless defined(&OHCI_REG_reserved_12c);
    eval 'sub OHCI_REG_reserved_130 () {0x130;}' unless defined(&OHCI_REG_reserved_130);
    eval 'sub OHCI_REG_reserved_134 () {0x134;}' unless defined(&OHCI_REG_reserved_134);
    eval 'sub OHCI_REG_reserved_138 () {0x138;}' unless defined(&OHCI_REG_reserved_138);
    eval 'sub OHCI_REG_reserved_13c () {0x13c;}' unless defined(&OHCI_REG_reserved_13c);
    eval 'sub OHCI_REG_reserved_140 () {0x140;}' unless defined(&OHCI_REG_reserved_140);
    eval 'sub OHCI_REG_reserved_144 () {0x144;}' unless defined(&OHCI_REG_reserved_144);
    eval 'sub OHCI_REG_reserved_148 () {0x148;}' unless defined(&OHCI_REG_reserved_148);
    eval 'sub OHCI_REG_reserved_14c () {0x14c;}' unless defined(&OHCI_REG_reserved_14c);
    eval 'sub OHCI_REG_reserved_150 () {0x150;}' unless defined(&OHCI_REG_reserved_150);
    eval 'sub OHCI_REG_reserved_154 () {0x154;}' unless defined(&OHCI_REG_reserved_154);
    eval 'sub OHCI_REG_reserved_158 () {0x158;}' unless defined(&OHCI_REG_reserved_158);
    eval 'sub OHCI_REG_reserved_15c () {0x15c;}' unless defined(&OHCI_REG_reserved_15c);
    eval 'sub OHCI_REG_reserved_160 () {0x160;}' unless defined(&OHCI_REG_reserved_160);
    eval 'sub OHCI_REG_reserved_164 () {0x164;}' unless defined(&OHCI_REG_reserved_164);
    eval 'sub OHCI_REG_reserved_168 () {0x168;}' unless defined(&OHCI_REG_reserved_168);
    eval 'sub OHCI_REG_reserved_16c () {0x16c;}' unless defined(&OHCI_REG_reserved_16c);
    eval 'sub OHCI_REG_reserved_170 () {0x170;}' unless defined(&OHCI_REG_reserved_170);
    eval 'sub OHCI_REG_reserved_174 () {0x174;}' unless defined(&OHCI_REG_reserved_174);
    eval 'sub OHCI_REG_reserved_178 () {0x178;}' unless defined(&OHCI_REG_reserved_178);
    eval 'sub OHCI_REG_reserved_17c () {0x17c;}' unless defined(&OHCI_REG_reserved_17c);
    eval 'sub OHCI_REG_ASYNC_DMA_BASE () {0x180;}' unless defined(&OHCI_REG_ASYNC_DMA_BASE);
    eval 'sub OHCI_CTX_ASYNC_TX_REQUEST () {0;}' unless defined(&OHCI_CTX_ASYNC_TX_REQUEST);
    eval 'sub OHCI_CTX_ASYNC_TX_RESPONSE () {1;}' unless defined(&OHCI_CTX_ASYNC_TX_RESPONSE);
    eval 'sub OHCI_CTX_ASYNC_RX_REQUEST () {2;}' unless defined(&OHCI_CTX_ASYNC_RX_REQUEST);
    eval 'sub OHCI_CTX_ASYNC_RX_RESPONSE () {3;}' unless defined(&OHCI_CTX_ASYNC_RX_RESPONSE);
    eval 'sub OHCI_SUBREG_ContextControlSet () {0x000;}' unless defined(&OHCI_SUBREG_ContextControlSet);
    eval 'sub OHCI_SUBREG_ContextControlClear () {0x004;}' unless defined(&OHCI_SUBREG_ContextControlClear);
    eval 'sub OHCI_SUBREG_reserved_008 () {0x008;}' unless defined(&OHCI_SUBREG_reserved_008);
    eval 'sub OHCI_SUBREG_CommandPtr () {0x00c;}' unless defined(&OHCI_SUBREG_CommandPtr);
    eval 'sub OHCI_SUBREG_ContextMatch () {0x010;}' unless defined(&OHCI_SUBREG_ContextMatch);
    eval 'sub OHCI_SUBREG_reserved_014 () {0x014;}' unless defined(&OHCI_SUBREG_reserved_014);
    eval 'sub OHCI_SUBREG_reserved_018 () {0x018;}' unless defined(&OHCI_SUBREG_reserved_018);
    eval 'sub OHCI_SUBREG_reserved_01c () {0x01c;}' unless defined(&OHCI_SUBREG_reserved_01c);
    eval 'sub OHCI_ASYNC_DMA_WRITE {
        local($sc, $ctx, $reg, $val) = @_;
	    eval q( &OHCI_CSR_WRITE($sc,  &OHCI_REG_ASYNC_DMA_BASE + 32*($ctx) + ($reg), $val));
    }' unless defined(&OHCI_ASYNC_DMA_WRITE);
    eval 'sub OHCI_ASYNC_DMA_READ {
        local($sc, $ctx, $reg) = @_;
	    eval q( &OHCI_CSR_READ($sc,  &OHCI_REG_ASYNC_DMA_BASE + 32*($ctx) + ($reg)));
    }' unless defined(&OHCI_ASYNC_DMA_READ);
    eval 'sub OHCI_REG_SYNC_TX_DMA_BASE () {0x200;}' unless defined(&OHCI_REG_SYNC_TX_DMA_BASE);
    eval 'sub OHCI_SYNC_TX_DMA_WRITE {
        local($sc, $ctx, $reg, $val) = @_;
	    eval q( &OHCI_CSR_WRITE($sc,  &OHCI_REG_SYNC_TX_DMA_BASE + 16*($ctx) + ($reg), $val));
    }' unless defined(&OHCI_SYNC_TX_DMA_WRITE);
    eval 'sub OHCI_SYNC_TX_DMA_READ {
        local($sc, $ctx, $reg) = @_;
	    eval q( &OHCI_CSR_READ($sc,  &OHCI_REG_SYNC_TX_DMA_BASE + 16*($ctx) + ($reg)));
    }' unless defined(&OHCI_SYNC_TX_DMA_READ);
    eval 'sub OHCI_REG_SYNC_RX_DMA_BASE () {0x400;}' unless defined(&OHCI_REG_SYNC_RX_DMA_BASE);
    eval 'sub OHCI_SYNC_RX_DMA_WRITE {
        local($sc, $ctx, $reg, $val) = @_;
	    eval q( &OHCI_CSR_WRITE($sc,  &OHCI_REG_SYNC_RX_DMA_BASE + 32*($ctx) + ($reg), $val));
    }' unless defined(&OHCI_SYNC_RX_DMA_WRITE);
    eval 'sub OHCI_SYNC_RX_DMA_READ {
        local($sc, $ctx, $reg) = @_;
	    eval q( &OHCI_CSR_READ($sc,  &OHCI_REG_SYNC_RX_DMA_BASE + 32*($ctx) + ($reg)));
    }' unless defined(&OHCI_SYNC_RX_DMA_READ);
    eval 'sub OHCI_BITVAL {
        local($val, $name) = @_;
	    eval q((((($val) & $name &_MASK) >> $name &_BITPOS)));
    }' unless defined(&OHCI_BITVAL);
    eval 'sub OHCI_Version_GUID_ROM () {0x01000000;}' unless defined(&OHCI_Version_GUID_ROM);
    eval 'sub OHCI_Version_GET_Version {
        local($x) = @_;
	    eval q((((($x) >> 16) & 0xf) + ((($x) >> 20) & 0xf) * 10));
    }' unless defined(&OHCI_Version_GET_Version);
    eval 'sub OHCI_Version_GET_Revision {
        local($x) = @_;
	    eval q((((($x) >> 4) & 0xf) + (($x) & 0xf) * 10));
    }' unless defined(&OHCI_Version_GET_Revision);
    eval 'sub OHCI_Guid_AddrReset () {0x80000000;}' unless defined(&OHCI_Guid_AddrReset);
    eval 'sub OHCI_Guid_RdStart () {0x02000000;}' unless defined(&OHCI_Guid_RdStart);
    eval 'sub OHCI_Guid_RdData_MASK () {0x00ff0000;}' unless defined(&OHCI_Guid_RdData_MASK);
    eval 'sub OHCI_Guid_RdData_BITPOS () {16;}' unless defined(&OHCI_Guid_RdData_BITPOS);
    eval 'sub OHCI_Guid_MiniROM_MASK () {0x000000ff;}' unless defined(&OHCI_Guid_MiniROM_MASK);
    eval 'sub OHCI_Guid_MiniROM_BITPOS () {0;}' unless defined(&OHCI_Guid_MiniROM_BITPOS);
    eval 'sub OHCI_CsrControl_Done () {0x80000000;}' unless defined(&OHCI_CsrControl_Done);
    eval 'sub OHCI_CsrControl_SelMASK () {0x00000003;}' unless defined(&OHCI_CsrControl_SelMASK);
    eval 'sub OHCI_CsrControl_BusManId () {0;}' unless defined(&OHCI_CsrControl_BusManId);
    eval 'sub OHCI_CsrControl_BWAvail () {1;}' unless defined(&OHCI_CsrControl_BWAvail);
    eval 'sub OHCI_CsrControl_ChanAvailHi () {2;}' unless defined(&OHCI_CsrControl_ChanAvailHi);
    eval 'sub OHCI_CsrControl_ChanAvailLo () {3;}' unless defined(&OHCI_CsrControl_ChanAvailLo);
    eval 'sub OHCI_BusOptions_LinkSpd_MASK () {0x00000007;}' unless defined(&OHCI_BusOptions_LinkSpd_MASK);
    eval 'sub OHCI_BusOptions_LinkSpd_BITPOS () {0;}' unless defined(&OHCI_BusOptions_LinkSpd_BITPOS);
    eval 'sub OHCI_BusOptions_G_MASK () {0x000000c0;}' unless defined(&OHCI_BusOptions_G_MASK);
    eval 'sub OHCI_BusOptions_G_BITPOS () {6;}' unless defined(&OHCI_BusOptions_G_BITPOS);
    eval 'sub OHCI_BusOptions_MaxRec_MASK () {0x0000f000;}' unless defined(&OHCI_BusOptions_MaxRec_MASK);
    eval 'sub OHCI_BusOptions_MaxRec_BITPOS () {12;}' unless defined(&OHCI_BusOptions_MaxRec_BITPOS);
    eval 'sub OHCI_BusOptions_CycClkAcc_MASK () {0x00ff0000;}' unless defined(&OHCI_BusOptions_CycClkAcc_MASK);
    eval 'sub OHCI_BusOptions_CycClkAcc_BITPOS () {16;}' unless defined(&OHCI_BusOptions_CycClkAcc_BITPOS);
    eval 'sub OHCI_BusOptions_PMC () {0x08000000;}' unless defined(&OHCI_BusOptions_PMC);
    eval 'sub OHCI_BusOptions_BMC () {0x10000000;}' unless defined(&OHCI_BusOptions_BMC);
    eval 'sub OHCI_BusOptions_ISC () {0x20000000;}' unless defined(&OHCI_BusOptions_ISC);
    eval 'sub OHCI_BusOptions_CMC () {0x40000000;}' unless defined(&OHCI_BusOptions_CMC);
    eval 'sub OHCI_BusOptions_IRMC () {0x80000000;}' unless defined(&OHCI_BusOptions_IRMC);
    eval 'sub OHCI_BusOptions_reserved () {0x07000f38;}' unless defined(&OHCI_BusOptions_reserved);
    eval 'sub OHCI_HCControl_SoftReset () {0x00010000;}' unless defined(&OHCI_HCControl_SoftReset);
    eval 'sub OHCI_HCControl_LinkEnable () {0x00020000;}' unless defined(&OHCI_HCControl_LinkEnable);
    eval 'sub OHCI_HCControl_PostedWriteEnable () {0x00040000;}' unless defined(&OHCI_HCControl_PostedWriteEnable);
    eval 'sub OHCI_HCControl_LPS () {0x00080000;}' unless defined(&OHCI_HCControl_LPS);
    eval 'sub OHCI_HCControl_APhyEnhanceEnable () {0x00400000;}' unless defined(&OHCI_HCControl_APhyEnhanceEnable);
    eval 'sub OHCI_HCControl_ProgramPhyEnable () {0x00800000;}' unless defined(&OHCI_HCControl_ProgramPhyEnable);
    eval 'sub OHCI_HCControl_NoByteSwapData () {0x40000000;}' unless defined(&OHCI_HCControl_NoByteSwapData);
    eval 'sub OHCI_HCControl_BIBImageValid () {0x80000000;}' unless defined(&OHCI_HCControl_BIBImageValid);
    eval 'sub OHCI_SelfID_Error () {0x80000000;}' unless defined(&OHCI_SelfID_Error);
    eval 'sub OHCI_SelfID_Gen_MASK () {0x00ff0000;}' unless defined(&OHCI_SelfID_Gen_MASK);
    eval 'sub OHCI_SelfID_Gen_BITPOS () {16;}' unless defined(&OHCI_SelfID_Gen_BITPOS);
    eval 'sub OHCI_SelfID_Size_MASK () {0x000007fc;}' unless defined(&OHCI_SelfID_Size_MASK);
    eval 'sub OHCI_SelfID_Size_BITPOS () {2;}' unless defined(&OHCI_SelfID_Size_BITPOS);
    eval 'sub OHCI_Int_MasterEnable () {0x80000000;}' unless defined(&OHCI_Int_MasterEnable);
    eval 'sub OHCI_Int_VendorSpecific () {0x40000000;}' unless defined(&OHCI_Int_VendorSpecific);
    eval 'sub OHCI_Int_SoftInterrupt () {0x20000000;}' unless defined(&OHCI_Int_SoftInterrupt);
    eval 'sub OHCI_Int_Ack_Tardy () {0x08000000;}' unless defined(&OHCI_Int_Ack_Tardy);
    eval 'sub OHCI_Int_PhyRegRcvd () {0x04000000;}' unless defined(&OHCI_Int_PhyRegRcvd);
    eval 'sub OHCI_Int_CycleTooLong () {0x02000000;}' unless defined(&OHCI_Int_CycleTooLong);
    eval 'sub OHCI_Int_UnrecoverableError () {0x01000000;}' unless defined(&OHCI_Int_UnrecoverableError);
    eval 'sub OHCI_Int_CycleInconsistent () {0x00800000;}' unless defined(&OHCI_Int_CycleInconsistent);
    eval 'sub OHCI_Int_CycleLost () {0x00400000;}' unless defined(&OHCI_Int_CycleLost);
    eval 'sub OHCI_Int_Cycle64Seconds () {0x00200000;}' unless defined(&OHCI_Int_Cycle64Seconds);
    eval 'sub OHCI_Int_CycleSynch () {0x00100000;}' unless defined(&OHCI_Int_CycleSynch);
    eval 'sub OHCI_Int_Phy () {0x00080000;}' unless defined(&OHCI_Int_Phy);
    eval 'sub OHCI_Int_RegAccessFail () {0x00040000;}' unless defined(&OHCI_Int_RegAccessFail);
    eval 'sub OHCI_Int_BusReset () {0x00020000;}' unless defined(&OHCI_Int_BusReset);
    eval 'sub OHCI_Int_SelfIDComplete () {0x00010000;}' unless defined(&OHCI_Int_SelfIDComplete);
    eval 'sub OHCI_Int_SelfIDCOmplete2 () {0x00008000;}' unless defined(&OHCI_Int_SelfIDCOmplete2);
    eval 'sub OHCI_Int_LockRespErr () {0x00000200;}' unless defined(&OHCI_Int_LockRespErr);
    eval 'sub OHCI_Int_PostedWriteErr () {0x00000100;}' unless defined(&OHCI_Int_PostedWriteErr);
    eval 'sub OHCI_Int_IsochRx () {0x00000080;}' unless defined(&OHCI_Int_IsochRx);
    eval 'sub OHCI_Int_IsochTx () {0x00000040;}' unless defined(&OHCI_Int_IsochTx);
    eval 'sub OHCI_Int_RSPkt () {0x00000020;}' unless defined(&OHCI_Int_RSPkt);
    eval 'sub OHCI_Int_RQPkt () {0x00000010;}' unless defined(&OHCI_Int_RQPkt);
    eval 'sub OHCI_Int_ARRS () {0x00000008;}' unless defined(&OHCI_Int_ARRS);
    eval 'sub OHCI_Int_ARRQ () {0x00000004;}' unless defined(&OHCI_Int_ARRQ);
    eval 'sub OHCI_Int_RespTxComplete () {0x00000002;}' unless defined(&OHCI_Int_RespTxComplete);
    eval 'sub OHCI_Int_ReqTxComplete () {0x00000001;}' unless defined(&OHCI_Int_ReqTxComplete);
    eval 'sub OHCI_LinkControl_CycleSource () {0x00400000;}' unless defined(&OHCI_LinkControl_CycleSource);
    eval 'sub OHCI_LinkControl_CycleMaster () {0x00200000;}' unless defined(&OHCI_LinkControl_CycleMaster);
    eval 'sub OHCI_LinkControl_CycleTimerEnable () {0x00100000;}' unless defined(&OHCI_LinkControl_CycleTimerEnable);
    eval 'sub OHCI_LinkControl_RcvPhyPkt () {0x00000400;}' unless defined(&OHCI_LinkControl_RcvPhyPkt);
    eval 'sub OHCI_LinkControl_RcvSelfID () {0x00000200;}' unless defined(&OHCI_LinkControl_RcvSelfID);
    eval 'sub OHCI_LinkControl_Tag1SyncFilterLock () {0x00000040;}' unless defined(&OHCI_LinkControl_Tag1SyncFilterLock);
    eval 'sub OHCI_NodeId_IDValid () {0x80000000;}' unless defined(&OHCI_NodeId_IDValid);
    eval 'sub OHCI_NodeId_ROOT () {0x40000000;}' unless defined(&OHCI_NodeId_ROOT);
    eval 'sub OHCI_NodeId_CPS () {0x08000000;}' unless defined(&OHCI_NodeId_CPS);
    eval 'sub OHCI_NodeId_BusNumber () {0x0000ffc0;}' unless defined(&OHCI_NodeId_BusNumber);
    eval 'sub OHCI_NodeId_NodeNumber () {0x0000003f;}' unless defined(&OHCI_NodeId_NodeNumber);
    eval 'sub OHCI_PhyControl_RdDone () {0x80000000;}' unless defined(&OHCI_PhyControl_RdDone);
    eval 'sub OHCI_PhyControl_RdAddr () {0x0f000000;}' unless defined(&OHCI_PhyControl_RdAddr);
    eval 'sub OHCI_PhyControl_RdAddr_BITPOS () {24;}' unless defined(&OHCI_PhyControl_RdAddr_BITPOS);
    eval 'sub OHCI_PhyControl_RdData () {0x00ff0000;}' unless defined(&OHCI_PhyControl_RdData);
    eval 'sub OHCI_PhyControl_RdData_BITPOS () {16;}' unless defined(&OHCI_PhyControl_RdData_BITPOS);
    eval 'sub OHCI_PhyControl_RdReg () {0x00008000;}' unless defined(&OHCI_PhyControl_RdReg);
    eval 'sub OHCI_PhyControl_WrReg () {0x00004000;}' unless defined(&OHCI_PhyControl_WrReg);
    eval 'sub OHCI_PhyControl_RegAddr () {0x00000f00;}' unless defined(&OHCI_PhyControl_RegAddr);
    eval 'sub OHCI_PhyControl_RegAddr_BITPOS () {8;}' unless defined(&OHCI_PhyControl_RegAddr_BITPOS);
    eval 'sub OHCI_PhyControl_WrData () {0x000000ff;}' unless defined(&OHCI_PhyControl_WrData);
    eval 'sub OHCI_PhyControl_WrData_BITPOS () {0;}' unless defined(&OHCI_PhyControl_WrData_BITPOS);
    eval 'sub OHCI_CTXCTL_RUN () {0x00008000;}' unless defined(&OHCI_CTXCTL_RUN);
    eval 'sub OHCI_CTXCTL_WAKE () {0x00001000;}' unless defined(&OHCI_CTXCTL_WAKE);
    eval 'sub OHCI_CTXCTL_DEAD () {0x00000800;}' unless defined(&OHCI_CTXCTL_DEAD);
    eval 'sub OHCI_CTXCTL_ACTIVE () {0x00000400;}' unless defined(&OHCI_CTXCTL_ACTIVE);
    eval 'sub OHCI_CTXCTL_SPD_BITLEN () {3;}' unless defined(&OHCI_CTXCTL_SPD_BITLEN);
    eval 'sub OHCI_CTXCTL_SPD_BITPOS () {5;}' unless defined(&OHCI_CTXCTL_SPD_BITPOS);
    eval 'sub OHCI_CTXCTL_SPD_100 () {0;}' unless defined(&OHCI_CTXCTL_SPD_100);
    eval 'sub OHCI_CTXCTL_SPD_200 () {1;}' unless defined(&OHCI_CTXCTL_SPD_200);
    eval 'sub OHCI_CTXCTL_SPD_400 () {2;}' unless defined(&OHCI_CTXCTL_SPD_400);
    eval 'sub OHCI_CTXCTL_EVENT_BITLEN () {5;}' unless defined(&OHCI_CTXCTL_EVENT_BITLEN);
    eval 'sub OHCI_CTXCTL_EVENT_BITPOS () {0;}' unless defined(&OHCI_CTXCTL_EVENT_BITPOS);
    eval 'sub OHCI_CTXCTL_EVENT_NO_STATUS () {0;}' unless defined(&OHCI_CTXCTL_EVENT_NO_STATUS);
    eval 'sub OHCI_CTXCTL_EVENT_RESERVED1 () {1;}' unless defined(&OHCI_CTXCTL_EVENT_RESERVED1);
    eval 'sub OHCI_CTXCTL_EVENT_LONG_PACKET () {2;}' unless defined(&OHCI_CTXCTL_EVENT_LONG_PACKET);
    eval 'sub OHCI_CTXCTL_EVENT_MISSING_ACK () {3;}' unless defined(&OHCI_CTXCTL_EVENT_MISSING_ACK);
    eval 'sub OHCI_CTXCTL_EVENT_UNDERRUN () {4;}' unless defined(&OHCI_CTXCTL_EVENT_UNDERRUN);
    eval 'sub OHCI_CTXCTL_EVENT_OVERRUN () {5;}' unless defined(&OHCI_CTXCTL_EVENT_OVERRUN);
    eval 'sub OHCI_CTXCTL_EVENT_DESCRIPTOR_READ () {6;}' unless defined(&OHCI_CTXCTL_EVENT_DESCRIPTOR_READ);
    eval 'sub OHCI_CTXCTL_EVENT_DATA_READ () {7;}' unless defined(&OHCI_CTXCTL_EVENT_DATA_READ);
    eval 'sub OHCI_CTXCTL_EVENT_DATA_WRITE () {8;}' unless defined(&OHCI_CTXCTL_EVENT_DATA_WRITE);
    eval 'sub OHCI_CTXCTL_EVENT_BUS_RESET () {9;}' unless defined(&OHCI_CTXCTL_EVENT_BUS_RESET);
    eval 'sub OHCI_CTXCTL_EVENT_TIMEOUT () {10;}' unless defined(&OHCI_CTXCTL_EVENT_TIMEOUT);
    eval 'sub OHCI_CTXCTL_EVENT_TCODE_ERR () {11;}' unless defined(&OHCI_CTXCTL_EVENT_TCODE_ERR);
    eval 'sub OHCI_CTXCTL_EVENT_RESERVED12 () {12;}' unless defined(&OHCI_CTXCTL_EVENT_RESERVED12);
    eval 'sub OHCI_CTXCTL_EVENT_RESERVED13 () {13;}' unless defined(&OHCI_CTXCTL_EVENT_RESERVED13);
    eval 'sub OHCI_CTXCTL_EVENT_UNKNOWN () {14;}' unless defined(&OHCI_CTXCTL_EVENT_UNKNOWN);
    eval 'sub OHCI_CTXCTL_EVENT_FLUSHED () {15;}' unless defined(&OHCI_CTXCTL_EVENT_FLUSHED);
    eval 'sub OHCI_CTXCTL_EVENT_RESERVED16 () {16;}' unless defined(&OHCI_CTXCTL_EVENT_RESERVED16);
    eval 'sub OHCI_CTXCTL_EVENT_ACK_COMPLETE () {17;}' unless defined(&OHCI_CTXCTL_EVENT_ACK_COMPLETE);
    eval 'sub OHCI_CTXCTL_EVENT_ACK_PENDING () {18;}' unless defined(&OHCI_CTXCTL_EVENT_ACK_PENDING);
    eval 'sub OHCI_CTXCTL_EVENT_RESERVED19 () {19;}' unless defined(&OHCI_CTXCTL_EVENT_RESERVED19);
    eval 'sub OHCI_CTXCTL_EVENT_ACK_BUSY_X () {20;}' unless defined(&OHCI_CTXCTL_EVENT_ACK_BUSY_X);
    eval 'sub OHCI_CTXCTL_EVENT_ACK_BUSY_A () {21;}' unless defined(&OHCI_CTXCTL_EVENT_ACK_BUSY_A);
    eval 'sub OHCI_CTXCTL_EVENT_ACK_BUSY_B () {22;}' unless defined(&OHCI_CTXCTL_EVENT_ACK_BUSY_B);
    eval 'sub OHCI_CTXCTL_EVENT_RESERVED23 () {23;}' unless defined(&OHCI_CTXCTL_EVENT_RESERVED23);
    eval 'sub OHCI_CTXCTL_EVENT_RESERVED24 () {24;}' unless defined(&OHCI_CTXCTL_EVENT_RESERVED24);
    eval 'sub OHCI_CTXCTL_EVENT_RESERVED25 () {25;}' unless defined(&OHCI_CTXCTL_EVENT_RESERVED25);
    eval 'sub OHCI_CTXCTL_EVENT_RESERVED26 () {26;}' unless defined(&OHCI_CTXCTL_EVENT_RESERVED26);
    eval 'sub OHCI_CTXCTL_EVENT_ACK_TARDY () {27;}' unless defined(&OHCI_CTXCTL_EVENT_ACK_TARDY);
    eval 'sub OHCI_CTXCTL_EVENT_RESERVED28 () {28;}' unless defined(&OHCI_CTXCTL_EVENT_RESERVED28);
    eval 'sub OHCI_CTXCTL_EVENT_ACK_DATA_ERROR () {29;}' unless defined(&OHCI_CTXCTL_EVENT_ACK_DATA_ERROR);
    eval 'sub OHCI_CTXCTL_EVENT_ACK_TYPE_ERROR () {30;}' unless defined(&OHCI_CTXCTL_EVENT_ACK_TYPE_ERROR);
    eval 'sub OHCI_CTXCTL_EVENT_RESERVED31 () {31;}' unless defined(&OHCI_CTXCTL_EVENT_RESERVED31);
    eval 'sub OHCI_CTXCTL_TX_CYCLE_MATCH_ENABLE () {0x80000000;}' unless defined(&OHCI_CTXCTL_TX_CYCLE_MATCH_ENABLE);
    eval 'sub OHCI_CTXCTL_TX_CYCLE_MATCH_BITLEN () {0x7fff0000;}' unless defined(&OHCI_CTXCTL_TX_CYCLE_MATCH_BITLEN);
    eval 'sub OHCI_CTXCTL_TX_CYCLE_MATCH_BITPOS () {16;}' unless defined(&OHCI_CTXCTL_TX_CYCLE_MATCH_BITPOS);
    eval 'sub OHCI_CTXCTL_RX_BUFFER_FILL () {0x80000000;}' unless defined(&OHCI_CTXCTL_RX_BUFFER_FILL);
    eval 'sub OHCI_CTXCTL_RX_ISOCH_HEADER () {0x40000000;}' unless defined(&OHCI_CTXCTL_RX_ISOCH_HEADER);
    eval 'sub OHCI_CTXCTL_RX_CYCLE_MATCH_ENABLE () {0x20000000;}' unless defined(&OHCI_CTXCTL_RX_CYCLE_MATCH_ENABLE);
    eval 'sub OHCI_CTXCTL_RX_MULTI_CHAN_MODE () {0x10000000;}' unless defined(&OHCI_CTXCTL_RX_MULTI_CHAN_MODE);
    eval 'sub OHCI_CTXCTL_RX_DUAL_BUFFER_MODE () {0x08000000;}' unless defined(&OHCI_CTXCTL_RX_DUAL_BUFFER_MODE);
    eval 'sub OHCI_CTXMATCH_TAG3 () {0x80000000;}' unless defined(&OHCI_CTXMATCH_TAG3);
    eval 'sub OHCI_CTXMATCH_TAG2 () {0x40000000;}' unless defined(&OHCI_CTXMATCH_TAG2);
    eval 'sub OHCI_CTXMATCH_TAG1 () {0x20000000;}' unless defined(&OHCI_CTXMATCH_TAG1);
    eval 'sub OHCI_CTXMATCH_TAG0 () {0x10000000;}' unless defined(&OHCI_CTXMATCH_TAG0);
    eval 'sub OHCI_CTXMATCH_CYCLE_MATCH_MASK () {0x07fff000;}' unless defined(&OHCI_CTXMATCH_CYCLE_MATCH_MASK);
    eval 'sub OHCI_CTXMATCH_CYCLE_MATCH_BITPOS () {12;}' unless defined(&OHCI_CTXMATCH_CYCLE_MATCH_BITPOS);
    eval 'sub OHCI_CTXMATCH_SYNC_MASK () {0x00000f00;}' unless defined(&OHCI_CTXMATCH_SYNC_MASK);
    eval 'sub OHCI_CTXMATCH_SYNC_BITPOS () {8;}' unless defined(&OHCI_CTXMATCH_SYNC_BITPOS);
    eval 'sub OHCI_CTXMATCH_TAG1_SYNC_FILTER () {0x00000040;}' unless defined(&OHCI_CTXMATCH_TAG1_SYNC_FILTER);
    eval 'sub OHCI_CTXMATCH_CHANNEL_NUMBER_MASK () {0x0000003f;}' unless defined(&OHCI_CTXMATCH_CHANNEL_NUMBER_MASK);
    eval 'sub OHCI_CTXMATCH_CHANNEL_NUMBER_BITPOS () {0;}' unless defined(&OHCI_CTXMATCH_CHANNEL_NUMBER_BITPOS);
    eval 'sub OHCI_TCODE_PHY () {0xe;}' unless defined(&OHCI_TCODE_PHY);
    if((defined(&BYTE_ORDER) ? &BYTE_ORDER : 0) == (defined(&BIG_ENDIAN) ? &BIG_ENDIAN : 0)) {
    }
    if((defined(&BYTE_ORDER) ? &BYTE_ORDER : 0) == (defined(&LITTLE_ENDIAN) ? &LITTLE_ENDIAN : 0)) {
    }
    eval 'sub fd_timestamp () { &fd_rescount;}' unless defined(&fd_timestamp);
    eval 'sub OHCI_DESC_INPUT () {0x2000;}' unless defined(&OHCI_DESC_INPUT);
    eval 'sub OHCI_DESC_LAST () {0x1000;}' unless defined(&OHCI_DESC_LAST);
    eval 'sub OHCI_DESC_STATUS () {0x0800;}' unless defined(&OHCI_DESC_STATUS);
    eval 'sub OHCI_DESC_IMMED () {0x0200;}' unless defined(&OHCI_DESC_IMMED);
    eval 'sub OHCI_DESC_PING () {0x0080;}' unless defined(&OHCI_DESC_PING);
    eval 'sub OHCI_DESC_INTR_ALWAYS () {0x0030;}' unless defined(&OHCI_DESC_INTR_ALWAYS);
    eval 'sub OHCI_DESC_INTR_ERR () {0x0010;}' unless defined(&OHCI_DESC_INTR_ERR);
    eval 'sub OHCI_DESC_BRANCH () {0x000c;}' unless defined(&OHCI_DESC_BRANCH);
    eval 'sub OHCI_DESC_WAIT () {0x0003;}' unless defined(&OHCI_DESC_WAIT);
    eval 'sub OHCI_DESC_MAX () {8;}' unless defined(&OHCI_DESC_MAX);
    eval 'sub OHCI_DESC_STATUS_ACK_MASK () {0x1f;}' unless defined(&OHCI_DESC_STATUS_ACK_MASK);
}
1;
